/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.ClientSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.io.DbCompare;
import org.jumpmind.symmetric.io.DbCompareConfig;
import org.jumpmind.symmetric.io.DbCompareReport;
import org.jumpmind.symmetric.util.SymmetricUtils;

public class DbCompareCommand
extends AbstractCommandLauncher {
    private Properties configProperties;
    private static final String OPTION_SOURCE = "source";
    private static final String OPTION_TARGET = "target";
    private static final String OPTION_EXCLUDE = "exclude";
    private static final String OPTION_SOURCE_TABLES = "source-tables";
    private static final String OPTION_TARGET_TABLES = "target-tables";
    private static final String OPTION_USE_SYM_CONFIG = "use-sym-config";
    private static final String OPTION_OUTPUT_SQL = "output-sql";
    private static final String OPTION_NUMERIC_SCALE = "numeric-scale";
    private static final String OPTION_DATE_TIME_FORMAT = "date-time-format";
    private static final String OPTION_CONFIG_PROPERTIES = "config";
    private static final String OPTION_CONTINUE_AFTER_ERROR = "continue-after-error";

    public DbCompareCommand() {
        super("dbcompare", "[tablename...]", "DbCompare.Option.");
    }

    @Override
    protected boolean printHelpIfNoOptionsAreProvided() {
        return true;
    }

    @Override
    protected boolean requiresPropertiesFile(CommandLine line) {
        return false;
    }

    @Override
    protected boolean executeWithOptions(CommandLine line) throws Exception {
        String continueAfterError;
        String dateTimeFormatArg;
        String targetTables;
        DbCompareConfig config = new DbCompareConfig();
        String source = line.getOptionValue('s');
        if (source == null) {
            source = this.getOptionValue(OPTION_SOURCE, OPTION_SOURCE, line, config);
        }
        if (StringUtils.isEmpty((CharSequence)source)) {
            throw new ParseException("-source properties file is required.");
        }
        File sourceProperies = new File(source);
        if (!sourceProperies.exists()) {
            throw new SymmetricException("Source properties file '" + sourceProperies + "' does not exist.", new Object[0]);
        }
        String target = line.getOptionValue('t');
        if (target == null) {
            target = this.getOptionValue(OPTION_TARGET, OPTION_TARGET, line, config);
        }
        if (StringUtils.isEmpty((CharSequence)target)) {
            throw new ParseException("-target properties file is required.");
        }
        File targetProperties = new File(target);
        if (!targetProperties.exists()) {
            throw new SymmetricException("Target properties file '" + targetProperties + "' does not exist.", new Object[0]);
        }
        config.setOutputSql(this.getOptionValue(OPTION_OUTPUT_SQL, "outputSql", line, config));
        config.setUseSymmetricConfig(Boolean.valueOf(this.getOptionValue(OPTION_USE_SYM_CONFIG, "useSymmetricConfig", line, config)).booleanValue());
        String excludedTableNames = this.getOptionValue(OPTION_EXCLUDE, "excludedTableNames", line, config);
        if (excludedTableNames != null) {
            config.setExcludedTableNames(Arrays.asList(excludedTableNames.split(",")));
        }
        if ((targetTables = this.getOptionValue(OPTION_TARGET_TABLES, "targetTableNames", line, config)) != null) {
            config.setTargetTableNames(Arrays.asList(targetTables.split(",")));
        }
        config.setWhereClauses(this.parseWhereClauses(line));
        config.setTablesToExcludedColumns(this.parseExcludedColumns(line));
        String sourceTables = this.getOptionValue(OPTION_SOURCE_TABLES, "sourceTableNames", line, config);
        if (sourceTables == null && !CollectionUtils.isEmpty((Collection)line.getArgList())) {
            config.setSourceTableNames(line.getArgList());
        } else if (sourceTables != null) {
            config.setSourceTableNames(Arrays.asList(sourceTables.split(",")));
        }
        String numericScaleArg = this.getOptionValue(OPTION_NUMERIC_SCALE, "numericScale", line, config);
        if (!StringUtils.isEmpty((CharSequence)numericScaleArg)) {
            try {
                config.setNumericScale(Integer.parseInt(numericScaleArg.trim()));
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Failed to parse arg [" + numericScaleArg + "] ", ex);
            }
        }
        if (!this.isValidDateFormat(dateTimeFormatArg = this.getOptionValue(OPTION_DATE_TIME_FORMAT, "dateTimeFormat", line, config))) {
            System.err.println("The date time format value " + dateTimeFormatArg + " is not a valid date time format.");
            System.exit(1);
        }
        if (!StringUtils.isEmpty((CharSequence)dateTimeFormatArg)) {
            config.setDateTimeFormat(dateTimeFormatArg);
        }
        if (!StringUtils.isEmpty((CharSequence)(continueAfterError = this.getOptionValue(OPTION_CONTINUE_AFTER_ERROR, "continueAfterError", line, config)))) {
            config.setContinueAfterError(Boolean.parseBoolean(continueAfterError));
        }
        ClientSymmetricEngine sourceEngine = new ClientSymmetricEngine(sourceProperies);
        ClientSymmetricEngine targetEngine = new ClientSymmetricEngine(targetProperties);
        DbCompare dbCompare = new DbCompare((ISymmetricEngine)sourceEngine, (ISymmetricEngine)targetEngine, config);
        DbCompareReport report = dbCompare.compare();
        for (DbCompareReport.TableReport tableReport : report.getTableReports()) {
            if (tableReport.getErrorRows() <= 0) continue;
            if (tableReport.getThrowable() instanceof RuntimeException) {
                throw (RuntimeException)tableReport.getThrowable();
            }
            throw new RuntimeException(tableReport.getThrowable());
        }
        return false;
    }

    private boolean isValidDateFormat(String format) {
        try {
            if (format != null) {
                new SimpleDateFormat(format);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected String getOptionValue(String optionName, String internalName, CommandLine line, DbCompareConfig config) {
        String optionValue;
        String string = optionValue = line.hasOption(optionName) ? line.getOptionValue(optionName) : null;
        if (optionValue == null) {
            Properties props = this.getConfigProperties(line);
            String string2 = optionValue = props != null ? props.getProperty(optionName) : null;
            if (optionValue == null) {
                String optionNameUnderScore = optionName.replace('-', '_');
                String string3 = optionValue = props != null ? props.getProperty(optionNameUnderScore) : null;
                if (optionValue != null) {
                    config.setConfigSource(internalName, line.getOptionValue(OPTION_CONFIG_PROPERTIES));
                }
            } else {
                config.setConfigSource(internalName, line.getOptionValue(OPTION_CONFIG_PROPERTIES));
            }
        } else {
            config.setConfigSource(internalName, "command-line");
        }
        return optionValue;
    }

    public static void main(String[] args) throws Exception {
        new DbCompareCommand().execute(args);
    }

    protected static void initFromServerProperties() {
    }

    @Override
    protected void printHelp(CommandLine cmd, Options options) {
        System.out.println(this.app + " version " + Version.version());
        System.out.println("Compare tables from 2 databases.\n");
        super.printHelp(cmd, options);
    }

    @Override
    protected void buildOptions(Options options) {
        this.addCommonOption(options, "h", "help", false);
        this.addOption(options, "s", OPTION_SOURCE, true);
        this.addOption(options, "t", OPTION_TARGET, true);
        this.addOption(options, null, OPTION_EXCLUDE, true);
        this.addOption(options, null, OPTION_TARGET_TABLES, true);
        this.addOption(options, null, OPTION_USE_SYM_CONFIG, true);
        this.addOption(options, null, OPTION_OUTPUT_SQL, true);
        this.addOption(options, null, OPTION_NUMERIC_SCALE, true);
        this.addOption(options, null, OPTION_DATE_TIME_FORMAT, true);
        this.addOption(options, null, OPTION_CONFIG_PROPERTIES, true);
        this.addOption(options, null, OPTION_CONTINUE_AFTER_ERROR, true);
    }

    protected Map<String, String> parseWhereClauses(CommandLine line) {
        Properties props = this.getConfigProperties(line);
        HashMap<String, String> whereClauses = new HashMap<String, String>();
        if (props != null) {
            for (Object key : props.keySet()) {
                String arg = key.toString();
                if (!arg.endsWith("where_clause")) continue;
                whereClauses.put(arg, props.getProperty(arg));
            }
        }
        return whereClauses;
    }

    protected Map<String, List<String>> parseExcludedColumns(CommandLine line) {
        Properties props = this.getConfigProperties(line);
        HashMap<String, List<String>> tablesToExcludedColumns = new HashMap<String, List<String>>();
        if (props != null) {
            for (Object key : props.keySet()) {
                String arg = key.toString();
                if (!arg.endsWith("exclude_columns")) continue;
                ArrayList<String> excludedColumns = (ArrayList<String>)tablesToExcludedColumns.get(key);
                if (excludedColumns == null) {
                    excludedColumns = new ArrayList<String>();
                    tablesToExcludedColumns.put(key.toString(), excludedColumns);
                }
                excludedColumns.addAll(Arrays.asList(props.getProperty(arg).split(",")));
            }
        }
        return tablesToExcludedColumns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties getConfigProperties(CommandLine line) {
        if (this.configProperties != null) {
            return this.configProperties;
        }
        String configPropertiesFile = line.getOptionValue(OPTION_CONFIG_PROPERTIES);
        if (StringUtils.isEmpty((CharSequence)configPropertiesFile)) return null;
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(configPropertiesFile);){
            props.load(in);
            SymmetricUtils.replaceSystemAndEnvironmentVariables((Properties)props);
            Properties properties = this.configProperties = props;
            return properties;
        }
        catch (Exception ex) {
            String qualifiedFileName = new File(configPropertiesFile).getAbsolutePath();
            throw new SymmetricException("Could not load config properties file '" + configPropertiesFile + "' at '" + qualifiedFileName + "' ", (Throwable)ex);
        }
    }

    static String stripLeadingHyphens(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("--")) {
            return str.substring(2, str.length());
        }
        if (str.startsWith("-")) {
            return str.substring(1, str.length());
        }
        return str;
    }
}

