/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import java.lang.reflect.Constructor;
import org.jumpmind.driver.DummyInterceptor;
import org.jumpmind.driver.InterceptResult;
import org.jumpmind.driver.PreparedStatementWrapper;
import org.jumpmind.driver.StatementInterceptor;
import org.jumpmind.driver.StatementWrapper;
import org.jumpmind.properties.TypedProperties;

public abstract class WrapperInterceptor {
    private Object wrapped;

    public static WrapperInterceptor createInterceptor(Object wrapped, TypedProperties systemPlusEngineProperties) {
        String className;
        String property = wrapped.getClass().getName() + ".interceptor";
        if (systemPlusEngineProperties == null) {
            systemPlusEngineProperties = new TypedProperties();
            systemPlusEngineProperties.putAll(System.getProperties());
        }
        if ((className = systemPlusEngineProperties.get(property)) != null && className.length() > 0) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(Object.class, TypedProperties.class);
                return (WrapperInterceptor)constructor.newInstance(wrapped, systemPlusEngineProperties);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to load and instantiate interceptor class [" + className + "]", ex);
            }
        }
        if (wrapped instanceof PreparedStatementWrapper || wrapped instanceof StatementWrapper) {
            return new StatementInterceptor(wrapped, systemPlusEngineProperties);
        }
        return new DummyInterceptor(wrapped);
    }

    public WrapperInterceptor(Object wrapped) {
        this.wrapped = wrapped;
    }

    public abstract InterceptResult preExecute(String var1, Object ... var2);

    public abstract InterceptResult postExecute(String var1, Object var2, long var3, long var5, Object ... var7);

    public Object getWrapped() {
        return this.wrapped;
    }
}

