/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sqlite;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;
import org.jumpmind.util.FormatUtils;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.lob.LobHandler;

public class SqliteJdbcSqlTemplate
extends JdbcSqlTemplate {
    public SqliteJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
    }

    @Override
    public boolean isUniqueKeyViolation(Throwable ex) {
        SQLException sqlEx = this.findSQLException(ex);
        return sqlEx != null && sqlEx.getMessage() != null && (sqlEx.getMessage().contains("[SQLITE_CONSTRAINT]") || sqlEx.getMessage().contains("[SQLITE_CONSTRAINT_PRIMARYKEY]") || sqlEx.getMessage().contains("[SQLITE_CONSTRAINT_UNIQUE]"));
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        return "SELECT last_insert_rowid();";
    }

    @Override
    public <T> T getObjectFromResultSet(ResultSet rs, Class<T> clazz) throws SQLException {
        if (Date.class.isAssignableFrom(clazz) || Timestamp.class.isAssignableFrom(clazz)) {
            String s = rs.getString(1);
            Date d = null;
            if (s != null) {
                d = FormatUtils.parseDate((String)s, (String[])FormatUtils.TIMESTAMP_PATTERNS);
            }
            if (d != null && Timestamp.class.isAssignableFrom(clazz)) {
                return (T)new Timestamp(d.getTime());
            }
            return (T)d;
        }
        return super.getObjectFromResultSet(rs, clazz);
    }

    @Override
    public void setValues(PreparedStatement ps, Object[] args, int[] argTypes, LobHandler lobHandler) throws SQLException {
        for (int i = 1; i <= args.length; ++i) {
            int argType;
            Object arg = args[i - 1];
            int n = argType = argTypes != null && argTypes.length >= i ? argTypes[i - 1] : Integer.MIN_VALUE;
            if (argType == 2004 && lobHandler != null && arg instanceof byte[]) {
                lobHandler.getLobCreator().setBlobAsBytes(ps, i, (byte[])arg);
                continue;
            }
            if (argType == 2004 && lobHandler != null && arg instanceof String) {
                lobHandler.getLobCreator().setBlobAsBytes(ps, i, arg.toString().getBytes(Charset.defaultCharset()));
                continue;
            }
            if (argType == 2005 && lobHandler != null) {
                lobHandler.getLobCreator().setClobAsString(ps, i, (String)arg);
                continue;
            }
            if (arg != null && argType == 91 && arg instanceof Date) {
                Date clone = (Date)((Date)arg).clone();
                args[i - 1] = arg = FormatUtils.TIMESTAMP_FORMATTER.format(DateUtils.truncate((Date)clone, (int)5));
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), (Object)arg);
                continue;
            }
            if (arg != null && (arg instanceof Date || arg instanceof Timestamp)) {
                args[i - 1] = arg = FormatUtils.TIMESTAMP_FORMATTER.format(arg);
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), (Object)arg);
                continue;
            }
            if (arg instanceof BigDecimal) {
                args[i - 1] = arg = Double.valueOf(((BigDecimal)arg).doubleValue());
            }
            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), (Object)arg);
        }
    }

    @Override
    public void setValues(PreparedStatement ps, Object[] args) throws SQLException {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg != null && (arg instanceof Date || arg instanceof Timestamp)) {
                    args[i] = arg = FormatUtils.TIMESTAMP_FORMATTER.format(arg);
                }
                this.doSetValue(ps, i + 1, arg);
            }
        }
    }
}

