/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.redshift;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.redshift.RedshiftDdlBuilder;
import org.jumpmind.db.platform.redshift.RedshiftDdlReader;
import org.jumpmind.db.platform.redshift.RedshiftJdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class RedshiftDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.amazon.redshift.jdbc42.Driver";
    public static final String JDBC_SUBPROTOCOL = "redshift";
    private Map<String, String> sqlScriptReplacementTokens = super.getSqlScriptReplacementTokens();

    public RedshiftDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, RedshiftDatabasePlatform.overrideSettings(settings));
        if (this.sqlScriptReplacementTokens == null) {
            this.sqlScriptReplacementTokens = new HashMap<String, String>();
        }
        this.sqlScriptReplacementTokens.put("current_timestamp", "sysdate");
    }

    protected static SqlTemplateSettings overrideSettings(SqlTemplateSettings settings) {
        if (settings == null) {
            settings = new SqlTemplateSettings();
        }
        settings.setQueryTimeout(0);
        return settings;
    }

    protected RedshiftDdlBuilder createDdlBuilder() {
        return new RedshiftDdlBuilder();
    }

    @Override
    protected RedshiftDdlReader createDdlReader() {
        return new RedshiftDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected RedshiftJdbcSqlTemplate createSqlTemplate() {
        return new RedshiftJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select current_schema()", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public Map<String, String> getSqlScriptReplacementTokens() {
        return this.sqlScriptReplacementTokens;
    }

    public boolean isClob(int type) {
        return type == 2005;
    }

    public PermissionResult getCreateSymTablePermission(Database database) {
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TABLE, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public PermissionResult getDropSymTablePermission() {
        PermissionResult result = new PermissionResult(PermissionType.DROP_TABLE, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public PermissionResult getAlterSymTablePermission(Database database) {
        PermissionResult result = new PermissionResult(PermissionType.ALTER_TABLE, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public PermissionResult getDropSymTriggerPermission() {
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset;
    }
}

