/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.postgresql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSqlDatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSqlDdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;

public class PostgreSqlDdlReader
extends AbstractJdbcDdlReader {
    public PostgreSqlDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern(null);
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            HashMap<String, IIndex> uniquesByName = new HashMap<String, IIndex>();
            for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
                IIndex index = table.getIndex(indexIdx);
                if (!index.isUnique() || index.getName() == null) continue;
                uniquesByName.put(index.getName(), index);
            }
            for (int columnIdx = 0; columnIdx < table.getColumnCount(); ++columnIdx) {
                String indexName;
                Column column = table.getColumn(columnIdx);
                if (!column.isAutoIncrement() || column.isPrimaryKey() || !uniquesByName.containsKey(indexName = table.getName() + "_" + column.getName() + "_key")) continue;
                table.removeIndex((IIndex)uniquesByName.get(indexName));
                uniquesByName.remove(indexName);
            }
            this.setPrimaryKeyConstraintName(connection, table);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPrimaryKeyConstraintName(Connection connection, Table table) throws SQLException {
        String sql = "select conname from pg_constraint where conrelid in (select oid from pg_class where relname=? and relnamespace in (select oid from pg_namespace where nspname=?)) and contype='p'";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, table.getName());
            pstmt.setString(2, table.getSchema());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                table.setPrimaryKeyConstraintName(rs.getString(1).trim());
            }
        }
        catch (Throwable throwable) {
            JdbcSqlTemplate.close(rs);
            JdbcSqlTemplate.close(pstmt);
            throw throwable;
        }
        JdbcSqlTemplate.close(rs);
        JdbcSqlTemplate.close(pstmt);
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        Integer type = (Integer)values.get("DATA_TYPE");
        if (typeName != null && typeName.equalsIgnoreCase("ABSTIME")) {
            return 93;
        }
        if (typeName != null && typeName.equalsIgnoreCase("TIMESTAMPTZ")) {
            return -101;
        }
        if (typeName != null && typeName.equalsIgnoreCase("TIMETZ")) {
            return -103;
        }
        if (PostgreSqlDatabasePlatform.isBlobStoredByReference(typeName)) {
            return 2004;
        }
        if (type != null && (type == 2002 || type == 1111)) {
            return -1;
        }
        if (typeName != null && typeName.equalsIgnoreCase("BIT")) {
            return 12;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String defaultValue;
        Column column = super.readColumn(metaData, values);
        PlatformColumn platformColumn = column.findPlatformColumn(this.platform.getName());
        if (platformColumn != null) {
            if ("serial".equals(platformColumn.getType()) || "serial4".equals(platformColumn.getType())) {
                platformColumn.setType("int4");
            } else if ("bigserial".equals(platformColumn.getType()) || "serial8".equals(platformColumn.getType())) {
                platformColumn.setType("int8");
            }
        }
        if (column.getSize() != null) {
            if (column.getSizeAsInt() <= 0) {
                column.setSize(null);
                if (column.getMappedTypeCode() == -2) {
                    column.setMappedTypeCode(-4);
                } else if (column.getMappedTypeCode() == 12) {
                    column.setMappedTypeCode(-1);
                }
            } else if (column.getSizeAsInt() == Integer.MAX_VALUE) {
                if (column.getMappedTypeCode() == 12) {
                    if (column.getJdbcTypeName().equalsIgnoreCase("TEXT")) {
                        column.setMappedTypeCode(-1);
                        column.setSize(null);
                    }
                    if (platformColumn != null) {
                        platformColumn.setSize(-1);
                    }
                } else if (column.getMappedTypeCode() == -2) {
                    column.setMappedTypeCode(-4);
                    column.setSize(null);
                }
            } else if (column.getSizeAsInt() == 131089 && column.getJdbcTypeCode() == 2) {
                column.setSizeAndScale(0, 0);
                column.setMappedTypeCode(3);
                if (platformColumn != null) {
                    platformColumn.setSize(-1);
                    platformColumn.setDecimalDigits(-1);
                }
            }
        }
        if (column.getJdbcTypeCode() == 93 || column.getJdbcTypeCode() == 92 || column.getJdbcTypeCode() == -101 || column.getJdbcTypeCode() == -103) {
            this.resetColumnSize(column, String.valueOf(column.getScale()));
        }
        if (column.getJdbcTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        if ((defaultValue = column.getDefaultValue()) != null && defaultValue.length() > 0) {
            if (defaultValue.startsWith("nextval(") || PostgreSqlDdlBuilder.isUsePseudoSequence() && defaultValue.endsWith("seq()")) {
                column.setAutoIncrement(true);
                defaultValue = null;
            } else {
                switch (column.getMappedTypeCode()) {
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: {
                        defaultValue = this.extractUndelimitedDefaultValue(defaultValue);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        defaultValue = this.extractDelimitedDefaultValue(defaultValue);
                    }
                }
                if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                    defaultValue = this.unescape(defaultValue, "'", "''");
                }
            }
            column.setDefaultValue(defaultValue);
        }
        return column;
    }

    private String extractDelimitedDefaultValue(String defaultValue) {
        int valueEnd;
        if (defaultValue.startsWith("'") && (valueEnd = defaultValue.indexOf("'::")) > 0) {
            return defaultValue.substring("'".length(), valueEnd);
        }
        return defaultValue;
    }

    private String extractUndelimitedDefaultValue(String defaultValue) {
        int valueEnd = defaultValue.indexOf("::");
        if (valueEnd > 0) {
            defaultValue = defaultValue.substring(0, valueEnd);
        } else if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
            defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
        }
        return defaultValue;
    }

    @Override
    protected void readForeignKey(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, ForeignKey> knownFks) throws SQLException {
        String fkName = (String)values.get(this.getName("FK_NAME"));
        ForeignKey fk = knownFks.get(fkName);
        if (fk == null) {
            fk = new ForeignKey(fkName);
            fk.setForeignTableName((String)values.get(this.getName("PKTABLE_NAME")));
            fk.setForeignTableCatalog((String)values.get(this.getName("PKTABLE_CAT")));
            String fkSchema = (String)values.get(this.getName("PKTABLE_SCHEM"));
            if (StringUtils.isBlank((CharSequence)fkSchema)) {
                fkSchema = (String)values.get(this.getName("pktable_schem"));
            }
            fk.setForeignTableSchema(fkSchema);
            this.readForeignKeyUpdateRule(values, fk);
            this.readForeignKeyDeleteRule(values, fk);
            knownFks.put(fkName, fk);
        }
        Reference ref = new Reference();
        ref.setForeignColumnName((String)values.get(this.getName("PKCOLUMN_NAME")));
        ref.setLocalColumnName((String)values.get(this.getName("FKCOLUMN_NAME")));
        if (values.containsKey(this.getName("KEY_SEQ"))) {
            ref.setSequenceValue(((Short)values.get(this.getName("KEY_SEQ"))).intValue());
        }
        fk.addReference(ref);
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) {
        return false;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        return table.doesIndexContainOnlyPrimaryKeyColumns(index);
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT trigger_name, trigger_schema, trigger_catalog, event_manipulation AS trigger_type, event_object_table AS table_name,trig.*, pgproc.prosrc FROM INFORMATION_SCHEMA.TRIGGERS AS trig INNER JOIN pg_catalog.pg_trigger AS pgtrig ON pgtrig.tgname=trig.trigger_name INNER JOIN pg_catalog.pg_proc AS pgproc ON pgproc.oid=pgtrig.tgfoid WHERE event_object_table=? AND event_object_schema=?;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("trigger_name"));
                trigger.setCatalogName(row.getString("trigger_catalog"));
                trigger.setSchemaName(row.getString("trigger_schema"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("prosrc"));
                row.remove((Object)"prosrc");
                String triggerType = row.getString("trigger_type");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }
}

