/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.postgresql;

import java.sql.Array;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.postgresql.PostgreSqlDdlBuilder;
import org.jumpmind.db.platform.postgresql.PostgreSqlDdlReader;
import org.jumpmind.db.platform.postgresql.PostgreSqlJdbcSqlTemplate;
import org.jumpmind.db.platform.postgresql.PostgresLobHandler;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BinaryEncoding;

public class PostgreSqlDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "org.postgresql.Driver";
    public static final String JDBC_SUBPROTOCOL = "postgresql";

    public PostgreSqlDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, PostgreSqlDatabasePlatform.overrideSettings(settings));
    }

    protected static SqlTemplateSettings overrideSettings(SqlTemplateSettings settings) {
        if (settings == null) {
            settings = new SqlTemplateSettings();
        }
        settings.setQueryTimeout(0);
        return settings;
    }

    protected static boolean isBlobStoredByReference(String jdbcTypeName) {
        return "OID".equalsIgnoreCase(jdbcTypeName) || "LO".equalsIgnoreCase(jdbcTypeName);
    }

    protected PostgreSqlDdlBuilder createDdlBuilder() {
        return new PostgreSqlDdlBuilder();
    }

    @Override
    protected PostgreSqlDdlReader createDdlReader() {
        return new PostgreSqlDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected PostgreSqlJdbcSqlTemplate createSqlTemplate() {
        PostgresLobHandler lobHandler = new PostgresLobHandler();
        return new PostgreSqlJdbcSqlTemplate(this.dataSource, this.settings, lobHandler, this.getDatabaseInfo());
    }

    public String getName() {
        return "postgres";
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select current_schema()", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public String getDefaultCatalog() {
        return null;
    }

    protected Array createArray(Column column, final String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String jdbcTypeName = column.getJdbcTypeName();
            if (jdbcTypeName.startsWith("_")) {
                jdbcTypeName = jdbcTypeName.substring(1);
            }
            int jdbcBaseType = 12;
            if (jdbcTypeName.toLowerCase().contains("int")) {
                jdbcBaseType = 4;
            }
            final String baseTypeName = jdbcTypeName;
            final int baseType = jdbcBaseType;
            return new Array(){

                @Override
                public String getBaseTypeName() {
                    return baseTypeName;
                }

                @Override
                public void free() {
                }

                @Override
                public int getBaseType() {
                    return baseType;
                }

                @Override
                public Object getArray() {
                    return null;
                }

                @Override
                public Object getArray(Map<String, Class<?>> map) {
                    return null;
                }

                @Override
                public Object getArray(long index, int count) {
                    return null;
                }

                @Override
                public Object getArray(long index, int count, Map<String, Class<?>> map) {
                    return null;
                }

                @Override
                public ResultSet getResultSet() {
                    return null;
                }

                @Override
                public ResultSet getResultSet(Map<String, Class<?>> map) {
                    return null;
                }

                @Override
                public ResultSet getResultSet(long index, int count) {
                    return null;
                }

                @Override
                public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) {
                    return null;
                }

                public String toString() {
                    return value;
                }
            };
        }
        return null;
    }

    protected String cleanTextForTextBasedColumns(String text) {
        return text.replace("\u0000", "");
    }

    public Object[] getObjectValues(BinaryEncoding encoding, String[] values, Column[] orderedMetaData, boolean useVariableDates, boolean fitToColumn) {
        Object[] objectValues = super.getObjectValues(encoding, values, orderedMetaData, useVariableDates, fitToColumn);
        for (int i = 0; i < orderedMetaData.length; ++i) {
            if (orderedMetaData[i] == null || orderedMetaData[i].getMappedTypeCode() != 2004 || objectValues[i] == null) continue;
            try {
                objectValues[i] = new SerialBlob((byte[])objectValues[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return objectValues;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE OR REPLACE FUNCTION TEST_TRIGGER() RETURNS trigger AS $$ BEGIN END $$ LANGUAGE plpgsql";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission and/or DROP TRIGGER permission");
        }
        return result;
    }

    public PermissionResult getDropSymTriggerPermission() {
        String dropTriggerSql = "DROP FUNCTION TEST_TRIGGER()";
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, dropTriggerSql);
        try {
            this.getSqlTemplate().update(dropTriggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
        }
        return result;
    }

    public PermissionResult getLogMinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.LOG_MINE, "UNIMPLEMENTED");
        String walLevel = this.getSqlTemplate().queryForString("select current_setting('wal_level')", new Object[0]);
        if ("logical".equals(walLevel)) {
            result.setStatus(PermissionResult.Status.PASS);
        } else {
            result.setStatus(PermissionResult.Status.FAIL);
            result.setTestDetails(walLevel);
            result.setSolution("Set wal_level to logical");
        }
        return result;
    }

    public long getEstimatedRowCount(Table table) {
        return this.getSqlTemplateDirty().queryForLong("select coalesce(c.reltuples, -1) from pg_catalog.pg_class c inner join pg_catalog.pg_namespace n on n.oid = c.relnamespace where c.relname = ? and n.nspname = ?", new Object[]{table.getName(), table.getSchema()});
    }

    public String getTruncateSql(Table table) {
        String sql = super.getTruncateSql(table);
        sql = sql + " cascade";
        return sql;
    }

    public String getDeleteSql(Table table) {
        String sql = super.getDeleteSql(table);
        sql = sql + " cascade";
        return sql;
    }

    public List<Transaction> getTransactions() {
        ISqlTemplate template = this.getSqlTemplate();
        String sql = "";
        boolean oldVersion = template.getDatabaseMajorVersion() == 9 && template.getDatabaseMinorVersion() < 2 || template.getDatabaseMajorVersion() < 9;
        sql = oldVersion ? "select distinct  a.procpid as pid,  a.usename,  a.client_addr,  blocking.pid as blockingPid,  a.query_start,  a.current_query as query from pg_stat_activity a join pg_catalog.pg_locks blocked  on a.procpid = blocked.pid left join pg_catalog.pg_locks blocking  on (blocking.relation = blocked.relation and blocking.locktype = blocked.locktype and blocked.pid != blocking.pid)" : "select distinct  a.pid as pid,  a.usename,  a.client_addr,  a.client_hostname,  a.state,  blocking.pid as blockingPid,  a.query_start,  a.query as query from pg_stat_activity a join pg_catalog.pg_locks blocked  on a.pid = blocked.pid left join pg_catalog.pg_locks blocking  on (blocking.relation = blocked.relation and blocking.locktype = blocked.locktype and blocked.pid != blocking.pid)";
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        String formatString = "yyyy-MM-dd HH:mm:ss.SSSX";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSX");
        for (Row row : template.query(sql)) {
            try {
                String startTime = row.getString("query_start");
                if (startTime == null) continue;
                int decimalIndex = startTime.indexOf(".");
                int timezoneIndex = startTime.indexOf("+");
                if (timezoneIndex == -1 && (timezoneIndex = startTime.indexOf("Z")) == -1) {
                    timezoneIndex = startTime.lastIndexOf("-");
                }
                String adjustedTime = StringUtils.rightPad((String)startTime.substring(0, Math.min(decimalIndex + 4, timezoneIndex)), (int)3, (String)"0") + startTime.substring(timezoneIndex);
                Transaction transaction = new Transaction(row.getString("pid"), row.getString("usename"), row.getString("blockingPid"), dateFormat.parse(adjustedTime), row.getString("query"));
                transaction.setRemoteIp(row.getString("client_addr"));
                if (!oldVersion) {
                    transaction.setRemoteHost(row.getString("client_hostname"));
                    transaction.setStatus(row.getString("state"));
                }
                transactions.add(transaction);
            }
            catch (ParseException e) {
                this.log.error("Could not parse date", (Throwable)e);
            }
        }
        return transactions;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset;
    }

    public String massageForObjectAlreadyExists(String sql) {
        String uppercaseSql = sql.trim().toUpperCase();
        if (uppercaseSql.contains("CREATE TABLE")) {
            return sql;
        }
        if (uppercaseSql.startsWith("CREATE") && uppercaseSql.contains("VIEW")) {
            String viewName = null;
            Pattern pattern = Pattern.compile("\\sview\\s([^\\s(]+)", 2);
            Matcher matcher = pattern.matcher(sql);
            if (matcher.find()) {
                viewName = matcher.group(1);
            }
            if (viewName != null) {
                return "drop view " + viewName + ";\n" + sql;
            }
            return sql;
        }
        return StringUtils.replaceOnceIgnoreCase((String)sql, (String)"create", (String)"create or replace");
    }

    public boolean supportsSliceTables() {
        return true;
    }

    public String getSliceTableSql(String columnName, int sliceNum, int totalSlices) {
        return "ascii(substring(" + columnName + ", 1, 1)) % " + totalSlices + " = " + sliceNum;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        if (column.getJdbcTypeName() != null && column.getJdbcTypeName().startsWith("json")) {
            return false;
        }
        return super.canColumnBeUsedInWhereClause(column);
    }

    public String getCharSetName() {
        return (String)this.getSqlTemplate().queryForObject("select pg_encoding_to_char(encoding) from pg_database\r\nwhere datname = current_database()", String.class, new Object[0]);
    }
}

