/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.CompressionTypes;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.DdlException;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2008DatabasePlatform;
import org.jumpmind.db.sql.ChangeCatalogConnectionHandler;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.mapper.StringMapper;

public class MsSqlDdlReader
extends AbstractJdbcDdlReader {
    private static final String[] KNOWN_SYSTEM_TABLES = new String[]{"dtproperties"};
    private Pattern isoDatePattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})'");
    private Pattern isoTimePattern = Pattern.compile("'(\\d{2}:\\d{2}:\\d{2})'");

    public MsSqlDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
    }

    @Override
    protected String getTableNamePattern(String tableName) {
        tableName = tableName.replace("_", "\\_");
        tableName = tableName.replace("%", "\\%");
        return tableName;
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        for (int idx = 0; idx < KNOWN_SYSTEM_TABLES.length; ++idx) {
            if (!KNOWN_SYSTEM_TABLES[idx].equals(tableName)) continue;
            return null;
        }
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)table.getSchema(), (CharSequence)"sys")) {
                return null;
            }
            this.determineAutoIncrementFromResultSetMetaData(connection, table, table.getColumns());
            int idx = 0;
            while (idx < table.getIndexCount()) {
                IIndex index = table.getIndex(idx);
                if (index.isUnique() && this.existsPKWithName(metaData, table, index.getName())) {
                    table.removeIndex(idx);
                    continue;
                }
                ++idx;
            }
            if (this.platform instanceof MsSql2008DatabasePlatform) {
                JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
                String sql = "SELECT [TABLENAME] = t.[Name]\n        ,[INDEXNAME] = i.[Name]\n        ,[IndexType] = i.[type_desc]\n        ,[FILTER] = i.filter_definition\n        ,[HASFILTER] = i.has_filter\n        ,[COMPRESSIONTYPE] = p.data_compression\n        ,[COMPRESSIONDESCRIPTION] = p.data_compression_desc\nFROM sys.indexes i\nINNER JOIN sys.tables t ON t.object_id = i.object_id\nINNER JOIN sys.partitions p ON p.object_id=t.object_id AND p.index_id=i.index_id\nWHERE t.type_desc = N'USER_TABLE'\nand t.name=?\nand p.index_id in (0,1)";
                ArrayList<String> l = new ArrayList<String>();
                l.add(tableName);
                this.log.debug("Running the following query to get metadata about whether a table has compression\n {}", (Object)sql);
                List filters = sqlTemplate.query(sql, l.toArray());
                for (Row filter : filters) {
                    int compressionType = filter.getInt("COMPRESSIONTYPE");
                    boolean hasCompression = compressionType > 0;
                    if (!hasCompression) continue;
                    if (compressionType == 1) {
                        this.log.debug("table: " + tableName + " has compression: " + CompressionTypes.ROW.name());
                        table.setCompressionType(CompressionTypes.ROW);
                        continue;
                    }
                    if (compressionType == 2) {
                        this.log.debug("table: " + tableName + " has compression: " + CompressionTypes.PAGE.name());
                        table.setCompressionType(CompressionTypes.PAGE);
                        continue;
                    }
                    if (compressionType == 3) {
                        this.log.debug("table: " + tableName + " has compression: " + CompressionTypes.COLUMNSTORE.name());
                        table.setCompressionType(CompressionTypes.COLUMNSTORE);
                        continue;
                    }
                    if (compressionType == 4) {
                        this.log.debug("table: " + tableName + " has compression: " + CompressionTypes.COLUMNSTORE_ARCHIVE.name());
                        table.setCompressionType(CompressionTypes.COLUMNSTORE_ARCHIVE);
                        continue;
                    }
                    table.setCompressionType(CompressionTypes.NONE);
                }
            }
        }
        return table;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        StringBuilder pkIndexName = new StringBuilder();
        pkIndexName.append("PK__");
        pkIndexName.append(table.getName());
        pkIndexName.append("__");
        return index.getName().toUpperCase().startsWith(pkIndexName.toString().toUpperCase());
    }

    private boolean existsPKWithName(DatabaseMetaDataWrapper metaData, Table table, String name) {
        try {
            ResultSet pks = metaData.getPrimaryKeys(table.getName());
            boolean found = false;
            while (pks.next() && !found) {
                if (!name.equals(pks.getString("PK_NAME"))) continue;
                found = true;
            }
            pks.close();
            return found;
        }
        catch (SQLException ex) {
            throw new DdlException((Throwable)ex);
        }
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        int size = -1;
        String columnSize = (String)values.get("COLUMN_SIZE");
        if (StringUtils.isNotBlank((CharSequence)columnSize)) {
            size = Integer.parseInt(columnSize);
        }
        if (typeName != null) {
            if (typeName.toLowerCase().startsWith("text")) {
                return -1;
            }
            if (typeName.toLowerCase().startsWith("ntext")) {
                return 2005;
            }
            if (typeName.toLowerCase().equals("float")) {
                return 6;
            }
            if (typeName.toUpperCase().contains("GEOMETRY")) {
                return 12;
            }
            if (typeName.toUpperCase().contains("GEOGRAPHY")) {
                return 12;
            }
            if (typeName.toUpperCase().contains("VARCHAR") && size > 8000) {
                return -1;
            }
            if (typeName.toUpperCase().contains("NVARCHAR") && size > 4000) {
                return -16;
            }
            if (typeName.toUpperCase().equals("SQL_VARIANT")) {
                return -2;
            }
            if (typeName.equalsIgnoreCase("DATETIMEOFFSET")) {
                return -101;
            }
            if (typeName.equalsIgnoreCase("datetime2")) {
                return 93;
            }
            if (typeName.equalsIgnoreCase("DATE")) {
                return 91;
            }
            if (typeName.equalsIgnoreCase("TIME")) {
                return 92;
            }
            if (typeName.equalsIgnoreCase("VARBINARY") && size > 8000) {
                return 2004;
            }
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        String defaultValue = column.getDefaultValue();
        if (column.isGenerated() && defaultValue == null) {
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
            String sql = "SELECT definition\nFROM sys.computed_columns\nWHERE OBJECT_NAME(object_id) = ?\nAND name = ?";
            ArrayList<String> l = new ArrayList<String>();
            l.add((String)values.get("TABLE_NAME"));
            l.add(column.getName());
            String definition = sqlTemplate.queryForString(sql, l.toArray());
            column.setDefaultValue(definition);
        }
        if (defaultValue != null) {
            while (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            if (column.getMappedTypeCode() == 93) {
                Matcher matcher = this.isoDatePattern.matcher(defaultValue);
                Timestamp timestamp = null;
                if (matcher.matches()) {
                    timestamp = new Timestamp(Date.valueOf(matcher.group(1)).getTime());
                } else {
                    matcher = this.isoTimePattern.matcher(defaultValue);
                    if (matcher.matches()) {
                        timestamp = new Timestamp(Time.valueOf(matcher.group(1)).getTime());
                    }
                }
                if (timestamp != null) {
                    defaultValue = timestamp.toString();
                }
            } else if (column.getMappedTypeCode() == 3 || column.getMappedTypeCode() == -5) {
                if (column.getScale() == 0 && defaultValue.endsWith(".")) {
                    defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                }
            } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                if (defaultValue.startsWith("N'") && defaultValue.endsWith("'")) {
                    defaultValue = defaultValue.substring(2, defaultValue.length() - 1);
                }
                defaultValue = this.unescape(defaultValue, "'", "''");
            }
            column.setDefaultValue(defaultValue);
        }
        if (column.getMappedTypeCode() == 3 && column.getSizeAsInt() == 19 && column.getScale() == 0) {
            column.setMappedTypeCode(-5);
        }
        if (column.getJdbcTypeName() != null && (column.getJdbcTypeName().equals("smallmoney") || column.getJdbcTypeName().equals("money") || column.getJdbcTypeName().equals("uniqueidentifier") || column.getJdbcTypeName().equals("date")) || column.getJdbcTypeName().equals("timestamp")) {
            this.removePlatformColumnSize(column);
        }
        if (column.getJdbcTypeName() != null) {
            if (column.getJdbcTypeName().equalsIgnoreCase("datetime2")) {
                this.adjustColumnSize(column, -20);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("datetime")) {
                column.setSize("3");
                this.removePlatformColumnSize(column);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("time")) {
                this.adjustColumnSize(column, -9);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("datetimeoffset")) {
                this.adjustColumnSize(column, -27);
            } else if (column.getJdbcTypeName().equalsIgnoreCase("date") || column.getJdbcTypeName().equalsIgnoreCase("smalldatetime")) {
                this.removeColumnSize(column);
            }
        }
        return column;
    }

    @Override
    public List<String> getTableNames(String catalog, String schema, String[] tableTypes) {
        StringBuilder sql = new StringBuilder("select \"TABLE_NAME\" from ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            sql.append("\"").append(catalog).append("\"").append(".");
        }
        sql.append("\"INFORMATION_SCHEMA\".\"TABLES\" where \"TABLE_TYPE\"='BASE TABLE'");
        ArrayList<String> args = new ArrayList<String>(2);
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            sql.append(" and \"TABLE_CATALOG\"=?");
            args.add(catalog);
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            sql.append(" and \"TABLE_SCHEMA\"=?");
            args.add(schema);
        }
        return schema == null ? new ArrayList<String>() : this.platform.getSqlTemplateDirty().queryWithHandler(sql.toString(), (ISqlRowMapper)new StringMapper(), (IConnectionHandler)new ChangeCatalogConnectionHandler(catalog), args.toArray(new Object[args.size()]));
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        String sql = "select TRIG.name, TAB.name as table_name, SC.name as table_schema, TRIG.is_disabled, TRIG.is_ms_shipped, TRIG.is_not_for_replication, TRIG.is_instead_of_trigger, TRIG.create_date, TRIG.modify_date, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsUpdateTrigger') AS isupdate, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsDeleteTrigger') AS isdelete, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsInsertTrigger') AS isinsert, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsAfterTrigger') AS isafter, OBJECTPROPERTY(TRIG.OBJECT_ID, 'ExecIsInsteadOfTrigger') AS isinsteadof, TRIG.object_id, TRIG.parent_id, TAB.schema_id, OBJECT_DEFINITION(TRIG.OBJECT_ID) as trigger_source from sys.triggers as TRIG inner join sys.tables as TAB on TRIG.parent_id = TAB.object_id inner join sys.schemas as SC on TAB.schema_id = SC.schema_id where TAB.name=? and SC.name=? ";
        return sqlTemplate.queryWithHandler(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("name"));
                trigger.setSchemaName(row.getString("table_schema"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setEnabled(Boolean.valueOf(row.getString("is_disabled")) == false);
                trigger.setSource(row.getString("trigger_source"));
                row.remove((Object)"trigger_source");
                for (String s : new String[]{"isupdate", "isdelete", "isinsert", "isafter", "isinsteadof"}) {
                    if (row.getString(s).equals("0")) {
                        row.put(s, (Object)false);
                        continue;
                    }
                    row.put(s, (Object)true);
                }
                if (row.getBoolean("isupdate")) {
                    trigger.setTriggerType(Trigger.TriggerType.UPDATE);
                } else if (row.getBoolean("isdelete")) {
                    trigger.setTriggerType(Trigger.TriggerType.DELETE);
                } else if (row.getBoolean("isinsert")) {
                    trigger.setTriggerType(Trigger.TriggerType.INSERT);
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, (IConnectionHandler)new ChangeCatalogConnectionHandler(catalog), new Object[]{tableName, schema});
    }

    @Override
    protected IConnectionHandler getConnectionHandler(String catalog) {
        return new ChangeCatalogConnectionHandler(catalog == null ? this.platform.getDefaultCatalog() : catalog);
    }

    @Override
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        Collection<IIndex> cIndex = super.readIndices(connection, metaData, tableName);
        if (this.platform instanceof MsSql2008DatabasePlatform && cIndex != null && cIndex.size() > 0) {
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
            String sql = "SELECT [TABLENAME] = t.[Name]\n        ,[INDEXNAME] = i.[Name]\n        ,[IndexType] = i.[type_desc]\n        ,[FILTER] = i.filter_definition\n        ,[HASFILTER] = i.has_filter\n        ,[COMPRESSIONTYPE] = p.data_compression\n        ,[COMPRESSIONDESCRIPTION] = p.data_compression_desc\nFROM sys.indexes i\nINNER JOIN sys.tables t ON t.object_id = i.object_id\nINNER JOIN sys.partitions p ON p.object_id=t.object_id AND p.index_id=i.index_id\nWHERE t.type_desc = N'USER_TABLE'\nand t.name=?\nand i.name in (%s)\nand p.index_id > 1";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < cIndex.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("?");
            }
            sql = String.format(sql, sb.toString());
            ArrayList<String> l = new ArrayList<String>();
            l.add(tableName);
            for (IIndex index : cIndex) {
                l.add(index.getName());
            }
            this.log.debug("Running the following query to get metadata about whether an index has compression or filters\n {}", (Object)sql);
            List filters = sqlTemplate.query(sql, l.toArray());
            for (Row filter : filters) {
                boolean hasCompression;
                String indexName = filter.getString("INDEXNAME");
                IIndex iIndex = this.findIndex(indexName, cIndex);
                if (iIndex == null) continue;
                boolean hasFilter = filter.getBoolean("HASFILTER");
                int compressionType = filter.getInt("COMPRESSIONTYPE");
                boolean bl = hasCompression = compressionType > 0;
                if (!hasFilter && !hasCompression) continue;
                PlatformIndex platformIndex = new PlatformIndex();
                platformIndex.setName(indexName);
                if (hasFilter) {
                    this.log.debug("table: " + tableName + " index: " + indexName + " has filter: " + filter.getString("FILTER"));
                    platformIndex.setFilterCondition("WHERE " + filter.getString("FILTER"));
                }
                if (hasCompression) {
                    if (compressionType == 1) {
                        this.log.debug("table: " + tableName + " index: " + indexName + " has compression: " + CompressionTypes.ROW.name());
                        platformIndex.setCompressionType(CompressionTypes.ROW);
                    } else if (compressionType == 2) {
                        this.log.debug("table: " + tableName + " index: " + indexName + " has compression: " + CompressionTypes.PAGE.name());
                        platformIndex.setCompressionType(CompressionTypes.PAGE);
                    } else if (compressionType == 3) {
                        this.log.debug("table: " + tableName + " index: " + indexName + " has compression: " + CompressionTypes.COLUMNSTORE.name());
                        platformIndex.setCompressionType(CompressionTypes.COLUMNSTORE);
                    } else if (compressionType == 4) {
                        this.log.debug("table: " + tableName + " index: " + indexName + " has compression: " + CompressionTypes.COLUMNSTORE_ARCHIVE.name());
                        platformIndex.setCompressionType(CompressionTypes.COLUMNSTORE_ARCHIVE);
                    } else {
                        platformIndex.setCompressionType(CompressionTypes.NONE);
                    }
                }
                iIndex.addPlatformIndex(platformIndex);
            }
        }
        return cIndex;
    }

    private IIndex findIndex(String indexName, Collection<IIndex> cIndex) {
        for (IIndex index : cIndex) {
            if (!StringUtils.equals((CharSequence)index.getName(), (CharSequence)indexName)) continue;
            return index;
        }
        return null;
    }

    @Override
    protected String getWithNoLockHint() {
        return " WITH (NOLOCK) ";
    }
}

