/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.MetaDataColumnDescriptor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class H2DdlReader
extends AbstractJdbcDdlReader {
    private boolean isVersion2;

    public H2DdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.isVersion2 = platform.getSqlTemplate().getDatabaseMajorVersion() == 2;
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null && table.getColumnsAsList().stream().anyMatch(col -> col.getDefaultValue() != null && col.getDefaultValue().contains("(") && col.getDefaultValue().contains(")"))) {
            this.determineGeneratedColumns(connection, table, table.getColumns());
        }
        return table;
    }

    protected void determineGeneratedColumns(Connection conn, Table table, Column[] columnsToCheck) {
        StringBuilder query = new StringBuilder();
        if (columnsToCheck == null || columnsToCheck.length == 0) {
            return;
        }
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        String isGeneratedColumnName = "is_computed";
        if (this.isVersion2) {
            isGeneratedColumnName = "is_generated";
        }
        query.append("SELECT column_name, " + isGeneratedColumnName + " FROM information_schema.columns WHERE ");
        ArrayList<String> l = new ArrayList<String>();
        if (table.getCatalog() != null) {
            query.append("table_catalog = ? AND ");
            l.add(table.getCatalog());
        }
        if (table.getSchema() != null) {
            query.append("table_schema = ? AND ");
            l.add(table.getSchema());
        }
        query.append("table_name = ?");
        l.add(table.getName());
        List result = sqlTemplate.query(query.toString(), l.toArray());
        block0: for (Column column : columnsToCheck) {
            for (Row row : result) {
                if (!column.getName().equalsIgnoreCase(row.getString("column_name"))) continue;
                if (this.isVersion2) {
                    column.setGenerated("ALWAYS".equals(row.getString("is_generated")));
                    continue block0;
                }
                column.setGenerated(row.getBoolean("is_computed"));
                continue block0;
            }
        }
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String autoIncrement;
        String maxLength;
        Column column = super.readColumn(metaData, values);
        if (values.get("CHARACTER_MAXIMUM_LENGTH") != null && StringUtils.isNotBlank((CharSequence)(maxLength = (String)values.get("CHARACTER_MAXIMUM_LENGTH")))) {
            Integer size = Integer.valueOf(maxLength);
            if (!this.isVersion2 && size == Integer.MAX_VALUE && column.getMappedTypeCode() == 12) {
                column.setMappedTypeCode(-1);
                column.setMappedType("LONGVARCHAR");
                column.findPlatformColumn(this.platform.getName()).setType("LONGVARCHAR");
            }
            column.setSize(size.toString());
            column.findPlatformColumn(this.platform.getName()).setSize(size.intValue());
        }
        if (values.get("COLUMN_DEFAULT") != null) {
            column.setDefaultValue(values.get("COLUMN_DEFAULT").toString());
        }
        if (values.get("NUMERIC_SCALE") != null && values.get("DECIMAL_DIGITS") != null && (Integer)values.get("DECIMAL_DIGITS") == 0) {
            int scale = (Integer)values.get("NUMERIC_SCALE");
            column.setScale(scale);
            column.findPlatformColumn(this.platform.getName()).setDecimalDigits(scale);
        }
        if (column.getMappedTypeCode() == 93) {
            this.resetColumnSize(column, column.getScale() > 9 ? "9" : String.valueOf(column.getScale()));
        }
        if (column.getMappedTypeCode() == 92) {
            this.resetColumnSize(column, "0");
        }
        if (column.getMappedTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        String defaultValue = column.getDefaultValue();
        if (TypeMap.isTextType((int)column.getMappedTypeCode()) && defaultValue != null) {
            column.setDefaultValue(this.unescape(defaultValue, "'", "''"));
        }
        if ((autoIncrement = (String)values.get("IS_AUTOINCREMENT")) != null && "YES".equalsIgnoreCase(autoIncrement.trim()) || this.isVersion2 && defaultValue != null && defaultValue.toUpperCase().startsWith("NEXTVAL(")) {
            column.setAutoIncrement(true);
            column.setDefaultValue(null);
        }
        return column;
    }

    @Override
    protected String getResultSetSchemaName() {
        if (this.isVersion2) {
            return "TABLE_SCHEM";
        }
        return "TABLE_SCHEMA";
    }

    @Override
    protected String getResultSetCatalogName() {
        if (this.isVersion2) {
            return "TABLE_CAT";
        }
        return "TABLE_CATALOG";
    }

    @Override
    protected List<MetaDataColumnDescriptor> initColumnsForColumn() {
        List<MetaDataColumnDescriptor> result = super.initColumnsForColumn();
        result.add(new MetaDataColumnDescriptor("COLUMN_DEFAULT", 12));
        result.add(new MetaDataColumnDescriptor("NUMERIC_SCALE", 4, (Object)0));
        result.add(new MetaDataColumnDescriptor("CHARACTER_MAXIMUM_LENGTH", 12));
        return result;
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) {
        String name = index.getName();
        return name != null && (name.startsWith(fk.getName()) || name.startsWith("CONSTRAINT_INDEX_"));
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        String name = index.getName();
        return name != null && name.startsWith("PRIMARY_KEY_");
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        String triggerTypeColumnName;
        String tableNameColumnName;
        if (this.isVersion2) {
            tableNameColumnName = "EVENT_OBJECT_TABLE";
            triggerTypeColumnName = "EVENT_MANIPULATION";
        } else {
            tableNameColumnName = "TABLE_NAME";
            triggerTypeColumnName = "TRIGGER_TYPE";
        }
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT * FROM INFORMATION_SCHEMA.TRIGGERS WHERE " + tableNameColumnName + "=? and TRIGGER_SCHEMA=? and TRIGGER_CATALOG=? ;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                String triggerType;
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setCatalogName(row.getString("TRIGGER_CATALOG"));
                trigger.setSchemaName(row.getString("TRIGGER_SCHEMA"));
                trigger.setTableName(row.getString(tableNameColumnName));
                trigger.setEnabled(true);
                if (!H2DdlReader.this.isVersion2) {
                    trigger.setSource(row.getString("SQL"));
                    row.remove((Object)"SQL");
                }
                if ((triggerType = row.getString(triggerTypeColumnName)).equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema, catalog});
        return triggers;
    }
}

