/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.ase;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.ase.AseDdlBuilder;
import org.jumpmind.db.platform.ase.AseDdlReader;
import org.jumpmind.db.platform.ase.AseJdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BinaryEncoding;

public class AseDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String JDBC_DRIVER_OLD = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String JDBC_SUBPROTOCOL = "sybase:Tds";
    public static final long MAX_TEXT_SIZE = Integer.MAX_VALUE;
    private Map<String, String> sqlScriptReplacementTokens = super.getSqlScriptReplacementTokens();

    public AseDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        if (this.sqlScriptReplacementTokens == null) {
            this.sqlScriptReplacementTokens = new HashMap<String, String>();
        }
        this.sqlScriptReplacementTokens.put("current_timestamp", "getdate()");
        this.useMultiThreadSyncTriggers = false;
    }

    protected AseDdlBuilder createDdlBuilder() {
        return new AseDdlBuilder();
    }

    @Override
    protected AseDdlReader createDdlReader() {
        return new AseDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected AseJdbcSqlTemplate createSqlTemplate() {
        return new AseJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return "ase";
    }

    public String getDefaultCatalog() {
        if (StringUtils.isBlank((CharSequence)this.defaultCatalog)) {
            this.defaultCatalog = (String)this.getSqlTemplate().queryForObject("select DB_NAME()", String.class, new Object[0]);
        }
        return this.defaultCatalog;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select USER_NAME()", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public Map<String, String> getSqlScriptReplacementTokens() {
        return this.sqlScriptReplacementTokens;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        return !this.isLob(column.getJdbcTypeCode()) && super.canColumnBeUsedInWhereClause(column);
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "create trigger TEST_TRIGGER on " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " for insert as begin select 1 end";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    protected Object getObjectValue(String value, Column column, BinaryEncoding encoding, boolean useVariableDates, boolean fitToColumn) throws DecoderException {
        String objectValue = value;
        String typeName = column.getJdbcTypeName();
        if (typeName.equalsIgnoreCase("unichar") || typeName.equalsIgnoreCase("unitext") || typeName.equalsIgnoreCase("univarchar")) {
            String stringValue = this.cleanTextForTextBasedColumns(objectValue);
            int size = column.getSizeAsInt();
            if (this.settings.isRightTrimCharValues()) {
                stringValue = StringUtils.stripEnd((String)stringValue, null);
            }
            if (fitToColumn && size > 0 && stringValue.length() > size) {
                stringValue = stringValue.substring(0, size);
            }
            objectValue = stringValue;
            return objectValue;
        }
        return super.getObjectValue(value, column, encoding, useVariableDates, fitToColumn);
    }
}

