/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.NonUniqueIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.model.UniqueIndex;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.MetaDataColumnDescriptor;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.db.util.TableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcDdlReader
implements IDdlReader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<MetaDataColumnDescriptor> _columnsForTable;
    private final List<MetaDataColumnDescriptor> _columnsForColumn;
    private final List<MetaDataColumnDescriptor> _columnsForPK;
    private final List<MetaDataColumnDescriptor> _columnsForFK;
    private final List<MetaDataColumnDescriptor> _columnsForIndex;
    protected IDatabasePlatform platform;
    private HashMap<Integer, String> _defaultSizes = new HashMap();
    private String _defaultCatalogPattern = "%";
    private String _defaultSchemaPattern = "%";
    private String _defaultTablePattern = "%";
    private String _defaultColumnPattern;
    private String[] _defaultTableTypes = new String[]{"TABLE"};

    public AbstractJdbcDdlReader(IDatabasePlatform platform) {
        this.platform = platform;
        this._defaultSizes.put(1, "254");
        this._defaultSizes.put(12, "254");
        this._defaultSizes.put(-1, "254");
        this._defaultSizes.put(-2, "254");
        this._defaultSizes.put(-3, "254");
        this._defaultSizes.put(-4, "254");
        this._defaultSizes.put(4, "32");
        this._defaultSizes.put(-5, "64");
        this._defaultSizes.put(7, "7,0");
        this._defaultSizes.put(6, "15,0");
        this._defaultSizes.put(8, "15,0");
        this._defaultSizes.put(3, "15,15");
        this._defaultSizes.put(2, "15,15");
        this._columnsForTable = this.initColumnsForTable();
        this._columnsForColumn = this.initColumnsForColumn();
        this._columnsForPK = this.initColumnsForPK();
        this._columnsForFK = this.initColumnsForFK();
        this._columnsForIndex = this.initColumnsForIndex();
    }

    public List<Trigger> getTriggers(String catalog, String schema, String tableName) {
        return Collections.emptyList();
    }

    public IDatabasePlatform getPlatform() {
        return this.platform;
    }

    public DatabaseInfo getPlatformInfo() {
        return this.platform.getDatabaseInfo();
    }

    protected List<MetaDataColumnDescriptor> initColumnsForTable() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor(this.getName("TABLE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("TABLE_TYPE"), 12, (Object)"UNKNOWN"));
        result.add(new MetaDataColumnDescriptor(this.getResultSetCatalogName(), 12));
        result.add(new MetaDataColumnDescriptor(this.getResultSetSchemaName(), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("REMARKS"), 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForColumn() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor(this.getName("COLUMN_DEF"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("COLUMN_DEFAULT"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("TABLE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("COLUMN_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("TYPE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("DATA_TYPE"), 4, (Object)1111));
        result.add(new MetaDataColumnDescriptor(this.getName("NUM_PREC_RADIX"), 4, (Object)10));
        result.add(new MetaDataColumnDescriptor(this.getName("DECIMAL_DIGITS"), 4, (Object)0));
        result.add(new MetaDataColumnDescriptor(this.getName("COLUMN_SIZE"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("CHAR_OCTET_LENGTH"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("IS_NULLABLE"), 12, (Object)"YES"));
        result.add(new MetaDataColumnDescriptor(this.getName("IS_AUTOINCREMENT"), 12, (Object)"YES"));
        result.add(new MetaDataColumnDescriptor(this.getName("REMARKS"), 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForPK() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor(this.getName("COLUMN_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("TABLE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("PK_NAME"), 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForFK() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor(this.getName("PKTABLE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("FKTABLE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("KEY_SEQ"), -6, (Object)0));
        result.add(new MetaDataColumnDescriptor(this.getName("FK_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("FKTABLE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("PKCOLUMN_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("FKCOLUMN_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("UPDATE_RULE"), -6));
        result.add(new MetaDataColumnDescriptor(this.getName("DELETE_RULE"), -6));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForIndex() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor(this.getName("INDEX_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("TABLE_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("NON_UNIQUE"), -7, (Object)Boolean.TRUE));
        result.add(new MetaDataColumnDescriptor(this.getName("ORDINAL_POSITION"), -6, (Object)0));
        result.add(new MetaDataColumnDescriptor(this.getName("COLUMN_NAME"), 12));
        result.add(new MetaDataColumnDescriptor(this.getName("TYPE"), -6));
        return result;
    }

    protected String getName(String defaultName) {
        return defaultName;
    }

    public String getDefaultCatalogPattern() {
        return this._defaultCatalogPattern;
    }

    public void setDefaultCatalogPattern(String catalogPattern) {
        this._defaultCatalogPattern = catalogPattern;
    }

    public String getDefaultSchemaPattern() {
        return this._defaultSchemaPattern;
    }

    public void setDefaultSchemaPattern(String schemaPattern) {
        this._defaultSchemaPattern = schemaPattern;
    }

    public String getDefaultTablePattern() {
        return this._defaultTablePattern;
    }

    public void setDefaultTablePattern(String tablePattern) {
        this._defaultTablePattern = tablePattern;
    }

    public String getDefaultColumnPattern() {
        return this._defaultColumnPattern;
    }

    public void setDefaultColumnPattern(String columnPattern) {
        this._defaultColumnPattern = columnPattern;
    }

    public String[] getDefaultTableTypes() {
        return this._defaultTableTypes;
    }

    public void setDefaultTableTypes(String[] types) {
        this._defaultTableTypes = types;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForTable() {
        return this._columnsForTable;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForColumn() {
        return this._columnsForColumn;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForPK() {
        return this._columnsForPK;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForFK() {
        return this._columnsForFK;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForIndex() {
        return this._columnsForIndex;
    }

    public Database getDatabase(Connection connection) throws SQLException {
        return this.readTables(null, null, null);
    }

    protected String getResultSetSchemaName() {
        return "TABLE_SCHEM";
    }

    protected String getResultSetCatalogName() {
        return "TABLE_CAT";
    }

    public Database readTables(final String catalog, final String schema, final String[] tableTypes) {
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        return this.postprocessModelFromDatabase(sqlTemplate.execute(new IConnectionCallback<Database>(){

            @Override
            public Database execute(Connection connection) throws SQLException {
                Database db = new Database();
                db.setName(Table.getFullyQualifiedTablePrefix((String)catalog, (String)schema));
                db.setCatalog(catalog);
                db.setSchema(schema);
                db.addTables(AbstractJdbcDdlReader.this.readTables(connection, catalog, schema, tableTypes));
                db.initialize();
                return db;
            }
        }));
    }

    protected Database postprocessModelFromDatabase(Database model) {
        for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            this.postprocessTableFromDatabase(model.getTable(tableIdx));
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Table> readTables(Connection connection, String catalog, String schemaPattern, String[] tableTypes) throws SQLException {
        try (ResultSet tableData = null;){
            DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
            metaData.setMetaData(connection.getMetaData());
            metaData.setCatalog(catalog == null ? this.getDefaultCatalogPattern() : catalog);
            metaData.setSchemaPattern(schemaPattern == null ? this.getDefaultSchemaPattern() : schemaPattern);
            metaData.setTableTypes(tableTypes == null || tableTypes.length == 0 ? this.getDefaultTableTypes() : tableTypes);
            tableData = metaData.getTables(this.getDefaultTablePattern());
            ArrayList<Table> tables = new ArrayList<Table>();
            while (tableData.next()) {
                Map<String, Object> values = this.readMetaData(tableData, this.getColumnsForTable());
                Table table = this.readTable(connection, metaData, values);
                if (table == null) continue;
                tables.add(table);
            }
            final Collator collator = Collator.getInstance();
            Collections.sort(tables, new Comparator<Table>(){

                @Override
                public int compare(Table obj1, Table obj2) {
                    return collator.compare(obj1.getName().toUpperCase(), obj2.getName().toUpperCase());
                }
            });
            ArrayList<Table> arrayList = tables;
            return arrayList;
        }
    }

    public Table readTable(final String catalog, final String schema, final String table) {
        try {
            this.log.debug("reading table: " + table);
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
            return this.postprocessTableFromDatabase(sqlTemplate.execute(new IConnectionCallback<Table>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Table execute(Connection connection) throws SQLException {
                    ResultSet tableData;
                    block5: {
                        DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
                        metaData.setMetaData(connection.getMetaData());
                        if (StringUtils.isNotBlank((CharSequence)catalog)) {
                            metaData.setCatalog(catalog);
                        }
                        if (StringUtils.isNotBlank((CharSequence)schema)) {
                            metaData.setSchemaPattern(schema);
                        }
                        metaData.setTableTypes(null);
                        tableData = null;
                        try {
                            AbstractJdbcDdlReader.this.log.debug("getting table metadata for {}", (Object)table);
                            tableData = metaData.getTables(AbstractJdbcDdlReader.this.getTableNamePattern(table));
                            AbstractJdbcDdlReader.this.log.debug("done getting table metadata for {}", (Object)table);
                            if (tableData == null || !tableData.next()) break block5;
                            Map<String, Object> values = AbstractJdbcDdlReader.this.readMetaData(tableData, AbstractJdbcDdlReader.this.initColumnsForTable());
                            Table table2 = AbstractJdbcDdlReader.this.readTable(connection, metaData, values);
                            AbstractJdbcDdlReader.this.close(tableData);
                            return table2;
                        }
                        catch (Throwable throwable) {
                            AbstractJdbcDdlReader.this.close(tableData);
                            throw throwable;
                        }
                    }
                    AbstractJdbcDdlReader.this.log.debug("table {} not found", (Object)table);
                    Table table3 = null;
                    AbstractJdbcDdlReader.this.close(tableData);
                    return table3;
                }
            }));
        }
        catch (SqlException e) {
            if (e.getMessage() != null && StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"does not exist")) {
                return null;
            }
            this.log.error("Failed to get metadata for {} because: {} {}", new Object[]{Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)table), ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            throw e;
        }
    }

    protected Table postprocessTableFromDatabase(Table table) {
        if (table != null) {
            for (int columnIdx = 0; columnIdx < table.getColumnCount(); ++columnIdx) {
                String defaultValue;
                Column column = table.getColumn(columnIdx);
                if (!TypeMap.isTextType((int)column.getMappedTypeCode()) && !TypeMap.isDateTimeType((int)column.getMappedTypeCode()) || (defaultValue = column.getDefaultValue()) == null || defaultValue.length() < 2 || !defaultValue.startsWith("'") || !defaultValue.endsWith("'")) continue;
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                column.setDefaultValue(defaultValue);
            }
        }
        return table;
    }

    protected void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected String getTableNamePattern(String tableName) {
        return tableName;
    }

    protected String getTableNamePatternForConstraints(String tableName) {
        return tableName;
    }

    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String tableName = (String)values.get(this.getName("TABLE_NAME"));
        if (tableName == null) {
            tableName = (String)values.get("NAME");
        }
        try {
            Table table = null;
            if (tableName != null && tableName.length() > 0) {
                String[] unsupportedTableTypes;
                String type = (String)values.get(this.getName("TABLE_TYPE"));
                for (String unsupportedTableType : unsupportedTableTypes = this.getUnsupportedTableTypes()) {
                    if (!StringUtils.isNotBlank((CharSequence)type) || !type.equals(unsupportedTableType)) continue;
                    return null;
                }
                table = new Table();
                table.setName(tableName);
                table.setType(type);
                String catalog = (String)values.get(this.getName(this.getResultSetCatalogName()));
                table.setCatalog(catalog);
                String schema = (String)values.get(this.getName(this.getResultSetSchemaName()));
                table.setSchema(schema);
                table.setDescription((String)values.get(this.getName("REMARKS")));
                table.addColumns(this.readColumns(metaData, tableName));
                if (table.getColumnCount() > 0) {
                    table.addForeignKeys(this.readForeignKeys(connection, metaData, tableName));
                    table.addIndices(this.readIndices(connection, metaData, tableName));
                    Collection<String> primaryKeys = this.readPrimaryKeyNames(metaData, tableName);
                    int primaryKeySequence = 1;
                    Iterator<String> it = primaryKeys.iterator();
                    while (it.hasNext()) {
                        Column column = table.findColumn(it.next(), true);
                        if (column == null) continue;
                        column.setPrimaryKey(true);
                        column.setPrimaryKeySequence(primaryKeySequence);
                        ++primaryKeySequence;
                    }
                    if (this.getPlatformInfo().isSystemIndicesReturned()) {
                        this.removeSystemIndices(connection, metaData, table);
                    }
                    this.removeGeneratedColumns(connection, metaData, table);
                } else {
                    table = null;
                }
            }
            return table;
        }
        catch (RuntimeException ex) {
            this.log.error("Failed to read table: {}.  Error: {}", (Object)tableName, (Object)ex.getMessage());
            throw ex;
        }
        catch (SQLException ex) {
            this.log.error("Failed to read table: {}.  Error: {}", (Object)tableName, (Object)ex.getMessage());
            throw ex;
        }
    }

    protected String[] getUnsupportedTableTypes() {
        return new String[0];
    }

    protected void removeSystemIndices(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        this.removeInternalPrimaryKeyIndex(connection, metaData, table);
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            this.removeInternalForeignKeyIndex(connection, metaData, table, table.getForeignKey(fkIdx));
        }
    }

    protected void removeGeneratedColumns(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
    }

    protected void removeInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        Column[] pks = table.getPrimaryKeyColumns();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int columnIdx = 0; columnIdx < pks.length; ++columnIdx) {
            columnNames.add(pks[columnIdx].getName());
        }
        int indexIdx = 0;
        while (indexIdx < table.getIndexCount()) {
            IIndex index = table.getIndex(indexIdx);
            if (index.isUnique() && this.matches(index, columnNames) && this.isInternalPrimaryKeyIndex(connection, metaData, table, index)) {
                table.removeIndex(indexIdx);
                continue;
            }
            ++indexIdx;
        }
    }

    protected void removeInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int columnIdx = 0; columnIdx < fk.getReferenceCount(); ++columnIdx) {
            columnNames.add(fk.getReference(columnIdx).getLocalColumnName());
        }
        int indexIdx = 0;
        while (indexIdx < table.getIndexCount()) {
            IIndex index = table.getIndex(indexIdx);
            if (this.matches(index, columnNames) && this.isInternalForeignKeyIndex(connection, metaData, table, fk, index)) {
                fk.setAutoIndexPresent(true);
                table.removeIndex(indexIdx);
                continue;
            }
            ++indexIdx;
        }
    }

    protected boolean matches(IIndex index, List<String> columnsToSearchFor) {
        for (String column : columnsToSearchFor) {
            boolean found = false;
            for (int i = 0; i < index.getColumnCount(); ++i) {
                if (column == null || !column.equals(index.getColumn(i).getName())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        return false;
    }

    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Column> readColumns(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ResultSet columnData = null;
        try {
            HashSet<String> columnNames = new HashSet<String>();
            columnData = metaData.getColumns(this.getTableNamePattern(tableName), this.getDefaultColumnPattern());
            ArrayList<Column> columns = new ArrayList<Column>();
            while (columnData.next()) {
                Map<String, Object> values = this.readMetaData(columnData, this.getColumnsForColumn());
                Column column = this.readColumn(metaData, values);
                if (!columnNames.contains(column.getName())) {
                    columnNames.add(column.getName());
                    columns.add(column);
                }
                this.genericizeDefaultValuesAndUpdatePlatformColumn(column);
            }
            ArrayList<Column> arrayList = columns;
            this.close(columnData);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.close(columnData);
            throw throwable;
        }
    }

    protected void genericizeDefaultValuesAndUpdatePlatformColumn(Column column) {
        PlatformColumn platformColumn = column.findPlatformColumn(this.platform.getName());
        platformColumn.setDefaultValue(column.getDefaultValue());
        if ("getdate()".equalsIgnoreCase(column.getDefaultValue())) {
            column.setDefaultValue("CURRENT_TIMESTAMP");
        }
    }

    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        return null;
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = new Column();
        PlatformColumn platformColumn = new PlatformColumn();
        platformColumn.setName(this.platform.getName());
        column.setName((String)values.get(this.getName("COLUMN_NAME")));
        String defaultValue = (String)values.get(this.getName("COLUMN_DEF"));
        if (defaultValue == null) {
            defaultValue = (String)values.get(this.getName("COLUMN_DEFAULT"));
        }
        if (defaultValue != null) {
            defaultValue = defaultValue.trim();
            column.setDefaultValue(defaultValue);
        }
        String typeName = (String)values.get(this.getName("TYPE_NAME"));
        column.setJdbcTypeName(typeName);
        Integer mappedType = this.mapUnknownJdbcTypeForColumn(values);
        if (mappedType != null) {
            column.setMappedTypeCode(mappedType.intValue());
        } else {
            column.setMappedTypeCode(((Integer)values.get(this.getName("DATA_TYPE"))).intValue());
        }
        column.setJdbcTypeCode(((Integer)values.get(this.getName("DATA_TYPE"))).intValue());
        column.setPrecisionRadix(((Integer)values.get(this.getName("NUM_PREC_RADIX"))).intValue());
        String columnSize = (String)values.get(this.getName("COLUMN_SIZE"));
        int decimalDigits = (Integer)values.get(this.getName("DECIMAL_DIGITS"));
        try {
            platformColumn.setType(typeName);
            if (StringUtils.isNotBlank((CharSequence)columnSize)) {
                platformColumn.setSize(Integer.parseInt(columnSize));
            }
            platformColumn.setDecimalDigits(decimalDigits);
            column.addPlatformColumn(platformColumn);
        }
        catch (Exception ex) {
            this.log.warn("", (Throwable)ex);
        }
        if (columnSize == null) {
            columnSize = this._defaultSizes.get(column.getMappedTypeCode());
        }
        column.setSize(columnSize);
        if (decimalDigits != 0) {
            column.setScale(decimalDigits);
        }
        if (values.get(this.getName("IS_NULLABLE")) != null) {
            column.setRequired("NO".equalsIgnoreCase(((String)values.get(this.getName("IS_NULLABLE"))).trim()));
        }
        if (values.get(this.getName("IS_GENERATEDCOLUMN")) != null) {
            column.setGenerated("YES".equalsIgnoreCase(((String)values.get(this.getName("IS_GENERATEDCOLUMN"))).trim()));
        }
        column.setDescription((String)values.get(this.getName("REMARKS")));
        Object octetLength = values.get(this.getName("CHAR_OCTET_LENGTH"));
        if (octetLength != null) {
            try {
                column.setCharOctetLength(Integer.parseInt(octetLength.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> readPrimaryKeyNames(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        TreeMap<Integer, String> pks = new TreeMap<Integer, String>();
        ResultSet pkData = null;
        try {
            pkData = metaData.getPrimaryKeys(this.getTableNamePatternForConstraints(tableName));
            int i = 1;
            while (pkData.next()) {
                Map<String, Object> values = this.readMetaData(pkData, this.getColumnsForPK());
                Integer pkSequence = this.readPrimaryKeySequence(values);
                if (pkSequence != null) {
                    pks.put(pkSequence, this.readPrimaryKeyName(metaData, values));
                    continue;
                }
                pks.put(i, this.readPrimaryKeyName(metaData, values));
                ++i;
            }
            this.close(pkData);
        }
        catch (Throwable throwable) {
            this.close(pkData);
            throw throwable;
        }
        return pks.values();
    }

    protected String readPrimaryKeyName(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        return (String)values.get(this.getName("COLUMN_NAME"));
    }

    protected Integer readPrimaryKeySequence(Map<String, Object> values) throws SQLException {
        Number primaryKeySequence = (Number)values.get(this.getName("KEY_SEQ"));
        if (primaryKeySequence == null) {
            primaryKeySequence = (Number)values.get(this.getName("ORDINAL_POSITION"));
        }
        return primaryKeySequence != null ? Integer.valueOf(primaryKeySequence.intValue()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ForeignKey> readForeignKeys(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        LinkedHashMap<String, ForeignKey> fks = new LinkedHashMap<String, ForeignKey>();
        if (this.getPlatformInfo().isForeignKeysSupported()) {
            ResultSet fkData = null;
            try {
                fkData = metaData.getForeignKeys(this.getTableNamePatternForConstraints(tableName));
                while (fkData.next()) {
                    Map<String, Object> values = this.readMetaData(fkData, this.getColumnsForFK());
                    String fkTableName = (String)values.get(this.getName("FKTABLE_NAME"));
                    if (!StringUtils.isBlank((CharSequence)fkTableName) && !fkTableName.equalsIgnoreCase(tableName)) continue;
                    this.readForeignKey(metaData, values, fks);
                }
                this.close(fkData);
            }
            catch (Throwable throwable) {
                this.close(fkData);
                throw throwable;
            }
        }
        return fks.values();
    }

    protected void readForeignKey(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, ForeignKey> knownFks) throws SQLException {
        String fkName = (String)values.get(this.getName("FK_NAME"));
        ForeignKey fk = knownFks.get(fkName);
        if (fk == null) {
            fk = new ForeignKey(fkName);
            fk.setForeignTableName((String)values.get(this.getName("PKTABLE_NAME")));
            fk.setForeignTableCatalog((String)values.get(this.getName("PKTABLE_CAT")));
            fk.setForeignTableSchema((String)values.get(this.getName("PKTABLE_SCHEM")));
            this.readForeignKeyUpdateRule(values, fk);
            this.readForeignKeyDeleteRule(values, fk);
            knownFks.put(fkName, fk);
        }
        Reference ref = new Reference();
        ref.setForeignColumnName((String)values.get(this.getName("PKCOLUMN_NAME")));
        ref.setLocalColumnName((String)values.get(this.getName("FKCOLUMN_NAME")));
        if (values.containsKey(this.getName("KEY_SEQ"))) {
            ref.setSequenceValue(((Short)values.get(this.getName("KEY_SEQ"))).intValue());
        }
        fk.addReference(ref);
    }

    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk) {
        if (values.get(this.getName("UPDATE_RULE")) != null && values.get(this.getName("UPDATE_RULE")) instanceof Short) {
            fk.setOnUpdateAction(ForeignKey.getForeignKeyAction((short)((Short)values.get(this.getName("UPDATE_RULE")))));
        } else {
            fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
        }
    }

    protected void readForeignKeyDeleteRule(Map<String, Object> values, ForeignKey fk) {
        if (values.get(this.getName("DELETE_RULE")) != null && values.get(this.getName("DELETE_RULE")) instanceof Short) {
            fk.setOnDeleteAction(ForeignKey.getForeignKeyAction((short)((Short)values.get(this.getName("DELETE_RULE")))));
        } else {
            fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ForeignKey> readExportedKeys(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        LinkedHashMap<String, ForeignKey> fks = new LinkedHashMap<String, ForeignKey>();
        if (this.getPlatformInfo().isForeignKeysSupported()) {
            ResultSet fkData = null;
            try {
                fkData = metaData.getExportedKeys(this.getTableNamePatternForConstraints(tableName));
                while (fkData.next()) {
                    Map<String, Object> values = this.readMetaData(fkData, this.getColumnsForFK());
                    String fkTableName = (String)values.get(this.getName("PKTABLE_NAME"));
                    if (!StringUtils.isBlank((CharSequence)fkTableName) && !fkTableName.equalsIgnoreCase(tableName)) continue;
                    this.readExportedKey(metaData, values, fks);
                }
                this.close(fkData);
            }
            catch (Throwable throwable) {
                this.close(fkData);
                throw throwable;
            }
        }
        return fks.values();
    }

    protected void readExportedKey(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, ForeignKey> knownFks) throws SQLException {
        String fkName = (String)values.get(this.getName("FK_NAME"));
        ForeignKey fk = knownFks.get(fkName);
        if (fk == null) {
            fk = new ForeignKey(fkName);
            fk.setForeignTableName((String)values.get(this.getName("FKTABLE_NAME")));
            try {
                fk.setForeignTableCatalog((String)values.get(this.getName("FKTABLE_CAT")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fk.setForeignTableSchema((String)values.get(this.getName("FKTABLE_SCHEM")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            knownFks.put(fkName, fk);
        }
        Reference ref = new Reference();
        ref.setForeignColumnName((String)values.get(this.getName("FKCOLUMN_NAME")));
        ref.setLocalColumnName((String)values.get(this.getName("PKCOLUMN_NAME")));
        if (values.containsKey(this.getName("KEY_SEQ"))) {
            ref.setSequenceValue(((Short)values.get(this.getName("KEY_SEQ"))).intValue());
        }
        fk.addReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        LinkedHashMap<String, IIndex> indices = new LinkedHashMap<String, IIndex>();
        if (this.getPlatformInfo().isIndicesSupported()) {
            ResultSet indexData = null;
            try {
                indexData = metaData.getIndices(this.getTableNamePatternForConstraints(tableName), false, false);
                while (indexData.next()) {
                    Map<String, Object> values = this.readMetaData(indexData, this.getColumnsForIndex());
                    this.readIndex(metaData, values, indices);
                }
                this.close(indexData);
            }
            catch (Throwable throwable) {
                this.close(indexData);
                throw throwable;
            }
        }
        return indices.values();
    }

    protected void readIndex(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, IIndex> knownIndices) throws SQLException {
        Short indexType = (Short)values.get(this.getName("TYPE"));
        if (indexType != null && indexType == 0) {
            return;
        }
        String indexName = (String)values.get(this.getName("INDEX_NAME"));
        if (indexName != null) {
            Object index = knownIndices.get(indexName);
            if (index == null) {
                index = (Boolean)values.get(this.getName("NON_UNIQUE")) != false ? new NonUniqueIndex() : new UniqueIndex();
                index.setName(indexName);
                knownIndices.put(indexName, (IIndex)index);
            }
            IndexColumn indexColumn = new IndexColumn();
            String columnName = (String)values.get(this.getName("COLUMN_NAME"));
            if (columnName != null && columnName.startsWith("\"") && columnName.endsWith("\"")) {
                columnName = columnName.substring(1, columnName.length() - 1);
            }
            indexColumn.setName(columnName);
            if (values.containsKey(this.getName("ORDINAL_POSITION"))) {
                indexColumn.setOrdinalPosition(((Short)values.get(this.getName("ORDINAL_POSITION"))).intValue());
            }
            index.addColumn(indexColumn);
        }
    }

    protected Map<String, Object> readMetaData(ResultSet resultSet, List<MetaDataColumnDescriptor> columnDescriptors) throws SQLException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        HashSet<String> processed = new HashSet<String>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            boolean foundMetaDataDescriptor = false;
            String columnName = meta.getColumnName(i);
            for (MetaDataColumnDescriptor metaDataColumnDescriptor : columnDescriptors) {
                if (!metaDataColumnDescriptor.getName().equals(columnName)) continue;
                foundMetaDataDescriptor = true;
                values.put(metaDataColumnDescriptor.getName(), metaDataColumnDescriptor.readColumn(resultSet));
                processed.add(columnName);
                break;
            }
            if (foundMetaDataDescriptor) continue;
            try {
                values.put(columnName, resultSet.getObject(i));
                continue;
            }
            catch (Exception e) {
                values.put(columnName, resultSet.getString(i));
            }
        }
        for (MetaDataColumnDescriptor metaDataColumnDescriptor : columnDescriptors) {
            if (processed.contains(metaDataColumnDescriptor.getName())) continue;
            values.put(metaDataColumnDescriptor.getName(), metaDataColumnDescriptor.readColumn(resultSet));
        }
        return values;
    }

    protected void determineAutoIncrementFromResultSetMetaData(Connection conn, Table table, Column[] columnsToCheck) throws SQLException {
        this.determineAutoIncrementFromResultSetMetaData(conn, table, columnsToCheck, ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineAutoIncrementFromResultSetMetaData(Connection conn, Table table, Column[] columnsToCheck, String catalogSeparator) throws SQLException {
        StringBuilder query = new StringBuilder();
        try {
            if (columnsToCheck == null || columnsToCheck.length == 0) {
                return;
            }
            query.append("SELECT ");
            for (int idx = 0; idx < columnsToCheck.length; ++idx) {
                if (idx > 0) {
                    query.append(",");
                }
                query.append("t.");
                this.appendColumn(query, columnsToCheck[idx].getName());
            }
            query.append(" FROM ");
            if (table.getCatalog() != null && !table.getCatalog().trim().equals("")) {
                this.appendIdentifier(query, table.getCatalog());
                query.append(catalogSeparator);
            }
            if (table.getSchema() != null && !table.getSchema().trim().equals("")) {
                this.appendIdentifier(query, table.getSchema()).append(".");
            }
            this.appendIdentifier(query, table.getName()).append(" t " + this.getWithNoLockHint() + " WHERE 1 = 0");
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Running the following query to get metadata about whether a column is an auto increment column: \n{}", (Object)query);
                }
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery(query.toString());
                    ResultSetMetaData rsMetaData = rs.getMetaData();
                    for (int idx = 0; idx < columnsToCheck.length; ++idx) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(columnsToCheck[idx] + " is auto increment? " + rsMetaData.isAutoIncrement(idx + 1));
                        }
                        if (!rsMetaData.isAutoIncrement(idx + 1)) continue;
                        columnsToCheck[idx].setAutoIncrement(true);
                    }
                }
                finally {
                    this.close(rs);
                }
            }
            finally {
                this.close(stmt);
            }
        }
        catch (SQLException ex) {
            StringBuilder msg = new StringBuilder("Failed to determine auto increment columns using this query: '" + query + "'.  This is probably not harmful, but should be fixed.  ");
            msg.append("\n");
            msg.append(table);
            if (columnsToCheck != null) {
                for (Column col : columnsToCheck) {
                    msg.append("\n");
                    msg.append(col);
                }
            }
            this.log.warn(msg.toString(), (Throwable)ex);
        }
    }

    protected String getWithNoLockHint() {
        return "";
    }

    protected StringBuilder appendIdentifier(StringBuilder query, String identifier) {
        if (this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        query.append(identifier);
        if (this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        return query;
    }

    protected StringBuilder appendColumn(StringBuilder query, String identifier) {
        return this.appendIdentifier(query, identifier);
    }

    protected String unescape(String text, String unescaped, String escaped) {
        if (text != null && !"''".equals(text)) {
            text = escaped.equals("''") ? (text.length() > 2 && text.startsWith("'") && text.endsWith("'") ? "'" + StringUtils.replace((String)text.substring(1, text.length() - 1), (String)escaped, (String)unescaped) + "'" : StringUtils.replace((String)text, (String)escaped, (String)unescaped)) : StringUtils.replace((String)text, (String)escaped, (String)unescaped);
        }
        return text;
    }

    public List<String> getTableTypes() {
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        return sqlTemplate.execute(new IConnectionCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> execute(Connection connection) throws SQLException {
                ArrayList<String> types = new ArrayList<String>();
                DatabaseMetaData meta = connection.getMetaData();
                ResultSet rs = null;
                try {
                    rs = meta.getTableTypes();
                    while (rs.next()) {
                        types.add(rs.getString(1));
                    }
                    ArrayList<String> arrayList = types;
                    return arrayList;
                }
                finally {
                    JdbcSqlTemplate.close(rs);
                }
            }
        });
    }

    public List<String> getCatalogNames() {
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        return sqlTemplate.execute(new IConnectionCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> execute(Connection connection) throws SQLException {
                ArrayList<String> catalogs = new ArrayList<String>();
                DatabaseMetaData meta = connection.getMetaData();
                ResultSet rs = null;
                try {
                    rs = meta.getCatalogs();
                    while (rs.next()) {
                        String catalog = rs.getString(1);
                        if (catalog == null) continue;
                        catalogs.add(catalog);
                    }
                    ArrayList<String> arrayList = catalogs;
                    return arrayList;
                }
                finally {
                    JdbcSqlTemplate.close(rs);
                }
            }
        });
    }

    public List<String> getSchemaNames(final String catalog) {
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        return sqlTemplate.execute(new IConnectionCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> execute(Connection connection) throws SQLException {
                ArrayList<String> schemas = new ArrayList<String>();
                IConnectionHandler connectionHandler = AbstractJdbcDdlReader.this.getConnectionHandler(catalog);
                if (connectionHandler != null) {
                    connectionHandler.before(connection);
                }
                DatabaseMetaData meta = connection.getMetaData();
                ResultSet rs = null;
                try {
                    try {
                        rs = meta.getSchemas();
                    }
                    catch (SQLException e) {
                        rs = meta.getSchemas("", null);
                    }
                    while (rs.next()) {
                        int columnCount = rs.getMetaData().getColumnCount();
                        String schema = rs.getString(1);
                        String schemaCatalog = null;
                        if (columnCount > 1) {
                            schemaCatalog = rs.getString(2);
                        }
                        if ((StringUtils.isBlank(schemaCatalog) || StringUtils.isBlank((CharSequence)catalog)) && !schemas.contains(schema)) {
                            schemas.add(schema);
                            continue;
                        }
                        if (!StringUtils.isNotBlank((CharSequence)schemaCatalog) || !schemaCatalog.equals(catalog)) continue;
                        schemas.add(schema);
                    }
                    ArrayList<String> arrayList = schemas;
                    return arrayList;
                }
                finally {
                    if (connectionHandler != null) {
                        connectionHandler.after(connection);
                    }
                    AbstractJdbcDdlReader.this.close(rs);
                }
            }
        });
    }

    protected IConnectionHandler getConnectionHandler(String catalog) {
        return null;
    }

    public List<String> getTableNames(final String catalog, final String schema, final String[] tableTypes) {
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        List<String> list = sqlTemplate.execute(new IConnectionCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> execute(Connection connection) throws SQLException {
                ArrayList<String> list = new ArrayList<String>();
                DatabaseMetaData meta = connection.getMetaData();
                ResultSet rs = null;
                try {
                    rs = meta.getTables(catalog, schema, AbstractJdbcDdlReader.this.getDefaultTablePattern(), tableTypes);
                    while (rs.next()) {
                        String tableName = rs.getString("TABLE_NAME");
                        if (tableName == null) {
                            tableName = rs.getString("NAME");
                        }
                        list.add(tableName);
                    }
                    ArrayList<String> arrayList = list;
                    AbstractJdbcDdlReader.this.close(rs);
                    return arrayList;
                }
                catch (Throwable throwable) {
                    AbstractJdbcDdlReader.this.close(rs);
                    throw throwable;
                }
            }
        });
        return list;
    }

    public List<String> getColumnNames(final String catalog, final String schema, final String tableName) {
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        return sqlTemplate.execute(new IConnectionCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> execute(Connection connection) throws SQLException {
                ArrayList<String> list = new ArrayList<String>();
                DatabaseMetaData meta = connection.getMetaData();
                ResultSet rs = null;
                try {
                    rs = meta.getColumns(catalog, schema, tableName, null);
                    while (rs.next()) {
                        String tableName2 = rs.getString(AbstractJdbcDdlReader.this.getName("COLUMN_NAME"));
                        list.add(tableName2);
                    }
                    ArrayList<String> arrayList = list;
                    AbstractJdbcDdlReader.this.close(rs);
                    return arrayList;
                }
                catch (Throwable throwable) {
                    AbstractJdbcDdlReader.this.close(rs);
                    throw throwable;
                }
            }
        });
    }

    public List<String> getListOfTriggers() {
        return new ArrayList<String>();
    }

    public Trigger getTriggerFor(Table table, String triggerName) {
        Trigger trigger = null;
        List<Trigger> triggers = this.getTriggers(table.getCatalog(), table.getSchema(), table.getName());
        for (Trigger t : triggers) {
            if (!t.getName().equalsIgnoreCase(triggerName)) continue;
            trigger = t;
            break;
        }
        return trigger;
    }

    public Collection<ForeignKey> getExportedKeys(final Table table) {
        try {
            JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
            return sqlTemplate.execute(new IConnectionCallback<Collection<ForeignKey>>(){

                @Override
                public Collection<ForeignKey> execute(Connection connection) throws SQLException {
                    DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
                    metaData.setMetaData(connection.getMetaData());
                    metaData.setCatalog(table.getCatalog());
                    metaData.setSchemaPattern(table.getSchema());
                    metaData.setTableTypes(null);
                    return AbstractJdbcDdlReader.this.readExportedKeys(connection, metaData, table.getName());
                }
            });
        }
        catch (SqlException e) {
            if (e.getMessage() != null && StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"does not exist")) {
                return null;
            }
            this.log.error("Failed to get metadata for {}, because {} {}", new Object[]{table.getFullyQualifiedTableName(), ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            throw e;
        }
    }

    public List<TableRow> getExportedForeignTableRows(ISqlTransaction transaction, List<TableRow> tableRows, Set<TableRow> visited, BinaryEncoding encoding) {
        ArrayList<TableRow> fkDepList = new ArrayList<TableRow>();
        for (TableRow tableRow : tableRows) {
            Collection<ForeignKey> exportedKeys;
            if (!visited.add(tableRow) || (exportedKeys = this.getExportedKeys(tableRow.getTable())) == null) continue;
            for (ForeignKey fk : exportedKeys) {
                Table foreignTable = this.lookupForeignTable(this.platform, fk, tableRow, false);
                if (foreignTable != null) {
                    Row selectRow = new Row(fk.getReferenceCount());
                    String referenceColumnName = null;
                    boolean[] nullValues = new boolean[fk.getReferenceCount()];
                    ArrayList<Column> fkColumns = new ArrayList<Column>();
                    int index = 0;
                    for (Reference ref : fk.getReferences()) {
                        Column foreignColumn = foreignTable.findColumn(ref.getForeignColumnName());
                        referenceColumnName = ref.getLocalColumnName();
                        Object value = tableRow.getRow().get((Object)referenceColumnName);
                        nullValues[index++] = value == null;
                        selectRow.put(foreignColumn.getName(), value);
                        fkColumns.add(foreignColumn);
                    }
                    if (!this.isAllNullValues(nullValues)) {
                        Column[] keyColumns = fkColumns.toArray(new Column[0]);
                        DmlStatement selectSt = this.platform.createDmlStatement(DmlStatement.DmlType.SELECT, foreignTable.getCatalog(), foreignTable.getSchema(), foreignTable.getName(), keyColumns, foreignTable.getColumns(), nullValues, null);
                        List rows = transaction.query(selectSt.getSql(), (ISqlRowMapper)new RowMapper(), selectRow.toArray(), selectSt.getTypes());
                        if (rows != null) {
                            for (Row row : rows) {
                                DmlStatement whereSt = null;
                                String whereSql = null;
                                if (foreignTable.getPrimaryKeyColumns() == null || foreignTable.getPrimaryKeyColumns().length == 0) {
                                    whereSt = this.platform.createDmlStatement(DmlStatement.DmlType.WHERE, foreignTable.getCatalog(), foreignTable.getSchema(), foreignTable.getName(), keyColumns, foreignTable.getColumns(), nullValues, null);
                                    whereSql = whereSt.buildDynamicSql(BinaryEncoding.HEX, row, false, true, keyColumns).substring(6);
                                } else {
                                    whereSt = this.platform.createDmlStatement(DmlStatement.DmlType.WHERE, foreignTable.getCatalog(), foreignTable.getSchema(), foreignTable.getName(), foreignTable.getPrimaryKeyColumns(), foreignTable.getColumns(), nullValues, null);
                                    whereSql = whereSt.buildDynamicSql(BinaryEncoding.HEX, row, false, true, foreignTable.getPrimaryKeyColumns()).substring(6);
                                }
                                String delimiter = this.platform.getDatabaseInfo().getSqlCommandDelimiter();
                                if (delimiter != null && delimiter.length() > 0) {
                                    whereSql = whereSql.substring(0, whereSql.length() - delimiter.length());
                                }
                                TableRow foreignTableRow = new TableRow(foreignTable, row, whereSql, referenceColumnName, fk.getName());
                                fkDepList.add(foreignTableRow);
                                this.log.debug("Add foreign table reference '{}' whereSql='{}'", (Object)foreignTable.getName(), (Object)whereSql);
                            }
                        }
                    } else {
                        this.log.debug("The foreign table reference was null for {}", (Object)foreignTable.getName());
                    }
                } else {
                    this.log.debug("Foreign table '{}' not found for foreign key '{}'", (Object)fk.getForeignTableName(), (Object)fk.getName());
                }
                if (fkDepList.size() <= 0) continue;
                fkDepList.addAll(this.getExportedForeignTableRows(transaction, fkDepList, visited, encoding));
            }
        }
        return fkDepList;
    }

    public List<TableRow> getImportedForeignTableRows(List<TableRow> tableRows, Set<TableRow> visited, BinaryEncoding encoding) {
        return this.getImportedForeignTableRows(tableRows, visited, encoding, 1, 250);
    }

    protected List<TableRow> getImportedForeignTableRows(List<TableRow> tableRows, Set<TableRow> visited, BinaryEncoding encoding, int depth, int maxDepth) {
        ArrayList<TableRow> fkDepList = new ArrayList<TableRow>();
        for (TableRow tableRow : tableRows) {
            if (!visited.add(tableRow)) continue;
            for (ForeignKey fk : tableRow.getTable().getForeignKeys()) {
                Table foreignTable = this.lookupForeignTable(this.platform, fk, tableRow, true);
                if (foreignTable != null) {
                    Row whereRow = new Row(fk.getReferenceCount());
                    String referenceColumnName = null;
                    boolean[] nullValues = new boolean[fk.getReferenceCount()];
                    int index = 0;
                    for (Reference ref : fk.getReferences()) {
                        Column foreignColumn = foreignTable.findColumn(ref.getForeignColumnName());
                        referenceColumnName = ref.getLocalColumnName();
                        Object value = tableRow.getRow().get((Object)referenceColumnName);
                        nullValues[index++] = value == null;
                        whereRow.put(foreignColumn.getName(), value);
                        foreignColumn.setPrimaryKey(true);
                    }
                    if (!this.isAllNullValues(nullValues)) {
                        DmlStatement whereSt = this.platform.createDmlStatement(DmlStatement.DmlType.WHERE, foreignTable.getCatalog(), foreignTable.getSchema(), foreignTable.getName(), foreignTable.getPrimaryKeyColumns(), foreignTable.getColumns(), nullValues, null);
                        String whereSql = whereSt.buildDynamicSql(BinaryEncoding.HEX, whereRow, false, true, foreignTable.getPrimaryKeyColumns()).substring(6);
                        String delimiter = this.platform.getDatabaseInfo().getSqlCommandDelimiter();
                        if (delimiter != null && delimiter.length() > 0) {
                            whereSql = whereSql.substring(0, whereSql.length() - delimiter.length());
                        }
                        Row foreignRow = new Row(foreignTable.getColumnCount());
                        DmlStatement selectSt = this.platform.createDmlStatement(DmlStatement.DmlType.SELECT, foreignTable, null);
                        Object[] keys = whereRow.toArray(foreignTable.getPrimaryKeyColumnNames());
                        Map values = this.platform.getSqlTemplateDirty().queryForMap(selectSt.getSql(), keys);
                        if (values == null) {
                            this.log.info("Unable to find missing foreign key data for table '{}', parent data not found.  Using sql='{}' with keys '{}'", new Object[]{foreignTable.getName(), selectSt.getSql(), keys});
                        } else {
                            foreignRow.putAll(values);
                        }
                        TableRow foreignTableRow = new TableRow(foreignTable, foreignRow, whereSql, referenceColumnName, fk.getName());
                        if (!fkDepList.contains(foreignTableRow)) {
                            fkDepList.add(foreignTableRow);
                        }
                        this.log.debug("Add foreign table reference '{}' whereSql='{}'", (Object)foreignTable.getName(), (Object)whereSql);
                        continue;
                    }
                    this.log.info("The foreign table reference was null for {}", (Object)foreignTable.getName());
                    continue;
                }
                this.log.warn("Foreign table '{}' not found for foreign key '{}'", (Object)fk.getForeignTableName(), (Object)fk.getName());
            }
        }
        if (fkDepList.size() > 0) {
            if (depth < maxDepth) {
                fkDepList.addAll(this.getImportedForeignTableRows(fkDepList, visited, encoding, depth + 1, maxDepth));
            } else {
                this.log.warn("Reached max depth reading imported foreign table rows");
            }
        }
        return fkDepList;
    }

    private Table lookupForeignTable(IDatabasePlatform platform, ForeignKey fk, TableRow tableRow, boolean clearPrimaryKeys) {
        Table foreignTable = null;
        Table table = platform.getTableFromCache(tableRow.getTable().getCatalog(), tableRow.getTable().getSchema(), fk.getForeignTableName(), false);
        if (table == null && (table = fk.getForeignTable()) == null) {
            table = platform.getTableFromCache(fk.getForeignTableName(), false);
        }
        if (table != null) {
            try {
                foreignTable = (Table)table.clone();
                if (clearPrimaryKeys) {
                    for (Column column : foreignTable.getColumns()) {
                        column.setPrimaryKey(false);
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        return foreignTable;
    }

    private boolean isAllNullValues(boolean[] nullValues) {
        boolean allNullValues = true;
        for (boolean b : nullValues) {
            if (b) continue;
            allNullValues = false;
            break;
        }
        return allNullValues;
    }

    protected void resetColumnSize(Column column, String size) {
        column.setSize(size);
        PlatformColumn platformColumn = column.findPlatformColumn(this.platform.getName());
        if (platformColumn != null) {
            platformColumn.setSize(column.getSizeAsInt());
            if (size != null && size.indexOf(",") != -1) {
                platformColumn.setDecimalDigits(column.getScale());
            } else {
                platformColumn.setDecimalDigits(-1);
            }
        }
    }

    protected void adjustColumnSize(Column column, int amount) {
        this.adjustColumnSize(column, amount, 0);
    }

    protected void adjustColumnSize(Column column, int amount, int maxSize) {
        int size = column.getSizeAsInt() + amount;
        if (size < 0) {
            size = 0;
        } else if (maxSize > 0 && size > maxSize) {
            size = maxSize;
        }
        this.resetColumnSize(column, String.valueOf(size));
    }

    protected void removeColumnSize(Column column) {
        column.setSize(null);
        this.removePlatformColumnSize(column);
    }

    protected void removePlatformColumnSize(Column column) {
        PlatformColumn platformColumn = column.findPlatformColumn(this.platform.getName());
        if (platformColumn != null) {
            platformColumn.setSize(-1);
            platformColumn.setDecimalDigits(-1);
        }
    }
}

