/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.util.MavenArtifact;
import org.jumpmind.symmetric.util.ModuleException;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger log = LoggerFactory.getLogger(ModuleManager.class);
    private static final String EXT_PROPERTIES = ".properties";
    private static final String EXT_JAR = "jar";
    private static final String PROP_REPOSITORIES = "repos";
    private static final String PROP_VERSION = "sym.version";
    private static final String PROP_DRIVER = "driver.";
    private static final String MODULE_ID_ALL = "all";
    private static ModuleManager instance;
    private Properties properties = new Properties();
    private Map<String, List<MavenArtifact>> modules = new TreeMap<String, List<MavenArtifact>>();
    private Map<String, String> driverToModule = new HashMap<String, String>();
    private List<String> repos = new ArrayList<String>();
    private String modulesDir;

    private ModuleManager() throws ModuleException {
        String sysModulesDir = System.getProperty("symmetric.modules.dir");
        this.modulesDir = StringUtils.isNotBlank((CharSequence)sysModulesDir) ? sysModulesDir : ("true".equals(System.getProperty("symmetric.launcher")) ? this.joinDirName(AppUtils.getSymHome(), "lib") : ".");
        File dir = new File(this.modulesDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (InputStream in = this.getClass().getResourceAsStream("/symmetric-modules.properties");){
            this.properties.load(in);
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String key = entry.getKey().toString();
                if (key.equals(PROP_REPOSITORIES)) {
                    for (String repo : entry.getValue().toString().split("\\s*,\\s*")) {
                        this.repos.add(repo);
                    }
                    continue;
                }
                if (key.startsWith(PROP_DRIVER)) {
                    String[] drivers;
                    for (String driver : drivers = entry.getValue().toString().split("\\s*,\\s*")) {
                        this.driverToModule.put(driver, key.substring(PROP_DRIVER.length()));
                    }
                    continue;
                }
                ArrayList<MavenArtifact> list = new ArrayList<MavenArtifact>();
                for (String dependency : entry.getValue().toString().split("\\s*,\\s*")) {
                    list.add(new MavenArtifact(dependency));
                }
                this.modules.put(key, list);
            }
        }
        catch (Exception e) {
            this.logAndThrow("Unable to read symmetric-modules.properties file: " + e.getMessage(), e);
        }
    }

    public static ModuleManager getInstance() throws ModuleException {
        if (instance == null) {
            instance = new ModuleManager();
        }
        return instance;
    }

    /*
     * Exception decompiling
     */
    public void install(String moduleId) throws ModuleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void installAll() throws ModuleException {
        List<String> installedModuleIds = this.list();
        for (String moduleId : this.listAll()) {
            if (installedModuleIds.contains(moduleId)) continue;
            this.install(moduleId);
        }
    }

    public void upgrade(String moduleId) throws ModuleException {
        this.checkModuleInstalled(moduleId, true);
        log.info("Checking if module {} needs upgraded", (Object)moduleId);
        File file = new File(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES));
        try {
            FileReader reader = new FileReader(file);
            Properties prop = new Properties();
            prop.load(reader);
            String oldDepString = this.removeBlankSpace(prop.getProperty(moduleId));
            String newDepString = this.removeBlankSpace(this.properties.getProperty(moduleId));
            if (oldDepString == null || !oldDepString.equals(newDepString)) {
                log.info("Upgrading module {}", (Object)moduleId);
                this.remove(moduleId);
                this.install(moduleId);
            }
        }
        catch (IOException e) {
            this.logAndThrow("Unable to list files for module " + moduleId + " because: " + e.getMessage(), e);
        }
    }

    public void upgradeAll() throws ModuleException {
        for (String moduleId : this.list()) {
            this.upgrade(moduleId);
        }
    }

    public void convertToModules() {
        log.info("Module conversion starting");
        String dirName = System.getProperty("symmetric.engines.dir", AppUtils.getSymHome() + "/engines");
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        if (files != null) {
            List<String> currentModules = this.list();
            log.info("Checking {} files in engines directory for possible module conversion", (Object)files.length);
            for (File file : files) {
                if (!file.getName().endsWith(EXT_PROPERTIES)) continue;
                log.info("Checking {} for possible module conversion", (Object)file.getPath());
                this.convertToModule(file, currentModules);
            }
        }
        log.info("Module conversion ended");
    }

    protected void convertToModule(File engineFile, List<String> currentModules) {
        TypedProperties prop = new TypedProperties();
        try (FileInputStream is = new FileInputStream(engineFile);){
            prop.load((InputStream)is);
        }
        catch (IOException e) {
            log.error("Failed module conversion for engine " + engineFile.getPath(), (Throwable)e);
            return;
        }
        String driver = prop.getProperty("db.driver");
        String moduleId = this.driverToModule.get(driver);
        if (moduleId != null && currentModules.contains(moduleId)) {
            log.info("Module '" + moduleId + "' already installed");
        } else if (moduleId != null && this.modules.containsKey(moduleId)) {
            try {
                this.install(moduleId);
                currentModules.add(moduleId);
            }
            catch (ModuleException e) {
                log.error("Failed module conversion for module " + moduleId, (Throwable)e);
            }
        } else {
            log.info("Skipping module conversion for driver '" + driver + "' and module '" + moduleId + "' for engine " + engineFile.getPath());
        }
    }

    private String buildUrl(String repo, MavenArtifact artifact, String extension) {
        return this.buildFileName(this.joinDirName(repo, artifact.getGroupId().replace(".", "/"), artifact.getArtifactId(), artifact.getVersion()), artifact, extension);
    }

    private String buildFileName(String baseDir, MavenArtifact artifact, String extension) {
        return this.joinDirName(baseDir, artifact.getArtifactId() + "-" + artifact.getVersion() + "." + extension);
    }

    private String joinDirName(String ... args) {
        return StringUtils.join((Object[])args, (String)"/");
    }

    private List<MavenArtifact> resolveArtifacts(String moduleId) {
        return this.modules.get(moduleId);
    }

    public void remove(String moduleId) throws ModuleException {
        if (MODULE_ID_ALL.equals(moduleId)) {
            this.removeAll();
            return;
        }
        this.checkModuleInstalled(moduleId, true);
        List<String> filesToRemove = this.listFiles(moduleId);
        for (String string : this.list()) {
            if (string.equals(moduleId)) continue;
            filesToRemove.removeAll(this.listFiles(string));
        }
        boolean success = true;
        for (String fileName : filesToRemove) {
            boolean delSuccess = new File(this.joinDirName(this.modulesDir, fileName)).delete();
            log.info("Removing {} ({})", (Object)fileName, (Object)(delSuccess ? "OK" : "FAIL"));
            success &= delSuccess;
        }
        boolean bl = new File(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES)).delete();
        log.info("Removing {} ({})", (Object)(moduleId + EXT_PROPERTIES), (Object)(bl ? "OK" : "FAIL"));
        if (!(success &= bl)) {
            this.logAndThrow("Unable to remove all files associated with module " + moduleId);
        }
    }

    public void removeAll() throws ModuleException {
        for (String moduleId : this.list()) {
            this.remove(moduleId);
        }
    }

    private String[] getPropFileNames() {
        File dir = new File(this.modulesDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ModuleManager.EXT_PROPERTIES) && ModuleManager.this.modules.containsKey(name.substring(0, name.indexOf(".")));
            }
        };
        return dir.list(filter);
    }

    public List<String> list() {
        ArrayList<String> names = new ArrayList<String>();
        String[] fileNames = this.getPropFileNames();
        if (fileNames != null) {
            for (String propFileName : fileNames) {
                names.add(propFileName.substring(0, propFileName.length() - EXT_PROPERTIES.length()));
            }
        }
        Collections.sort(names);
        return names;
    }

    public List<String> listFiles(String moduleId) throws ModuleException {
        ArrayList<String> fileNames = new ArrayList<String>();
        this.checkModuleInstalled(moduleId, true);
        File file = new File(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES));
        if (file.canRead()) {
            try {
                FileReader reader = new FileReader(file);
                Properties prop = new Properties();
                prop.load(reader);
                for (MavenArtifact artifact : MavenArtifact.parseCsv(prop.getProperty(moduleId))) {
                    fileNames.add(artifact.toFileName(EXT_JAR));
                }
            }
            catch (IOException e) {
                this.logAndThrow("Unable to list files for module " + moduleId + " because: " + e.getMessage(), e);
            }
        }
        return fileNames;
    }

    public List<String> listDependencies(String moduleId) throws ModuleException {
        this.checkModuleValid(moduleId);
        List<MavenArtifact> artifacts = this.resolveArtifacts(moduleId);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (MavenArtifact artifact : artifacts) {
            fileNames.add(artifact.toFileName(EXT_JAR));
        }
        return fileNames;
    }

    public List<String> listAll() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.modules.keySet()) {
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    private void checkModuleInstalled(String moduleId, boolean shouldBeInstalled) throws ModuleException {
        this.checkModuleValid(moduleId);
        boolean isInstalled = this.list().contains(moduleId);
        if (isInstalled && !shouldBeInstalled) {
            throw new ModuleException("Module is already installed", false);
        }
        if (!isInstalled && shouldBeInstalled) {
            throw new ModuleException("Module is not installed", false);
        }
    }

    private void checkModuleValid(String moduleId) throws ModuleException {
        if (!this.modules.containsKey(moduleId)) {
            throw new ModuleException("Invalid module specified", false);
        }
    }

    private String removeBlankSpace(String str) {
        if (str != null) {
            str = str.replaceAll("\\s", "");
        }
        return str;
    }

    private void logAndThrow(String message) throws ModuleException {
        log.error(message);
        throw new ModuleException(message);
    }

    private void logAndThrow(String message, Exception e) throws ModuleException {
        log.error(message);
        throw new ModuleException(message, e);
    }
}

