/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.TransportUtils;

public class InternalOutgoingWithResponseTransport
implements IOutgoingWithResponseTransport {
    BufferedWriter writer = null;
    BufferedReader reader = null;
    OutputStream os = null;
    boolean open = true;

    InternalOutgoingWithResponseTransport(OutputStream os, InputStream respIs) {
        this.os = os;
        this.writer = TransportUtils.toWriter(os);
        this.reader = TransportUtils.toReader(respIs);
    }

    @Override
    public OutputStream openStream() {
        return this.os;
    }

    @Override
    public BufferedReader readResponse() throws IOException {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.reader;
    }

    @Override
    public void close() {
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public BufferedWriter openWriter() {
        return this.writer;
    }

    @Override
    public BufferedWriter getWriter() {
        return this.writer;
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists(IConfigurationService configurationService, String queue, Node targetNode) {
        return configurationService.getSuspendIgnoreChannelLists();
    }
}

