/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.BatchId;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.symmetric.transport.http.Http2Connection;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.symmetric.transport.http.HttpIncomingTransport;
import org.jumpmind.symmetric.transport.http.HttpOutgoingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportManager
extends AbstractTransportManager
implements ITransportManager {
    private static final Logger log = LoggerFactory.getLogger(HttpTransportManager.class);
    protected ISymmetricEngine engine;
    protected Map<String, String> sessionIdByUri = new HashMap<String, String>();
    protected boolean useHeaderSecurityToken;
    protected boolean useSessionAuth;
    protected boolean isHttp2Enabled;

    public HttpTransportManager() {
    }

    public HttpTransportManager(ISymmetricEngine engine) {
        super(engine.getExtensionService());
        this.engine = engine;
        this.useHeaderSecurityToken = engine.getParameterService().is("http.use.header.security.token");
        this.useSessionAuth = engine.getParameterService().is("http.use.session.auth");
        this.isHttp2Enabled = engine.getParameterService().is("https2.enable", false);
    }

    @Override
    public int sendCopyRequest(Node local) throws IOException {
        StringBuilder data = new StringBuilder();
        Map<String, BatchId> batchIds = this.engine.getIncomingBatchService().findMaxBatchIdsByChannel();
        for (String channelId : batchIds.keySet()) {
            if ("config".equals(channelId) || "heartbeat".equals(channelId)) continue;
            BatchId batchId = batchIds.get(channelId);
            HttpTransportManager.append(data, channelId + "-" + batchId.getNodeId(), batchId.getBatchId());
        }
        String securityToken = this.engine.getNodeService().findNodeSecurity(local.getNodeId()).getNodePassword();
        String url = this.addNodeInfo(this.engine.getParameterService().getRegistrationUrl() + "/copy", local.getNodeId(), securityToken, false);
        url = this.add(url, "externalId", this.engine.getParameterService().getExternalId(), "&");
        url = this.add(url, "nodeGroupId", this.engine.getParameterService().getNodeGroupId(), "&");
        log.info("Contact server to do node copy using a url of: " + url);
        return this.sendMessage(new URL(url), local.getNodeId(), securityToken, null, data.toString());
    }

    @Override
    public int sendStatusRequest(Node local, Map<String, String> statuses) throws IOException {
        String securityToken = this.engine.getNodeService().findNodeSecurity(local.getNodeId()).getNodePassword();
        String url = this.addNodeInfo(this.engine.getParameterService().getRegistrationUrl() + "/pushstatus/", local.getNodeId(), securityToken, false);
        url = this.add(url, "externalId", this.engine.getParameterService().getExternalId(), "&");
        url = this.add(url, "nodeGroupId", this.engine.getParameterService().getNodeGroupId(), "&");
        for (String key : statuses.keySet()) {
            url = this.add(url, key, statuses.get(key), "&");
        }
        log.debug("Sending status with URL: " + url);
        return this.sendMessage(new URL(url), local.getNodeId(), securityToken, null, "");
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, String registrationUrl) throws IOException {
        return this.sendAcknowledgement(remote, list, local, securityToken, null, registrationUrl);
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        if (list != null && list.size() > 0) {
            String data = this.getAcknowledgementData(remote.requires13Compatiblity(), local.getNodeId(), list);
            log.debug("Sending ack: {}", (Object)data);
            return this.sendMessage("ack", remote, local, data, securityToken, requestProperties, registrationUrl);
        }
        return 200;
    }

    @Override
    public void writeAcknowledgement(OutputStream out, Node remote, List<IncomingBatch> list, Node local, String securityToken) throws IOException {
        String data = this.getAcknowledgementData(remote.requires13Compatiblity(), local.getNodeId(), list);
        log.debug("Sending ack: {}", (Object)data);
        this.writeMessage(out, data);
    }

    protected int sendMessage(String action, Node remote, Node local, String data, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        return this.sendMessage(new URL(this.buildURL(action, remote, local, securityToken, registrationUrl)), local.getNodeId(), securityToken, requestProperties, data);
    }

    /*
     * Exception decompiling
     */
    protected int sendMessage(URL url, String nodeId, String securityToken, Map<String, String> requestProperties, String data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkForConnectionUpgrade(HttpConnection conn) {
    }

    public HttpConnection openConnection(URL url, String nodeId, String securityToken) throws IOException {
        String sessionId;
        HttpConnection conn = null;
        conn = this.isHttp2Enabled ? new Http2Connection(url) : new HttpConnection(url);
        conn.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        boolean hasSession = false;
        if (this.useSessionAuth && (sessionId = this.sessionIdByUri.get(this.getUri(conn))) != null) {
            conn.setRequestProperty("Session-ID", sessionId);
            hasSession = true;
        }
        if (securityToken != null && this.useHeaderSecurityToken && !hasSession) {
            conn.setRequestProperty("Security-Token", securityToken);
        }
        return conn;
    }

    public void updateSession(HttpConnection conn) {
        String sessionId;
        if (this.useSessionAuth && (sessionId = conn.getHeaderField("Set-Session-ID")) != null) {
            this.sessionIdByUri.put(this.getUri(conn), sessionId);
        }
    }

    public void clearSession(HttpConnection conn) {
        if (this.useSessionAuth) {
            this.sessionIdByUri.remove(this.getUri(conn));
        }
    }

    protected String getUri(HttpConnection conn) {
        String uri = conn.getURL().toExternalForm();
        uri = uri.substring(0, uri.lastIndexOf("/"));
        return uri;
    }

    public int getOutputStreamSize() {
        return this.engine.getParameterService().getInt("http.push.stream.output.size");
    }

    public boolean isOutputStreamEnabled() {
        return this.engine.getParameterService().is("http.push.stream.output.enabled");
    }

    public int getHttpTimeOutInMs() {
        return this.engine.getParameterService().getInt("http.timeout.ms");
    }

    public int getHttpConnectTimeOutInMs() {
        return this.engine.getParameterService().getInt("http.connect.timeout.ms");
    }

    public boolean isUseCompression(Node targetNode) {
        ISymmetricEngine targetEngine = AbstractSymmetricEngine.findEngineByUrl(targetNode.getSyncUrl());
        return this.engine.getParameterService().is("http.compression") && targetEngine == null;
    }

    public int getCompressionLevel() {
        return this.engine.getParameterService().getInt("compression.level");
    }

    public int getCompressionStrategy() {
        return this.engine.getParameterService().getInt("compression.strategy");
    }

    public void writeMessage(OutputStream out, String data) throws IOException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
        pw.println(data);
        pw.flush();
    }

    @Override
    public IIncomingTransport getFilePullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpConnection conn = this.createGetConnectionFor(new URL(this.buildURL("filesync/pull", remote, local, securityToken, registrationUrl)), local.getNodeId(), securityToken);
        if (requestProperties != null) {
            for (String key : requestProperties.keySet()) {
                conn.addRequestProperty(key, requestProperties.get(key));
            }
        }
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService(), local.getNodeId(), securityToken);
    }

    @Override
    public IIncomingTransport getPullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpConnection conn = this.createGetConnectionFor(new URL(this.buildURL("pull", remote, local, securityToken, registrationUrl)), local.getNodeId(), securityToken);
        if (requestProperties != null) {
            for (String key : requestProperties.keySet()) {
                conn.addRequestProperty(key, requestProperties.get(key));
            }
        }
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService(), local.getNodeId(), securityToken);
    }

    @Override
    public IIncomingTransport getPingTransport(Node remote, Node local, String registrationUrl) throws IOException {
        HttpConnection conn = this.createGetConnectionFor(new URL(this.resolveURL(remote.getSyncUrl(), registrationUrl) + "/ping"));
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService());
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        URL url = new URL(this.buildURL("push", remote, local, securityToken, registrationUrl));
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false, requestProperties);
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        URL url = new URL(this.buildURL("push", remote, local, securityToken, registrationUrl));
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false);
    }

    @Override
    public IOutgoingWithResponseTransport getFilePushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        URL url = new URL(this.buildURL("filesync/push", remote, local, securityToken, registrationUrl));
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), true);
    }

    @Override
    public IIncomingTransport getConfigTransport(Node remote, Node local, String securityToken, String symmetricVersion, String configVersion, String registrationUrl) throws IOException {
        StringBuilder builder = new StringBuilder(this.buildURL("config", remote, local, securityToken, registrationUrl));
        HttpTransportManager.append(builder, "symmetricVersion", symmetricVersion);
        HttpTransportManager.append(builder, "configVersion", configVersion);
        HttpConnection conn = this.createGetConnectionFor(new URL(builder.toString()), local.getNodeId(), securityToken);
        return new HttpIncomingTransport(this, conn, this.engine.getParameterService());
    }

    @Override
    public IIncomingTransport getRegisterTransport(Node node, String registrationUrl) throws IOException {
        return this.getRegisterTransport(node, registrationUrl, null);
    }

    @Override
    public IIncomingTransport getRegisterTransport(Node node, String registrationUrl, Map<String, String> requestProperties) throws IOException {
        return new HttpIncomingTransport(this, this.createGetConnectionFor(new URL(HttpTransportManager.buildRegistrationUrl(registrationUrl, node))), this.engine.getParameterService(), TransportUtils.convertNodeToProperties(node, requestProperties));
    }

    @Override
    public IOutgoingWithResponseTransport getRegisterPushTransport(Node remote, Node local) throws IOException {
        StringBuilder builder = new StringBuilder(HttpTransportManager.buildRegistrationUrl(remote.getSyncUrl(), remote)).append("?");
        HttpTransportManager.append(builder, "pushRegistration", Boolean.TRUE);
        HttpTransportManager.append(builder, "nodeId", local.getNodeId());
        HttpTransportManager.append(builder, "nodeGroupId", local.getNodeGroupId());
        HttpTransportManager.append(builder, "externalId", local.getExternalId());
        HttpTransportManager.append(builder, "syncURL", local.getSyncUrl());
        URL url = new URL(builder.toString());
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), null, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false);
    }

    @Override
    public IOutgoingWithResponseTransport getBandwidthPushTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        URL url = new URL(this.resolveURL(remote.getSyncUrl(), registrationUrl) + "/bandwidth?direction=push");
        return new HttpOutgoingTransport(this, url, this.getHttpTimeOutInMs(), this.getHttpConnectTimeOutInMs(), this.isUseCompression(remote), this.getCompressionStrategy(), this.getCompressionLevel(), local.getNodeId(), securityToken, this.isOutputStreamEnabled(), this.getOutputStreamSize(), false, requestProperties);
    }

    public static String buildRegistrationUrl(String baseUrl, Node node) {
        if (baseUrl == null) {
            baseUrl = "";
        }
        StringBuilder builder = new StringBuilder(baseUrl);
        builder.append("/registration");
        return builder.toString();
    }

    protected HttpConnection createGetConnectionFor(URL url, String nodeId, String securityToken) throws IOException {
        HttpConnection conn = this.openConnection(url, nodeId, securityToken);
        conn.setRequestProperty("accept-encoding", "gzip");
        conn.setConnectTimeout(this.getHttpConnectTimeOutInMs());
        conn.setReadTimeout(this.getHttpTimeOutInMs());
        conn.setRequestMethod("GET");
        return conn;
    }

    protected HttpConnection createGetConnectionFor(URL url) throws IOException {
        return this.createGetConnectionFor(url, null, null);
    }

    protected static InputStream getInputStreamFrom(HttpConnection connection) throws IOException {
        String type = connection.getContentEncoding();
        InputStream in = connection.getInputStream();
        if (!StringUtils.isBlank((CharSequence)type) && type.equals("gzip")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    protected static BufferedReader getReaderFrom(HttpConnection connection) throws IOException {
        String type = connection.getContentEncoding();
        InputStream in = connection.getInputStream();
        if (!StringUtils.isBlank((CharSequence)type) && type.equals("gzip")) {
            in = new GZIPInputStream(in);
        }
        return TransportUtils.toReader(in);
    }

    protected String buildURL(String action, Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        boolean forceParamSecurityToken = Version.isOlderMinorVersion(remote.getSymmetricVersion(), "3.11");
        String url = this.addNodeInfo(this.resolveURL(remote.getSyncUrl(), registrationUrl) + "/" + action, local.getNodeId(), securityToken, forceParamSecurityToken);
        log.debug("Building transport url: {}", (Object)url);
        return url;
    }

    protected String addNodeInfo(String base, String nodeId, String securityToken, boolean forceParamSecurityToken) {
        StringBuilder sb = new StringBuilder(this.addNodeId(base, nodeId, "?"));
        if (!this.useHeaderSecurityToken || forceParamSecurityToken) {
            sb.append("&").append("securityToken").append("=").append(securityToken);
        }
        return sb.toString();
    }

    protected String addNodeId(String base, String nodeId, String connector) {
        return this.add(base, "nodeId", nodeId, connector);
    }

    protected String add(String base, String key, String value, String connector) {
        StringBuilder sb = new StringBuilder(base);
        sb.append(connector);
        sb.append(key);
        sb.append("=");
        try {
            sb.append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IoException((Exception)e);
        }
        return sb.toString();
    }

    protected ISymmetricEngine getEngine() {
        return this.engine;
    }
}

