/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Pair;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.util.CustomizableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2Connection
extends HttpConnection {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static X509TrustManager trustManager;
    protected static SSLSocketFactory sslSocketFactory;
    protected static HostnameVerifier hostnameVerifier;
    protected ExecutorService executor;
    protected OkHttpClient.Builder clientBuilder;
    protected Request.Builder requestBuilder;
    protected Response response;
    protected String requestMethod;
    protected MediaType mediaType;
    protected boolean dooutput;
    protected OutputStream internalOut;
    protected OutputStream externalOut;
    protected IOException exception;

    public Http2Connection(URL url) throws IOException {
        super(url);
        this.reset();
    }

    protected void reset() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory(Thread.currentThread().getName()));
        this.clientBuilder = new OkHttpClient.Builder();
        if (sslSocketFactory != null && trustManager != null) {
            this.clientBuilder = this.clientBuilder.sslSocketFactory(sslSocketFactory, trustManager);
        }
        this.clientBuilder.hostnameVerifier(hostnameVerifier).retryOnConnectionFailure(true);
        this.requestBuilder = new Request.Builder().url(this.url);
        this.dooutput = false;
        this.requestMethod = "GET";
        this.internalOut = null;
        this.externalOut = null;
        this.exception = null;
    }

    @Override
    public synchronized void disconnect() {
        this.close();
    }

    @Override
    public synchronized void close() {
        this.closeOutput();
        if (this.response != null) {
            this.response.close();
            this.response = null;
        }
        if (!this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
        this.reset();
    }

    protected void closeOutput() {
        if (this.externalOut != null) {
            try {
                this.externalOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.externalOut = null;
            this.internalOut = null;
        }
    }

    protected synchronized Response getResponse() throws IOException {
        if (this.response == null) {
            BlockingRequestBody requestBody = null;
            if (this.dooutput) {
                requestBody = new BlockingRequestBody(this);
            }
            Request request = this.requestBuilder.method(this.requestMethod, (RequestBody)requestBody).build();
            OkHttpClient client = this.clientBuilder.build();
            if (this.log.isDebugEnabled()) {
                this.logHeaders("Request", request.headers());
            }
            try {
                this.response = client.newCall(request).execute();
                if (this.log.isDebugEnabled()) {
                    this.logHeaders("Response", this.response.headers());
                }
            }
            catch (IOException e) {
                this.exception = e;
                throw e;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("HTTP response: {}", (Object)this.response.code());
            }
        }
        return this.response;
    }

    protected void logHeaders(String name, Headers headers) {
        StringBuilder sb = new StringBuilder("{");
        for (Pair header : headers) {
            if (((String)header.getFirst()).equalsIgnoreCase("Session-ID") || ((String)header.getFirst()).equalsIgnoreCase("Set-Session-ID") || ((String)header.getFirst()).equalsIgnoreCase("regPassword") || ((String)header.getFirst()).equalsIgnoreCase("Security-Token")) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append((String)header.getFirst()).append("=").append((String)header.getSecond());
        }
        sb.append("}");
        this.log.debug(name + " headers: {}", (Object)sb);
    }

    @Override
    public int getResponseCode() throws IOException {
        this.waitForResponse();
        return this.getResponse().code();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ResponseBody respBody;
        this.closeOutput();
        this.waitForResponse();
        InputStream stream = null;
        Response resp = this.getResponse();
        if (resp != null && (respBody = this.response.body()) != null) {
            stream = respBody.byteStream();
        }
        return stream;
    }

    public String getResponseBody() throws IOException {
        ResponseBody responseBody;
        this.waitForResponse();
        String body = null;
        if (this.response != null && (responseBody = this.response.body()) != null) {
            body = responseBody.string();
        }
        return body;
    }

    protected void waitForResponse() throws IOException {
        if (this.dooutput) {
            if (!this.executor.isTerminated()) {
                try {
                    this.log.debug("Waiting for HTTP thread");
                    long hours = 1L;
                    while (!this.executor.awaitTermination(1L, TimeUnit.HOURS)) {
                        this.log.info("Waiting for HTTP thread for {} hours", (Object)hours);
                        ++hours;
                    }
                    this.log.debug("Done waiting for HTTP thread");
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            if (this.exception != null) {
                throw new IOException(this.exception);
            }
        }
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.externalOut == null) {
            this.externalOut = new BlockingOutputStream(this);
            CallableResponse callable = new CallableResponse(this);
            Future<Response> future = this.executor.submit(callable);
            this.executor.shutdown();
            try {
                this.log.debug("Waiting for output stream");
                this.wait();
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                throw new IOException(e);
            }
            if (future != null && this.internalOut == null) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        throw new IOException(e.getCause());
                    }
                    throw new IOException(e);
                }
            }
        }
        return this.externalOut;
    }

    @Override
    public synchronized String getContentEncoding() {
        return this.response == null ? null : this.response.header("Content-Encoding");
    }

    @Override
    public synchronized String getHeaderField(String name) {
        return this.response == null ? null : this.response.header(name);
    }

    @Override
    public synchronized Map<String, List<String>> getHeaderFields() {
        return this.response == null ? new HashMap() : this.response.headers().toMultimap();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.clientBuilder = this.clientBuilder.connectTimeout((long)timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.clientBuilder = this.clientBuilder.readTimeout((long)timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.clientBuilder = this.clientBuilder.followRedirects(true).followSslRedirects(true);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.requestMethod = method;
    }

    @Override
    public void setDoInput(boolean doinput) {
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.dooutput = dooutput;
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.requestBuilder = this.requestBuilder.cacheControl(new CacheControl.Builder().noCache().build());
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.detectMediaType(key, value);
        this.requestBuilder = this.requestBuilder.header(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.detectMediaType(key, value);
        this.requestBuilder = this.requestBuilder.addHeader(key, value);
    }

    protected void detectMediaType(String key, String value) {
        if (key.equalsIgnoreCase("Content-Type")) {
            this.mediaType = MediaType.parse((String)value);
        }
    }

    public static X509TrustManager getTrustManager() {
        return trustManager;
    }

    public static void setDefaultTrustManager(X509TrustManager trustManager) {
        Http2Connection.trustManager = trustManager;
    }

    public static SSLSocketFactory getSslSocketFactory() {
        return sslSocketFactory;
    }

    public void setSslSocketFactoryAndTrustManager(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.clientBuilder.sslSocketFactory(sslSocketFactory, trustManager);
    }

    public static void setDefaultSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        Http2Connection.sslSocketFactory = sslSocketFactory;
    }

    public static HostnameVerifier getHostnameVerifier() {
        return hostnameVerifier;
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.clientBuilder.hostnameVerifier(hostnameVerifier);
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        Http2Connection.hostnameVerifier = hostnameVerifier;
    }

    protected class BlockingOutputStream
    extends OutputStream {
        protected Http2Connection connection;
        protected boolean closed;

        protected BlockingOutputStream(Http2Connection connection) {
            this.connection = connection;
        }

        @Override
        public void write(int b) throws IOException {
            Http2Connection.this.internalOut.write(b);
        }

        @Override
        public void flush() throws IOException {
            Http2Connection.this.internalOut.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.closed) {
                Http2Connection http2Connection = this.connection;
                synchronized (http2Connection) {
                    Http2Connection.this.log.debug("Closing output stream");
                    this.connection.notifyAll();
                }
                this.closed = true;
            }
        }
    }

    protected class BlockingRequestBody
    extends RequestBody {
        protected Http2Connection connection;

        protected BlockingRequestBody(Http2Connection connection) {
            this.connection = connection;
        }

        public MediaType contentType() {
            if (Http2Connection.this.mediaType != null) {
                return Http2Connection.this.mediaType;
            }
            if (Http2Connection.this.requestMethod.equalsIgnoreCase("PUT")) {
                return null;
            }
            if (Http2Connection.this.requestMethod.equalsIgnoreCase("POST")) {
                return MediaType.parse((String)"application/x-www-form-urlencoded");
            }
            return MediaType.parse((String)"text/plain");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(BufferedSink sink) throws IOException {
            Http2Connection.this.internalOut = sink.outputStream();
            Http2Connection http2Connection = this.connection;
            synchronized (http2Connection) {
                Http2Connection.this.log.debug("Ready with output stream");
                this.connection.notifyAll();
                try {
                    Http2Connection.this.log.debug("Waiting for output stream to close");
                    this.connection.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    protected class CallableResponse
    implements Callable<Response> {
        protected Http2Connection connection;

        protected CallableResponse(Http2Connection connection) {
            this.connection = connection;
        }

        @Override
        public Response call() throws Exception {
            try {
                Http2Connection.this.exception = null;
                return Http2Connection.this.getResponse();
            }
            catch (Throwable t) {
                Http2Connection.this.log.debug("No output stream, caught exception instead", t);
                Http2Connection http2Connection = this.connection;
                synchronized (http2Connection) {
                    Http2Connection.this.internalOut = null;
                    this.connection.notifyAll();
                    throw t;
                }
            }
        }
    }
}

