/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentConnectionManager
implements IConcurrentConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentConnectionManager.class);
    protected IParameterService parameterService;
    protected Map<String, Map<String, Reservation>> activeReservationsByNodeByPool = new HashMap<String, Map<String, Reservation>>();
    protected Map<String, Map<String, NodeConnectionStatistics>> nodeConnectionStatistics = new HashMap<String, Map<String, NodeConnectionStatistics>>();
    protected Set<String> whiteList = new HashSet<String>();
    protected Map<String, Long> transportErrorTimeByNode = new HashMap<String, Long>();

    public ConcurrentConnectionManager(IParameterService parameterService, IStatisticManager statisticManager) {
        this.parameterService = parameterService;
    }

    protected void logTooBusyRejection(String nodeId, String poolId) {
        ++this.getNodeConnectionStatistics((String)nodeId, (String)poolId).numOfRejections;
    }

    protected void logConnectedTimePeriod(String nodeId, long startMs, long endMs, String poolId) {
        NodeConnectionStatistics stats = this.getNodeConnectionStatistics(nodeId, poolId);
        ++stats.totalConnectionCount;
        stats.totalConnectionTimeMs += endMs - startMs;
        stats.lastConnectionTimeMs = startMs;
    }

    private synchronized NodeConnectionStatistics getNodeConnectionStatistics(String nodeId, String poolId) {
        NodeConnectionStatistics stats;
        Map<String, NodeConnectionStatistics> statsMap = this.nodeConnectionStatistics.get(poolId);
        if (statsMap == null) {
            statsMap = new HashMap<String, NodeConnectionStatistics>();
            this.nodeConnectionStatistics.put(poolId, statsMap);
        }
        if ((stats = statsMap.get(nodeId)) == null) {
            stats = new NodeConnectionStatistics();
            statsMap.put(nodeId, stats);
        }
        return stats;
    }

    @Override
    public synchronized boolean releaseConnection(String nodeId, String channelId, String poolId) {
        String reservationId = ConcurrentConnectionManager.getReservationIdentifier(nodeId, channelId);
        log.debug("Releasing connection for {} {}", (Object)poolId, (Object)reservationId);
        Map<String, Reservation> reservations = this.getReservationMap(poolId);
        Reservation reservation = reservations.remove(reservationId);
        if (reservation != null) {
            this.logConnectedTimePeriod(reservationId, reservation.createTime, System.currentTimeMillis(), poolId);
            return true;
        }
        log.warn("Failed to release connection for {}", (Object)reservationId);
        return false;
    }

    @Override
    public synchronized boolean releaseConnection(String nodeId, String poolId) {
        Map<String, Reservation> reservations = this.getReservationMap(poolId);
        Reservation reservation = reservations.remove(nodeId);
        if (reservation != null) {
            this.logConnectedTimePeriod(nodeId, reservation.createTime, System.currentTimeMillis(), poolId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addToWhitelist(String nodeId) {
        this.whiteList.add(nodeId);
    }

    @Override
    public synchronized void removeFromWhiteList(String nodeId) {
        this.whiteList.remove(nodeId);
    }

    @Override
    public synchronized String[] getWhiteList() {
        return this.whiteList.toArray(new String[this.whiteList.size()]);
    }

    @Override
    public synchronized int getReservationCount(String poolId) {
        return this.getReservationMap(poolId).size();
    }

    @Override
    public synchronized boolean reserveConnection(String nodeId, String channelId, String poolId, IConcurrentConnectionManager.ReservationType reservationRequest) {
        String reservationId = ConcurrentConnectionManager.getReservationIdentifier(nodeId, channelId);
        log.debug("Reserving connection for {} {}", (Object)poolId, (Object)reservationId);
        Map<String, Reservation> reservations = this.getReservationMap(poolId);
        int maxPoolSize = this.parameterService.getInt("http.concurrent.workers.max");
        long timeout = this.parameterService.getLong("http.concurrent.reservation.timeout.ms");
        this.removeTimedOutReservations(reservations);
        if (reservations.size() < maxPoolSize || reservations.containsKey(reservationId) || this.whiteList.contains(nodeId)) {
            Reservation existingReservation = reservations.get(reservationId);
            if (existingReservation == null || existingReservation.getType() == IConcurrentConnectionManager.ReservationType.SOFT) {
                reservations.put(reservationId, new Reservation(reservationId, reservationRequest == IConcurrentConnectionManager.ReservationType.SOFT ? System.currentTimeMillis() + timeout : Long.MAX_VALUE, reservationRequest));
                this.transportErrorTimeByNode.remove(nodeId);
                return true;
            }
            String message = "Node '{}' Channel '{}' requested a {} connection, but was rejected because it already has one";
            if (this.shouldLogTransportError(nodeId)) {
                log.warn(message, new Object[]{nodeId, channelId, poolId});
            } else {
                log.info(message, new Object[]{nodeId, channelId, poolId});
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean reserveConnection(String nodeId, String poolId, IConcurrentConnectionManager.ReservationType reservationRequest) {
        return this.reserveConnection(nodeId, null, poolId, reservationRequest);
    }

    @Override
    public Map<String, Date> getPullReservationsByNodeId() {
        return this.getReservationsByNodeId("pull");
    }

    @Override
    public Map<String, Date> getPushReservationsByNodeId() {
        return this.getReservationsByNodeId("push");
    }

    protected Map<String, Date> getReservationsByNodeId(String urlPath) {
        HashMap<String, Date> byNodeId = new HashMap<String, Date>();
        Set<String> poolIds = this.activeReservationsByNodeByPool.keySet();
        for (String poolId : poolIds) {
            if (!poolId.endsWith(urlPath)) continue;
            Map<String, Reservation> reservations = this.activeReservationsByNodeByPool.get(poolId);
            HashSet<String> nodeIds = new HashSet<String>(reservations.keySet());
            for (String nodeId : nodeIds) {
                Reservation reservation = reservations.get(nodeId);
                if (reservation == null || reservation.getType() != IConcurrentConnectionManager.ReservationType.HARD) continue;
                byNodeId.put(nodeId, new Date(reservation.getCreateTime()));
            }
        }
        return byNodeId;
    }

    protected void removeTimedOutReservations(Map<String, Reservation> reservations) {
        long currentTime = System.currentTimeMillis();
        String[] keys = reservations.keySet().toArray(new String[reservations.size()]);
        if (keys != null) {
            for (String key : keys) {
                Reservation reservation = reservations.get(key);
                if (reservation.timeToLiveInMs >= currentTime) continue;
                reservations.remove(key);
            }
        }
    }

    private Map<String, Reservation> getReservationMap(String poolId) {
        Map<String, Reservation> reservations = this.activeReservationsByNodeByPool.get(poolId);
        if (reservations == null) {
            reservations = new HashMap<String, Reservation>();
            this.activeReservationsByNodeByPool.put(poolId, reservations);
        }
        return reservations;
    }

    public static String getReservationIdentifier(String nodeId, String channelId) {
        return channelId == null || channelId.equals("0") ? nodeId : nodeId + "-" + channelId;
    }

    @Override
    public Map<String, Map<String, NodeConnectionStatistics>> getNodeConnectionStatisticsByPoolByNodeId() {
        return this.nodeConnectionStatistics;
    }

    protected boolean shouldLogTransportError(String nodeId) {
        long maxErrorMillis = this.parameterService.getLong("transport.max.error.millis", 300000L);
        Long errorTime = this.transportErrorTimeByNode.get(nodeId);
        if (errorTime == null) {
            errorTime = System.currentTimeMillis();
            this.transportErrorTimeByNode.put(nodeId, errorTime);
        }
        return System.currentTimeMillis() - errorTime >= maxErrorMillis;
    }

    @Override
    public Map<String, Map<String, Reservation>> getActiveReservationsByNodeByPool() {
        return this.activeReservationsByNodeByPool;
    }

    public static class NodeConnectionStatistics {
        int numOfRejections;
        long totalConnectionCount;
        long totalConnectionTimeMs;
        long lastConnectionTimeMs;

        public int getNumOfRejections() {
            return this.numOfRejections;
        }

        public long getTotalConnectionCount() {
            return this.totalConnectionCount;
        }

        public long getTotalConnectionTimeMs() {
            return this.totalConnectionTimeMs;
        }

        public long getLastConnectionTimeMs() {
            return this.lastConnectionTimeMs;
        }
    }

    public static class Reservation {
        String nodeId;
        String channelId = "0";
        long timeToLiveInMs;
        long createTime = System.currentTimeMillis();
        IConcurrentConnectionManager.ReservationType type;

        public Reservation(String nodeId, long timeToLiveInMs, IConcurrentConnectionManager.ReservationType type) {
            this.nodeId = nodeId;
            this.timeToLiveInMs = timeToLiveInMs;
            this.type = type;
        }

        public Reservation(String nodeId, String channelId, long timeToLiveInMs, IConcurrentConnectionManager.ReservationType type) {
            this.nodeId = nodeId;
            this.timeToLiveInMs = timeToLiveInMs;
            this.type = type;
        }

        public int hashCode() {
            return this.nodeId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Reservation) {
                return this.nodeId.equals(((Reservation)obj).nodeId);
            }
            return false;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public long getTimeToLiveInMs() {
            return this.timeToLiveInMs;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public IConcurrentConnectionManager.ReservationType getType() {
            return this.type;
        }

        public String getIdentifier() {
            return ConcurrentConnectionManager.getReservationIdentifier(this.getNodeId(), this.getChannelId());
        }
    }
}

