/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.util.Date;
import org.jumpmind.symmetric.statistic.AbstractNodeHostStats;
import org.jumpmind.util.AppUtils;

public class JobStats
extends AbstractNodeHostStats {
    private String jobName;
    private long processedCount;
    private String targetNodeId;
    private int targetNodeCount;
    private boolean errorFlag;
    private String errorMessage;

    public JobStats() {
    }

    public JobStats(String nodeId, String hostName, Date startTime, Date endTime, String jobName) {
        super(nodeId, hostName, startTime, endTime);
        this.jobName = jobName;
    }

    public JobStats(String targetNodeId, int targetNodeCount, long startTime, long endTime, String jobName, long processedCount) {
        this(jobName, startTime, endTime, processedCount);
        this.targetNodeId = targetNodeId;
        this.targetNodeCount = targetNodeCount;
    }

    public JobStats(String jobName, long startTime, long endTime, long processedCount) {
        this(null, null, new Date(startTime), new Date(endTime), jobName);
        this.processedCount = processedCount;
    }

    public JobStats(String jobName, long startTime, long endTime, long processedCount, Exception e) {
        this(null, null, new Date(startTime), new Date(endTime), jobName);
        this.processedCount = processedCount;
        this.errorFlag = true;
        this.errorMessage = e.getClass().getName() + ": " + e.getMessage() + "\r\n" + AppUtils.formatStackTrace((StackTraceElement[])e.getStackTrace(), (int)50, (boolean)false);
    }

    public JobStats(JobStats source) {
        super(source.getNodeId(), source.getHostName(), source.getStartTime(), source.getEndTime());
        this.jobName = source.getJobName();
        this.processedCount = source.getProcessedCount();
        this.targetNodeId = source.getTargetNodeId();
        this.targetNodeCount = source.getTargetNodeCount();
        this.errorFlag = source.isErrorFlag();
        this.errorMessage = source.getErrorMessage();
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String channelId) {
        this.jobName = channelId;
    }

    public long getProcessedCount() {
        return this.processedCount;
    }

    public void setProcessedCount(long processedCount) {
        this.processedCount = processedCount;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String targetNodeId) {
        this.targetNodeId = targetNodeId;
    }

    public int getTargetNodeCount() {
        return this.targetNodeCount;
    }

    public void setTargetNodeCount(int targetNodeCount) {
        this.targetNodeCount = targetNodeCount;
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

