/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.util.CounterStat;
import org.jumpmind.util.Context;

public class TriggerRouterContext
extends Context {
    Map<String, CounterStat> triggerReadTableFromDatabase = new HashMap<String, CounterStat>();
    Map<String, CounterStat> triggerCopyTable = new HashMap<String, CounterStat>();
    Map<Integer, CounterStat> multipleActiveTriggerRouter = new HashMap<Integer, CounterStat>();
    long fixMultipleActiveTriggerHistoriesTime;
    long triggersForCurrentNodeTime;
    long syncTriggersStartedTime;
    long activeTriggerHistoriesTime;
    long updateOrCreateDdlTriggersTime;
    long syncTriggersEndedTime;
    long tablesForTriggerTime;
    long dropTriggerTime;
    long doesTriggerExistTime;
    long inactivateTriggerHistTime;
    long triggerToTableSupportingInfoTime;
    long tableDoesNotExistTime;
    long updateOrCreateDatabaseTriggersTime;
    long triggerInactivatedTime;

    public synchronized void incrementReadTableCount(Trigger trigger) {
        if (trigger != null) {
            CounterStat counterStat = this.triggerReadTableFromDatabase.get(trigger.getTriggerId());
            if (counterStat == null) {
                counterStat = new CounterStat(trigger);
                this.triggerReadTableFromDatabase.put(trigger.getTriggerId(), counterStat);
            }
            counterStat.incrementCount();
        }
    }

    public synchronized Set<String> getTriggerReadTableFromDatabaseKeyset() {
        return this.triggerReadTableFromDatabase.keySet();
    }

    public synchronized long getTriggerReadTableFromDatabaseCount(String triggerId) {
        CounterStat counterStat = this.triggerReadTableFromDatabase.get(triggerId);
        if (counterStat != null) {
            return counterStat.getCount();
        }
        return 0L;
    }

    public synchronized void incrementCopyTableCount(Trigger trigger) {
        if (trigger != null) {
            CounterStat counterStat = this.triggerCopyTable.get(trigger.getTriggerId());
            if (counterStat == null) {
                counterStat = new CounterStat(trigger);
                this.triggerCopyTable.put(trigger.getTriggerId(), counterStat);
            }
            counterStat.incrementCount();
        }
    }

    public synchronized Set<String> getTriggerCopyTableKeyset() {
        return this.triggerCopyTable.keySet();
    }

    public synchronized long getTriggerCopyTableCount(String triggerId) {
        CounterStat counterStat = this.triggerCopyTable.get(triggerId);
        if (counterStat != null) {
            return counterStat.getCount();
        }
        return 0L;
    }

    public synchronized Set<Integer> getMultipleActiveTriggerRouterKeyset() {
        return this.multipleActiveTriggerRouter.keySet();
    }

    public synchronized long getMultipleActiveTriggerRouterCount(Integer triggerRouterId) {
        CounterStat counterStat = this.multipleActiveTriggerRouter.get(triggerRouterId);
        if (counterStat != null) {
            return counterStat.getCount();
        }
        return 0L;
    }

    public synchronized void incrementMultipleActiveTriggerRouterCount(Integer triggerRouterId) {
        if (triggerRouterId != null) {
            CounterStat counterStat = this.multipleActiveTriggerRouter.get(triggerRouterId);
            if (counterStat == null) {
                counterStat = new CounterStat(triggerRouterId);
                this.multipleActiveTriggerRouter.put(triggerRouterId, counterStat);
            }
            counterStat.incrementCount();
        }
    }

    public synchronized void incrementFixMultipleActiveTriggerHistoriesTime(long t) {
        this.fixMultipleActiveTriggerHistoriesTime += t;
    }

    public synchronized long getFixMultipleActiveTriggerHistoriesTime() {
        return this.fixMultipleActiveTriggerHistoriesTime;
    }

    public synchronized void incrementTriggersForCurrentNodeTime(long t) {
        this.triggersForCurrentNodeTime += t;
    }

    public synchronized long getTriggersForCurrentNodeTime() {
        return this.triggersForCurrentNodeTime;
    }

    public synchronized void incrementSyncTriggersStartedTime(long t) {
        this.syncTriggersStartedTime += t;
    }

    public synchronized long getSyncTriggersStartedTime() {
        return this.syncTriggersStartedTime;
    }

    public synchronized void incrementActiveTriggerHistoriesTime(long t) {
        this.activeTriggerHistoriesTime += t;
    }

    public synchronized long getActiveTriggerHistoriesTime() {
        return this.activeTriggerHistoriesTime;
    }

    public synchronized void incrementUpdateOrCreateDdlTriggersTime(long t) {
        this.updateOrCreateDdlTriggersTime += t;
    }

    public synchronized long getUpdateOrCreateDdlTriggersTime() {
        return this.updateOrCreateDdlTriggersTime;
    }

    public synchronized void incrementSyncTriggersEndedTime(long t) {
        this.syncTriggersEndedTime += t;
    }

    public synchronized long getSyncTriggersEndedTime() {
        return this.syncTriggersEndedTime;
    }

    public synchronized void incrementTablesForTriggerTime(long t) {
        this.tablesForTriggerTime += t;
    }

    public synchronized long getTablesForTriggerTime() {
        return this.tablesForTriggerTime;
    }

    public synchronized void incrementDropTriggerTime(long t) {
        this.dropTriggerTime += t;
    }

    public synchronized long getDropTriggerTime() {
        return this.dropTriggerTime;
    }

    public synchronized void incrementDoesTriggerExistTime(long t) {
        this.doesTriggerExistTime += t;
    }

    public synchronized long getDoesTriggerExistTime() {
        return this.doesTriggerExistTime;
    }

    public synchronized void incrementInactivateTriggerHistTime(long t) {
        this.inactivateTriggerHistTime += t;
    }

    public synchronized long getInactivateTriggerHistTime() {
        return this.inactivateTriggerHistTime;
    }

    public synchronized void incrementTriggerToTableSupportingInfoTime(long t) {
        this.triggerToTableSupportingInfoTime += t;
    }

    public synchronized long getTriggerToTableSupportingInfoTime() {
        return this.triggerToTableSupportingInfoTime;
    }

    public synchronized void incrementTableDoesNotExistTime(long t) {
        this.tableDoesNotExistTime += t;
    }

    public synchronized long getTableDoesNotExistTime() {
        return this.tableDoesNotExistTime;
    }

    public synchronized void incrementUpdateOrCreateDatabaseTriggersTime(long t) {
        this.updateOrCreateDatabaseTriggersTime += t;
    }

    public synchronized long getUpdateOrCreateDatabaseTriggersTime() {
        return this.updateOrCreateDatabaseTriggersTime;
    }

    public synchronized void incrementTriggerInactivatedTime(long t) {
        this.triggerInactivatedTime += t;
    }

    public synchronized long getTriggerInactivatedTime() {
        return this.triggerInactivatedTime;
    }
}

