/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.transform.AdditiveColumnTransform;
import org.jumpmind.symmetric.io.data.transform.BinaryLeftColumnTransform;
import org.jumpmind.symmetric.io.data.transform.BshColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ClarionDateTimeColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ColumnPolicy;
import org.jumpmind.symmetric.io.data.transform.ColumnsToRowsKeyColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ColumnsToRowsValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ConstantColumnTransform;
import org.jumpmind.symmetric.io.data.transform.CopyColumnTransform;
import org.jumpmind.symmetric.io.data.transform.CopyIfChangedColumnTransform;
import org.jumpmind.symmetric.io.data.transform.DeletedColumnListColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IdentityColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IsBlankTransform;
import org.jumpmind.symmetric.io.data.transform.IsEmptyTransform;
import org.jumpmind.symmetric.io.data.transform.IsNullTransform;
import org.jumpmind.symmetric.io.data.transform.JavaColumnTransform;
import org.jumpmind.symmetric.io.data.transform.LeftColumnTransform;
import org.jumpmind.symmetric.io.data.transform.LookupColumnTransform;
import org.jumpmind.symmetric.io.data.transform.MathColumnTransform;
import org.jumpmind.symmetric.io.data.transform.MultiplierColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ParameterColumnTransform;
import org.jumpmind.symmetric.io.data.transform.RemoveColumnTransform;
import org.jumpmind.symmetric.io.data.transform.SubstrColumnTransform;
import org.jumpmind.symmetric.io.data.transform.TargetDmlAction;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.symmetric.io.data.transform.TrimColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ValueMapColumnTransform;
import org.jumpmind.symmetric.io.data.transform.VariableColumnTransform;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.security.ISmtpPasswordFilter;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.TransformServiceSqlMap;
import org.jumpmind.util.FormatUtils;

public class TransformService
extends AbstractService
implements ITransformService {
    private static final String NODE_FILTER_BSH = "filter = null; if (engine != null && engine.getExtensionService() != null) filter = engine.getExtensionService().getExtensionPoint(org.jumpmind.symmetric.security.INodePasswordFilter.class); if (filter != null) return filter.%s(currentValue); else return currentValue;";
    private static final String SMTP_PASSWORD_BSH = "if (sourceDmlTypeString.equalsIgnoreCase(\"insert\") || sourceDmlTypeString.equalsIgnoreCase(\"update\")) {if (PARAM_KEY.equalsIgnoreCase(\"smtp.password\")) {filter = null; if (engine != null && engine.getExtensionService() != null) filter = engine.getExtensionService().getExtensionPoint(org.jumpmind.symmetric.security.ISmtpPasswordFilter.class); if (filter != null) return filter.%s(currentValue); else return currentValue;} else { return currentValue; }}";
    private IConfigurationService configurationService;
    private IExtensionService extensionService;
    private IParameterService parameterService;
    private Date lastUpdateTime;
    private ICacheManager cacheManager;

    public TransformService(ISymmetricEngine engine, ISymmetricDialect symmetricDialect) {
        super(engine.getParameterService(), symmetricDialect);
        this.cacheManager = engine.getCacheManager();
        this.configurationService = engine.getConfigurationService();
        this.extensionService = engine.getExtensionService();
        this.parameterService = engine.getParameterService();
        this.addColumnTransform("parameter", (IColumnTransform<?>)new ParameterColumnTransform(this.parameterService));
        this.addColumnTransform("variable", (IColumnTransform<?>)new VariableColumnTransform());
        this.addColumnTransform("lookup", (IColumnTransform<?>)new LookupColumnTransform());
        this.addColumnTransform("bsh", (IColumnTransform<?>)new BshColumnTransform(this.parameterService));
        this.addColumnTransform("additive", (IColumnTransform<?>)new AdditiveColumnTransform());
        this.addColumnTransform("java", (IColumnTransform<?>)new JavaColumnTransform(this.extensionService));
        this.addColumnTransform("const", (IColumnTransform<?>)new ConstantColumnTransform());
        this.addColumnTransform("copy", (IColumnTransform<?>)new CopyColumnTransform());
        this.addColumnTransform("identity", (IColumnTransform<?>)new IdentityColumnTransform());
        this.addColumnTransform("multiply", (IColumnTransform<?>)new MultiplierColumnTransform());
        this.addColumnTransform("substr", (IColumnTransform<?>)new SubstrColumnTransform());
        this.addColumnTransform("left", (IColumnTransform<?>)new LeftColumnTransform());
        this.addColumnTransform("trim", (IColumnTransform<?>)new TrimColumnTransform());
        this.addColumnTransform("bleft", (IColumnTransform<?>)new BinaryLeftColumnTransform());
        this.addColumnTransform("remove", (IColumnTransform<?>)new RemoveColumnTransform());
        this.addColumnTransform("math", (IColumnTransform<?>)new MathColumnTransform());
        this.addColumnTransform("valueMap", (IColumnTransform<?>)new ValueMapColumnTransform());
        this.addColumnTransform("copyIfChanged", (IColumnTransform<?>)new CopyIfChangedColumnTransform());
        this.addColumnTransform("columnsToRowsKey", (IColumnTransform<?>)new ColumnsToRowsKeyColumnTransform());
        this.addColumnTransform("columnsToRowsValue", (IColumnTransform<?>)new ColumnsToRowsValueColumnTransform());
        this.addColumnTransform("clarionDateTime", (IColumnTransform<?>)new ClarionDateTimeColumnTransform());
        this.addColumnTransform("isEmpty", (IColumnTransform<?>)new IsEmptyTransform());
        this.addColumnTransform("isNull", (IColumnTransform<?>)new IsNullTransform());
        this.addColumnTransform("isBlank", (IColumnTransform<?>)new IsBlankTransform());
        this.addColumnTransform("deletedColumns", (IColumnTransform<?>)new DeletedColumnListColumnTransform());
        this.setSqlMap(new TransformServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    private void addColumnTransform(String name, IColumnTransform<?> columnTransform) {
        this.extensionService.addExtensionPoint(name, (IExtensionPoint)columnTransform);
    }

    @Override
    public Map<String, IColumnTransform<?>> getColumnTransforms() {
        return this.extensionService.getExtensionPointMap(IColumnTransform.class);
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date2;
        Date date1 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxTransformTableLastUpdateTime"), Date.class, new Object[0]);
        Date date = this.maxDate(date1, date2 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxTransformColumnLastUpdateTime"), Date.class, new Object[0]));
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer transform settings were detected");
            }
            this.lastUpdateTime = date;
            this.clearCache();
            return true;
        }
        return false;
    }

    public List<TransformTableNodeGroupLink> findTransformsFor(NodeGroupLink nodeGroupLink) {
        return this.findTransformsFor(nodeGroupLink, null);
    }

    @Override
    public List<TransformTableNodeGroupLink> findTransformsFor(NodeGroupLink nodeGroupLink, TransformPoint transformPoint) {
        Map<NodeGroupLink, Map<TransformPoint, List<TransformTableNodeGroupLink>>> byLinkByTransformPoint = this.readInCacheIfExpired();
        Map<TransformPoint, List<TransformTableNodeGroupLink>> byTransformPoint = byLinkByTransformPoint.get(nodeGroupLink);
        if (byTransformPoint != null) {
            if (transformPoint != null) {
                return byTransformPoint.get(transformPoint);
            }
            List<TransformTableNodeGroupLink> transformsExtract = byTransformPoint.get(TransformPoint.EXTRACT);
            List<TransformTableNodeGroupLink> transformsLoad = byTransformPoint.get(TransformPoint.LOAD);
            ArrayList<TransformTableNodeGroupLink> transforms = new ArrayList<TransformTableNodeGroupLink>();
            if (transformsExtract != null) {
                transforms.addAll(transformsExtract);
            }
            if (transformsLoad != null) {
                transforms.addAll(transformsLoad);
            }
            return transforms;
        }
        return null;
    }

    @Override
    public List<TransformTableNodeGroupLink> findTransformsFor(String sourceNodeGroupId, String targetNodeGroupId, String table) {
        NodeGroupLink nodeGroupLink = new NodeGroupLink(sourceNodeGroupId, targetNodeGroupId);
        List<TransformTableNodeGroupLink> transformsForNodeGroupLink = this.findTransformsFor(nodeGroupLink);
        if (!CollectionUtils.isEmpty(transformsForNodeGroupLink)) {
            ArrayList<TransformTableNodeGroupLink> transforms = new ArrayList<TransformTableNodeGroupLink>();
            for (TransformTableNodeGroupLink transform : transformsForNodeGroupLink) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)table, (CharSequence)transform.getSourceTableName())) continue;
                transforms.add(transform);
            }
            if (!transforms.isEmpty()) {
                return transforms;
            }
        }
        return null;
    }

    @Override
    public void clearCache() {
        this.cacheManager.flushTransformCache();
    }

    private Map<NodeGroupLink, Map<TransformPoint, List<TransformTableNodeGroupLink>>> readInCacheIfExpired() {
        return this.cacheManager.getTransformCache();
    }

    @Override
    public Map<NodeGroupLink, Map<TransformPoint, List<TransformTableNodeGroupLink>>> readInCacheIfExpiredFromDb() {
        HashMap<NodeGroupLink, Map<TransformPoint, List<TransformTableNodeGroupLink>>> byByLinkByTransformPoint = new HashMap<NodeGroupLink, Map<TransformPoint, List<TransformTableNodeGroupLink>>>(2);
        List<TransformTableNodeGroupLink> transforms = this.getTransformTablesFromDB(true, true);
        for (TransformTableNodeGroupLink transformTable : transforms) {
            ArrayList<TransformTableNodeGroupLink> byTableName;
            NodeGroupLink nodeGroupLink = transformTable.getNodeGroupLink();
            HashMap<TransformPoint, ArrayList<TransformTableNodeGroupLink>> byTransformPoint = (HashMap<TransformPoint, ArrayList<TransformTableNodeGroupLink>>)byByLinkByTransformPoint.get(nodeGroupLink);
            if (byTransformPoint == null) {
                byTransformPoint = new HashMap<TransformPoint, ArrayList<TransformTableNodeGroupLink>>(2);
                byByLinkByTransformPoint.put(nodeGroupLink, byTransformPoint);
            }
            if ((byTableName = (ArrayList<TransformTableNodeGroupLink>)byTransformPoint.get(transformTable.getTransformPoint())) == null) {
                byTableName = new ArrayList<TransformTableNodeGroupLink>();
                byTransformPoint.put(transformTable.getTransformPoint(), byTableName);
            }
            byTableName.add(transformTable);
        }
        this.addBuiltInTableTransforms(byByLinkByTransformPoint);
        return byByLinkByTransformPoint;
    }

    private void addBuiltInTableTransforms(Map<NodeGroupLink, Map<TransformPoint, List<TransformTableNodeGroupLink>>> byLinkByTransformPoint) {
        ArrayList<NodeGroupLink> nodeGroupLinks = new ArrayList<NodeGroupLink>(this.configurationService.getNodeGroupLinks(true));
        nodeGroupLinks.add(null);
        for (NodeGroupLink nodeGroupLink : nodeGroupLinks) {
            List<TransformTableNodeGroupLink> transforms;
            Map<TransformPoint, List<TransformTableNodeGroupLink>> byTransformPoint = byLinkByTransformPoint.get(nodeGroupLink);
            if (byTransformPoint == null) {
                byTransformPoint = new HashMap<TransformPoint, List<TransformTableNodeGroupLink>>();
                byLinkByTransformPoint.put(nodeGroupLink, byTransformPoint);
            }
            if ((transforms = byTransformPoint.get(TransformPoint.LOAD)) == null) {
                transforms = new ArrayList<TransformTableNodeGroupLink>();
                byTransformPoint.put(TransformPoint.LOAD, transforms);
            }
            transforms.addAll(this.getConfigLoadTransforms(nodeGroupLink));
            transforms = byTransformPoint.get(TransformPoint.EXTRACT);
            if (transforms == null) {
                transforms = new ArrayList<TransformTableNodeGroupLink>();
                byTransformPoint.put(TransformPoint.EXTRACT, transforms);
            }
            transforms.addAll(this.getConfigExtractTransforms(nodeGroupLink));
        }
    }

    @Override
    public List<TransformTableNodeGroupLink> getConfigExtractTransforms(NodeGroupLink nodeGroupLink) {
        TransformColumn column;
        TransformTableNodeGroupLink transform;
        String tableName;
        ArrayList<TransformTableNodeGroupLink> transforms = new ArrayList<TransformTableNodeGroupLink>();
        if (this.extensionService.getExtensionPoint(INodePasswordFilter.class) != null) {
            tableName = TableConstants.getTableName(this.parameterService.getTablePrefix(), "node_security");
            transform = new TransformTableNodeGroupLink();
            transform.setSourceTableName(tableName);
            transform.setTargetTableName(tableName);
            transform.setTransformPoint(TransformPoint.EXTRACT);
            column = new TransformColumn("node_password", "node_password", false);
            column.setTransformType("bsh");
            column.setTransformExpression(String.format(NODE_FILTER_BSH, "onNodeSecurityRender"));
            transform.addTransformColumn(column);
            transform.setNodeGroupLink(nodeGroupLink);
            transforms.add(transform);
        }
        if (this.extensionService.getExtensionPoint(ISmtpPasswordFilter.class) != null) {
            tableName = TableConstants.getTableName(this.parameterService.getTablePrefix(), "parameter");
            transform = new TransformTableNodeGroupLink();
            transform.setSourceTableName(tableName);
            transform.setTargetTableName(tableName);
            transform.setTransformPoint(TransformPoint.EXTRACT);
            column = new TransformColumn("param_value", "param_value", false);
            column.setTransformType("bsh");
            column.setTransformExpression(String.format(SMTP_PASSWORD_BSH, "onSmtpPasswordRender"));
            transform.addTransformColumn(column);
            transform.setNodeGroupLink(nodeGroupLink);
            transforms.add(transform);
        }
        return transforms;
    }

    @Override
    public List<TransformTableNodeGroupLink> getConfigLoadTransforms(NodeGroupLink nodeGroupLink) {
        ArrayList<TransformTableNodeGroupLink> transforms = new ArrayList<TransformTableNodeGroupLink>();
        TransformColumn column = new TransformColumn("heartbeat_time", "heartbeat_time", false);
        column.setTransformType("variable");
        column.setTransformExpression("system_timestamp");
        String tableName = TableConstants.getTableName(this.parameterService.getTablePrefix(), "node_host");
        TransformTableNodeGroupLink transform = new TransformTableNodeGroupLink();
        transform.setSourceTableName(tableName);
        transform.setTargetTableName(tableName);
        transform.setTransformPoint(TransformPoint.EXTRACT);
        transform.addTransformColumn(column);
        transform.setNodeGroupLink(nodeGroupLink);
        transforms.add(transform);
        if (this.extensionService.getExtensionPoint(INodePasswordFilter.class) != null) {
            tableName = TableConstants.getTableName(this.parameterService.getTablePrefix(), "node_security");
            transform = new TransformTableNodeGroupLink();
            transform.setSourceTableName(tableName);
            transform.setTargetTableName(tableName);
            transform.setTransformPoint(TransformPoint.LOAD);
            column = new TransformColumn("node_password", "node_password", false);
            column.setTransformType("bsh");
            column.setTransformExpression(String.format(NODE_FILTER_BSH, "onNodeSecuritySave"));
            transform.addTransformColumn(column);
            transform.setNodeGroupLink(nodeGroupLink);
            transforms.add(transform);
        }
        if (this.extensionService.getExtensionPoint(ISmtpPasswordFilter.class) != null) {
            tableName = TableConstants.getTableName(this.parameterService.getTablePrefix(), "parameter");
            transform = new TransformTableNodeGroupLink();
            transform.setSourceTableName(tableName);
            transform.setTargetTableName(tableName);
            transform.setTransformPoint(TransformPoint.LOAD);
            column = new TransformColumn("param_value", "param_value", false);
            column.setTransformType("bsh");
            column.setTransformExpression(String.format(SMTP_PASSWORD_BSH, "onSmtpPasswordSave"));
            transform.addTransformColumn(column);
            transform.setNodeGroupLink(nodeGroupLink);
            transforms.add(transform);
        }
        return transforms;
    }

    private List<TransformTableNodeGroupLink> getTransformTablesFromDB(boolean includeColumns, boolean replaceTokens) {
        List transforms = this.sqlTemplate.query(this.getSql("selectTransformTable", "orderByTransformOrder"), (ISqlRowMapper)new TransformTableMapper(), new Object[0]);
        if (includeColumns) {
            List<TransformColumn> columns = this.getTransformColumnsFromDB();
            for (TransformTableNodeGroupLink transformTable : transforms) {
                for (TransformColumn column : columns) {
                    if (!column.getTransformId().equals(transformTable.getTransformId())) continue;
                    transformTable.addTransformColumn(column);
                }
            }
        }
        if (replaceTokens) {
            TypedProperties replacements = this.parameterService.getAllParameters();
            for (TransformTableNodeGroupLink transform : transforms) {
                transform.setSourceCatalogName(FormatUtils.replaceTokens((String)transform.getSourceCatalogName(), (Map)replacements, (boolean)true));
                transform.setSourceSchemaName(FormatUtils.replaceTokens((String)transform.getSourceSchemaName(), (Map)replacements, (boolean)true));
                transform.setSourceTableName(FormatUtils.replaceTokens((String)transform.getSourceTableName(), (Map)replacements, (boolean)true));
                transform.setTargetCatalogName(FormatUtils.replaceTokens((String)transform.getTargetCatalogName(), (Map)replacements, (boolean)true));
                transform.setTargetSchemaName(FormatUtils.replaceTokens((String)transform.getTargetSchemaName(), (Map)replacements, (boolean)true));
                transform.setTargetTableName(FormatUtils.replaceTokens((String)transform.getTargetTableName(), (Map)replacements, (boolean)true));
            }
        }
        return transforms;
    }

    private List<TransformColumn> getTransformColumnsFromDB() {
        List columns = this.sqlTemplate.query(this.getSql("selectTransformColumn"), (ISqlRowMapper)new TransformColumnMapper(), new Object[0]);
        return columns;
    }

    @Override
    public List<TransformTableNodeGroupLink> getTransformTables(boolean includeColumns) {
        return this.getTransformTablesFromDB(includeColumns, true);
    }

    @Override
    public List<TransformTableNodeGroupLink> getTransformTables(boolean includeColumns, boolean replaceTokens) {
        return this.getTransformTablesFromDB(includeColumns, replaceTokens);
    }

    @Override
    public List<TransformColumn> getTransformColumns() {
        return this.getTransformColumnsFromDB();
    }

    @Override
    public List<TransformColumn> getTransformColumnsForTable(String transformId) {
        List columns = this.sqlTemplate.query(this.getSql("selectTransformColumnForTable"), (ISqlRowMapper)new TransformColumnMapper(), new Object[]{transformId});
        return columns;
    }

    @Override
    public void saveTransformTable(TransformTableNodeGroupLink transformTable, boolean saveTransformColumns) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            transformTable.setLastUpdateTime(new Date());
            if (transaction.prepareAndExecute(this.getSql("updateTransformTableSql"), new Object[]{transformTable.getNodeGroupLink().getSourceNodeGroupId(), transformTable.getNodeGroupLink().getTargetNodeGroupId(), transformTable.getSourceCatalogName(), transformTable.getSourceSchemaName(), transformTable.getSourceTableName(), transformTable.getTargetCatalogName(), transformTable.getTargetSchemaName(), transformTable.getTargetTableName(), transformTable.getTransformPoint().toString(), transformTable.isUpdateFirst() ? 1 : 0, transformTable.getDeleteAction().toString(), transformTable.getUpdateAction(), transformTable.getTransformOrder(), transformTable.getColumnPolicy().toString(), transformTable.getLastUpdateTime(), transformTable.getLastUpdateBy(), transformTable.getTransformId()}) == 0) {
                transformTable.setCreateTime(new Date());
                transaction.prepareAndExecute(this.getSql("insertTransformTableSql"), new Object[]{transformTable.getNodeGroupLink().getSourceNodeGroupId(), transformTable.getNodeGroupLink().getTargetNodeGroupId(), transformTable.getSourceCatalogName(), transformTable.getSourceSchemaName(), transformTable.getSourceTableName(), transformTable.getTargetCatalogName(), transformTable.getTargetSchemaName(), transformTable.getTargetTableName(), transformTable.getTransformPoint().toString(), transformTable.isUpdateFirst() ? 1 : 0, transformTable.getDeleteAction().toString(), transformTable.getUpdateAction(), transformTable.getTransformOrder(), transformTable.getColumnPolicy().toString(), transformTable.getLastUpdateTime(), transformTable.getLastUpdateBy(), transformTable.getCreateTime(), transformTable.getTransformId()});
            }
            if (saveTransformColumns) {
                this.deleteTransformColumns(transaction, transformTable.getTransformId());
                List columns = transformTable.getTransformColumns();
                if (columns != null) {
                    for (TransformColumn transformColumn : columns) {
                        this.saveTransformColumn(transaction, transformColumn);
                    }
                }
            }
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
            this.clearCache();
        }
    }

    @Override
    public void saveTransformTableAsCopy(String originalId, TransformTableNodeGroupLink transformTable) {
        String newId = transformTable.getTransformId();
        List transformTables = this.sqlTemplate.query(this.getSql("selectTransformTable", "whereTransformIdLike"), (ISqlRowMapper)new TransformTableMapper(), new Object[]{newId + "%"});
        List ids = transformTables.stream().map(TransformTable::getTransformId).collect(Collectors.toList());
        String suffix = "";
        int i = 2;
        while (ids.contains(newId + suffix)) {
            suffix = "_" + i;
            ++i;
        }
        transformTable.setTransformId(newId + suffix);
        this.saveTransformTable(transformTable, false);
        try (ISqlTransaction transaction = null;){
            transaction = this.sqlTemplate.startSqlTransaction();
            for (TransformColumn transformColumn : this.getTransformColumnsForTable(originalId)) {
                transformColumn.setTransformId(newId + suffix);
                this.saveTransformColumn(transaction, transformColumn);
            }
            transaction.commit();
        }
    }

    @Override
    public void renameTransformTable(String oldId, TransformTableNodeGroupLink transformTable) {
        this.saveTransformTable(transformTable, false);
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            transaction.prepareAndExecute(this.getSql("updateTransformIdSql"), new Object[]{transformTable.getTransformId(), oldId});
            transaction.prepareAndExecute(this.getSql("deleteTransformTableSql"), new Object[]{oldId});
            transaction.commit();
        }
        catch (Exception ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    protected void deleteTransformColumns(ISqlTransaction transaction, String transformTableId) {
        transaction.prepareAndExecute(this.getSql("deleteTransformColumnsSql"), new Object[]{transformTableId});
    }

    @Override
    public void deleteAllTransformColumns() {
        this.sqlTemplate.update(this.getSql("deleteAllTransformColumnsSql"), new Object[0]);
        this.clearCache();
    }

    @Override
    public void deleteTransformTable(String transformTableId) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.deleteTransformColumns(transaction, transformTableId);
            transaction.prepareAndExecute(this.getSql("deleteTransformTableSql"), new Object[]{transformTableId});
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
            this.clearCache();
        }
    }

    @Override
    public void deleteAllTransformTables() {
        this.sqlTemplate.update(this.getSql("deleteAllTransformTablesSql"), new Object[0]);
        this.clearCache();
    }

    protected void saveTransformColumn(ISqlTransaction transaction, TransformColumn transformColumn) {
        transformColumn.setLastUpdateTime(new Date());
        if (transaction.prepareAndExecute(this.getSql("updateTransformColumnSql"), new Object[]{transformColumn.getSourceColumnName(), transformColumn.isPk() ? 1 : 0, transformColumn.getTransformType(), transformColumn.getTransformExpression(), transformColumn.getTransformOrder(), transformColumn.getLastUpdateTime(), transformColumn.getLastUpdateBy(), transformColumn.getTransformId(), transformColumn.getIncludeOn().toDbValue(), transformColumn.getTargetColumnName()}) == 0) {
            transformColumn.setCreateTime(new Date());
            transaction.prepareAndExecute(this.getSql("insertTransformColumnSql"), new Object[]{transformColumn.getTransformId(), transformColumn.getIncludeOn().toDbValue(), transformColumn.getTargetColumnName(), transformColumn.getSourceColumnName(), transformColumn.isPk() ? 1 : 0, transformColumn.getTransformType(), transformColumn.getTransformExpression(), transformColumn.getTransformOrder(), transformColumn.getLastUpdateTime(), transformColumn.getLastUpdateBy(), transformColumn.getCreateTime()});
        }
    }

    public static class TransformTableNodeGroupLink
    extends TransformTable
    implements IModelObject {
        private static final long serialVersionUID = 1L;
        protected NodeGroupLink nodeGroupLink;
        protected boolean bound;

        public void setNodeGroupLink(NodeGroupLink nodeGroupLink) {
            this.nodeGroupLink = nodeGroupLink;
        }

        public NodeGroupLink getNodeGroupLink() {
            return this.nodeGroupLink;
        }

        public boolean isBound() {
            return this.bound;
        }

        public void setBound(boolean bound) {
            this.bound = bound;
        }
    }

    static class TransformColumnMapper
    implements ISqlRowMapper<TransformColumn> {
        TransformColumnMapper() {
        }

        public TransformColumn mapRow(Row rs) {
            TransformColumn col = new TransformColumn();
            col.setTransformId(rs.getString("transform_id"));
            col.setIncludeOn(TransformColumn.IncludeOnType.decode((String)rs.getString("include_on")));
            col.setTargetColumnName(rs.getString("target_column_name"));
            col.setSourceColumnName(rs.getString("source_column_name"));
            col.setPk(rs.getBoolean("pk"));
            col.setTransformType(rs.getString("transform_type"));
            col.setTransformExpression(rs.getString("transform_expression"));
            col.setTransformOrder(rs.getInt("transform_order"));
            col.setCreateTime(rs.getDateTime("create_time"));
            col.setLastUpdateBy(rs.getString("last_update_by"));
            col.setLastUpdateTime(rs.getDateTime("last_update_time"));
            return col;
        }
    }

    class TransformTableMapper
    implements ISqlRowMapper<TransformTableNodeGroupLink> {
        TransformTableMapper() {
        }

        public TransformTableNodeGroupLink mapRow(Row rs) {
            TransformTableNodeGroupLink table = new TransformTableNodeGroupLink();
            table.setTransformId(rs.getString("transform_id"));
            table.setNodeGroupLink(TransformService.this.configurationService.getNodeGroupLinkFor(rs.getString("source_node_group_id"), rs.getString("target_node_group_id"), false));
            table.setSourceCatalogName(StringUtils.trimToNull((String)rs.getString("source_catalog_name")));
            table.setSourceSchemaName(StringUtils.trimToNull((String)rs.getString("source_schema_name")));
            table.setSourceTableName(rs.getString("source_table_name"));
            table.setTargetCatalogName(StringUtils.trimToNull((String)rs.getString("target_catalog_name")));
            table.setTargetSchemaName(StringUtils.trimToNull((String)rs.getString("target_schema_name")));
            table.setTargetTableName(StringUtils.trimToNull((String)rs.getString("target_table_name")));
            try {
                table.setTransformPoint(TransformPoint.valueOf((String)rs.getString("transform_point").toUpperCase()));
            }
            catch (RuntimeException ex) {
                TransformService.this.log.warn("Invalid value provided for transform_point of '{}.'  Valid values are: {}", (Object)rs.getString("transform_point"), (Object)Arrays.toString(TransformPoint.values()));
                throw ex;
            }
            table.setTransformOrder(rs.getInt("transform_order"));
            table.setUpdateFirst(rs.getBoolean("update_first"));
            table.setColumnPolicy(ColumnPolicy.valueOf((String)rs.getString("column_policy")));
            table.setUpdateAction(rs.getString("update_action"));
            table.setDeleteAction(TargetDmlAction.valueOf((String)rs.getString("delete_action")));
            table.setCreateTime(rs.getDateTime("create_time"));
            table.setLastUpdateBy(rs.getString("last_update_by"));
            table.setLastUpdateTime(rs.getDateTime("last_update_time"));
            return table;
        }
    }
}

