/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.exception.InterruptedException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerReBuildReason;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractFileParsingRouter;
import org.jumpmind.symmetric.route.AuditTableDataRouter;
import org.jumpmind.symmetric.route.BshDataRouter;
import org.jumpmind.symmetric.route.CSVRouter;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.ColumnMatchDataRouter;
import org.jumpmind.symmetric.route.CommonBatchCollisionException;
import org.jumpmind.symmetric.route.ConfigurationChangedDataRouter;
import org.jumpmind.symmetric.route.ConvertToReloadRouter;
import org.jumpmind.symmetric.route.DBFRouter;
import org.jumpmind.symmetric.route.DataGapDetector;
import org.jumpmind.symmetric.route.DataGapFastDetector;
import org.jumpmind.symmetric.route.DataGapRouteReader;
import org.jumpmind.symmetric.route.DefaultBatchAlgorithm;
import org.jumpmind.symmetric.route.DefaultDataRouter;
import org.jumpmind.symmetric.route.DelayRoutingException;
import org.jumpmind.symmetric.route.FileSyncDataRouter;
import org.jumpmind.symmetric.route.IBatchAlgorithm;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IDataToRouteReader;
import org.jumpmind.symmetric.route.JavaDataRouter;
import org.jumpmind.symmetric.route.LookupTableDataRouter;
import org.jumpmind.symmetric.route.NonTransactionalBatchAlgorithm;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.route.SubSelectDataRouter;
import org.jumpmind.symmetric.route.TPSRouter;
import org.jumpmind.symmetric.route.TransactionalBatchAlgorithm;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.RouterServiceSqlMap;
import org.jumpmind.symmetric.util.CounterStat;
import org.jumpmind.util.FormatUtils;

public class RouterService
extends AbstractService
implements IRouterService,
INodeCommunicationService.INodeCommunicationExecutor {
    final int MAX_LOGGING_LENGTH = 512;
    protected Map<Integer, CounterStat> missingTriggerRouter = new HashMap<Integer, CounterStat>();
    protected Map<String, CounterStat> invalidRouterType = new HashMap<String, CounterStat>();
    protected Map<Integer, CounterStat> missingColumns = new HashMap<Integer, CounterStat>();
    protected long triggerRouterCacheTime = 0L;
    protected Map<String, Boolean> commonBatchesLastKnownState = new HashMap<String, Boolean>();
    protected long commonBatchesCacheTime;
    protected Map<String, Boolean> defaultRouterOnlyLastKnownState = new HashMap<String, Boolean>();
    protected long defaultRoutersCacheTime;
    protected transient ExecutorService readThread = null;
    protected ISymmetricEngine engine;
    protected IExtensionService extensionService;
    protected DataGapDetector gapDetector;
    protected boolean firstTimeCheck = true;
    protected boolean hasMaxDataRoutedOnChannel;
    protected boolean isUsingTargetExternalId;
    protected boolean useChannelThreading;

    public RouterService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.extensionService = engine.getExtensionService();
        this.extensionService.addExtensionPoint("default", new DefaultBatchAlgorithm());
        this.extensionService.addExtensionPoint("nontransactional", new NonTransactionalBatchAlgorithm());
        this.extensionService.addExtensionPoint("transactional", new TransactionalBatchAlgorithm());
        this.extensionService.addExtensionPoint("configurationChanged", new ConfigurationChangedDataRouter(engine));
        this.extensionService.addExtensionPoint("java", new JavaDataRouter(engine));
        this.extensionService.addExtensionPoint("bsh", new BshDataRouter(engine));
        this.extensionService.addExtensionPoint("subselect", new SubSelectDataRouter(this.symmetricDialect));
        this.extensionService.addExtensionPoint("lookuptable", new LookupTableDataRouter(this.symmetricDialect));
        this.extensionService.addExtensionPoint("default", new DefaultDataRouter());
        this.extensionService.addExtensionPoint("audit", new AuditTableDataRouter(engine));
        this.extensionService.addExtensionPoint("column", new ColumnMatchDataRouter(engine));
        this.extensionService.addExtensionPoint("filesync", new FileSyncDataRouter(engine));
        this.extensionService.addExtensionPoint("dbf", new DBFRouter(engine));
        this.extensionService.addExtensionPoint("tps", new TPSRouter(engine));
        this.extensionService.addExtensionPoint("csv", new CSVRouter(engine));
        this.extensionService.addExtensionPoint("convertToReload", new ConvertToReloadRouter(engine));
        this.setSqlMap(new RouterServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
        this.gapDetector = new DataGapFastDetector(engine.getDataService(), this.parameterService, engine.getContextService(), this.symmetricDialect, this, engine.getStatisticManager(), engine.getNodeService());
    }

    @Override
    public boolean shouldDataBeRouted(SimpleRouterContext context, DataMetaData dataMetaData, Node node, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        IDataRouter router = this.getDataRouter(dataMetaData.getRouter(), dataMetaData);
        HashSet<Node> oneNodeSet = new HashSet<Node>(1);
        oneNodeSet.add(node);
        Set<String> nodeIds = router.routeToNodes(context, dataMetaData, oneNodeSet, initialLoad, initialLoadSelectUsed, triggerRouter);
        return nodeIds != null && nodeIds.contains(node.getNodeId());
    }

    @Override
    public synchronized void stop() {
        if (this.readThread != null) {
            try {
                this.log.info("RouterService is shutting down");
                this.readThread.shutdown();
                this.readThread = null;
            }
            catch (Exception ex) {
                this.log.error("", (Throwable)ex);
            }
        }
    }

    @Override
    public void flushCache() {
        this.defaultRoutersCacheTime = 0L;
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized long routeData(boolean force) {
        long dataCount = -1L;
        Node identity = this.engine.getNodeService().findIdentity();
        if (identity != null && (force || this.engine.getClusterService().lock("Routing"))) {
            Data data;
            block24: {
                long startTime = System.currentTimeMillis();
                try {
                    if (this.firstTimeCheck) {
                        this.engine.getOutgoingBatchService().updateAbandonedRoutingBatches();
                        if (this.engine.getDataService().fixLastDataGap()) {
                            this.engine.getContextService().save("routing.full.gap.analysis", Boolean.TRUE.toString());
                        }
                        this.firstTimeCheck = false;
                        this.engine.getClusterService().refreshLock("Routing");
                    }
                    do {
                        long ts = System.currentTimeMillis();
                        this.hasMaxDataRoutedOnChannel = false;
                        this.isUsingTargetExternalId = this.engine.getCacheManager().isUsingTargetExternalId(false);
                        this.useChannelThreading = this.parameterService.is("routing.use.channel.threads");
                        this.gapDetector.beforeRouting();
                        dataCount = this.routeDataForEachChannel();
                        ts = System.currentTimeMillis() - ts;
                        if (dataCount > 0L || ts > 30000L) {
                            this.log.info("Routed {} data events in {} ms", (Object)dataCount, (Object)ts);
                        }
                        if (dataCount > 0L) {
                            this.gapDetector.afterRouting();
                        }
                        if (!this.hasMaxDataRoutedOnChannel) continue;
                        this.log.debug("Immediately routing again because a channel reached max data to route");
                    } while (this.hasMaxDataRoutedOnChannel);
                    if (dataCount > 0L) {
                        this.engine.getStatisticManager().addJobStats("Routing", startTime, System.currentTimeMillis(), dataCount);
                    }
                    if (force) break block24;
                }
                catch (InterruptedException e222222) {
                    Data data2;
                    this.engine.getStatisticManager().addJobStats("Routing", startTime, System.currentTimeMillis(), dataCount, (Exception)((Object)e222222));
                    this.log.warn("Interrupted");
                    if (!force) {
                        this.engine.getClusterService().unlock("Routing");
                    }
                    for (CounterStat counterStat : this.invalidRouterType.values()) {
                        Router router = (Router)counterStat.getObject();
                        this.log.warn("Invalid router type of '{}' configured on router '{}'.  Using default router instead.", (Object)router.getRouterType(), (Object)router.getRouterId());
                    }
                    this.invalidRouterType.clear();
                    for (CounterStat counterStat : this.missingTriggerRouter.values()) {
                        data2 = (Data)counterStat.getObject();
                        this.log.warn("Ignoring data captured for table '{}' because there is no trigger router configured for it.  If you removed or disabled the trigger router, you can disregard this warning.  Starting with data id {} and trigger hist id {}, there were {} occurrences.", new Object[]{data2.getTableName(), data2.getDataId(), data2.getTriggerHistory().getTriggerHistoryId(), counterStat.getCount()});
                    }
                    this.missingTriggerRouter.clear();
                    for (CounterStat counterStat : this.missingColumns.values()) {
                        data2 = (Data)counterStat.getObject();
                        this.log.warn("Ignoring data captured for table '{}' with trigger hist id {} because the number of columns and values don't match.  This can happen when you manually remove rows from sym_trigger_hist.  Starting with data id {}, there were {} occurrences.", new Object[]{data2.getTableName(), data2.getTriggerHistory().getTriggerHistoryId(), data2.getDataId(), counterStat.getCount()});
                    }
                    this.missingColumns.clear();
                }
                catch (RuntimeException e2222222) {
                    this.engine.getStatisticManager().addJobStats("Routing", startTime, System.currentTimeMillis(), dataCount, e2222222);
                    throw e2222222;
                    {
                        catch (Throwable throwable) {
                            Data data3;
                            if (!force) {
                                this.engine.getClusterService().unlock("Routing");
                            }
                            for (CounterStat counterStat : this.invalidRouterType.values()) {
                                Router router = (Router)counterStat.getObject();
                                this.log.warn("Invalid router type of '{}' configured on router '{}'.  Using default router instead.", (Object)router.getRouterType(), (Object)router.getRouterId());
                            }
                            this.invalidRouterType.clear();
                            for (CounterStat counterStat : this.missingTriggerRouter.values()) {
                                data3 = (Data)counterStat.getObject();
                                this.log.warn("Ignoring data captured for table '{}' because there is no trigger router configured for it.  If you removed or disabled the trigger router, you can disregard this warning.  Starting with data id {} and trigger hist id {}, there were {} occurrences.", new Object[]{data3.getTableName(), data3.getDataId(), data3.getTriggerHistory().getTriggerHistoryId(), counterStat.getCount()});
                            }
                            this.missingTriggerRouter.clear();
                            for (CounterStat counterStat : this.missingColumns.values()) {
                                data3 = (Data)counterStat.getObject();
                                this.log.warn("Ignoring data captured for table '{}' with trigger hist id {} because the number of columns and values don't match.  This can happen when you manually remove rows from sym_trigger_hist.  Starting with data id {}, there were {} occurrences.", new Object[]{data3.getTableName(), data3.getTriggerHistory().getTriggerHistoryId(), data3.getDataId(), counterStat.getCount()});
                            }
                            this.missingColumns.clear();
                            throw throwable;
                        }
                    }
                }
                this.engine.getClusterService().unlock("Routing");
            }
            for (CounterStat counterStat : this.invalidRouterType.values()) {
                Router router = (Router)counterStat.getObject();
                this.log.warn("Invalid router type of '{}' configured on router '{}'.  Using default router instead.", (Object)router.getRouterType(), (Object)router.getRouterId());
            }
            this.invalidRouterType.clear();
            for (CounterStat counterStat : this.missingTriggerRouter.values()) {
                data = (Data)counterStat.getObject();
                this.log.warn("Ignoring data captured for table '{}' because there is no trigger router configured for it.  If you removed or disabled the trigger router, you can disregard this warning.  Starting with data id {} and trigger hist id {}, there were {} occurrences.", new Object[]{data.getTableName(), data.getDataId(), data.getTriggerHistory().getTriggerHistoryId(), counterStat.getCount()});
            }
            this.missingTriggerRouter.clear();
            for (CounterStat counterStat : this.missingColumns.values()) {
                data = (Data)counterStat.getObject();
                this.log.warn("Ignoring data captured for table '{}' with trigger hist id {} because the number of columns and values don't match.  This can happen when you manually remove rows from sym_trigger_hist.  Starting with data id {}, there were {} occurrences.", new Object[]{data.getTableName(), data.getTriggerHistory().getTriggerHistoryId(), data.getDataId(), counterStat.getCount()});
            }
            this.missingColumns.clear();
        }
        return dataCount;
    }

    protected long routeDataForEachChannel() {
        long dataCount = 0L;
        Node sourceNode = this.engine.getNodeService().findIdentity();
        ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(sourceNode.getNodeId(), null, ProcessType.ROUTER_JOB));
        processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
        try {
            List<NodeChannel> channels = this.engine.getConfigurationService().getNodeChannels(false);
            Set<String> readyChannels = null;
            if (this.parameterService.is("routing.query.channels.first")) {
                readyChannels = this.getReadyChannels();
                this.engine.getClusterService().refreshLock("Routing");
            }
            INodeCommunicationService nodeComService = this.engine.getNodeCommunicationService();
            RemoteNodeStatuses nodeStatuses = null;
            if (this.useChannelThreading) {
                nodeStatuses = new RemoteNodeStatuses(this.engine.getConfigurationService().getChannels(false));
            }
            for (NodeChannel nodeChannel : channels) {
                if (nodeChannel.isEnabled() && (readyChannels == null || readyChannels.contains(nodeChannel.getChannelId()))) {
                    if (this.useChannelThreading) {
                        NodeCommunication lock = nodeComService.find(this.engine.getNodeId(), nodeChannel.getChannelId(), NodeCommunication.CommunicationType.ROUTE);
                        nodeComService.execute(lock, nodeStatuses, this);
                        continue;
                    }
                    processInfo.setCurrentTableName("");
                    processInfo.setCurrentChannelId(nodeChannel.getChannelId());
                    dataCount += this.routeDataForChannel(processInfo, nodeChannel, sourceNode, null, null);
                    continue;
                }
                if (nodeChannel.isEnabled()) continue;
                this.gapDetector.setIsAllDataRead(false);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Not routing the {} channel.  It is either disabled or suspended.", (Object)nodeChannel.getChannelId());
            }
            if (this.useChannelThreading) {
                long ts = System.currentTimeMillis();
                int timeout = this.parameterService.getInt("cluster.lock.refresh.ms", 1200000);
                while (!nodeStatuses.isComplete()) {
                    try {
                        this.log.debug("Waiting for threads to complete");
                        nodeStatuses.waitForComplete(timeout);
                    }
                    catch (InterruptedException e) {
                        if (e.getCause() != null && e.getCause() instanceof java.lang.InterruptedException) {
                            throw e;
                        }
                        this.engine.getClusterService().refreshLock("Routing");
                        this.log.info("Waiting on channel threads for {} seconds", (Object)(System.currentTimeMillis() - ts / 1000L));
                    }
                }
                dataCount = nodeStatuses.getDataProcessedCount();
            }
            processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
        }
        catch (RuntimeException ex) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            this.firstTimeCheck = true;
            throw ex;
        }
        return dataCount;
    }

    protected Set<String> getReadyChannels() {
        int[] types;
        Object[] args;
        String sql;
        List<DataGap> dataGaps = this.gapDetector.getDataGaps();
        int dataIdSqlType = this.engine.getSymmetricDialect().getSqlTypeForIds();
        int numberOfGapsToQualify = this.parameterService.getInt("routing.max.gaps.to.qualify.in.sql", 100);
        int maxGapsBeforeGreaterThanQuery = this.parameterService.getInt("routing.data.reader.threshold.gaps.to.use.greater.than.query", 100);
        if (maxGapsBeforeGreaterThanQuery > 0 && dataGaps.size() > maxGapsBeforeGreaterThanQuery) {
            sql = this.getSql("selectChannelsUsingStartDataId");
            args = new Object[]{dataGaps.get(0).getStartId()};
            types = new int[]{dataIdSqlType};
        } else {
            sql = this.qualifyUsingDataGaps(dataGaps, numberOfGapsToQualify, this.getSql("selectChannelsUsingGapsSql"));
            int numberOfArgs = 2 * (numberOfGapsToQualify < dataGaps.size() ? numberOfGapsToQualify : dataGaps.size());
            args = new Object[numberOfArgs];
            types = new int[numberOfArgs];
            for (int i = 0; i < numberOfGapsToQualify && i < dataGaps.size(); ++i) {
                DataGap gap = dataGaps.get(i);
                args[i * 2] = gap.getStartId();
                types[i * 2] = dataIdSqlType;
                args[i * 2 + 1] = i + 1 == numberOfGapsToQualify && i + 1 < dataGaps.size() ? Long.valueOf(dataGaps.get(dataGaps.size() - 1).getEndId()) : Long.valueOf(gap.getEndId());
                types[i * 2 + 1] = dataIdSqlType;
            }
        }
        final HashSet<String> readyChannels = new HashSet<String>();
        this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new ISqlRowMapper<String>(){

            public String mapRow(Row row) {
                readyChannels.add(row.getString("channel_id"));
                return null;
            }
        }, args, types);
        return readyChannels;
    }

    protected String qualifyUsingDataGaps(List<DataGap> dataGaps, int numberOfGapsToQualify, String sql) {
        StringBuilder gapClause = new StringBuilder();
        for (int i = 0; i < numberOfGapsToQualify && i < dataGaps.size(); ++i) {
            if (i == 0) {
                gapClause.append("(");
            } else {
                gapClause.append(" or ");
            }
            gapClause.append("(data_id between ? and ?)");
        }
        gapClause.append(")");
        return FormatUtils.replace((String)"dataRange", (String)gapClause.toString(), (String)sql);
    }

    @Deprecated
    protected boolean producesCommonBatches(Channel channel, String nodeGroupId, List<TriggerRouter> triggerRouters) {
        String channelId = channel.getChannelId();
        Boolean producesCommonBatches = this.commonBatchesLastKnownState.get(channelId);
        long cacheTime = this.parameterService.getLong("cache.channel.common.batches.time.ms");
        if (producesCommonBatches == null || System.currentTimeMillis() - this.commonBatchesCacheTime > cacheTime) {
            producesCommonBatches = !"config".equals(channelId) && !channel.isFileSyncFlag() && !channel.isReloadFlag() && !"heartbeat".equals(channelId) && !"monitor".equals(channelId);
            if (producesCommonBatches.booleanValue() && triggerRouters != null) {
                ArrayList<TriggerRouter> testableTriggerRouters = new ArrayList<TriggerRouter>();
                for (TriggerRouter triggerRouter : triggerRouters) {
                    if (triggerRouter.getTrigger().getChannelId().equals(channelId)) {
                        testableTriggerRouters.add(triggerRouter);
                        continue;
                    }
                    String anotherChannelTableName = triggerRouter.getTrigger().getFullyQualifiedSourceTableName();
                    for (TriggerRouter triggerRouter2 : triggerRouters) {
                        String currentTableName = triggerRouter2.getTrigger().getFullyQualifiedSourceTableName();
                        String currentChannelId = triggerRouter2.getTrigger().getChannelId();
                        if (!anotherChannelTableName.equals(currentTableName) || !currentChannelId.equals(channelId) || !triggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId().equals(triggerRouter2.getRouter().getNodeGroupLink().getSourceNodeGroupId()) || !triggerRouter.getRouter().getNodeGroupLink().getSourceNodeGroupId().equals(triggerRouter2.getRouter().getNodeGroupLink().getTargetNodeGroupId())) continue;
                        testableTriggerRouters.add(triggerRouter);
                    }
                }
                block2: for (TriggerRouter triggerRouter : testableTriggerRouters) {
                    boolean isDefaultRouter = "default".equals(triggerRouter.getRouter().getRouterType());
                    if (!triggerRouter.getRouter().getNodeGroupLink().getSourceNodeGroupId().equals(nodeGroupId)) continue;
                    if (!isDefaultRouter) {
                        producesCommonBatches = false;
                        break;
                    }
                    if (!triggerRouter.getTrigger().isSyncOnIncomingBatch()) continue;
                    String outgoingTableName = triggerRouter.getTrigger().getFullyQualifiedSourceTableName();
                    for (TriggerRouter triggerRouter2 : testableTriggerRouters) {
                        String incomingTableName = triggerRouter2.getTrigger().getFullyQualifiedSourceTableName();
                        String targetNodeGroupId = triggerRouter2.getRouter().getNodeGroupLink().getTargetNodeGroupId();
                        if (!incomingTableName.equals(outgoingTableName) || !targetNodeGroupId.equals(nodeGroupId)) continue;
                        producesCommonBatches = false;
                        continue block2;
                    }
                }
            }
            if (!producesCommonBatches.equals(this.commonBatchesLastKnownState.get(channelId))) {
                String message = "The '{}' channel is " + (producesCommonBatches != false ? "" : "NOT ") + "in common batch mode";
                if (channelId.equals("config") || channelId.equals("heartbeat") || channelId.equals("filesync") || channelId.equals("monitor") || channelId.equals("filesync_reload") || channelId.equals("reload")) {
                    this.log.debug(message, (Object)channelId);
                } else {
                    this.log.info(message, (Object)channelId);
                }
                this.commonBatchesLastKnownState.put(channelId, producesCommonBatches);
            }
            this.commonBatchesCacheTime = System.currentTimeMillis();
        }
        return producesCommonBatches;
    }

    protected boolean onlyDefaultRoutersAssigned(Channel channel, String nodeGroupId, List<TriggerRouter> triggerRouters) {
        String channelId = channel.getChannelId();
        Boolean onlyDefaultRoutersAssigned = this.defaultRouterOnlyLastKnownState.get(channelId);
        long cacheTime = this.parameterService.getLong("cache.channel.default.router.time.ms");
        if (onlyDefaultRoutersAssigned == null || System.currentTimeMillis() - this.defaultRoutersCacheTime > cacheTime) {
            onlyDefaultRoutersAssigned = !"config".equals(channelId) && !channel.isFileSyncFlag() && !channel.isReloadFlag() && !"heartbeat".equals(channelId) && !"monitor".equals(channelId);
            if (onlyDefaultRoutersAssigned.booleanValue() && triggerRouters != null) {
                for (TriggerRouter triggerRouter : triggerRouters) {
                    if (!triggerRouter.getTrigger().getChannelId().equals(channel.getChannelId()) || !triggerRouter.getRouter().getNodeGroupLink().getSourceNodeGroupId().equals(nodeGroupId) || "default".equals(triggerRouter.getRouter().getRouterType())) continue;
                    onlyDefaultRoutersAssigned = false;
                }
            }
            if (!onlyDefaultRoutersAssigned.equals(this.defaultRouterOnlyLastKnownState.get(channelId))) {
                if (onlyDefaultRoutersAssigned.booleanValue()) {
                    this.log.debug("The '{}' channel for the '{}' node group has only default routers assigned to it.  Change data won't be selected during routing", (Object)channelId, (Object)nodeGroupId);
                }
                this.defaultRouterOnlyLastKnownState.put(channelId, onlyDefaultRoutersAssigned);
            }
            this.defaultRoutersCacheTime = System.currentTimeMillis();
        }
        return onlyDefaultRoutersAssigned;
    }

    @Override
    public void execute(NodeCommunication nodeCommunication, RemoteNodeStatus status) {
        Node sourceNode = this.engine.getNodeService().findIdentity();
        String channelId = nodeCommunication.getQueue();
        List<NodeChannel> nodeChannels = this.engine.getConfigurationService().getNodeChannels(false);
        ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(sourceNode.getNodeId(), channelId, null, ProcessType.ROUTER_JOB));
        processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
        for (NodeChannel nodeChannel : nodeChannels) {
            if (!nodeChannel.getChannelId().equals(channelId)) continue;
            try {
                this.log.debug("Routing on thread for {}", (Object)nodeChannel.getChannelId());
                long dataProcessed = this.routeDataForChannel(processInfo, nodeChannel, sourceNode, nodeCommunication, null);
                status.setDataProcessed(dataProcessed);
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                break;
            }
            catch (RuntimeException e) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected long routeDataForChannel(ProcessInfo processInfo, NodeChannel nodeChannel, Node sourceNode, NodeCommunication nodeCommunication, ChannelRouterContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void completeBatchesAndCommit(ChannelRouterContext context) {
        this.gapDetector.setFullGapAnalysis(context.getSqlTransaction(), true);
        HashSet<IDataRouter> usedRouters = new HashSet<IDataRouter>(context.getUsedDataRouters());
        ArrayList<OutgoingBatch> batches = new ArrayList<OutgoingBatch>(context.getBatchesByNodes().values());
        for (Map<String, OutgoingBatch> groupBatches : context.getBatchesByGroups().values()) {
            batches.addAll(groupBatches.values());
        }
        long ts = System.currentTimeMillis();
        this.completeBatches(context, batches, usedRouters);
        context.commit();
        context.incrementStat(System.currentTimeMillis() - ts, "batches.update.time.ms");
        for (IDataRouter dataRouter : usedRouters) {
            dataRouter.contextCommitted(context);
        }
        context.setNeedsCommitted(false);
    }

    protected void completeBatches(ChannelRouterContext context, List<OutgoingBatch> batches, Set<IDataRouter> usedRouters) {
        if (this.engine.getParameterService().is("routing.log.stats.on.batch.error")) {
            this.engine.getStatisticManager().addRouterStats(context.getStartDataId(), context.getEndDataId(), context.getDataReadCount(), context.getPeekAheadFillCount(), context.getDataGaps(), null, batches);
        }
        for (OutgoingBatch batch : batches) {
            for (IDataRouter dataRouter : usedRouters) {
                dataRouter.completeBatch(context, batch);
            }
            if ("-1".equals(batch.getNodeId())) {
                batch.setStatus(AbstractBatch.Status.OK);
            } else {
                batch.setStatus(AbstractBatch.Status.NE);
            }
            batch.setRouterMillis((System.currentTimeMillis() - batch.getCreateTime().getTime()) / (long)batches.size());
        }
        this.engine.getOutgoingBatchService().updateOutgoingBatches(context.getSqlTransaction(), batches, context.getMaxBatchesJdbcFlushSize());
    }

    protected Set<Node> findAvailableNodes(TriggerRouter triggerRouter, ChannelRouterContext context) {
        long ts = System.currentTimeMillis();
        Set<Node> nodes = context.getAvailableNodes().get(triggerRouter);
        if (nodes == null) {
            nodes = new HashSet<Node>();
            Router router = triggerRouter.getRouter();
            NodeGroupLink link = this.engine.getConfigurationService().getNodeGroupLinkFor(router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId(), false);
            if (link != null) {
                nodes.addAll(this.engine.getNodeService().findEnabledNodesFromNodeGroup(router.getNodeGroupLink().getTargetNodeGroupId()));
            } else if (!router.getRouterId().startsWith(this.parameterService.getTablePrefix().toLowerCase())) {
                this.log.error("The router {} has no node group link configured from {} to {}", new Object[]{router.getRouterId(), router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId()});
            }
            context.getAvailableNodes().put(triggerRouter, nodes);
        }
        nodes = this.engine.getGroupletService().getTargetEnabled(triggerRouter, nodes);
        context.incrementStat(System.currentTimeMillis() - ts, "lookup.avail.nodes.ms");
        return nodes;
    }

    protected IDataToRouteReader startReading(ChannelRouterContext context) {
        DataGapRouteReader reader = new DataGapRouteReader(context, this.engine);
        if (this.parameterService.is("jobs.synchronized.enable")) {
            reader.run();
        } else {
            if (this.readThread == null) {
                this.readThread = Executors.newCachedThreadPool(new ThreadFactory(){
                    final AtomicInteger threadNumber = new AtomicInteger(1);
                    final String namePrefix;
                    {
                        this.namePrefix = RouterService.this.parameterService.getEngineName().toLowerCase() + "-router-reader-";
                    }

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(r);
                        t.setName(this.namePrefix + this.threadNumber.getAndIncrement());
                        if (t.isDaemon()) {
                            t.setDaemon(false);
                        }
                        if (t.getPriority() != 5) {
                            t.setPriority(5);
                        }
                        return t;
                    }
                });
            }
            this.readThread.execute(reader);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long selectDataAndRoute(ProcessInfo processInfo, NodeCommunication nodeCommunication, ChannelRouterContext context) throws java.lang.InterruptedException {
        IDataToRouteReader reader = this.startReading(context);
        Data data = null;
        Data nextData = null;
        long totalDataCount = 0L;
        long totalDataEventCount = 0L;
        long statsDataCount = 0L;
        long statsDataEventCount = 0L;
        int maxNumberOfEventsBeforeFlush = this.parameterService.getInt("routing.flush.jdbc.batch.size");
        try {
            long ts;
            long startTime = ts = System.currentTimeMillis();
            nextData = reader.take();
            do {
                if (nextData != null) {
                    data = nextData;
                    nextData = reader.take();
                    if (data == null) continue;
                    processInfo.setCurrentTableName(data.getTableName());
                    processInfo.incrementCurrentDataCount();
                    if (data.isPreRouted()) {
                        context.addData(data.getDataId());
                    } else {
                        boolean atTransactionBoundary = false;
                        if (nextData != null) {
                            String nextTxId = nextData.getTransactionId();
                            atTransactionBoundary = nextTxId == null || !nextTxId.equals(data.getTransactionId());
                        }
                        context.setEncountedTransactionBoundary(atTransactionBoundary);
                        ++statsDataCount;
                        ++totalDataCount;
                        int dataEventsInserted = this.routeData(processInfo, data, context);
                        statsDataEventCount += (long)dataEventsInserted;
                        totalDataEventCount += (long)dataEventsInserted;
                    }
                    long insertTs = System.currentTimeMillis();
                    try {
                        if (maxNumberOfEventsBeforeFlush <= context.getDataEventList().size() || context.isNeedsCommitted()) {
                            this.engine.getDataService().insertDataEvents(context.getSqlTransaction(), context.getDataEventList());
                            context.clearDataEventsList();
                            context.incrementStat(System.currentTimeMillis() - insertTs, "data.events.insert.time.ms");
                        }
                        if (context.isNeedsCommitted()) {
                            this.completeBatchesAndCommit(context);
                        }
                    }
                    finally {
                        if (statsDataCount > 1024L) {
                            this.engine.getStatisticManager().incrementDataRouted(context.getChannel().getChannelId(), statsDataCount);
                            statsDataCount = 0L;
                            this.engine.getStatisticManager().incrementDataEventInserted(context.getChannel().getChannelId(), statsDataEventCount);
                            statsDataEventCount = 0L;
                        }
                    }
                    long routeTs = System.currentTimeMillis() - ts;
                    if (routeTs > 60000L) {
                        if (!this.useChannelThreading) {
                            this.engine.getClusterService().refreshLock("Routing");
                        }
                        this.log.info("Routing channel '{}' for {} seconds, routedCount={}, dataEventCount={}, startDataId={}, endDataId={}, readCount={}, peekAheadFillCount={}, dataGaps={}", new Object[]{context.getChannel().getChannelId(), (System.currentTimeMillis() - startTime) / 1000L, totalDataCount, totalDataEventCount, context.getStartDataId(), context.getEndDataId(), context.getDataReadCount(), context.getPeekAheadFillCount(), context.getDataGaps().size()});
                        ts = System.currentTimeMillis();
                    }
                    context.setLastDataProcessed(data);
                    continue;
                }
                data = null;
            } while (data != null);
            long routeTime = System.currentTimeMillis() - startTime;
            if (routeTime > 60000L) {
                this.log.info("Done routing for channel '{}' which took {} seconds", new Object[]{context.getChannel().getChannelId(), (System.currentTimeMillis() - startTime) / 1000L});
                if (context.getTimesByRouter().size() < 10) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, Long> entry : context.getTimesByRouter().entrySet()) {
                        if (sb.length() != 0) {
                            sb.append(", ");
                        }
                        sb.append(entry.getKey()).append("=").append(entry.getValue());
                    }
                    this.log.info("Router times for channel '{}': {}", (Object)context.getChannel().getChannelId(), (Object)sb);
                }
                ts = System.currentTimeMillis();
            }
        }
        finally {
            reader.setReading(false);
            if (statsDataCount > 0L) {
                this.engine.getStatisticManager().incrementDataRouted(context.getChannel().getChannelId(), statsDataCount);
            }
            if (statsDataEventCount > 0L) {
                this.engine.getStatisticManager().incrementDataEventInserted(context.getChannel().getChannelId(), statsDataEventCount);
            }
        }
        context.incrementStat(totalDataCount, "data.routed.count");
        return totalDataEventCount;
    }

    protected int routeData(ProcessInfo processInfo, Data data, ChannelRouterContext context) {
        int numberOfDataEventsInserted = 0;
        List<TriggerRouter> triggerRouters = this.getTriggerRoutersForData(data, context);
        Table table = null;
        if (!this.isUsingTargetExternalId && data.getTriggerHistory() != null) {
            table = this.platform.getTableFromCache(data.getTriggerHistory().getSourceCatalogName(), data.getTriggerHistory().getSourceSchemaName(), data.getTriggerHistory().getSourceTableName(), false);
        }
        if (table == null) {
            table = this.buildTableFromTriggerHistory(data.getTriggerHistory());
        }
        if (triggerRouters != null && triggerRouters.size() > 0) {
            boolean isUnrouted = false;
            boolean alreadyInsertedUnrouted = false;
            for (TriggerRouter triggerRouter : triggerRouters) {
                DataMetaData dataMetaData = new DataMetaData(data, table, triggerRouter.getRouter(), context.getChannel());
                Collection<String> nodeIds = null;
                if (!context.getChannel().isIgnoreEnabled() && triggerRouter.isRouted(data.getDataEventType())) {
                    String targetNodeIds = data.getNodeList();
                    if (StringUtils.isNotBlank((CharSequence)targetNodeIds)) {
                        List<String> targetNodeIdsList = Arrays.asList(targetNodeIds.split(","));
                        nodeIds = CollectionUtils.intersection(targetNodeIdsList, this.toNodeIds(this.findAvailableNodes(triggerRouter, context)));
                        if (nodeIds.size() == 0 && this.log.isDebugEnabled()) {
                            this.log.debug("None of the target nodes specified in the data.node_list field ({}) were qualified nodes. Data id {} for table '{}' will not be routed using the {} router", new Object[]{targetNodeIds, data.getDataId(), data.getTableName(), triggerRouter.getRouter().getRouterId()});
                        }
                    } else if (data.getTriggerHistory().getLastTriggerBuildReason() == TriggerReBuildReason.TRIGGER_HIST_MISSING && !this.doesColumnCountMatchValues(dataMetaData, data)) {
                        Integer triggerHistId = data.getTriggerHistory().getTriggerHistoryId();
                        CounterStat counterStat = this.missingColumns.get(triggerHistId);
                        if (counterStat == null) {
                            counterStat = new CounterStat(data);
                            this.missingColumns.put(triggerHistId, counterStat);
                        }
                        counterStat.incrementCount();
                    } else {
                        try {
                            IDataRouter dataRouter = this.getDataRouter(triggerRouter.getRouter(), dataMetaData);
                            long ts = System.currentTimeMillis();
                            nodeIds = dataRouter.routeToNodes(context, dataMetaData, this.findAvailableNodes(triggerRouter, context), false, false, triggerRouter);
                            ts = System.currentTimeMillis() - ts;
                            context.incrementStat(ts, "data.router.time.ms");
                            context.addUsedDataRouter(dataRouter);
                            context.addTimesByRouter(triggerRouter.getRouterId(), ts);
                        }
                        catch (DelayRoutingException ex) {
                            throw ex;
                        }
                        catch (RuntimeException ex) {
                            if (ex instanceof ProtocolException && !context.getChannel().getChannel().isContainsBigLob() && !context.isOverrideContainsBigLob()) {
                                this.log.warn(ex.getMessage() + "  If this happens often, it might be better to isolate the table with sym_channel.contains_big_lobs enabled.");
                                throw ex;
                            }
                            StringBuilder failureMessage = new StringBuilder("Failed to route data: ");
                            failureMessage.append(data.getDataId()).append(" for table: ").append(data.getTableName()).append(".\n");
                            data.writeCsvDataDetails(failureMessage);
                            throw new SymmetricException(failureMessage.toString(), ex);
                        }
                    }
                    if (nodeIds != null) {
                        if (!triggerRouter.isPingBackEnabled() && data.getSourceNodeId() != null && !data.getSourceNodeId().equals("")) {
                            nodeIds.remove(data.getSourceNodeId());
                            if (context.isNonCommonForIncoming()) {
                                context.setForceNonCommon(true);
                            }
                        }
                        nodeIds.remove(this.engine.getNodeService().findIdentityNodeId());
                    }
                }
                boolean bl = isUnrouted = nodeIds == null || nodeIds.size() == 0;
                if (!isUnrouted || !alreadyInsertedUnrouted) {
                    numberOfDataEventsInserted += this.insertDataEvents(processInfo, context, dataMetaData, nodeIds);
                    if (isUnrouted) {
                        alreadyInsertedUnrouted = true;
                    }
                }
                if (!context.isForceNonCommon()) continue;
                context.setForceNonCommon(false);
            }
        } else {
            Integer triggerHistId = data.getTriggerHistory() != null ? data.getTriggerHistory().getTriggerHistoryId() : -1;
            CounterStat counterStat = this.missingTriggerRouter.get(triggerHistId);
            if (counterStat == null) {
                counterStat = new CounterStat(data);
                this.missingTriggerRouter.put(triggerHistId, counterStat);
            }
            counterStat.incrementCount();
            numberOfDataEventsInserted += this.insertDataEvents(processInfo, context, new DataMetaData(data, table, null, context.getChannel()), new HashSet<String>(0));
        }
        context.incrementStat(numberOfDataEventsInserted, "data.events.insert.count");
        return numberOfDataEventsInserted;
    }

    protected int insertDataEvents(ProcessInfo processInfo, ChannelRouterContext context, DataMetaData dataMetaData, Collection<String> nodeIds) {
        boolean useCommonMode;
        long ts = System.currentTimeMillis();
        String tableName = dataMetaData.getTable().getNameLowerCase();
        DataEventType eventType = dataMetaData.getData().getDataEventType();
        Map<String, OutgoingBatch> batches = null;
        long loadId = -1L;
        boolean dataEventAdded = false;
        boolean detectGroupCollision = false;
        int numberOfDataEventsInserted = 0;
        ArrayList<OutgoingBatch> batchesToInsert = new ArrayList<OutgoingBatch>();
        ArrayList<OutgoingBatch> batchesToRoute = new ArrayList<OutgoingBatch>();
        if (nodeIds == null || nodeIds.size() == 0) {
            nodeIds = new HashSet<String>(1);
            nodeIds.add("-1");
        }
        boolean bl = useCommonMode = (context.isProduceGroupBatches() && !context.isForceNonCommon() || context.isProduceCommonBatches()) && nodeIds.size() > 1;
        if (context.isProduceGroupBatches() && useCommonMode) {
            int groupKey;
            Map<Integer, Map<String, OutgoingBatch>> batchesByGroups = context.getBatchesByGroups();
            batches = batchesByGroups.get(groupKey = nodeIds.hashCode());
            if (batches == null) {
                batches = new HashMap<String, OutgoingBatch>();
                batchesByGroups.put(groupKey, batches);
            } else {
                detectGroupCollision = true;
            }
        } else {
            batches = context.getBatchesByNodes();
        }
        if (eventType == DataEventType.RELOAD) {
            loadId = context.getLastLoadId();
            if (loadId < 0L) {
                loadId = this.engine.getSequenceService().nextVal("outgoing_batch_load_id");
                context.setLastLoadId(loadId);
            }
            if (context.getChannel().isReloadFlag()) {
                context.setNeedsCommitted(true);
            }
        } else if (eventType == DataEventType.CREATE) {
            if (dataMetaData.getData().getPkData() != null) {
                try {
                    loadId = Long.parseLong(dataMetaData.getData().getPkData());
                }
                catch (NumberFormatException batchesByGroups) {
                    // empty catch block
                }
            }
            context.setNeedsCommitted(true);
        } else {
            context.setLastLoadId(-1L);
        }
        for (String nodeId : nodeIds) {
            if (nodeId == null) continue;
            OutgoingBatch batch = batches.get(nodeId);
            if (batch == null) {
                batch = new OutgoingBatch(nodeId, dataMetaData.getNodeChannel().getChannelId(), AbstractBatch.Status.RT);
                batch.setCommonFlag(useCommonMode);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("About to insert a new batch for node {} on the '{}' channel.  Batches in progress are: {}.", new Object[]{nodeId, batch.getChannelId(), batches.values()});
                }
                if (detectGroupCollision) {
                    throw new CommonBatchCollisionException("Collision detected for group " + nodeIds.hashCode() + " when routing nodes " + nodeIds);
                }
                processInfo.incrementBatchCount();
                batchesToInsert.add(batch);
                batches.put(nodeId, batch);
            }
            batch.incrementRowCount(eventType);
            batch.incrementDataRowCount();
            if (context.getChannel().getChannel().isFileSyncFlag() && context.getChannel().getChannel().isUseRowDataToRoute()) {
                String[] data = dataMetaData.getData().getParsedData("rowData");
                if (data == null) {
                    data = dataMetaData.getData().getParsedData("pkData");
                }
                if (data != null && data.length >= 4) {
                    batch.incrementFileCount(data[3]);
                }
            } else {
                batch.incrementTableCount(tableName);
            }
            if (loadId != -1L) {
                batch.setLoadId(loadId);
            }
            if (!useCommonMode || !dataEventAdded) {
                batchesToRoute.add(batch);
                ++numberOfDataEventsInserted;
                dataEventAdded = true;
            }
            if (!context.isBatchComplete(batch, dataMetaData)) continue;
            context.setNeedsCommitted(true);
        }
        if (batchesToInsert.size() > 0) {
            ISqlTransaction transaction = null;
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                transaction.setInBatchMode(true);
                this.engine.getOutgoingBatchService().insertOutgoingBatches(transaction, batchesToInsert, context.getMaxBatchesJdbcFlushSize(), useCommonMode);
                transaction.commit();
                context.incrementStat(batchesToInsert.size(), "batches.insert.count");
                if (useCommonMode) {
                    context.incrementStat(batchesToInsert.size(), "batches.common.count");
                } else {
                    context.incrementStat(batchesToInsert.size(), "batches.noncommon.count");
                }
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        }
        for (OutgoingBatch batch : batchesToRoute) {
            context.addDataEvent(dataMetaData.getData().getDataId(), batch.getBatchId());
        }
        context.incrementStat(System.currentTimeMillis() - ts, "batches.insert.time.ms");
        return numberOfDataEventsInserted;
    }

    protected IDataRouter getDataRouter(Router router, DataMetaData dataMetaData) {
        IDataRouter dataRouter = null;
        Map<String, IDataRouter> routers = this.getRouters();
        if (!StringUtils.isBlank((CharSequence)router.getRouterType())) {
            dataRouter = routers.get(router.getRouterType());
            if (dataRouter == null) {
                CounterStat counterStat = this.invalidRouterType.get(router.getRouterId());
                if (counterStat == null) {
                    counterStat = new CounterStat(router);
                    this.invalidRouterType.put(router.getRouterId(), counterStat);
                }
                counterStat.incrementCount();
            } else if (dataRouter.isDmlOnly() && !dataMetaData.getData().getDataEventType().isDml()) {
                dataRouter = null;
            }
        }
        if (dataRouter == null) {
            return this.getRouters().get("default");
        }
        return dataRouter;
    }

    protected List<TriggerRouter> getTriggerRoutersForData(Data data, ChannelRouterContext context) {
        long ts = System.currentTimeMillis();
        List<TriggerRouter> triggerRouters = null;
        if (data != null) {
            if (data.getTriggerHistory() != null) {
                triggerRouters = this.engine.getTriggerRouterService().getTriggerRoutersForCurrentNode(false).get(data.getTriggerHistory().getTriggerId());
                if (triggerRouters == null && data.getTriggerHistory().getTriggerId() != null && data.getTriggerHistory().getTriggerId().equals("SYM_VIRTUAL_FILE_PARSE_TRIGGER")) {
                    TriggerRouter dynamicTriggerRouter = new TriggerRouter();
                    String routerId = AbstractFileParsingRouter.getRouterIdFromExternalData(data.getExternalData());
                    dynamicTriggerRouter.setRouter(this.engine.getTriggerRouterService().getRouterById(routerId));
                    dynamicTriggerRouter.setTrigger(new Trigger());
                    triggerRouters = new ArrayList<TriggerRouter>();
                    triggerRouters.add(dynamicTriggerRouter);
                    data.setDataEventType(DataEventType.INSERT);
                }
                if ((triggerRouters == null || triggerRouters.size() == 0) && System.currentTimeMillis() - this.triggerRouterCacheTime > 10000L) {
                    triggerRouters = this.engine.getTriggerRouterService().getTriggerRoutersForCurrentNode(true).get(data.getTriggerHistory().getTriggerId());
                    this.triggerRouterCacheTime = System.currentTimeMillis();
                }
            } else {
                this.log.warn("Could not find a trigger hist record for recorded data {}.  Was the trigger hist record deleted manually?", (Object)data.getDataId());
            }
        }
        context.incrementStat(System.currentTimeMillis() - ts, "lookup.trigger.routers.ms");
        return triggerRouters;
    }

    @Override
    public long getUnroutedDataCount() {
        long maxDataIdAlreadyRouted = 0L;
        if (this.parameterService.is("cluster.lock.enabled")) {
            maxDataIdAlreadyRouted = this.sqlTemplateDirty.queryForLong(this.getSql("selectLastDataIdRoutedUsingDataGapSql"), new Object[0]);
        } else {
            DataGap lastGap = this.gapDetector.getLastDataGap();
            if (lastGap != null) {
                maxDataIdAlreadyRouted = lastGap.getStartId();
            }
        }
        long leftToRoute = this.engine.getDataService().findMaxDataId() - maxDataIdAlreadyRouted + 1L;
        if (leftToRoute > 0L) {
            return leftToRoute;
        }
        return 0L;
    }

    @Override
    public List<String> getAvailableBatchAlgorithms() {
        return new ArrayList<String>(this.extensionService.getExtensionPointMap(IBatchAlgorithm.class).keySet());
    }

    @Override
    public Map<String, IDataRouter> getRouters() {
        return this.extensionService.getExtensionPointMap(IDataRouter.class);
    }

    @Override
    public List<DataGap> getDataGaps() {
        return this.gapDetector.getDataGaps();
    }

    protected Table buildTableFromTriggerHistory(TriggerHistory triggerHistory) {
        String[] columnNames;
        Table table = new Table(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName());
        for (String columnName : columnNames = triggerHistory.getColumnNames().split(",")) {
            table.addColumn(new Column(columnName));
        }
        return table;
    }

    protected boolean doesColumnCountMatchValues(DataMetaData dataMetaData, Data data) {
        if (data.getCreateTime() == null || data.getTriggerHistory().getCreateTime() == null || data.getTriggerHistory().getCreateTime().compareTo(data.getCreateTime()) > 0) {
            String[] rowData = null;
            rowData = dataMetaData.getData().getDataEventType() == DataEventType.DELETE ? dataMetaData.getData().toParsedOldData() : dataMetaData.getData().toParsedRowData();
            return rowData == null || dataMetaData.getTable().getColumnCount() == rowData.length;
        }
        return true;
    }
}

