/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.config.INodeIdCreator;
import org.jumpmind.symmetric.ext.INodeRegistrationAuthenticator;
import org.jumpmind.symmetric.ext.INodeRegistrationListener;
import org.jumpmind.symmetric.ext.IRegistrationRedirect;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.RegistrationRequest;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.RegistrationFailedException;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationRedirectException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.RegistrationServiceSqlMap;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.ServiceUnavailableException;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.RandomTimeSlot;

public class RegistrationService
extends AbstractService
implements IRegistrationService {
    private INodeService nodeService;
    private IDataExtractorService dataExtractorService;
    private IDataService dataService;
    private IDataLoaderService dataLoaderService;
    private ITransportManager transportManager;
    private IOutgoingBatchService outgoingBatchService;
    private RandomTimeSlot randomTimeSlot;
    private IStatisticManager statisticManager;
    private IConfigurationService configurationService;
    private IExtensionService extensionService;
    private ISymmetricEngine engine;
    private boolean allowClientRegistration = true;

    public RegistrationService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.nodeService = engine.getNodeService();
        this.dataExtractorService = engine.getDataExtractorService();
        this.dataService = engine.getDataService();
        this.dataLoaderService = engine.getDataLoaderService();
        this.transportManager = engine.getTransportManager();
        this.statisticManager = engine.getStatisticManager();
        this.configurationService = engine.getConfigurationService();
        this.outgoingBatchService = engine.getOutgoingBatchService();
        this.extensionService = engine.getExtensionService();
        this.randomTimeSlot = new RandomTimeSlot(this.parameterService.getExternalId(), engine.getParameterService().getInt("registration.max.time.between.retries", 30));
        this.setSqlMap(new RegistrationServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public Node registerPullOnlyNode(String externalId, String nodeGroupId, String databaseType, String databaseVersion, String databaseName) throws IOException {
        Node node = new Node();
        node.setExternalId(externalId);
        node.setNodeGroupId(nodeGroupId);
        node.setDatabaseType(databaseType);
        node.setDatabaseVersion(databaseVersion);
        node.setDatabaseName(databaseName);
        node.setDeploymentType("rest");
        node = this.processRegistration(node, null, null, null, null, true);
        if (node.isSyncEnabled()) {
            this.markNodeAsRegistered(node.getNodeId());
        }
        return node;
    }

    @Override
    public boolean registerNode(Node preRegisteredNode, OutputStream out, boolean isRequestedRegistration) throws IOException {
        return this.registerNode(preRegisteredNode, null, null, out, null, null, isRequestedRegistration);
    }

    protected void extractConfiguration(OutputStream out, Node registeredNode) {
        this.dataExtractorService.extractConfigurationStandalone(registeredNode, TransportUtils.toWriter(out), TableConstants.getConfigTablesExcludedFromRegistration());
    }

    protected Node processRegistration(Node nodePriorToRegistration, String remoteHost, String remoteAddress, String userId, String password, boolean isRequestedRegistration) throws IOException {
        NodeSecurity mySecurity;
        Node processedNode = new Node();
        processedNode.setSyncEnabled(false);
        if (!this.allowClientRegistration) {
            this.log.warn("Cannot register a client node until this node has synced triggers");
            return processedNode;
        }
        Node identity = this.nodeService.findIdentity();
        NodeSecurity nodeSecurity = mySecurity = identity == null ? null : this.nodeService.findNodeSecurity(identity.getNodeId());
        if (identity == null || mySecurity != null && mySecurity.isRegistrationEnabled()) {
            RegistrationRequest req = new RegistrationRequest(nodePriorToRegistration, RegistrationRequest.RegistrationStatus.ER, remoteHost, remoteAddress);
            req.setErrorMessage("Cannot register a client node until this node is registered");
            this.saveRegistrationRequest(req);
            this.log.warn(req.getErrorMessage());
            return processedNode;
        }
        try {
            boolean requiresInitialLoad;
            if (!this.nodeService.isRegistrationServer() && (requiresInitialLoad = this.parameterService.is("registration.require.initial.load", true)) && (mySecurity == null || mySecurity.getInitialLoadEndTime() == null)) {
                RegistrationRequest req = new RegistrationRequest(nodePriorToRegistration, RegistrationRequest.RegistrationStatus.ER, remoteHost, remoteAddress);
                req.setErrorMessage("Cannot register a client node until this node has an initial load (ie. node_security.initial_load_end_time is a non null value)");
                this.saveRegistrationRequest(req);
                this.log.warn(req.getErrorMessage());
                return processedNode;
            }
            String redirectUrl = null;
            IRegistrationRedirect registrationRedirect = this.extensionService.getExtensionPoint(IRegistrationRedirect.class);
            redirectUrl = registrationRedirect != null ? registrationRedirect.getRedirectionUrlFor(nodePriorToRegistration.getExternalId(), nodePriorToRegistration.getNodeGroupId()) : this.getRedirectionUrlFor(nodePriorToRegistration.getExternalId());
            if (redirectUrl != null) {
                this.log.info("Redirecting {} to {} for registration.", (Object)nodePriorToRegistration.getExternalId(), (Object)redirectUrl);
                this.saveRegistrationRequest(new RegistrationRequest(nodePriorToRegistration, RegistrationRequest.RegistrationStatus.RR, remoteHost, remoteAddress));
                throw new RegistrationRedirectException(redirectUrl);
            }
            NodeGroupLink link = this.configurationService.getNodeGroupLinkFor(identity.getNodeGroupId(), nodePriorToRegistration.getNodeGroupId(), false);
            if (link == null && this.parameterService.is("registration.require.node.group.link", true) && !this.parameterService.is("registration.auto.create.group.link")) {
                RegistrationRequest req = new RegistrationRequest(nodePriorToRegistration, RegistrationRequest.RegistrationStatus.ER, remoteHost, remoteAddress);
                req.setErrorMessage(String.format("Cannot register a client node unless a node group link exists so the registering node can receive configuration updates.  Please add a group link where the source group id is %s and the target group id is %s", identity.getNodeGroupId(), nodePriorToRegistration.getNodeGroupId()));
                this.saveRegistrationRequest(req);
                this.log.warn(req.getErrorMessage());
                return processedNode;
            }
            String nodeId = StringUtils.isBlank((CharSequence)nodePriorToRegistration.getNodeId()) ? this.extensionService.getExtensionPoint(INodeIdCreator.class).selectNodeId(nodePriorToRegistration, remoteHost, remoteAddress) : nodePriorToRegistration.getNodeId();
            Node foundNode = this.nodeService.findNode(nodeId);
            NodeSecurity security = this.nodeService.findNodeSecurity(nodeId);
            boolean isRegistrationAuthenticated = false;
            if (userId != null || password != null) {
                List<INodeRegistrationAuthenticator> listeners = this.extensionService.getExtensionPointList(INodeRegistrationAuthenticator.class);
                for (INodeRegistrationAuthenticator listener : listeners) {
                    isRegistrationAuthenticated |= listener.authenticate(userId, password);
                }
            }
            if (!(foundNode != null && security != null && security.isRegistrationEnabled() && security.isRegistrationAllowedNow() || !this.parameterService.is("auto.registration") && !isRegistrationAuthenticated)) {
                this.openRegistration(nodePriorToRegistration, remoteHost, remoteAddress, null, null);
                nodeId = StringUtils.isBlank((CharSequence)nodePriorToRegistration.getNodeId()) ? this.extensionService.getExtensionPoint(INodeIdCreator.class).selectNodeId(nodePriorToRegistration, remoteHost, remoteAddress) : nodePriorToRegistration.getNodeId();
                security = this.nodeService.findNodeSecurity(nodeId);
                foundNode = this.nodeService.findNode(nodeId);
            } else if (foundNode == null || security == null || !security.isRegistrationEnabled() || !security.isRegistrationAllowedNow()) {
                this.saveRegistrationRequest(new RegistrationRequest(nodePriorToRegistration, RegistrationRequest.RegistrationStatus.RQ, remoteHost, remoteAddress));
                return processedNode;
            }
            if (link == null && this.parameterService.is("registration.auto.create.group.link")) {
                link = new NodeGroupLink(identity.getNodeGroupId(), nodePriorToRegistration.getNodeGroupId());
                this.configurationService.saveNodeGroupLink(link);
                ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
                Router router = new Router();
                router.setNodeGroupLink(link);
                router.setRouterId(router.createDefaultName());
                triggerRouterService.saveRouter(router);
                link = this.configurationService.getNodeGroupLinkFor(nodePriorToRegistration.getNodeGroupId(), identity.getNodeGroupId(), false);
                if (link == null) {
                    link = new NodeGroupLink(nodePriorToRegistration.getNodeGroupId(), identity.getNodeGroupId(), NodeGroupLinkAction.P);
                    this.configurationService.saveNodeGroupLink(link);
                    router = new Router();
                    router.setNodeGroupLink(link);
                    router.setRouterId(router.createDefaultName());
                    triggerRouterService.saveRouter(router);
                }
            }
            foundNode.setSyncEnabled(true);
            foundNode.setSyncUrl(nodePriorToRegistration.getSyncUrl());
            foundNode.setDatabaseType(nodePriorToRegistration.getDatabaseType());
            foundNode.setDatabaseVersion(nodePriorToRegistration.getDatabaseVersion());
            foundNode.setSymmetricVersion(nodePriorToRegistration.getSymmetricVersion());
            foundNode.setDeploymentType(nodePriorToRegistration.getDeploymentType());
            foundNode.setDatabaseName(nodePriorToRegistration.getDatabaseName());
            foundNode.setConfigVersion(Version.version());
            this.nodeService.save(foundNode);
            this.log.info("Registered node " + foundNode + " in my database, but pending acknowledgement");
            if (security != null && security.getInitialLoadTime() == null || isRequestedRegistration) {
                if (this.parameterService.is("auto.reload")) {
                    this.engine.getInitialLoadService().cancelAllLoadsForTarget(nodeId);
                    this.log.info("Auto reload for target node {}", (Object)nodeId);
                    this.nodeService.setInitialLoadEnabled(nodeId, true, false, -1L, "registration");
                }
                if (this.parameterService.is("auto.reload.reverse")) {
                    this.log.info("Auto reverse reload from source node {}", (Object)nodeId);
                    this.nodeService.setReverseInitialLoadEnabled(nodeId, true, false, -1L, "registration");
                }
            }
            this.saveRegistrationRequest(new RegistrationRequest(foundNode, RegistrationRequest.RegistrationStatus.OK, remoteHost, remoteAddress));
            this.markNodeAsRegistrationPending(nodeId);
            this.statisticManager.incrementNodesRegistered(1L);
            return foundNode;
        }
        catch (RegistrationNotOpenException ex) {
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                this.log.warn("Registration not allowed for {} because {}", (Object)nodePriorToRegistration, (Object)ex.getMessage());
            }
            return processedNode;
        }
    }

    @Override
    public boolean registerNode(Node nodePriorToRegistration, String remoteHost, String remoteAddress, OutputStream out, String userId, String password, boolean isRequestedRegistration) throws IOException {
        Node node;
        String nodeId;
        NodeSecurity nodeSecurity;
        NodeGroupLink link;
        if (this.parameterService.is("registration.push.config.allowed") && (link = this.configurationService.getNodeGroupLinkFor(this.parameterService.getNodeGroupId(), nodePriorToRegistration.getNodeGroupId(), false)) != null && link.getDataEventAction() == NodeGroupLinkAction.P && (nodeSecurity = this.nodeService.findNodeSecurity(nodeId = StringUtils.isBlank((CharSequence)nodePriorToRegistration.getNodeId()) ? this.extensionService.getExtensionPoint(INodeIdCreator.class).selectNodeId(nodePriorToRegistration, remoteHost, remoteAddress) : nodePriorToRegistration.getNodeId())) != null && nodeSecurity.isRegistrationEnabled() && (node = this.nodeService.findNode(nodeId)) != null && node.getSyncUrl() != null && node.getSyncUrl().length() > 0) {
            this.log.debug("Pull of registration from {} is being ignored because group link is push", (Object)nodePriorToRegistration);
            return true;
        }
        Node processedNode = this.processRegistration(nodePriorToRegistration, remoteHost, remoteAddress, userId, password, isRequestedRegistration);
        if (processedNode.isSyncEnabled()) {
            this.log.info("Preparing to send registration to node {} by clearing its outgoing config batches", (Object)processedNode);
            this.outgoingBatchService.markAllConfigAsSentForNode(processedNode.getNodeId());
            this.log.info("Sending registration batch to node {}", (Object)processedNode);
            this.extractConfiguration(out, processedNode);
        }
        return processedNode.isSyncEnabled();
    }

    @Override
    public List<RegistrationRequest> getRegistrationRequests(boolean includeNodesWithOpenRegistrations) {
        List requests = this.sqlTemplate.query(this.getSql("selectRegistrationRequestSql"), (ISqlRowMapper)new RegistrationRequestMapper(), new Object[0]);
        if (!includeNodesWithOpenRegistrations) {
            Collection<Node> nodes = this.nodeService.findNodesWithOpenRegistration();
            Iterator i = requests.iterator();
            while (i.hasNext()) {
                RegistrationRequest registrationRequest = (RegistrationRequest)i.next();
                for (Node node : nodes) {
                    if (!node.getNodeGroupId().equals(registrationRequest.getNodeGroupId()) || !node.getExternalId().equals(registrationRequest.getExternalId())) continue;
                    i.remove();
                }
            }
        }
        return requests;
    }

    @Override
    public boolean deleteRegistrationRequest(RegistrationRequest request) {
        String externalId = request.getExternalId() == null ? "" : request.getExternalId();
        String nodeGroupId = request.getNodeGroupId() == null ? "" : request.getNodeGroupId();
        return 0 < this.sqlTemplate.update(this.getSql("deleteRegistrationRequestSql"), new Object[]{nodeGroupId, externalId, request.getHostName(), request.getStatus().name()});
    }

    @Override
    public void saveRegistrationRequest(RegistrationRequest request) {
        boolean foundOne = false;
        List<RegistrationRequest> requests = this.getRegistrationRequests(true);
        for (RegistrationRequest registrationRequest : requests) {
            if (!registrationRequest.getNodeGroupId().equals(request.getNodeGroupId()) || !registrationRequest.getExternalId().equals(request.getExternalId())) continue;
            request.setAttemptCount(registrationRequest.getAttemptCount() + 1L);
            foundOne = true;
            break;
        }
        String externalId = request.getExternalId() == null ? "" : request.getExternalId();
        String nodeGroupId = request.getNodeGroupId() == null ? "" : request.getNodeGroupId();
        int count = 0;
        if (foundOne) {
            count = this.sqlTemplate.update(this.getSql("updateRegistrationRequestSql"), new Object[]{request.getAttemptCount(), request.getLastUpdateBy(), request.getLastUpdateTime(), request.getRegisteredNodeId(), request.getStatus().name(), request.getErrorMessage(), nodeGroupId, externalId, request.getHostName()}, new int[]{2, 12, 93, 12, 12, 12, 12, 12, 12});
        }
        if (count == 0) {
            this.sqlTemplate.update(this.getSql("insertRegistrationRequestSql"), new Object[]{request.getLastUpdateBy(), request.getLastUpdateTime(), request.getRegisteredNodeId(), request.getStatus().name(), nodeGroupId, externalId, request.getIpAddress(), request.getHostName(), request.getErrorMessage(), new Date()}, new int[]{12, 93, 12, 12, 12, 12, 12, 12, 12, 93});
        }
    }

    @Override
    public String getRedirectionUrlFor(String externalId) {
        List list = this.sqlTemplate.query(this.getSql("getRegistrationRedirectUrlSql"), (ISqlRowMapper)new StringMapper(), new Object[]{externalId}, new int[]{12});
        if (list.size() > 0) {
            return this.transportManager.resolveURL((String)list.get(0), this.parameterService.getRegistrationUrl());
        }
        return null;
    }

    @Override
    public void saveRegistrationRedirect(String externalIdToRedirect, String nodeIdToRedirectTo) {
        int count = this.sqlTemplate.update(this.getSql("updateRegistrationRedirectUrlSql"), new Object[]{nodeIdToRedirectTo, externalIdToRedirect}, new int[]{12, 12});
        if (count == 0) {
            this.sqlTemplate.update(this.getSql("insertRegistrationRedirectUrlSql"), new Object[]{nodeIdToRedirectTo, externalIdToRedirect}, new int[]{12, 12});
        }
    }

    @Override
    public void markNodeAsRegistered(String nodeId) {
        this.sqlTemplate.update(this.getSql("registerNodeSecuritySql"), new Object[]{new Date(), nodeId});
        this.nodeService.flushNodeAuthorizedCache();
        List<INodeRegistrationListener> registrationListeners = this.extensionService.getExtensionPointList(INodeRegistrationListener.class);
        for (INodeRegistrationListener l : registrationListeners) {
            l.registrationSyncTriggers();
        }
        this.log.info("Completed registration of node {}", (Object)nodeId);
        if (this.engine.getCacheManager().isUsingTargetExternalId(false)) {
            Node node = this.nodeService.findNode(nodeId);
            if (node != null) {
                this.log.info("Syncing triggers for node {} using target external ID of {}", (Object)node.toString(), (Object)node.getExternalId());
                this.engine.getTriggerRouterService().syncTriggers(node.getExternalId(), false);
            } else {
                this.log.warn("Unable to sync triggers for target external ID because node {} was not found", (Object)nodeId);
            }
        }
    }

    protected void markNodeAsRegistrationPending(String nodeId) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.symmetricDialect.disableSyncTriggers(transaction, nodeId);
            transaction.prepareAndExecute(this.getSql("registrationPendingSql"), new Object[]{new Date(), nodeId});
            transaction.commit();
            this.nodeService.flushNodeAuthorizedCache();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.symmetricDialect.enableSyncTriggers(transaction);
            this.close(transaction);
        }
    }

    private void sleepBeforeRegistrationRetry() {
        long sleepTimeInMs = 1000L * (long)this.randomTimeSlot.getRandomValueSeededByExternalId();
        this.log.info("Could not register.  Sleeping for {}ms before attempting again.", (Object)sleepTimeInMs);
        List<INodeRegistrationListener> registrationListeners = this.extensionService.getExtensionPointList(INodeRegistrationListener.class);
        for (INodeRegistrationListener l : registrationListeners) {
            l.registrationNextAttemptUpdated((int)(sleepTimeInMs / 1000L));
        }
        AppUtils.sleep((long)sleepTimeInMs);
    }

    @Override
    public boolean isRegisteredWithServer() {
        return this.nodeService.findIdentity() != null;
    }

    @Override
    public synchronized boolean registerWithServer() {
        boolean wasRegistered;
        boolean registered = wasRegistered = this.isRegisteredWithServer();
        int maxNumberOfAttempts = this.parameterService.getInt("registration.number.of.attempts");
        while (!registered && (maxNumberOfAttempts < 0 || maxNumberOfAttempts > 0) && this.engine.isStarted()) {
            if ((registered = this.attemptToRegisterWithServer(--maxNumberOfAttempts)) || maxNumberOfAttempts == 0) continue;
            this.sleepBeforeRegistrationRetry();
        }
        if (!registered) {
            throw new RegistrationFailedException(String.format("Failed after trying to register %s times.", this.parameterService.getString("registration.number.of.attempts")));
        }
        return registered != wasRegistered;
    }

    @Override
    public synchronized boolean attemptToRegisterWithServer(int maxNumberOfAttempts) {
        List<INodeRegistrationListener> registrationListeners = this.extensionService.getExtensionPointList(INodeRegistrationListener.class);
        boolean registered = this.isRegisteredWithServer();
        if (!registered) {
            try {
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationStarting(Thread.currentThread());
                }
                this.log.info("This node is unregistered.  It will attempt to register using the registration.url");
                registered = this.dataLoaderService.loadDataFromPull(null, (String)null).getStatus() == RemoteNodeStatus.Status.DATA_PROCESSED;
            }
            catch (ConnectException e) {
                this.log.warn("The request to register failed because the client failed to connect to the server.  The connection error message was: {}", (Object)e.getMessage());
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationFailed("The request to register failed because the client failed to connect to the server.  The connection error message was: " + e.getMessage());
                }
            }
            catch (UnknownHostException e) {
                this.log.warn("The request to register failed because the host was unknown.  The unknown host exception was: {}", (Object)e.getMessage());
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationFailed("The request to register failed because the host was unknown.  The unknown host exception was: " + e.getMessage());
                }
            }
            catch (ConnectionRejectedException e) {
                this.log.warn("The request to register was rejected by the server.  Either the server node is not started, the server is not configured properly or the registration url is incorrect");
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationFailed("The request to register was rejected by the server.  Either the server node is not started, the server is not configured properly or the registration url is incorrect");
                }
            }
            catch (RegistrationNotOpenException e) {
                this.log.warn("Waiting for registration to be accepted by the server. Registration is not open.");
                boolean authWasAttempted = false;
                for (INodeRegistrationListener l : registrationListeners) {
                    Map<String, String> prop = l.getRequestProperties();
                    if (prop == null || !prop.containsKey("regUserId")) continue;
                    authWasAttempted = true;
                }
                for (INodeRegistrationListener l : registrationListeners) {
                    if (authWasAttempted) {
                        l.registrationFailed("User is not authorized.  Registration is not open.");
                        continue;
                    }
                    l.registrationFailed("Waiting for registration to be accepted by the server. Registration is not open.");
                }
            }
            catch (ServiceUnavailableException e) {
                this.log.warn("Unable to register with server because the service is not available.  It may be starting up.");
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationFailed("Unable to register with server because the service is not available.  It may be starting up.");
                }
            }
            catch (Exception e) {
                this.log.error("Unexpected error during registration: " + (StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : e.getClass().getName()), (Throwable)e);
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationFailed("Unexpected error during registration: " + (StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
                }
            }
            registered = this.checkRegistrationSuccessful(registered, maxNumberOfAttempts);
        }
        return registered;
    }

    protected boolean checkRegistrationSuccessful(boolean registered, int maxNumberOfAttempts) {
        if (!registered && (maxNumberOfAttempts < 0 || maxNumberOfAttempts > 0) && (registered = this.isRegisteredWithServer())) {
            this.log.info("We registered, but were not able to acknowledge our registration.  Sending a sql event to the node where we registered to indicate that we are alive and registered");
            Node identity = this.nodeService.findIdentity();
            Node parentNode = this.nodeService.findNode(identity.getCreatedAtNodeId());
            this.dataService.insertSqlEvent(parentNode, "update " + this.tablePrefix + "_node_security set registration_enabled=1, registration_time=current_timestamp where node_id='" + identity.getNodeId() + "'", false, -1L, null);
        }
        if (registered) {
            List<INodeRegistrationListener> registrationListeners = this.extensionService.getExtensionPointList(INodeRegistrationListener.class);
            Node node = this.nodeService.findIdentity();
            if (node != null) {
                this.log.info("Successfully registered node [id={}]", (Object)node.getNodeId());
                this.extensionService.refresh();
                this.dataService.heartbeat(true);
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationSuccessful();
                }
            } else {
                this.log.error("Node identity is missing after registration.  The registration server may be misconfigured or have an error");
                for (INodeRegistrationListener l : registrationListeners) {
                    l.registrationFailed("Node identity is missing after registration.  The registration server may be misconfigured or have an error");
                }
                registered = false;
            }
        }
        return registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OutgoingBatch> registerWithClient(Node remote, IOutgoingWithResponseTransport transport) {
        ArrayList<OutgoingBatch> extractedBatches = new ArrayList<OutgoingBatch>();
        Node identity = this.nodeService.findIdentity();
        if (identity != null) {
            this.log.info("Node {} is unregistered.  Requesting to push registration to {}", (Object)remote.getNodeId(), (Object)remote.getSyncUrl());
            Node node = null;
            try (IIncomingTransport reqTransport = null;){
                HashMap<String, String> prop = new HashMap<String, String>();
                prop.put("pushRegistration", Boolean.TRUE.toString());
                reqTransport = this.transportManager.getRegisterTransport(identity, remote.getSyncUrl(), prop);
                Map<String, String> params = this.transportManager.readRequestProperties(reqTransport.openStream());
                node = TransportUtils.convertPropertiesToNode(params);
                node = this.processRegistration(node, params.get("hostName"), params.get("ipAddress"), null, null, true);
            }
            if (node != null && node.isSyncEnabled()) {
                OutgoingBatch batch = new OutgoingBatch(remote.getNodeId(), "config", AbstractBatch.Status.LD);
                batch.setBatchId(-9999L);
                extractedBatches.add(batch);
                try {
                    this.log.info("Preparing to send registration to node {} by clearing its outgoing config batches", (Object)remote);
                    this.outgoingBatchService.markAllConfigAsSentForNode(remote.getNodeId());
                    this.log.info("Sending registration batch to node {}", (Object)remote);
                    this.extractConfiguration(transport.openStream(), remote);
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error("Failed to push registration batch", (Throwable)e);
                    }
                    this.log.error("Failed to push registration batch: {}: {}", (Object)e.getClass().getSimpleName(), (Object)StringUtils.trimToEmpty((String)e.getMessage()));
                }
            }
        }
        return extractedBatches;
    }

    @Override
    public boolean writeRegistrationProperties(OutputStream os) {
        try {
            Node local = new Node(this.parameterService, this.symmetricDialect, this.engine.getDatabasePlatform().getName());
            local.setDeploymentType(this.engine.getDeploymentType());
            Map<String, String> requestProperties = TransportUtils.convertNodeToProperties(local, null);
            this.transportManager.writeRequestProperties(requestProperties, os);
        }
        catch (IOException e) {
            this.log.error("Failed to write response for push registration request", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean loadRegistrationBatch(Node node, InputStream is, OutputStream os) {
        try {
            this.dataLoaderService.loadDataFromPush(node, "default", is, os);
        }
        catch (IOException e) {
            this.log.error("Failed to load batch from push registration", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void reOpenRegistration(String nodeId) {
        this.reOpenRegistration(nodeId, null, null, null, null, false);
    }

    @Override
    public synchronized void reOpenRegistration(String nodeId, boolean forceNewPassword) {
        this.reOpenRegistration(nodeId, null, null, null, null, forceNewPassword);
    }

    protected synchronized void reOpenRegistration(String nodeId, String remoteHost, String remoteAddress, Date notBefore, Date notAfter, boolean forceNewPassword) {
        Node node = this.nodeService.findNode(nodeId);
        NodeSecurity security = this.nodeService.findNodeSecurity(nodeId);
        String password = null;
        password = security != null && StringUtils.isNotBlank((CharSequence)security.getNodePassword()) && this.parameterService.is("registration.reopen.use.same.password", true) && !forceNewPassword ? security.getNodePassword() : this.extensionService.getExtensionPoint(INodeIdCreator.class).generatePassword(node);
        password = this.filterPasswordOnSaveIfNeeded(password);
        if (node != null) {
            int updateCount = this.sqlTemplate.update(this.getSql("reopenRegistrationSql"), new Object[]{password, notBefore, notAfter, nodeId});
            if (updateCount == 0 && this.nodeService.findNodeSecurity(nodeId) == null) {
                this.sqlTemplate.update(this.getSql("openRegistrationNodeSecuritySql"), new Object[]{nodeId, password, notBefore, notAfter, this.nodeService.findIdentityNodeId()});
                this.log.info("Registration was opened for {}", (Object)nodeId);
            } else if (updateCount == 0) {
                this.log.warn("Registration was already enabled for {}.  No need to reenable it", (Object)nodeId);
            } else {
                this.log.info("Registration was reopened for {}", (Object)nodeId);
            }
            if (StringUtils.isNotBlank((CharSequence)remoteHost)) {
                NodeHost nodeHost = new NodeHost(node.getNodeId(), null);
                nodeHost.setHeartbeatTime(new Date());
                nodeHost.setIpAddress(remoteAddress);
                nodeHost.setHostName(remoteHost);
                this.nodeService.updateNodeHost(nodeHost);
            }
            this.nodeService.flushNodeAuthorizedCache();
        } else {
            this.log.warn("There was no row with a node id of {} to 'reopen' registration for", (Object)nodeId);
        }
    }

    @Override
    public synchronized String openRegistration(String nodeGroup, String externalId) {
        Node node = new Node();
        node.setExternalId(externalId);
        node.setNodeGroupId(nodeGroup);
        return this.openRegistration(node);
    }

    @Override
    public synchronized String openRegistration(String nodeGroup, String externalId, String syncUrl, Date notBefore, Date notAfter) {
        Node node = new Node();
        node.setExternalId(externalId);
        node.setNodeGroupId(nodeGroup);
        node.setSyncUrl(syncUrl);
        return this.openRegistration(node, null, null, notBefore, notAfter);
    }

    @Override
    public synchronized String openRegistration(String nodeGroup, String externalId, String remoteHost, String remoteAddress) {
        Node node = new Node();
        node.setExternalId(externalId);
        node.setNodeGroupId(nodeGroup);
        return this.openRegistration(node, remoteHost, remoteAddress, null, null);
    }

    @Override
    public synchronized String openRegistration(Node node) {
        return this.openRegistration(node, null, null, null, null);
    }

    protected String openRegistration(Node node, String remoteHost, String remoteAddress, Date notBefore, Date notAfter) {
        Node me = this.nodeService.findIdentity();
        if (me != null) {
            String nodeId = this.extensionService.getExtensionPoint(INodeIdCreator.class).generateNodeId(node, remoteHost, remoteAddress);
            Node existingNode = this.nodeService.findNode(nodeId);
            if (existingNode == null) {
                node.setNodeId(nodeId);
                node.setSyncEnabled(false);
                boolean masterToMasterOnly = this.configurationService.containsMasterToMaster();
                node.setCreatedAtNodeId(masterToMasterOnly ? null : me.getNodeId());
                this.nodeService.save(node);
                this.nodeService.deleteNodeSecurity(nodeId);
                String password = this.extensionService.getExtensionPoint(INodeIdCreator.class).generatePassword(node);
                password = this.filterPasswordOnSaveIfNeeded(password);
                this.sqlTemplate.update(this.getSql("openRegistrationNodeSecuritySql"), new Object[]{nodeId, password, notBefore, notAfter, me.getNodeId()});
                if (StringUtils.isNotBlank((CharSequence)remoteHost)) {
                    NodeHost nodeHost = new NodeHost(node.getNodeId(), null);
                    nodeHost.setHeartbeatTime(new Date());
                    nodeHost.setIpAddress(remoteAddress);
                    nodeHost.setHostName(remoteHost);
                    this.nodeService.updateNodeHost(nodeHost);
                }
                this.nodeService.flushNodeAuthorizedCache();
                this.nodeService.flushNodeCache();
                this.nodeService.insertNodeGroup(node.getNodeGroupId(), null);
                this.nodeService.flushNodeGroupCache();
                this.log.info("Just opened registration for external id of {} and a node group of {} and a node id of {}", new Object[]{node.getExternalId(), node.getNodeGroupId(), nodeId});
            } else {
                this.reOpenRegistration(nodeId, remoteHost, remoteAddress, notBefore, notAfter, false);
            }
            return nodeId;
        }
        throw new IllegalStateException("This node has not been configured.  Could not find a row in the identity table");
    }

    @Override
    public boolean isAutoRegistration() {
        return this.parameterService.is("auto.registration");
    }

    private String filterPasswordOnSaveIfNeeded(String password) {
        String s = password;
        INodePasswordFilter nodePasswordFilter = this.extensionService.getExtensionPoint(INodePasswordFilter.class);
        if (nodePasswordFilter != null) {
            s = nodePasswordFilter.onNodeSecuritySave(password);
        }
        return s;
    }

    @Override
    public boolean isRegistrationOpen(String nodeGroupId, String externalId) {
        Node node = this.nodeService.findNodeByExternalId(nodeGroupId, externalId);
        if (node != null) {
            NodeSecurity security = this.nodeService.findNodeSecurity(node.getNodeId());
            return security != null && security.isRegistrationEnabled() && security.isRegistrationAllowedNow();
        }
        return false;
    }

    @Override
    public boolean isRegistrationOpen() {
        Node node = this.nodeService.findIdentity();
        NodeSecurity nodeSecurity = null;
        if (node != null) {
            nodeSecurity = this.nodeService.findNodeSecurity(node.getNodeId());
        }
        return nodeSecurity != null && nodeSecurity.isRegistrationEnabled() && nodeSecurity.isRegistrationAllowedNow();
    }

    @Override
    public void requestNodeCopy() {
        Node copyFrom = this.nodeService.findIdentity();
        if (copyFrom == null) {
            throw new IllegalStateException("No identity found.  Can only copy if the node has an identity");
        }
        boolean copied = false;
        for (int maxNumberOfAttempts = this.parameterService.getInt("registration.number.of.attempts"); !(copied || maxNumberOfAttempts >= 0 && maxNumberOfAttempts <= 0); --maxNumberOfAttempts) {
            try {
                this.log.info("Detected that node '{}' should be copied to a new node id.  Attempting to contact server to accomplish this", (Object)copyFrom.getNodeId());
                boolean bl = copied = this.transportManager.sendCopyRequest(copyFrom) == 200;
                if (!copied) continue;
                this.nodeService.deleteIdentity();
                continue;
            }
            catch (ConnectException e) {
                this.log.warn("The request to copy failed because the client failed to connect to the server");
                continue;
            }
            catch (UnknownHostException e) {
                this.log.warn("The request to copy failed because the host was unknown");
                continue;
            }
            catch (ConnectionRejectedException ex) {
                this.log.warn("The request to copy was rejected by the server.  Either the server node is not started, the server is not configured properly or the registration url is incorrect");
                continue;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
            if (copied) continue;
            long sleepTimeInMs = 1000L * (long)this.randomTimeSlot.getRandomValueSeededByExternalId();
            this.log.warn("Copy failed.  Sleeping before attempting again.", (Object)sleepTimeInMs);
            this.log.info("Sleeping for {}ms", (Object)sleepTimeInMs);
            AppUtils.sleep((long)sleepTimeInMs);
        }
        if (!copied) {
            throw new RegistrationFailedException(String.format("Failed after trying to copy %s times.", this.parameterService.getString("registration.number.of.attempts")));
        }
    }

    @Override
    public void setAllowClientRegistration(boolean enabled) {
        this.allowClientRegistration = enabled;
    }

    static class RegistrationRequestMapper
    implements ISqlRowMapper<RegistrationRequest> {
        RegistrationRequestMapper() {
        }

        public RegistrationRequest mapRow(Row rs) {
            RegistrationRequest request = new RegistrationRequest();
            request.setNodeGroupId(rs.getString("node_group_id"));
            request.setExternalId(rs.getString("external_id"));
            request.setStatus(RegistrationRequest.RegistrationStatus.valueOf(RegistrationRequest.RegistrationStatus.class, rs.getString("status")));
            request.setHostName(rs.getString("host_name"));
            request.setIpAddress(rs.getString("ip_address"));
            request.setAttemptCount(rs.getLong("attempt_count"));
            request.setRegisteredNodeId(rs.getString("registered_node_id"));
            request.setCreateTime(rs.getDateTime("create_time"));
            request.setLastUpdateBy(rs.getString("last_update_by"));
            request.setLastUpdateTime(rs.getDateTime("last_update_time"));
            request.setErrorMessage(rs.getString("error_message"));
            return request;
        }
    }
}

