/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.DatabaseParameter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.NodeCommunicationServiceSqlMap;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.RandomTimeSlot;
import org.slf4j.MDC;

public class NodeCommunicationService
extends AbstractService
implements INodeCommunicationService {
    private Map<NodeCommunication.CommunicationType, ThreadPoolExecutor> executors = new HashMap<NodeCommunication.CommunicationType, ThreadPoolExecutor>();
    private INodeService nodeService;
    private IClusterService clusterService;
    private IConfigurationService configurationService;
    private boolean initialized = false;
    private Map<NodeCommunication.CommunicationType, Set<String>> currentlyExecuting;
    private Map<NodeCommunication.CommunicationType, Map<String, NodeCommunication>> lockCache;

    public NodeCommunicationService(IClusterService clusterService, INodeService nodeService, IParameterService parameterService, IConfigurationService configurationService, ISymmetricDialect symmetricDialect) {
        super(parameterService, symmetricDialect);
        NodeCommunication.CommunicationType[] types;
        this.setSqlMap(new NodeCommunicationServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
        this.clusterService = clusterService;
        this.nodeService = nodeService;
        this.configurationService = configurationService;
        this.currentlyExecuting = new HashMap<NodeCommunication.CommunicationType, Set<String>>();
        for (NodeCommunication.CommunicationType communicationType : types = NodeCommunication.CommunicationType.values()) {
            this.currentlyExecuting.put(communicationType, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.lockCache = new HashMap<NodeCommunication.CommunicationType, Map<String, NodeCommunication>>();
        for (NodeCommunication.CommunicationType type : types) {
            this.lockCache.put(type, new HashMap());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void initialize() {
        if (this.initialized) return;
        if (this.clusterService.isClusteringEnabled()) {
            try {
                int locksCleared = this.sqlTemplate.update(this.getSql("clearLocksOnRestartSql"), new Object[]{this.clusterService.getServerId()});
                if (locksCleared <= 0) return;
                this.log.info("Cleared {} node communication locks for {}", (Object)locksCleared, (Object)this.clusterService.getServerId());
                return;
            }
            finally {
                this.initialized = true;
            }
        } else {
            this.initialized = true;
        }
    }

    @Override
    public synchronized void persistToTableForSnapshot() {
        this.sqlTemplate.update(this.getSql("deleteSql"), new Object[0]);
        Collection<Map<String, NodeCommunication>> values = this.lockCache.values();
        for (Map<String, NodeCommunication> map : values) {
            Collection<NodeCommunication> nodeCommies = map.values();
            for (NodeCommunication nodeCommunication : nodeCommies) {
                this.save(nodeCommunication, true);
            }
        }
    }

    @Override
    public NodeCommunication find(String nodeId, String queue, NodeCommunication.CommunicationType communicationType) {
        NodeCommunication lock = null;
        if (this.clusterService.isClusteringEnabled()) {
            lock = (NodeCommunication)this.sqlTemplate.queryForObject(this.getSql("selectNodeCommunicationByNodeAndChannelSql"), (ISqlRowMapper)new NodeCommunicationMapper(), new Object[]{nodeId, queue, communicationType.name()});
        } else {
            Map<String, NodeCommunication> locks = this.lockCache.get((Object)communicationType);
            lock = locks.get(nodeId + "-" + queue);
        }
        if (lock == null) {
            lock = new NodeCommunication();
            lock.setNodeId(nodeId);
            lock.setCommunicationType(communicationType);
            lock.setQueue(queue);
            this.save(lock, false);
        }
        return lock;
    }

    protected List<NodeCommunication> find(NodeCommunication.CommunicationType communicationType) {
        if (this.clusterService.isClusteringEnabled()) {
            String SQL_KEY = NodeCommunication.CommunicationType.isPullType(communicationType) ? "selectNodeCommunicationPullSql" : "selectNodeCommunicationSql";
            return new ArrayList<NodeCommunication>(this.sqlTemplate.query(this.getSql(SQL_KEY), (ISqlRowMapper)new NodeCommunicationMapper(), new Object[]{communicationType.name()}));
        }
        Map<String, NodeCommunication> locks = this.lockCache.get((Object)communicationType);
        ArrayList<NodeCommunication> list = new ArrayList<NodeCommunication>(locks.values());
        this.sortNodeCommunications(list, communicationType);
        return list;
    }

    @Override
    public List<NodeCommunication> list(NodeCommunication.CommunicationType communicationType) {
        return this.list(communicationType, true);
    }

    @Override
    public List<NodeCommunication> listAll(NodeCommunication.CommunicationType communicationType) {
        return this.list(communicationType, false);
    }

    protected List<NodeCommunication> list(NodeCommunication.CommunicationType communicationType, boolean onlyNodesWithChanges) {
        this.initialize();
        long ts = System.currentTimeMillis();
        List<NodeCommunication> communicationRows = this.find(communicationType);
        this.log.debug("Found {} node communication locks to push to in {}ms", (Object)communicationRows.size(), (Object)(System.currentTimeMillis() - ts));
        List<Node> nodesToCommunicateWith = null;
        switch (communicationType) {
            case PULL: 
            case FILE_PULL: {
                List<Node> nodes = this.nodeService.findNodesToPull();
                nodesToCommunicateWith = this.removeOfflineNodes(nodes);
                break;
            }
            case FILE_PUSH: 
            case PUSH: {
                ts = System.currentTimeMillis();
                List<Node> nodes = this.nodeService.findNodesToPushTo();
                nodesToCommunicateWith = this.removeOfflineNodes(nodes);
                this.log.debug("Found {} nodes to push to in {}ms", (Object)nodesToCommunicateWith.size(), (Object)(System.currentTimeMillis() - ts));
                break;
            }
            case OFFLN_PUSH: 
            case OFF_FSPUSH: {
                nodesToCommunicateWith = this.getNodesToCommunicateWithOffline(NodeCommunication.CommunicationType.PUSH);
                break;
            }
            case OFFLN_PULL: 
            case OFF_FSPULL: {
                nodesToCommunicateWith = this.getNodesToCommunicateWithOffline(NodeCommunication.CommunicationType.PULL);
                break;
            }
            default: {
                nodesToCommunicateWith = new ArrayList<Node>(0);
            }
        }
        HashMap<String, NodeCommunication> communicationRowsMap = new HashMap<String, NodeCommunication>(communicationRows.size());
        for (NodeCommunication nodeCommunication : communicationRows) {
            communicationRowsMap.put(nodeCommunication.getIdentifier(), nodeCommunication);
        }
        List<NodeCommunication> nodesToCommunicateWithList = this.filterForChannelThreading(nodesToCommunicateWith);
        HashMap<String, NodeCommunication> nodesToCommunicateWithListMap = new HashMap<String, NodeCommunication>(nodesToCommunicateWithList.size());
        for (NodeCommunication nodeToCommunicateWith : nodesToCommunicateWithList) {
            NodeCommunication comm = (NodeCommunication)communicationRowsMap.get(nodeToCommunicateWith.getIdentifier());
            if (comm == null) {
                comm = new NodeCommunication();
                comm.setNodeId(nodeToCommunicateWith.getNodeId());
                comm.setQueue(nodeToCommunicateWith.getQueue());
                comm.setCommunicationType(communicationType);
                this.save(comm, false);
                communicationRows.add(comm);
            }
            comm.setNode(nodeToCommunicateWith.getNode());
            nodesToCommunicateWithListMap.put(nodeToCommunicateWith.getNodeId(), nodeToCommunicateWith);
        }
        Iterator<NodeCommunication> it = communicationRows.iterator();
        while (it.hasNext()) {
            Node node;
            NodeCommunication nodeCommunication = it.next();
            NodeCommunication nodeToCommunicateWith = (NodeCommunication)nodesToCommunicateWithListMap.get(nodeCommunication.getNodeId());
            Node node2 = node = nodeToCommunicateWith != null ? nodeToCommunicateWith.getNode() : null;
            if (node != null && this.isQueueValid(nodeCommunication)) continue;
            this.delete(nodeCommunication);
            it.remove();
        }
        if (communicationType == NodeCommunication.CommunicationType.PUSH && onlyNodesWithChanges && this.parameterService.getInt("push.thread.per.server.count") < communicationRows.size()) {
            ts = System.currentTimeMillis();
            List<String> nodeIds = this.getNodeIdsWithUnsentCount();
            ArrayList<NodeCommunication> filteredNodes = new ArrayList<NodeCommunication>(nodeIds.size());
            for (NodeCommunication nodeCommunication : communicationRows) {
                if (!nodeIds.contains(nodeCommunication.getNodeId())) continue;
                filteredNodes.add(nodeCommunication);
            }
            this.log.debug("Filtered down to {} nodes to push to in {}ms", (Object)filteredNodes.size(), (Object)(System.currentTimeMillis() - ts));
            communicationRows = filteredNodes;
        }
        if (communicationType == NodeCommunication.CommunicationType.PULL || communicationType == NodeCommunication.CommunicationType.FILE_PULL) {
            communicationRows = this.removeNodesWithNoBatchesToSend(communicationRows);
        }
        return communicationRows;
    }

    private boolean isQueueValid(NodeCommunication nodeCommunication) {
        boolean ret = false;
        String queue = nodeCommunication.getQueue();
        Map<String, Channel> channels = this.configurationService.getChannels(false);
        for (String key : channels.keySet()) {
            Channel channel = channels.get(key);
            if (channel == null || !StringUtils.equalsIgnoreCase((CharSequence)queue, (CharSequence)channel.getQueue())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected List<String> getNodeIdsWithUnsentCount() {
        return this.sqlTemplate.query(this.getSql("selectNodeIdsWithUnsentBatchsSql"), (ISqlRowMapper)new StringMapper(), new Object[]{AbstractBatch.Status.ER.name(), AbstractBatch.Status.NE.name(), AbstractBatch.Status.QY.name(), AbstractBatch.Status.SE.name(), AbstractBatch.Status.LD.name(), AbstractBatch.Status.IG.name(), AbstractBatch.Status.RS.name()});
    }

    protected List<NodeCommunication> filterForChannelThreading(List<Node> nodesToCommunicateWith) {
        ArrayList<NodeCommunication> nodeCommunications = new ArrayList<NodeCommunication>();
        Collection<Channel> channels = this.configurationService.getChannels(false).values();
        for (Node node : nodesToCommunicateWith) {
            if (node.isVersionGreaterThanOrEqualTo(3, 8, 0)) {
                HashSet<String> channelThreads = new HashSet<String>();
                for (Channel channel : channels) {
                    if (channelThreads.contains(channel.getQueue())) continue;
                    NodeCommunication nodeCommunication = new NodeCommunication();
                    nodeCommunication.setNodeId(node.getNodeId());
                    nodeCommunication.setQueue(channel.getQueue());
                    nodeCommunication.setNode(node);
                    nodeCommunications.add(nodeCommunication);
                    channelThreads.add(channel.getQueue());
                }
                continue;
            }
            NodeCommunication nodeCommunication = new NodeCommunication();
            nodeCommunication.setNodeId(node.getNodeId());
            nodeCommunication.setNode(node);
            nodeCommunications.add(nodeCommunication);
        }
        return nodeCommunications;
    }

    protected List<Node> removeOfflineNodes(List<Node> nodes) {
        if (this.parameterService.is("node.offline")) {
            nodes.clear();
        } else {
            List<DatabaseParameter> parms = this.parameterService.getOfflineNodeParameters();
            for (DatabaseParameter parm : parms) {
                Iterator<Node> iter = nodes.iterator();
                while (iter.hasNext()) {
                    Node node = iter.next();
                    if (!parm.getNodeGroupId().equals("ALL") && (!parm.getNodeGroupId().equals(node.getNodeGroupId()) || !parm.getExternalId().equals("ALL") && !parm.getExternalId().equals(node.getExternalId()))) continue;
                    iter.remove();
                }
            }
        }
        return nodes;
    }

    protected List<Node> getNodesToCommunicateWithOffline(NodeCommunication.CommunicationType communicationType) {
        ArrayList<Node> nodesToCommunicateWith;
        block9: {
            block7: {
                block8: {
                    nodesToCommunicateWith = new ArrayList<Node>();
                    if (!this.parameterService.is("node.offline") && (!communicationType.equals((Object)NodeCommunication.CommunicationType.PULL) || !this.parameterService.is("node.offline.incoming.accept.all"))) break block7;
                    if (!communicationType.equals((Object)NodeCommunication.CommunicationType.PUSH)) break block8;
                    nodesToCommunicateWith.addAll(this.nodeService.findTargetNodesFor(NodeGroupLinkAction.W));
                    nodesToCommunicateWith.addAll(this.nodeService.findNodesToPushTo());
                    break block9;
                }
                if (!communicationType.equals((Object)NodeCommunication.CommunicationType.PULL)) break block9;
                nodesToCommunicateWith.addAll(this.nodeService.findSourceNodesFor(NodeGroupLinkAction.P));
                nodesToCommunicateWith.addAll(this.nodeService.findNodesToPull());
                break block9;
            }
            List<DatabaseParameter> parms = this.parameterService.getOfflineNodeParameters();
            if (parms.size() > 0) {
                ArrayList<Node> sourceNodes = new ArrayList<Node>();
                if (communicationType.equals((Object)NodeCommunication.CommunicationType.PUSH)) {
                    sourceNodes.addAll(this.nodeService.findTargetNodesFor(NodeGroupLinkAction.W));
                    sourceNodes.addAll(this.nodeService.findNodesToPushTo());
                } else if (communicationType.equals((Object)NodeCommunication.CommunicationType.PULL)) {
                    sourceNodes.addAll(this.nodeService.findSourceNodesFor(NodeGroupLinkAction.P));
                    sourceNodes.addAll(this.nodeService.findNodesToPull());
                }
                if (sourceNodes != null && sourceNodes.size() > 0) {
                    for (DatabaseParameter parm : parms) {
                        for (Node node : sourceNodes) {
                            if (!parm.getNodeGroupId().equals("ALL") && (!parm.getNodeGroupId().equals(node.getNodeGroupId()) || !parm.getExternalId().equals("ALL") && !parm.getExternalId().equals(node.getExternalId()))) continue;
                            nodesToCommunicateWith.add(node);
                        }
                    }
                }
            }
        }
        return nodesToCommunicateWith;
    }

    public boolean delete(NodeCommunication nodeCommunication) {
        if (this.clusterService.isClusteringEnabled()) {
            return 1 == this.sqlTemplate.update(this.getSql("deleteNodeCommunicationSql"), new Object[]{nodeCommunication.getNodeId(), nodeCommunication.getQueue(), nodeCommunication.getCommunicationType().name()});
        }
        Map<String, NodeCommunication> locks = this.lockCache.get((Object)nodeCommunication.getCommunicationType());
        return locks.remove(nodeCommunication.getIdentifier()) != null;
    }

    protected void save(NodeCommunication nodeCommunication, boolean force) {
        if (this.clusterService.isClusteringEnabled() || force) {
            if (0 >= this.sqlTemplate.update(this.getSql("updateNodeCommunicationSql"), new Object[]{nodeCommunication.getLockTime(), nodeCommunication.getLockingServerId(), nodeCommunication.getLastLockMillis(), nodeCommunication.getSuccessCount(), nodeCommunication.getFailCount(), nodeCommunication.getTotalSuccessCount(), nodeCommunication.getTotalFailCount(), nodeCommunication.getTotalSuccessMillis(), nodeCommunication.getTotalFailMillis(), nodeCommunication.getLastLockTime(), nodeCommunication.getBatchToSendCount(), nodeCommunication.getNodePriority(), nodeCommunication.getNodeId(), nodeCommunication.getQueue(), nodeCommunication.getCommunicationType().name()})) {
                this.sqlTemplate.update(this.getSql("insertNodeCommunicationSql"), new Object[]{nodeCommunication.getLockTime(), nodeCommunication.getLockingServerId(), nodeCommunication.getLastLockMillis(), nodeCommunication.getSuccessCount(), nodeCommunication.getFailCount(), nodeCommunication.getTotalSuccessCount(), nodeCommunication.getTotalFailCount(), nodeCommunication.getTotalSuccessMillis(), nodeCommunication.getTotalFailMillis(), nodeCommunication.getLastLockTime(), nodeCommunication.getBatchToSendCount(), nodeCommunication.getNodePriority(), nodeCommunication.getNodeId(), nodeCommunication.getQueue(), nodeCommunication.getCommunicationType().name()});
            }
        } else {
            Map<String, NodeCommunication> locks = this.lockCache.get((Object)nodeCommunication.getCommunicationType());
            locks.put(nodeCommunication.getIdentifier(), nodeCommunication);
        }
    }

    protected List<NodeCommunication> removeNodesWithNoBatchesToSend(List<NodeCommunication> nodeCommunications) {
        if (!this.parameterService.is("hybrid.push.pull.enabled")) {
            return nodeCommunications;
        }
        ArrayList<NodeCommunication> filteredNodes = new ArrayList<NodeCommunication>(nodeCommunications);
        for (NodeCommunication nodeCommunication : nodeCommunications) {
            long elapsedLock = System.currentTimeMillis() - nodeCommunication.getLastLockMillis();
            if (nodeCommunication.getBatchToSendCount() != 0L || elapsedLock >= this.parameterService.getLong("hybrid.push.pull.timeout.ms")) continue;
            filteredNodes.remove(nodeCommunication);
        }
        return filteredNodes;
    }

    protected ThreadPoolExecutor getExecutor(NodeCommunication.CommunicationType communicationType) {
        return this.getExecutor(communicationType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPoolExecutor getExecutor(NodeCommunication.CommunicationType communicationType, String threadChannelId) {
        ThreadPoolExecutor service = this.executors.get((Object)communicationType);
        String threadCountParameter = "";
        switch (communicationType) {
            case PULL: {
                threadCountParameter = "pull.thread.per.server.count";
                break;
            }
            case PUSH: {
                threadCountParameter = "push.thread.per.server.count";
                break;
            }
            case ROUTE: {
                threadCountParameter = "routing.thread.per.server.count";
                break;
            }
            case OFFLN_PULL: {
                threadCountParameter = "offline.pull.thread.per.server.count";
                break;
            }
            case OFFLN_PUSH: {
                threadCountParameter = "offline.push.thread.per.server.count";
                break;
            }
            case FILE_PULL: 
            case OFF_FSPULL: {
                threadCountParameter = "file.push.thread.per.server.count";
                break;
            }
            case FILE_PUSH: 
            case OFF_FSPUSH: {
                threadCountParameter = "file.push.thread.per.server.count";
                break;
            }
            case FILE_XTRCT: 
            case EXTRACT: {
                threadCountParameter = "initial.load.extract.thread.per.server.count";
                break;
            }
        }
        int threadCount = this.parameterService.getInt(threadCountParameter, 1);
        if (service != null && service.getCorePoolSize() != threadCount) {
            this.log.info("{} has changed from {} to {}.  Restarting thread pool", new Object[]{threadCountParameter, service.getCorePoolSize(), threadCount});
            this.stop();
            service = null;
        }
        if (service == null) {
            NodeCommunicationService nodeCommunicationService = this;
            synchronized (nodeCommunicationService) {
                service = this.executors.get((Object)communicationType);
                if (service == null) {
                    if (threadCount <= 0) {
                        this.log.warn("{}={} is not a valid value. Defaulting to 1", (Object)threadCountParameter, (Object)threadCount);
                        threadCount = 1;
                    } else if (threadCount > 1) {
                        this.log.info("{} will use {} threads", (Object)communicationType.name().toLowerCase(), (Object)threadCount);
                    }
                    service = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadCount, new ChannelThreadFactory(this.parameterService.getEngineName(), communicationType.name()));
                    this.executors.put(communicationType, service);
                }
            }
        }
        return service;
    }

    @Override
    public int getAvailableThreads(NodeCommunication.CommunicationType communicationType) {
        ThreadPoolExecutor service = this.getExecutor(communicationType);
        return service.getMaximumPoolSize() - service.getActiveCount();
    }

    protected Date getLockTimeoutDate(NodeCommunication.CommunicationType communicationType) {
        String parameter = "";
        switch (communicationType) {
            case PULL: {
                parameter = "pull.lock.timeout.ms";
                break;
            }
            case PUSH: {
                parameter = "push.lock.timeout.ms";
                break;
            }
            case ROUTE: {
                parameter = "routing.lock.timeout.ms";
                break;
            }
            case OFFLN_PULL: {
                parameter = "offline.pull.lock.timeout.ms";
                break;
            }
            case OFFLN_PUSH: {
                parameter = "offline.push.lock.timeout.ms";
                break;
            }
            case FILE_PULL: 
            case OFF_FSPULL: {
                parameter = "file.pull.lock.timeout.ms";
                break;
            }
            case FILE_PUSH: 
            case OFF_FSPUSH: {
                parameter = "file.push.lock.timeout.ms";
                break;
            }
            case FILE_XTRCT: 
            case EXTRACT: {
                parameter = "initial.load.extract.timeout.ms";
                break;
            }
        }
        return DateUtils.addMilliseconds((Date)new Date(), (int)(-this.parameterService.getInt(parameter, 0x6DDD00)));
    }

    @Override
    public boolean execute(final NodeCommunication nodeCommunication, RemoteNodeStatuses statuses, final INodeCommunicationService.INodeCommunicationExecutor executor) {
        Date now = new Date();
        final Set<String> executing = this.currentlyExecuting.get((Object)nodeCommunication.getCommunicationType());
        try {
            boolean locked;
            boolean bl = locked = !executing.contains(nodeCommunication.getIdentifier()) && this.lock(nodeCommunication, now);
            if (locked) {
                executing.add(nodeCommunication.getIdentifier());
                nodeCommunication.setLastLockTime(now);
                nodeCommunication.setLockingServerId(this.clusterService.getServerId());
                final RemoteNodeStatus status = statuses.add(nodeCommunication.getNodeId(), nodeCommunication.getQueue());
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long ts = System.currentTimeMillis();
                        boolean failed = false;
                        try {
                            MDC.put((String)"engineName", (String)NodeCommunicationService.this.parameterService.getEngineName());
                            String name = NodeCommunicationService.this.parameterService.getEngineName().toLowerCase() + "-" + nodeCommunication.getCommunicationType().name().toLowerCase() + "-" + nodeCommunication.getQueue().toLowerCase();
                            Thread thread = Thread.currentThread();
                            thread.setName(thread.getName().replaceFirst(".*(-\\d+)", name + "$1"));
                            executor.execute(nodeCommunication, status);
                            failed = status.failed();
                        }
                        catch (Throwable ex) {
                            failed = true;
                            NodeCommunicationService.this.log.error(String.format("Failed to execute %s for node %s and channel %s", nodeCommunication.getCommunicationType().name(), nodeCommunication.getNodeId(), nodeCommunication.getQueue()), ex);
                        }
                        finally {
                            status.setComplete(true);
                            executing.remove(nodeCommunication.getIdentifier());
                            NodeCommunicationService.this.unlock(nodeCommunication, failed, ts);
                        }
                    }
                };
                if (this.parameterService.is("jobs.synchronized.enable")) {
                    r.run();
                } else {
                    ThreadPoolExecutor service = this.getExecutor(nodeCommunication.getCommunicationType(), nodeCommunication.getQueue());
                    service.execute(r);
                }
            }
            return locked;
        }
        catch (RuntimeException ex) {
            this.log.error(String.format("Failed to execute %s for node %s and channel thread %s", nodeCommunication.getCommunicationType().name(), nodeCommunication.getNodeId(), nodeCommunication.getQueue()), (Throwable)ex);
            executing.remove(nodeCommunication.getIdentifier());
            this.unlock(nodeCommunication, true, System.currentTimeMillis());
            return false;
        }
    }

    protected boolean lock(NodeCommunication nodeCommunication, Date lockTime) {
        Date lockTimeout = this.getLockTimeoutDate(nodeCommunication.getCommunicationType());
        if (this.clusterService.isClusteringEnabled()) {
            return this.sqlTemplate.update(this.getSql("aquireLockSql"), new Object[]{this.clusterService.getServerId(), lockTime, lockTime, nodeCommunication.getNodeId(), nodeCommunication.getQueue(), nodeCommunication.getCommunicationType().name(), lockTimeout}) == 1;
        }
        if (nodeCommunication.getLockTime() == null || nodeCommunication.getLockTime().before(lockTimeout)) {
            nodeCommunication.setLockingServerId(this.clusterService.getServerId());
            nodeCommunication.setLockTime(lockTime);
            nodeCommunication.setLastLockTime(lockTime);
            return true;
        }
        return false;
    }

    protected void unlock(NodeCommunication nodeCommunication, boolean failed, long ts) {
        boolean unlocked = false;
        int attempts = 1;
        do {
            try {
                long millis = System.currentTimeMillis() - ts;
                nodeCommunication.setLockTime(null);
                nodeCommunication.setLastLockMillis(millis);
                if (failed) {
                    nodeCommunication.setFailCount(nodeCommunication.getFailCount() + 1L);
                    nodeCommunication.setTotalFailCount(nodeCommunication.getTotalFailCount() + 1L);
                    nodeCommunication.setTotalFailMillis(nodeCommunication.getTotalFailMillis() + millis);
                } else {
                    nodeCommunication.setSuccessCount(nodeCommunication.getSuccessCount() + 1L);
                    nodeCommunication.setTotalSuccessCount(nodeCommunication.getTotalSuccessCount() + 1L);
                    nodeCommunication.setTotalSuccessMillis(nodeCommunication.getTotalSuccessMillis() + millis);
                    nodeCommunication.setFailCount(0L);
                }
                if (this.clusterService.isClusteringEnabled()) {
                    this.save(nodeCommunication, false);
                }
                unlocked = true;
                if (attempts <= true) continue;
                this.log.info("Successfully unlocked {} node communication record for {} and channel {} after {} attempts", new Object[]{nodeCommunication.getCommunicationType().name(), nodeCommunication.getNodeId(), nodeCommunication.getQueue(), attempts});
            }
            catch (Throwable e) {
                this.log.error(String.format("Failed to unlock %s node communication record for %s and channel %s", nodeCommunication.getCommunicationType().name(), nodeCommunication.getNodeId(), nodeCommunication.getQueue()), e);
                long sleepTime = 1000L * (long)new RandomTimeSlot(nodeCommunication.getNodeId(), 30).getRandomValueSeededByExternalId();
                this.log.warn("Sleeping for {} ms before attempting to unlock the node communication record again", (Object)sleepTime);
                AppUtils.sleep((long)sleepTime);
                ++attempts;
            }
        } while (!unlocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        HashSet<NodeCommunication.CommunicationType> services = new HashSet<NodeCommunication.CommunicationType>(this.executors.keySet());
        for (NodeCommunication.CommunicationType communicationType : services) {
            try {
                ExecutorService service = this.executors.get((Object)communicationType);
                service.shutdown();
            }
            finally {
                this.executors.remove((Object)communicationType);
            }
        }
    }

    protected void sortNodeCommunications(List<NodeCommunication> list, final NodeCommunication.CommunicationType communicationType) {
        final Date FAR_PAST_DATE = new Date(0L);
        final Date FAR_FUTURE_DATE = new Date(Long.MAX_VALUE);
        Collections.sort(list, new Comparator<NodeCommunication>(){

            @Override
            public int compare(NodeCommunication o1, NodeCommunication o2) {
                Date o2LockTime;
                int compareTo = Integer.compare(o1.getNodePriority(), o2.getNodePriority());
                if (compareTo != 0) {
                    return compareTo;
                }
                if (NodeCommunication.CommunicationType.isPullType(communicationType) && (compareTo = Long.compare(o1.getBatchToSendCount(), o2.getBatchToSendCount())) != 0) {
                    return compareTo;
                }
                Date o1LockTime = o1.getLastLockTime() != null ? o1.getLastLockTime() : FAR_PAST_DATE;
                compareTo = o1LockTime.compareTo(o2LockTime = o2.getLastLockTime() != null ? o2.getLastLockTime() : FAR_FUTURE_DATE);
                if (compareTo != 0) {
                    return compareTo;
                }
                return compareTo;
            }
        });
    }

    @Override
    public void updateBatchToSendCounts(String nodeId, Map<String, Integer> batchesCountToQueues) {
        List<NodeCommunication> nodeCommunications = this.find(NodeCommunication.CommunicationType.PULL);
        ArrayList<NodeCommunication> updatedNodeCommunications = new ArrayList<NodeCommunication>();
        for (String queue : batchesCountToQueues.keySet()) {
            NodeCommunication match = null;
            for (int i = 0; i < nodeCommunications.size(); ++i) {
                NodeCommunication nodeCommunication = nodeCommunications.get(i);
                if (!nodeCommunication.getNodeId().equals(nodeId) || !nodeCommunication.getQueue().equals(queue)) continue;
                match = nodeCommunication;
                break;
            }
            if (match == null) {
                NodeCommunication newNodeCommunication = new NodeCommunication();
                newNodeCommunication.setCommunicationType(NodeCommunication.CommunicationType.PULL);
                newNodeCommunication.setNodeId(nodeId);
                newNodeCommunication.setQueue(queue);
                newNodeCommunication.setBatchToSendCount(batchesCountToQueues.get(queue).intValue());
                updatedNodeCommunications.add(newNodeCommunication);
                continue;
            }
            match.setBatchToSendCount(batchesCountToQueues.get(queue).intValue());
            updatedNodeCommunications.add(match);
        }
        for (NodeCommunication nodeCommunication : updatedNodeCommunications) {
            this.save(nodeCommunication, false);
        }
    }

    @Override
    public Map<String, Integer> parseQueueToBatchCounts(String channelToBatchCountsString) {
        String[] channelToBatchCounts;
        HashMap<String, Integer> channelsToBatchCount = new HashMap<String, Integer>();
        for (String channelToBatchCount : channelToBatchCounts = channelToBatchCountsString.split(",")) {
            String[] queueToBatchCountSplit = channelToBatchCount.split(":");
            String queueName = queueToBatchCountSplit[0];
            int batchCount = Integer.parseInt(queueToBatchCountSplit[1].trim());
            channelsToBatchCount.put(queueName, batchCount);
        }
        Map<String, Channel> channels = this.configurationService.getChannels(false);
        HashMap<String, Integer> queuesToBatchCount = new HashMap<String, Integer>();
        for (String channelId : channelsToBatchCount.keySet()) {
            Channel channel = channels.get(channelId);
            if (channel == null) {
                this.log.warn("Unknown channel: '" + channelId + "'");
                continue;
            }
            String queue = channel.getQueue();
            if (!queuesToBatchCount.containsKey(queue)) {
                queuesToBatchCount.put(queue, (Integer)channelsToBatchCount.get(channelId));
                continue;
            }
            queuesToBatchCount.put(queue, (Integer)queuesToBatchCount.get(queue) + (Integer)channelsToBatchCount.get(channelId));
        }
        return queuesToBatchCount;
    }

    static class ChannelThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private String engineName;
        private String communicationType;

        public ChannelThreadFactory(String engineName, String communicationType) {
            this.engineName = engineName;
            this.communicationType = communicationType;
        }

        public String getThreadPrefix() {
            return new StringBuffer(this.engineName.toLowerCase()).append("-").append(this.communicationType.toLowerCase()).append("-default-").toString();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(this.getThreadPrefix() + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static class NodeCommunicationMapper
    implements ISqlRowMapper<NodeCommunication> {
        NodeCommunicationMapper() {
        }

        public NodeCommunication mapRow(Row rs) {
            NodeCommunication nodeCommunication = new NodeCommunication();
            nodeCommunication.setCommunicationType(NodeCommunication.CommunicationType.valueOf(rs.getString("communication_type").toUpperCase()));
            nodeCommunication.setNodeId(rs.getString("node_id"));
            nodeCommunication.setLockTime(rs.getDateTime("lock_time"));
            nodeCommunication.setLastLockMillis(rs.getLong("last_lock_millis"));
            nodeCommunication.setLockingServerId(rs.getString("locking_server_id"));
            nodeCommunication.setSuccessCount(rs.getLong("success_count"));
            nodeCommunication.setTotalSuccessCount(rs.getLong("total_success_count"));
            nodeCommunication.setTotalSuccessMillis(rs.getLong("total_success_millis"));
            nodeCommunication.setFailCount(rs.getLong("fail_count"));
            nodeCommunication.setTotalFailCount(rs.getLong("total_fail_count"));
            nodeCommunication.setTotalFailMillis(rs.getLong("total_fail_millis"));
            nodeCommunication.setLastLockTime(rs.getDateTime("last_lock_time"));
            nodeCommunication.setQueue(rs.getString("queue"));
            nodeCommunication.setBatchToSendCount(rs.getLong("batch_to_send_count"));
            nodeCommunication.setNodePriority(rs.getInt("node_priority"));
            return nodeCommunication;
        }
    }
}

