/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.file.DirectorySnapshot;
import org.jumpmind.symmetric.file.FileConflictException;
import org.jumpmind.symmetric.file.FileSyncZipDataWriter;
import org.jumpmind.symmetric.file.FileTriggerFileModifiedListener;
import org.jumpmind.symmetric.file.FileTriggerTracker;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.FileConflictStrategy;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.impl.AbstractOfflineDetectorService;
import org.jumpmind.symmetric.service.impl.DataExtractorService;
import org.jumpmind.symmetric.service.impl.FileSyncServiceSqlMap;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.NoContentException;
import org.jumpmind.symmetric.transport.file.FileIncomingTransport;
import org.jumpmind.symmetric.transport.file.FileOutgoingTransport;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.ExceptionUtils;

public class FileSyncService
extends AbstractOfflineDetectorService
implements IFileSyncService,
INodeCommunicationService.INodeCommunicationExecutor {
    private ISymmetricEngine engine;
    private Date lastUpdateTime;
    private ICacheManager cacheManager;

    public FileSyncService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect(), engine.getExtensionService());
        this.engine = engine;
        this.cacheManager = engine.getCacheManager();
        this.setSqlMap(new FileSyncServiceSqlMap(this.platform, this.createSqlReplacementTokens()));
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date3;
        Date date2;
        Date date1 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxFileTriggerLastUpdateTime"), Date.class, new Object[0]);
        Date date = this.maxDate(date1, date2 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxRouterLastUpdateTime"), Date.class, new Object[0]), date3 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxFileTriggerRouterLastUpdateTime"), Date.class, new Object[0]));
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer trigger router settings were detected");
            }
            this.lastUpdateTime = date;
            this.clearCache();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackChanges(boolean force) {
        if (force || this.engine.getClusterService().lock("File Sync Tracker")) {
            try {
                this.log.debug("Attempting to get exclusive lock for file sync track changes");
                if (this.engine.getClusterService().lock("FILE_SYNC_SHARED", "EXCLUSIVE", this.getParameterService().getLong("file.sync.lock.wait.ms"))) {
                    try {
                        this.log.debug("Tracking changes for file sync");
                        Node local = this.engine.getNodeService().findIdentity();
                        if (local == null) {
                            this.log.warn("Not running file sync trackChanges because the local node is not available yet.  It may not be registered yet.");
                            return;
                        }
                        ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(local.getNodeId(), null, ProcessType.FILE_SYNC_TRACKER));
                        boolean useCrc = this.engine.getParameterService().is("file.sync.use.crc");
                        if (this.engine.getParameterService().is("file.sync.fast.scan")) {
                            this.trackChangesFastScan(processInfo, useCrc);
                        } else {
                            this.trackChanges(processInfo, useCrc);
                        }
                        if (this.engine.getParameterService().is("file.sync.prevent.ping.back")) {
                            this.deleteFromFileIncoming();
                        }
                        processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                    }
                    finally {
                        this.log.debug("Done tracking changes for file sync");
                        this.engine.getClusterService().unlock("FILE_SYNC_SHARED", "EXCLUSIVE");
                    }
                }
                this.log.warn("Did not run the track file sync changes process because it was shared locked");
            }
            finally {
                if (!force) {
                    this.engine.getClusterService().unlock("File Sync Tracker");
                }
            }
        } else {
            this.log.debug("Did not run the track file sync changes process because it was cluster locked");
        }
    }

    protected void trackChanges(ProcessInfo processInfo, boolean useCrc) {
        long ctxTime = this.engine.getContextService().getLong("file.sync.fast.scan.track.time");
        Date ctxDate = new Date(ctxTime);
        if (ctxTime == 0L) {
            ctxDate = null;
        }
        Date currentDate = new Date();
        List<FileTriggerRouter> fileTriggerRouters = this.getFileTriggerRoutersForCurrentNode(false);
        for (FileTriggerRouter fileTriggerRouter : fileTriggerRouters) {
            if (!fileTriggerRouter.isEnabled()) continue;
            try {
                FileTrigger fileTrigger = fileTriggerRouter.getFileTrigger();
                boolean sourceDirReachable = this.checkSourceDir(fileTriggerRouter);
                if (!sourceDirReachable) continue;
                boolean ignoreFiles = this.shouldIgnoreInitialFiles(fileTriggerRouter, fileTrigger, ctxDate);
                FileTriggerTracker tracker = new FileTriggerTracker(fileTriggerRouter, this.getDirectorySnapshot(fileTriggerRouter), processInfo, useCrc, this.engine);
                DirectorySnapshot dirSnapshot = tracker.trackChanges();
                this.saveDirectorySnapshot(fileTriggerRouter, dirSnapshot, ignoreFiles);
                this.engine.getContextService().save("file.sync.fast.scan.track.time", String.valueOf(currentDate.getTime()));
            }
            catch (Exception ex) {
                this.log.error("Failed to track changes for file trigger router: " + fileTriggerRouter.getFileTrigger().getTriggerId() + "::" + fileTriggerRouter.getRouter().getRouterId(), (Throwable)ex);
            }
        }
    }

    protected void trackChangesFastScan(ProcessInfo processInfo, boolean useCrc) {
        long ctxTime = this.engine.getContextService().getLong("file.sync.fast.scan.track.time");
        Date ctxDate = new Date(ctxTime);
        ctxDate.setTime(ctxDate.getTime() / 1000L * 1000L);
        if (ctxTime == 0L) {
            ctxDate = null;
        }
        Date currentDate = new Date();
        currentDate.setTime(currentDate.getTime() / 1000L * 1000L);
        int maxRowsBeforeCommit = this.engine.getParameterService().getInt("dataloader.max.rows.before.commit");
        try {
            List<FileTriggerRouter> fileTriggerRouters = this.getFileTriggerRoutersForCurrentNode(false);
            for (final FileTriggerRouter fileTriggerRouter : fileTriggerRouters) {
                if (!fileTriggerRouter.isEnabled()) continue;
                FileTrigger fileTrigger = fileTriggerRouter.getFileTrigger();
                boolean sourceDirReachable = this.checkSourceDir(fileTriggerRouter);
                if (!sourceDirReachable) continue;
                final boolean ignoreFiles = this.shouldIgnoreInitialFiles(fileTriggerRouter, fileTrigger, ctxDate);
                FileAlterationObserver observer = new FileAlterationObserver(fileTriggerRouter.getFileTrigger().getBaseDir(), (FileFilter)fileTriggerRouter.getFileTrigger().createIOFileFilter());
                FileTriggerFileModifiedListener listener = new FileTriggerFileModifiedListener(fileTriggerRouter, ctxDate, currentDate, processInfo, useCrc, new FileTriggerFileModifiedListener.FileModifiedCallback(maxRowsBeforeCommit){

                    @Override
                    public void commit(DirectorySnapshot dirSnapshot) {
                        FileSyncService.this.saveDirectorySnapshot(fileTriggerRouter, dirSnapshot, ignoreFiles);
                    }

                    @Override
                    public DirectorySnapshot getLastDirectorySnapshot(String relativeDir) {
                        return FileSyncService.this.getDirectorySnapshot(fileTriggerRouter, relativeDir);
                    }
                }, this.engine);
                observer.addListener((FileAlterationListener)listener);
                observer.checkAndNotify();
                this.engine.getContextService().save("file.sync.fast.scan.track.time", String.valueOf(currentDate.getTime()));
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to track changes", (Throwable)ex);
        }
    }

    protected boolean checkSourceDir(FileTriggerRouter fileTriggerRouter) {
        File sourceDir = new File(fileTriggerRouter.getFileTrigger().getBaseDir());
        if (!sourceDir.exists()) {
            this.log.warn("Source directory does not exist: {}", (Object)sourceDir.getAbsolutePath());
            return false;
        }
        if (!sourceDir.canRead()) {
            this.log.warn("Source directory is not readable by user {}: {}", (Object)System.getProperty("user.name"), (Object)sourceDir.getAbsolutePath());
            return false;
        }
        return true;
    }

    protected boolean shouldIgnoreInitialFiles(FileTriggerRouter router, FileTrigger trigger, Date contextDate) {
        return contextDate == null || router.getLastUpdateTime().after(contextDate) || trigger.getLastUpdateTime().after(contextDate);
    }

    protected long saveDirectorySnapshot(FileTriggerRouter fileTriggerRouter, DirectorySnapshot dirSnapshot, boolean shouldIgnore) {
        long totalBytes = 0L;
        for (FileSnapshot fileSnapshot : dirSnapshot) {
            File file = fileTriggerRouter.getFileTrigger().createSourceFile(fileSnapshot);
            String filePath = file.getParentFile().getPath().replace('\\', '/');
            String fileName = file.getName();
            String nodeId = null;
            if (this.engine.getParameterService().is("file.sync.prevent.ping.back")) {
                nodeId = this.findSourceNodeIdFromFileIncoming(filePath, fileName, fileSnapshot.getFileModifiedTime());
            }
            if (StringUtils.isNotBlank(nodeId)) {
                fileSnapshot.setLastUpdateBy(nodeId);
            } else {
                fileSnapshot.setLastUpdateBy(null);
            }
            this.log.debug("Captured change " + fileSnapshot);
            totalBytes += fileSnapshot.getFileSize();
        }
        this.save(dirSnapshot, shouldIgnore);
        return totalBytes;
    }

    protected String findSourceNodeIdFromFileIncoming(String filePath, String fileName, long lastUpdateDate) {
        return this.sqlTemplate.queryForString(this.getSql("findNodeIdFromFileIncoming"), new Object[]{filePath, fileName, lastUpdateDate});
    }

    protected void deleteFromFileIncoming() {
        this.sqlTemplate.update(this.getSql("deleteFileIncoming"), new Object[0]);
    }

    @Override
    public List<FileTrigger> getFileTriggers() {
        return this.sqlTemplate.query(this.getSql("selectFileTriggersSql"), (ISqlRowMapper)new FileTriggerMapper(), new Object[0]);
    }

    @Override
    public FileTrigger getFileTrigger(String triggerId) {
        return (FileTrigger)this.sqlTemplate.queryForObject(this.getSql("selectFileTriggersSql", "triggerIdWhere"), (ISqlRowMapper)new FileTriggerMapper(), new Object[]{triggerId});
    }

    @Override
    public List<FileTriggerRouter> getFileTriggerRoutersForCurrentNode(boolean refreshCache) {
        String myNodeGroupId = this.parameterService.getNodeGroupId();
        List<FileTriggerRouter> allValues = this.getFileTriggerRouters(refreshCache);
        ArrayList<FileTriggerRouter> currentValues = new ArrayList<FileTriggerRouter>();
        for (FileTriggerRouter ftr : allValues) {
            if (!ftr.getRouter().getNodeGroupLink().getSourceNodeGroupId().equals(myNodeGroupId) || !ftr.isEnabled()) continue;
            currentValues.add(ftr);
        }
        return currentValues;
    }

    @Override
    public List<FileTriggerRouter> getFileTriggerRouters(boolean refreshCache) {
        return this.cacheManager.getFileTriggerRouters(refreshCache);
    }

    @Override
    public List<FileTriggerRouter> getFileTriggerRoutersFromDb() {
        return this.sqlTemplate.query(this.getSql("selectFileTriggerRoutersSql"), (ISqlRowMapper)new FileTriggerRouterMapper(), new Object[0]);
    }

    @Override
    public FileTriggerRouter getFileTriggerRouter(String triggerId, String routerId, boolean refreshCache) {
        List<FileTriggerRouter> allValues = this.getFileTriggerRouters(refreshCache);
        for (FileTriggerRouter ftr : allValues) {
            if (!ftr.getRouterId().equals(routerId) || !ftr.getTriggerId().equals(triggerId)) continue;
            return ftr;
        }
        return null;
    }

    @Override
    public void clearCache() {
        this.cacheManager.flushFileTriggerRouters();
    }

    @Override
    public void saveFileTrigger(FileTrigger fileTrigger) {
        fileTrigger.setLastUpdateTime(new Date());
        if (0 >= this.sqlTemplate.update(this.getSql("updateFileTriggerSql"), new Object[]{fileTrigger.getBaseDir(), fileTrigger.isRecurse() ? 1 : 0, fileTrigger.getIncludesFiles(), fileTrigger.getExcludesFiles(), fileTrigger.isSyncOnCreate() ? 1 : 0, fileTrigger.isSyncOnModified() ? 1 : 0, fileTrigger.isSyncOnDelete() ? 1 : 0, fileTrigger.isSyncOnCtlFile() ? 1 : 0, fileTrigger.isDeleteAfterSync() ? 1 : 0, fileTrigger.getBeforeCopyScript(), fileTrigger.getAfterCopyScript(), fileTrigger.getLastUpdateBy(), fileTrigger.getLastUpdateTime(), fileTrigger.getChannelId(), fileTrigger.getReloadChannelId(), fileTrigger.getTriggerId()}, new int[]{12, 5, 12, 12, 5, 5, 5, 5, 5, 12, 12, 12, 93, 12, 12, 12})) {
            fileTrigger.setCreateTime(fileTrigger.getLastUpdateTime());
            this.sqlTemplate.update(this.getSql("insertFileTriggerSql"), new Object[]{fileTrigger.getBaseDir(), fileTrigger.isRecurse() ? 1 : 0, fileTrigger.getIncludesFiles(), fileTrigger.getExcludesFiles(), fileTrigger.isSyncOnCreate() ? 1 : 0, fileTrigger.isSyncOnModified() ? 1 : 0, fileTrigger.isSyncOnDelete() ? 1 : 0, fileTrigger.isSyncOnCtlFile() ? 1 : 0, fileTrigger.isDeleteAfterSync() ? 1 : 0, fileTrigger.getBeforeCopyScript(), fileTrigger.getAfterCopyScript(), fileTrigger.getLastUpdateBy(), fileTrigger.getLastUpdateTime(), fileTrigger.getTriggerId(), fileTrigger.getCreateTime(), fileTrigger.getChannelId(), fileTrigger.getReloadChannelId()}, new int[]{12, 5, 12, 12, 5, 5, 5, 5, 5, 12, 12, 12, 93, 12, 93, 12, 12});
        }
    }

    @Override
    public void saveFileTriggerAsCopy(String originalId, FileTrigger fileTrigger) {
        String newId = fileTrigger.getTriggerId();
        List fileTriggers = this.sqlTemplate.query(this.getSql("selectFileTriggersSql", "triggerIdWhereLike"), (ISqlRowMapper)new FileTriggerMapper(), new Object[]{newId + "%"});
        List ids = fileTriggers.stream().map(FileTrigger::getTriggerId).collect(Collectors.toList());
        String suffix = "";
        int i = 2;
        while (ids.contains(newId + suffix)) {
            suffix = "_" + i;
            ++i;
        }
        fileTrigger.setTriggerId(newId + suffix);
        this.saveFileTrigger(fileTrigger);
        for (FileTriggerRouter fileTriggerRouter : this.sqlTemplate.query(this.getSql("selectFileTriggerRoutersSql", "whereTriggerId"), (ISqlRowMapper)new FileTriggerRouterMapper(), new Object[]{originalId})) {
            fileTriggerRouter.setTriggerId(newId + suffix);
            this.saveFileTriggerRouter(fileTriggerRouter);
        }
    }

    @Override
    public void renameFileTrigger(String oldId, FileTrigger fileTrigger) {
        this.saveFileTrigger(fileTrigger);
        this.sqlTemplate.update(this.getSql("updateFileTriggerIdSql"), new Object[]{fileTrigger.getTriggerId(), oldId});
        this.deleteFileTrigger(oldId);
    }

    @Override
    public void saveFileTriggerRouter(FileTriggerRouter fileTriggerRouter) {
        fileTriggerRouter.setLastUpdateTime(new Date());
        if (0 >= this.sqlTemplate.update(this.getSql("updateFileTriggerRouterSql"), new Object[]{fileTriggerRouter.isEnabled() ? 1 : 0, fileTriggerRouter.isInitialLoadEnabled() ? 1 : 0, fileTriggerRouter.getTargetBaseDir(), fileTriggerRouter.getConflictStrategyString(), fileTriggerRouter.getLastUpdateBy(), fileTriggerRouter.getLastUpdateTime(), fileTriggerRouter.getFileTrigger().getTriggerId(), fileTriggerRouter.getRouter().getRouterId()}, new int[]{5, 5, 12, 12, 12, 93, 12, 12})) {
            fileTriggerRouter.setCreateTime(fileTriggerRouter.getLastUpdateTime());
            this.sqlTemplate.update(this.getSql("insertFileTriggerRouterSql"), new Object[]{fileTriggerRouter.isEnabled() ? 1 : 0, fileTriggerRouter.isInitialLoadEnabled() ? 1 : 0, fileTriggerRouter.getTargetBaseDir(), fileTriggerRouter.getConflictStrategyString(), fileTriggerRouter.getCreateTime(), fileTriggerRouter.getLastUpdateBy(), fileTriggerRouter.getLastUpdateTime(), fileTriggerRouter.getFileTrigger().getTriggerId(), fileTriggerRouter.getRouter().getRouterId()}, new int[]{5, 5, 12, 12, 93, 12, 93, 12, 12});
        }
        this.clearCache();
    }

    @Override
    public void renameFileTriggerRouter(String oldTriggerId, String oldRouterId, FileTriggerRouter fileTriggerRouter) {
        this.deleteFileTriggerRouter(oldTriggerId, oldRouterId);
        this.saveFileTriggerRouter(fileTriggerRouter);
    }

    @Override
    public void deleteFileTriggerRouter(String triggerId, String routerId) {
        this.sqlTemplate.update(this.getSql("deleteFileTriggerRouterSql"), new Object[]{triggerId, routerId});
        this.clearCache();
    }

    @Override
    public void deleteAllFileTriggerRouters() {
        this.sqlTemplate.update(this.getSql("deleteAllFileTriggerRoutersSql"), new Object[0]);
        this.clearCache();
    }

    @Override
    public void deleteFileTriggerRouter(FileTriggerRouter fileTriggerRouter) {
        this.sqlTemplate.update(this.getSql("deleteFileTriggerRouterSql"), new Object[]{fileTriggerRouter.getFileTrigger().getTriggerId(), fileTriggerRouter.getRouter().getRouterId()});
        this.clearCache();
    }

    @Override
    public void deleteFileTrigger(FileTrigger fileTrigger) {
        this.deleteFileTrigger(fileTrigger.getTriggerId());
    }

    private void deleteFileTrigger(String id) {
        this.sqlTemplate.update(this.getSql("deleteFileTriggerSql"), new Object[]{id});
    }

    @Override
    public void deleteAllFileTriggers() {
        this.sqlTemplate.update(this.getSql("deleteAllFileTriggersSql"), new Object[0]);
        this.clearCache();
    }

    @Override
    public DirectorySnapshot getDirectorySnapshot(FileTriggerRouter fileTriggerRouter) {
        return new DirectorySnapshot(fileTriggerRouter, this.sqlTemplate.query(this.getSql("selectFileSnapshotSql"), (ISqlRowMapper)new FileSnapshotMapper(), new Object[]{fileTriggerRouter.getFileTrigger().getTriggerId(), fileTriggerRouter.getRouter().getRouterId()}));
    }

    public DirectorySnapshot getDirectorySnapshot(FileTriggerRouter fileTriggerRouter, String relativeDir) {
        return new DirectorySnapshot(fileTriggerRouter, this.sqlTemplate.query(this.getSql("selectFileSnapshotSql", "relativeDirWhere"), (ISqlRowMapper)new FileSnapshotMapper(), new Object[]{fileTriggerRouter.getFileTrigger().getTriggerId(), fileTriggerRouter.getRouter().getRouterId(), relativeDir}));
    }

    public void save(List<FileSnapshot> changes, boolean shouldIgnore) {
        if (changes != null) {
            ISqlTransaction sqlTransaction = null;
            try {
                sqlTransaction = this.sqlTemplate.startSqlTransaction();
                if (shouldIgnore) {
                    this.engine.getSymmetricDialect().disableSyncTriggers(sqlTransaction, null);
                }
                for (FileSnapshot fileSnapshot : changes) {
                    this.save(sqlTransaction, fileSnapshot);
                }
                sqlTransaction.commit();
            }
            catch (Error ex) {
                if (sqlTransaction != null) {
                    sqlTransaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (sqlTransaction != null) {
                    sqlTransaction.rollback();
                }
                throw ex;
            }
            finally {
                if (shouldIgnore && sqlTransaction != null) {
                    this.engine.getSymmetricDialect().enableSyncTriggers(sqlTransaction);
                }
                this.close(sqlTransaction);
            }
        }
    }

    public void save(ISqlTransaction sqlTransaction, FileSnapshot snapshot) {
        snapshot.setLastUpdateTime(new Date());
        if (0 >= sqlTransaction.prepareAndExecute(this.getSql("updateFileSnapshotSql"), new Object[]{snapshot.getLastEventType().getCode(), snapshot.getCrc32Checksum(), snapshot.getFileSize(), snapshot.getFileModifiedTime(), snapshot.getLastUpdateTime(), snapshot.getLastUpdateBy(), snapshot.getChannelId(), snapshot.getReloadChannelId(), snapshot.getTriggerId(), snapshot.getRouterId(), snapshot.getRelativeDir(), snapshot.getFileName()}, new int[]{12, 2, 2, 2, 93, 12, 12, 12, 12, 12, 12, 12})) {
            snapshot.setCreateTime(snapshot.getLastUpdateTime());
            sqlTransaction.prepareAndExecute(this.getSql("insertFileSnapshotSql"), new Object[]{snapshot.getLastEventType().getCode(), snapshot.getCrc32Checksum(), snapshot.getFileSize(), snapshot.getFileModifiedTime(), snapshot.getCreateTime(), snapshot.getLastUpdateTime(), snapshot.getLastUpdateBy(), snapshot.getChannelId(), snapshot.getReloadChannelId(), snapshot.getTriggerId(), snapshot.getRouterId(), snapshot.getRelativeDir(), snapshot.getFileName()}, new int[]{12, 2, 2, 2, 93, 93, 12, 12, 12, 12, 12, 12, 12});
        }
        if (snapshot.getLastEventType() == FileSnapshot.LastEventType.DELETE) {
            sqlTransaction.prepareAndExecute(this.getSql("deleteFileSnapshotSql"), new Object[]{snapshot.getTriggerId(), snapshot.getRouterId(), snapshot.getRelativeDir(), snapshot.getFileName()}, new int[]{12, 12, 12, 12});
        }
    }

    @Override
    public synchronized RemoteNodeStatuses pullFilesFromNodes(boolean force) {
        NodeCommunication.CommunicationType communicationType = this.engine.getParameterService().is("node.offline") ? NodeCommunication.CommunicationType.OFF_FSPULL : NodeCommunication.CommunicationType.FILE_PULL;
        return this.queueJob(force, this.parameterService.getLong("file.pull.period.minimum.ms", -1L), "File Sync Pull", communicationType);
    }

    @Override
    public synchronized RemoteNodeStatuses pushFilesToNodes(boolean force) {
        NodeCommunication.CommunicationType communicationType = this.engine.getParameterService().is("node.offline") ? NodeCommunication.CommunicationType.OFF_FSPUSH : NodeCommunication.CommunicationType.FILE_PUSH;
        return this.queueJob(force, this.parameterService.getLong("file.push.period.minimum.ms", -1L), "File Sync Push", communicationType);
    }

    @Override
    public Object[] getStagingPathComponents(OutgoingBatch fileSyncBatch) {
        StringBuilder zipName = new StringBuilder(32);
        zipName.append("filesync_").append(fileSyncBatch.getNodeBatchId()).append(".zip");
        return new String[]{"outgoing", fileSyncBatch.getNodeId(), zipName.toString()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OutgoingBatch> sendFiles(ProcessInfo processInfo, Node targetNode, IOutgoingTransport outgoingTransport) {
        List<OutgoingBatch> batchesToProcess = this.getBatchesToProcess(targetNode);
        if (batchesToProcess.isEmpty()) {
            return batchesToProcess;
        }
        IStagingManager stagingManager = this.engine.getStagingManager();
        long maxBytesToSync = this.parameterService.getLong("transport.max.bytes.to.sync");
        ArrayList<OutgoingBatch> processedBatches = new ArrayList<OutgoingBatch>();
        AbstractBatch currentBatch = null;
        IStagedResource stagedResource = null;
        IStagedResource previouslyStagedResource = null;
        FileSyncZipDataWriter dataWriter = null;
        try {
            long syncedBytes = 0L;
            try {
                for (int i = 0; i < batchesToProcess.size() && !this.isWaitForExtractionRequired((OutgoingBatch)(currentBatch = batchesToProcess.get(i)), previouslyStagedResource = this.getStagedResource((OutgoingBatch)currentBatch)); ++i) {
                    if (this.isFlushBatchesRequired((OutgoingBatch)currentBatch, processedBatches, previouslyStagedResource)) {
                    } else {
                        if (previouslyStagedResource != null) {
                            this.log.debug("Using existing extraction for file sync batch {}", (Object)currentBatch.getNodeBatchId());
                            stagedResource = previouslyStagedResource;
                        } else {
                            if (dataWriter == null) {
                                stagedResource = stagingManager.create(new Object[]{"outgoing", processInfo.getSourceNodeId(), targetNode.getNodeId(), "filesync.zip"});
                                dataWriter = new FileSyncZipDataWriter(maxBytesToSync, this, this.engine.getNodeService(), stagedResource, this.engine.getExtensionService(), this.engine.getConfigurationService());
                            }
                            this.log.debug("Extracting batch {} for filesync.", (Object)currentBatch.getNodeBatchId());
                            ((DataExtractorService)this.engine.getDataExtractorService()).extractOutgoingBatch(processInfo, targetNode, dataWriter, (OutgoingBatch)currentBatch, false, true, DataExtractorService.ExtractMode.FOR_SYM_CLIENT, null);
                        }
                        processedBatches.add((OutgoingBatch)currentBatch);
                        processInfo.incrementBatchCount();
                        processInfo.setCurrentBatchId(currentBatch.getBatchId());
                        this.log.debug("Processed file sync batch {}. syncedBytes={}, maxBytesToSync={}", new Object[]{currentBatch, syncedBytes += stagedResource.getSize(), maxBytesToSync});
                        if (previouslyStagedResource == null) {
                            if (!dataWriter.readyToSend()) continue;
                        }
                    }
                    break;
                }
            }
            finally {
                if (dataWriter != null) {
                    dataWriter.finish();
                }
            }
            processInfo.setStatus(ProcessInfo.ProcessStatus.TRANSFERRING);
            for (OutgoingBatch outgoingBatch : processedBatches) {
                outgoingBatch.setStatus(AbstractBatch.Status.SE);
            }
            this.engine.getOutgoingBatchService().updateOutgoingBatches(processedBatches);
            try {
                if (stagedResource != null && stagedResource.exists()) {
                    InputStream is = stagedResource.getInputStream();
                    try {
                        OutputStream os = outgoingTransport.openStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        os.flush();
                    }
                    catch (IOException e) {
                        throw new IoException((Exception)e);
                    }
                } else {
                    this.log.error("Missing staged ZIP file for target node {}: {}", (Object)targetNode, (Object)(stagedResource == null ? "<null>" : stagedResource));
                }
                for (int i = 0; i < batchesToProcess.size(); ++i) {
                    batchesToProcess.get(i).setStatus(AbstractBatch.Status.LD);
                }
                this.engine.getOutgoingBatchService().updateOutgoingBatches(batchesToProcess);
            }
            finally {
                if (stagedResource != null) {
                    stagedResource.close();
                }
            }
        }
        catch (RuntimeException e) {
            if (stagedResource == previouslyStagedResource) {
                stagedResource = null;
            }
            if (currentBatch != null) {
                this.engine.getStatisticManager().incrementDataExtractedErrors(currentBatch.getChannelId(), 1L);
                currentBatch.setSqlMessage(ExceptionUtils.getRootMessage((Throwable)e));
                currentBatch.revertStatsOnError();
                if (currentBatch.getStatus() != AbstractBatch.Status.IG) {
                    currentBatch.setStatus(AbstractBatch.Status.ER);
                }
                currentBatch.setErrorFlag(true);
                this.engine.getOutgoingBatchService().updateOutgoingBatch((OutgoingBatch)currentBatch);
                if (this.isStreamClosedByClient(e)) {
                    this.log.warn("Failed to extract file sync batch {}.  The stream was closed by the client.  The error was: {}", (Object)currentBatch, (Object)ExceptionUtils.getRootMessage((Throwable)e));
                } else {
                    this.log.error("Failed to extract file sync batch " + currentBatch, (Throwable)e);
                }
            } else {
                this.log.error("Could not log the outgoing batch status because the batch was null", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (stagedResource != null) {
                stagedResource.delete();
            }
        }
        return processedBatches;
    }

    private boolean isFlushBatchesRequired(OutgoingBatch currentBatch, List<OutgoingBatch> processedBatches, IStagedResource previouslyStagedResource) {
        boolean isFlushBatchesRequred;
        boolean bl = isFlushBatchesRequred = previouslyStagedResource != null && !processedBatches.isEmpty();
        if (isFlushBatchesRequred) {
            this.log.info("Batch will be sent on the next sync. {} Need to flush newly staged file sync batches now.", (Object)currentBatch.getNodeBatchId());
        }
        return isFlushBatchesRequred;
    }

    private boolean isWaitForExtractionRequired(OutgoingBatch currentBatch, IStagedResource previouslyStagedResource) {
        Channel channel = this.engine.getConfigurationService().getChannel(currentBatch.getChannelId());
        if (previouslyStagedResource == null && channel.isReloadFlag() && this.parameterService.is("initial.load.use.extract.job.enabled")) {
            if (currentBatch.getStatus() == AbstractBatch.Status.RQ) {
                this.log.info("Batch needs to be extracted by the extract job {}", (Object)currentBatch.getNodeBatchId());
            } else {
                this.log.info("Batch has status of '{}' but is not extracted. Requesting re-extract for batch: {}", (Object)currentBatch.getStatus(), (Object)currentBatch.getNodeBatchId());
                this.engine.getDataExtractorService().resetExtractRequest(currentBatch);
            }
            return true;
        }
        return false;
    }

    protected List<OutgoingBatch> getBatchesToProcess(Node targetNode) {
        ArrayList<OutgoingBatch> batchesToProcess = new ArrayList<OutgoingBatch>();
        List<Channel> fileSyncChannels = this.engine.getConfigurationService().getFileSyncChannels();
        OutgoingBatches batches = this.engine.getOutgoingBatchService().getOutgoingBatches(targetNode.getNodeId(), false);
        for (Channel channel : fileSyncChannels) {
            batchesToProcess.addAll(batches.filterBatchesForChannel(channel));
        }
        return batchesToProcess;
    }

    @Override
    public void acknowledgeFiles(OutgoingBatch outgoingBatch) {
        this.log.debug("Acknowledging file_sync outgoing batch-{}", (Object)outgoingBatch.getBatchId());
        ArrayList<File> filesToDelete = new ArrayList<File>();
        Table snapshotTable = this.platform.getTableFromCache(TableConstants.getTableName(this.tablePrefix, "file_snapshot"), false);
        ISqlReadCursor<Data> cursor = this.engine.getDataService().selectDataFor(outgoingBatch.getBatchId(), outgoingBatch.getChannelId());
        Data data = (Data)cursor.next();
        while (data != null) {
            if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
                Map columnData = data.toColumnNameValuePairs(snapshotTable.getColumnNames(), "rowData");
                FileSnapshot fileSnapshot = new FileSnapshot();
                fileSnapshot.setTriggerId((String)columnData.get("TRIGGER_ID"));
                fileSnapshot.setRouterId((String)columnData.get("ROUTER_ID"));
                fileSnapshot.setFileModifiedTime(Long.parseLong((String)columnData.get("FILE_MODIFIED_TIME")));
                fileSnapshot.setFileName((String)columnData.get("FILE_NAME"));
                fileSnapshot.setRelativeDir((String)columnData.get("RELATIVE_DIR"));
                fileSnapshot.setLastEventType(FileSnapshot.LastEventType.fromCode((String)columnData.get("LAST_EVENT_TYPE")));
                FileTriggerRouter triggerRouter = this.getFileTriggerRouter(fileSnapshot.getTriggerId(), fileSnapshot.getRouterId(), false);
                if (triggerRouter != null) {
                    File file;
                    FileTrigger fileTrigger = triggerRouter.getFileTrigger();
                    if (fileTrigger.isDeleteAfterSync()) {
                        file = fileTrigger.createSourceFile(fileSnapshot);
                        if (!file.isDirectory()) {
                            filesToDelete.add(file);
                            if (fileTrigger.isSyncOnCtlFile()) {
                                filesToDelete.add(this.getControleFile(file));
                            }
                        }
                    } else if (this.parameterService.is("file.sync.delete.ctl.file.after.sync", false) && !(file = fileTrigger.createSourceFile(fileSnapshot)).isDirectory() && fileTrigger.isSyncOnCtlFile()) {
                        filesToDelete.add(this.getControleFile(file));
                    }
                }
            }
            data = (Data)cursor.next();
        }
        cursor.close();
        cursor = null;
        if (filesToDelete != null && filesToDelete.size() > 0) {
            for (File file : filesToDelete) {
                if (file != null && file.exists()) {
                    this.log.debug("Deleting the '{}' file", (Object)file.getAbsolutePath());
                    boolean deleted = FileUtils.deleteQuietly((File)file);
                    if (!deleted) {
                        this.log.warn("Failed to 'delete on sync' the {} file", (Object)file.getAbsolutePath());
                    }
                }
                file = null;
            }
            filesToDelete = null;
        }
    }

    @Override
    public void loadFilesFromPush(String nodeId, InputStream in, OutputStream out) {
        INodeService nodeService = this.engine.getNodeService();
        Node local = nodeService.findIdentity();
        Node sourceNode = nodeService.findNode(nodeId, true);
        if (local != null && sourceNode != null) {
            ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(nodeId, local.getNodeId(), ProcessType.FILE_SYNC_PUSH_HANDLER));
            try {
                List<IncomingBatch> list = this.processZip(in, nodeId, processInfo);
                NodeSecurity security = nodeService.findNodeSecurity(local.getNodeId(), true);
                processInfo.setStatus(ProcessInfo.ProcessStatus.ACKING);
                this.engine.getTransportManager().writeAcknowledgement(out, sourceNode, list, local, security != null ? security.getNodePassword() : null);
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
            catch (Throwable e) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                if (e instanceof IOException) {
                    throw new IoException((Exception)((IOException)e));
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        } else {
            throw new SymmetricException("Could not load data because the node is not registered", new Object[0]);
        }
    }

    protected IStagedResource getStagedResource(OutgoingBatch currentBatch) {
        IStagedResource stagedResource = this.engine.getStagingManager().find(this.getStagingPathComponents(currentBatch));
        if (stagedResource != null && stagedResource.getState() == IStagedResource.State.DONE) {
            return stagedResource;
        }
        return null;
    }

    @Override
    public void execute(NodeCommunication nodeCommunication, RemoteNodeStatus status) {
        NodeSecurity security;
        Node identity = this.engine.getNodeService().findIdentity();
        if (identity != null && (security = this.engine.getNodeService().findNodeSecurity(identity.getNodeId(), true)) != null) {
            if (nodeCommunication.getCommunicationType() == NodeCommunication.CommunicationType.FILE_PULL || nodeCommunication.getCommunicationType() == NodeCommunication.CommunicationType.OFF_FSPULL) {
                this.pullFilesFromNode(nodeCommunication, status, identity, security);
            } else if (nodeCommunication.getCommunicationType() == NodeCommunication.CommunicationType.FILE_PUSH || nodeCommunication.getCommunicationType() == NodeCommunication.CommunicationType.OFF_FSPUSH) {
                this.pushFilesToNode(nodeCommunication, status, identity, security);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void pushFilesToNode(NodeCommunication nodeCommunication, RemoteNodeStatus status, Node identity, NodeSecurity security) {
        ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(nodeCommunication.getNodeId(), identity.getNodeId(), ProcessType.FILE_SYNC_PUSH_JOB));
        IOutgoingTransport transport = null;
        ITransportManager transportManager = null;
        try {
            if (!this.engine.getParameterService().is("node.offline")) {
                transportManager = this.engine.getTransportManager();
                transport = transportManager.getFilePushTransport(nodeCommunication.getNode(), identity, security.getNodePassword(), this.parameterService.getRegistrationUrl());
            } else {
                transportManager = ((AbstractSymmetricEngine)this.engine).getOfflineTransportManager();
                transport = transportManager.getFilePushTransport(nodeCommunication.getNode(), identity, security.getNodePassword(), this.parameterService.getRegistrationUrl());
            }
            List<OutgoingBatch> batches = this.sendFiles(processInfo, nodeCommunication.getNode(), transport);
            if (batches.size() > 0) {
                if (transport instanceof FileOutgoingTransport) {
                    ((FileOutgoingTransport)transport).setProcessedBatches(batches);
                }
                if (transport.isOpen()) {
                    List<BatchAck> batchAcks = this.readAcks(batches, (IOutgoingWithResponseTransport)transport, transportManager, this.engine.getAcknowledgeService(), null);
                    status.updateOutgoingStatus(batches, batchAcks);
                }
            }
            if (!status.failed() && batches.size() > 0) {
                this.log.info("Pushed files to {}. {} files and {} batches were processed", new Object[]{nodeCommunication.getNodeId(), status.getDataProcessed(), status.getBatchesProcessed()});
            } else if (status.failed()) {
                this.log.info("There was a failure while pushing files to {}. {} files and {} batches were processed", new Object[]{nodeCommunication.getNodeId(), status.getDataProcessed(), status.getBatchesProcessed()});
            }
            if (processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
            if (transport == null) return;
        }
        catch (Exception e) {
            try {
                this.fireOffline(e, nodeCommunication.getNode(), status);
                if (processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                if (transport == null) return;
            }
            catch (Throwable throwable) {
                if (processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                if (transport == null) throw throwable;
                transport.close();
                if (!(transport instanceof FileOutgoingTransport)) throw throwable;
                ((FileOutgoingTransport)transport).complete(processInfo.getStatus() == ProcessInfo.ProcessStatus.OK);
                throw throwable;
            }
            transport.close();
            if (!(transport instanceof FileOutgoingTransport)) return;
            ((FileOutgoingTransport)transport).complete(processInfo.getStatus() == ProcessInfo.ProcessStatus.OK);
            return;
        }
        transport.close();
        if (!(transport instanceof FileOutgoingTransport)) return;
        ((FileOutgoingTransport)transport).complete(processInfo.getStatus() == ProcessInfo.ProcessStatus.OK);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IncomingBatch> processZip(InputStream is, String sourceNodeId, ProcessInfo processInfo) throws IOException {
        File unzipDir;
        block36: {
            unzipDir = new File(this.parameterService.getTempDirectory(), String.format("filesync_incoming/%s/%s", this.engine.getNodeService().findIdentityNodeId(), sourceNodeId));
            FileUtils.deleteDirectory((File)unzipDir);
            unzipDir.mkdirs();
            try {
                AppUtils.unzip((InputStream)is, (File)unzipDir);
            }
            catch (IoException ex) {
                if (ex.toString().contains("EOFException")) break block36;
                throw ex;
            }
        }
        TreeSet<Long> batchIds = new TreeSet<Long>();
        String[] files = unzipDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    batchIds.add(Long.parseLong(files[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.log.error("Unexpected directory name.  Expected a number representing a batch id.  Instead the directory was named '{}'", (Object)files[i]);
                }
            }
        }
        ArrayList<IncomingBatch> batchesProcessed = new ArrayList<IncomingBatch>();
        IIncomingBatchService incomingBatchService = this.engine.getIncomingBatchService();
        processInfo.setStatus(ProcessInfo.ProcessStatus.LOADING);
        for (Long batchId : batchIds) {
            processInfo.setCurrentBatchId(batchId);
            processInfo.incrementBatchCount();
            File batchDir = new File(unzipDir, Long.toString(batchId));
            IncomingBatch incomingBatch = new IncomingBatch();
            File batchInfo = new File(batchDir, "batch-info.txt");
            if (batchInfo.exists()) {
                List info = FileUtils.readLines((File)batchInfo, (Charset)Charset.defaultCharset());
                if (info != null && info.size() > 0) {
                    incomingBatch.setChannelId(((String)info.get(0)).trim());
                } else {
                    incomingBatch.setChannelId("filesync");
                }
            } else {
                incomingBatch.setChannelId("filesync");
            }
            incomingBatch.setBatchId(batchId);
            incomingBatch.setStatus(AbstractBatch.Status.LD);
            incomingBatch.setNodeId(sourceNodeId);
            incomingBatch.setByteCount(FileUtils.sizeOfDirectory((File)batchDir));
            batchesProcessed.add(incomingBatch);
            if (!incomingBatchService.acquireIncomingBatch(incomingBatch)) continue;
            File syncScript = new File(batchDir, "sync.bsh");
            if (syncScript.exists()) {
                String script = FileUtils.readFileToString((File)syncScript, (Charset)Charset.defaultCharset());
                Interpreter interpreter = new Interpreter();
                boolean isLocked = false;
                try {
                    this.setInterpreterVariables(this.engine, sourceNodeId, batchDir, interpreter);
                    long waitMillis = this.getParameterService().getLong("file.sync.lock.wait.ms");
                    this.log.debug("The {} node is attempting to get shared lock for to update incoming status", (Object)sourceNodeId);
                    isLocked = this.engine.getClusterService().lock("FILE_SYNC_SHARED", "SHARED", waitMillis);
                    if (isLocked) {
                        this.log.debug("The {} node got a shared file sync lock", (Object)sourceNodeId);
                        int retryFileSyncCount = this.parameterService.getInt("file.sync.retry.count", 2);
                        long retryFileSyncDelayMs = this.parameterService.getLong("file.sync.retry.delay.ms", 5000L);
                        for (int i = 0; i < retryFileSyncCount; ++i) {
                            if (i > 0) {
                                try {
                                    this.log.info("Retrying file sync for batch {}", (Object)batchId);
                                    Thread.sleep(retryFileSyncDelayMs);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            try {
                                Map filesToEventType = (Map)interpreter.eval(script);
                                if (this.engine.getParameterService().is("file.sync.prevent.ping.back")) {
                                    this.updateFileIncoming(sourceNodeId, filesToEventType);
                                }
                                incomingBatch.setLoadRowCount(filesToEventType != null ? (long)filesToEventType.size() : 0L);
                                break;
                            }
                            catch (Throwable e) {
                                Throwable t;
                                this.log.error(e.getMessage(), e);
                                Throwable target = e;
                                if (e instanceof TargetError && (t = ((TargetError)e).getTarget()) != null) {
                                    target = t;
                                }
                                if (target instanceof FileSystemException) {
                                    if (i + 1 < retryFileSyncCount) continue;
                                    throw target;
                                }
                                throw target;
                            }
                        }
                    } else {
                        throw new RuntimeException("Could not obtain file sync shared lock within " + waitMillis + " millis");
                    }
                    incomingBatch.setStatus(AbstractBatch.Status.OK);
                    if (incomingBatchService.isRecordOkBatchesEnabled()) {
                        incomingBatchService.updateIncomingBatch(incomingBatch);
                        continue;
                    }
                    if (!incomingBatch.isRetry()) continue;
                    incomingBatchService.deleteIncomingBatch(incomingBatch);
                    continue;
                }
                catch (Throwable ex) {
                    Throwable target;
                    if (ex instanceof TargetError && (target = ((TargetError)ex).getTarget()) != null) {
                        ex = target;
                    }
                    String nodeIdBatchId = sourceNodeId + "-" + batchId;
                    if (ex instanceof EvalError) {
                        this.log.error("Failed to evalulate the script as part of file sync batch " + nodeIdBatchId + "\n" + script + "\n", ex);
                    } else if (ex instanceof FileConflictException) {
                        this.log.error(ex.getMessage() + ".  Failed to process file sync batch " + nodeIdBatchId);
                    } else {
                        this.log.error("Failed to process file sync for  batch " + nodeIdBatchId, ex);
                    }
                    incomingBatch.setErrorFlag(true);
                    incomingBatch.setStatus(AbstractBatch.Status.ER);
                    incomingBatch.setSqlMessage(ex.getMessage());
                    if (incomingBatchService.isRecordOkBatchesEnabled() || incomingBatch.isRetry()) {
                        incomingBatchService.updateIncomingBatch(incomingBatch);
                    } else {
                        incomingBatchService.insertIncomingBatch(incomingBatch);
                    }
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                    break;
                }
                finally {
                    this.log.debug("The {} node is done processing file sync files", (Object)sourceNodeId);
                    if (!isLocked) continue;
                    this.engine.getClusterService().unlock("FILE_SYNC_SHARED", "SHARED");
                    continue;
                }
            }
            this.log.error("Could not find the sync.bsh script for batch {}", (Object)batchId);
        }
        return batchesProcessed;
    }

    protected void setInterpreterVariables(ISymmetricEngine engine, String sourceNodeId, File batchDir, Interpreter interpreter) throws EvalError {
        interpreter.set("log", (Object)this.log);
        interpreter.set("batchDir", (Object)batchDir.getAbsolutePath().replace('\\', '/'));
        interpreter.set("engine", (Object)engine);
        interpreter.set("sourceNodeId", (Object)sourceNodeId);
    }

    protected void updateFileIncoming(String nodeId, Map<String, String> filesToEventType) {
        Set<String> filePaths = filesToEventType.keySet();
        for (String filePath : filePaths) {
            String eventType = filesToEventType.get(filePath);
            File file = new File(filePath);
            String fileName = file.getName();
            String dirName = file.getParentFile().getPath().replace('\\', '/');
            long lastUpdateTime = file.lastModified();
            int updateCount = this.sqlTemplate.update(this.getSql("updateFileIncoming"), new Object[]{nodeId, lastUpdateTime, eventType, dirName, fileName});
            if (updateCount > 0) continue;
            this.sqlTemplate.update(this.getSql("insertFileIncoming"), new Object[]{nodeId, lastUpdateTime, eventType, dirName, fileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void pullFilesFromNode(NodeCommunication nodeCommunication, RemoteNodeStatus status, Node identity, NodeSecurity security) {
        IIncomingTransport transport;
        block13: {
            transport = null;
            ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(nodeCommunication.getNodeId(), identity.getNodeId(), ProcessType.FILE_SYNC_PULL_JOB));
            try {
                ITransportManager transportManager;
                processInfo.setStatus(ProcessInfo.ProcessStatus.TRANSFERRING);
                if (!this.engine.getParameterService().is("node.offline")) {
                    transportManager = this.engine.getTransportManager();
                    transport = transportManager.getFilePullTransport(nodeCommunication.getNode(), identity, security.getNodePassword(), null, this.parameterService.getRegistrationUrl());
                } else {
                    transportManager = ((AbstractSymmetricEngine)this.engine).getOfflineTransportManager();
                    transport = transportManager.getFilePullTransport(nodeCommunication.getNode(), identity, security.getNodePassword(), null, this.parameterService.getRegistrationUrl());
                }
                List<IncomingBatch> batchesProcessed = this.processZip(transport.openStream(), nodeCommunication.getNodeId(), processInfo);
                if (batchesProcessed.size() > 0) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ACKING);
                    status.updateIncomingStatus(batchesProcessed);
                    this.sendAck(nodeCommunication.getNode(), identity, security, batchesProcessed, transportManager, status.getQueue());
                }
                if (!status.failed() && batchesProcessed.size() > 0) {
                    this.log.info("Pull files received from {}.  {} files and {} batches were processed", new Object[]{nodeCommunication.getNodeId(), status.getDataProcessed(), status.getBatchesProcessed()});
                } else if (status.failed()) {
                    this.log.info("There was a failure while pulling files from {}.  {} files and {} batches were processed", new Object[]{nodeCommunication.getNodeId(), status.getDataProcessed(), status.getBatchesProcessed()});
                }
                if (transport == null) return;
                transport.close();
                if (processInfo.getStatus() == ProcessInfo.ProcessStatus.ERROR) break block13;
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
            catch (NoContentException noContentEx) {
                block14: {
                    this.log.debug("Server reported no batches. " + (Object)((Object)noContentEx));
                    if (transport == null) return;
                    transport.close();
                    if (processInfo.getStatus() == ProcessInfo.ProcessStatus.ERROR) break block14;
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                if (!(transport instanceof FileIncomingTransport)) return;
                ((FileIncomingTransport)transport).complete(!status.failed());
                return;
            }
            catch (Exception e) {
                block15: {
                    this.fireOffline(e, nodeCommunication.getNode(), status);
                    if (transport == null) return;
                    transport.close();
                    if (processInfo.getStatus() == ProcessInfo.ProcessStatus.ERROR) break block15;
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                    {
                        catch (Throwable throwable) {
                            if (transport == null) throw throwable;
                            transport.close();
                            if (processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                            }
                            if (!(transport instanceof FileIncomingTransport)) throw throwable;
                            ((FileIncomingTransport)transport).complete(!status.failed());
                            throw throwable;
                        }
                    }
                }
                if (!(transport instanceof FileIncomingTransport)) return;
                ((FileIncomingTransport)transport).complete(!status.failed());
                return;
            }
        }
        if (!(transport instanceof FileIncomingTransport)) return;
        ((FileIncomingTransport)transport).complete(!status.failed());
        return;
    }

    protected RemoteNodeStatuses queueJob(boolean force, long minimumPeriodMs, String clusterLock, NodeCommunication.CommunicationType type) {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses(this.engine.getConfigurationService().getChannels(false));
        Node identity = this.engine.getNodeService().findIdentity();
        if (identity != null && identity.isSyncEnabled()) {
            if (force || !this.engine.getClusterService().isInfiniteLocked(clusterLock)) {
                INodeCommunicationService nodeCommunicationService = this.engine.getNodeCommunicationService();
                List<NodeCommunication> nodes = nodeCommunicationService.list(type);
                int availableThreads = nodeCommunicationService.getAvailableThreads(type);
                for (NodeCommunication nodeCommunication : nodes) {
                    if (StringUtils.isNotBlank((CharSequence)nodeCommunication.getNode().getSyncUrl()) || !this.parameterService.isRegistrationServer()) {
                        boolean meetsMinimumTime = true;
                        if (minimumPeriodMs > 0L && nodeCommunication.getLastLockTime() != null && System.currentTimeMillis() - nodeCommunication.getLastLockTime().getTime() < minimumPeriodMs) {
                            meetsMinimumTime = false;
                        }
                        if (availableThreads <= 0 || !meetsMinimumTime || !nodeCommunicationService.execute(nodeCommunication, statuses, this)) continue;
                        --availableThreads;
                        continue;
                    }
                    this.log.warn("File sync cannot communicate with node '{}' in the group '{}'.  The sync url is blank", (Object)nodeCommunication.getNode().getNodeId(), (Object)nodeCommunication.getNode().getNodeGroupId());
                }
            } else {
                this.log.debug("Did not run the {} process because it has been stopped", (Object)type.name().toLowerCase());
            }
        }
        return statuses;
    }

    protected String getEffectiveBaseDir(String baseDir) {
        String effectiveBaseDir = baseDir == null ? null : baseDir.replace('\\', '/');
        return effectiveBaseDir;
    }

    @Override
    public File getControleFile(File file) {
        File ctlFile = new File(file.getAbsolutePath() + ".ctl");
        if (this.engine.getParameterService().is("file.sync.use.ctl.as.file.ext", false)) {
            int extPosition = file.getAbsolutePath().lastIndexOf(46);
            ctlFile = new File(file.getAbsolutePath().substring(0, extPosition) + ".ctl");
        }
        return ctlFile;
    }

    @Override
    public void save(List<FileSnapshot> changes) {
    }

    static class FileSnapshotMapper
    implements ISqlRowMapper<FileSnapshot> {
        FileSnapshotMapper() {
        }

        public FileSnapshot mapRow(Row rs) {
            FileSnapshot fileSnapshot = new FileSnapshot();
            fileSnapshot.setCrc32Checksum(rs.getLong("crc32_checksum"));
            fileSnapshot.setCreateTime(rs.getDateTime("create_time"));
            fileSnapshot.setChannelId(rs.getString("channel_id"));
            fileSnapshot.setReloadChannelId(rs.getString("reload_channel_id"));
            fileSnapshot.setLastUpdateBy(rs.getString("last_update_by"));
            fileSnapshot.setLastUpdateTime(rs.getDateTime("last_update_time"));
            fileSnapshot.setFileModifiedTime(rs.getLong("file_modified_time"));
            fileSnapshot.setFileName(rs.getString("file_name"));
            fileSnapshot.setRelativeDir(rs.getString("relative_dir") == null ? null : rs.getString("relative_dir").replace('\\', '/'));
            fileSnapshot.setFileSize(rs.getLong("file_size"));
            fileSnapshot.setLastEventType(FileSnapshot.LastEventType.fromCode(rs.getString("last_event_type")));
            fileSnapshot.setTriggerId(rs.getString("trigger_id"));
            fileSnapshot.setRouterId(rs.getString("router_id"));
            return fileSnapshot;
        }
    }

    class FileTriggerRouterMapper
    implements ISqlRowMapper<FileTriggerRouter> {
        FileTriggerRouterMapper() {
        }

        public FileTriggerRouter mapRow(Row rs) {
            FileTriggerRouter fileTriggerRouter = new FileTriggerRouter();
            String triggerId = rs.getString("trigger_id");
            FileTrigger fileTrigger = FileSyncService.this.getFileTrigger(triggerId);
            fileTriggerRouter.setFileTrigger(fileTrigger);
            try {
                fileTriggerRouter.setConflictStrategy(FileConflictStrategy.valueOf(rs.getString("conflict_strategy").toUpperCase()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileTriggerRouter.setConflictStrategyString(rs.getString("conflict_strategy").toUpperCase());
            fileTriggerRouter.setCreateTime(rs.getDateTime("create_time"));
            fileTriggerRouter.setLastUpdateBy(rs.getString("last_update_by"));
            fileTriggerRouter.setLastUpdateTime(rs.getDateTime("last_update_time"));
            fileTriggerRouter.setEnabled(rs.getBoolean("enabled"));
            fileTriggerRouter.setInitialLoadEnabled(rs.getBoolean("initial_load_enabled"));
            fileTriggerRouter.setTargetBaseDir(rs.getString("target_base_dir") == null ? null : rs.getString("target_base_dir").replace('\\', '/'));
            fileTriggerRouter.setRouter(FileSyncService.this.engine.getTriggerRouterService().getRouterById(rs.getString("router_id")));
            return fileTriggerRouter;
        }
    }

    class FileTriggerMapper
    implements ISqlRowMapper<FileTrigger> {
        FileTriggerMapper() {
        }

        public FileTrigger mapRow(Row rs) {
            FileTrigger fileTrigger = new FileTrigger();
            fileTrigger.setBaseDir(FileSyncService.this.getEffectiveBaseDir(rs.getString("base_dir")));
            fileTrigger.setCreateTime(rs.getDateTime("create_time"));
            fileTrigger.setExcludesFiles(rs.getString("excludes_files"));
            fileTrigger.setIncludesFiles(rs.getString("includes_files"));
            fileTrigger.setLastUpdateBy(rs.getString("last_update_by"));
            fileTrigger.setLastUpdateTime(rs.getDateTime("last_update_time"));
            fileTrigger.setRecurse(rs.getBoolean("recurse"));
            fileTrigger.setSyncOnCreate(rs.getBoolean("sync_on_create"));
            fileTrigger.setSyncOnDelete(rs.getBoolean("sync_on_delete"));
            fileTrigger.setAfterCopyScript(rs.getString("after_copy_script"));
            fileTrigger.setBeforeCopyScript(rs.getString("before_copy_script"));
            fileTrigger.setSyncOnModified(rs.getBoolean("sync_on_modified"));
            fileTrigger.setSyncOnCtlFile(rs.getBoolean("sync_on_ctl_file"));
            fileTrigger.setDeleteAfterSync(rs.getBoolean("delete_after_sync"));
            fileTrigger.setTriggerId(rs.getString("trigger_id"));
            fileTrigger.setChannelId(rs.getString("channel_id"));
            fileTrigger.setReloadChannelId(rs.getString("reload_channel_id"));
            return fileTrigger;
        }
    }
}

