/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.List;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.extract.MultiBatchStagingWriter;
import org.jumpmind.symmetric.file.FileSyncZipDataWriter;
import org.jumpmind.symmetric.io.data.IDataProcessorListener;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.impl.DataExtractorService;

public class FileSyncExtractorService
extends DataExtractorService {
    private IFileSyncService fileSyncService;
    private INodeService nodeService;
    private IStagingManager stagingManager;
    private IConfigurationService configurationService;
    private INodeCommunicationService nodeCommunicationService;
    private IExtensionService extensionService;

    public FileSyncExtractorService(ISymmetricEngine engine) {
        super(engine);
        this.fileSyncService = engine.getFileSyncService();
        this.nodeService = engine.getNodeService();
        this.stagingManager = engine.getStagingManager();
        this.configurationService = engine.getConfigurationService();
        this.nodeCommunicationService = engine.getNodeCommunicationService();
        this.extensionService = engine.getExtensionService();
    }

    @Override
    protected boolean isApplicable(NodeCommunication nodeCommunication) {
        return this.parameterService.is("file.sync.enable") && nodeCommunication.getCommunicationType() == NodeCommunication.CommunicationType.FILE_XTRCT;
    }

    @Override
    protected boolean canProcessExtractRequest(ExtractRequest request, NodeCommunication.CommunicationType communicationType) {
        return request.getTableName().equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, "file_snapshot"));
    }

    @Override
    protected IDataWriter wrapWithTransformWriter(Node sourceNode, Node targetNode, ProcessInfo processInfo, IDataWriter dataWriter, boolean useStagingDataWriter) {
        return dataWriter;
    }

    @Override
    protected IStagedResource getStagedResource(OutgoingBatch currentBatch) {
        return this.stagingManager.find(this.fileSyncService.getStagingPathComponents(currentBatch));
    }

    @Override
    protected OutgoingBatch extractOutgoingBatch(ProcessInfo processInfo, Node targetNode, IDataWriter dataWriter, OutgoingBatch currentBatch, boolean useStagingDataWriter, boolean updateBatchStatistics, DataExtractorService.ExtractMode mode, IDataProcessorListener listener) {
        if (!this.parameterService.is("file.sync.enable")) {
            return null;
        }
        Channel channel = this.configurationService.getChannel(currentBatch.getChannelId());
        if (channel.isFileSyncFlag()) {
            return super.extractOutgoingBatch(processInfo, targetNode, dataWriter, currentBatch, useStagingDataWriter, updateBatchStatistics, mode, null);
        }
        this.log.debug("Skipping non-file sync channel {}", (Object)channel);
        return null;
    }

    @Override
    protected MultiBatchStagingWriter buildMultiBatchStagingWriter(ExtractRequest request, List<ExtractRequest> childRequests, Node sourceNode, Node targetNode, List<OutgoingBatch> batches, ProcessInfo processInfo, Channel channel, boolean isRestarted) {
        MultiBatchStagingWriter multiBatchStagingWriter = new MultiBatchStagingWriter(this.engine, request, childRequests, sourceNode.getNodeId(), batches, channel.getMaxBatchSize(), processInfo, isRestarted){

            @Override
            protected IDataWriter buildWriter() {
                IStagedResource stagedResource = this.stagingManager.create(FileSyncExtractorService.this.fileSyncService.getStagingPathComponents(this.outgoingBatch));
                this.log.info("Extracting file sync batch {} to resource '{}'", (Object)this.outgoingBatch.getNodeBatchId(), (Object)stagedResource);
                long maxBytesToSync = FileSyncExtractorService.this.parameterService.getLong("transport.max.bytes.to.sync");
                FileSyncZipDataWriter fileSyncWriter = new FileSyncZipDataWriter(maxBytesToSync, FileSyncExtractorService.this.fileSyncService, FileSyncExtractorService.this.nodeService, stagedResource, FileSyncExtractorService.this.extensionService, FileSyncExtractorService.this.configurationService){

                    @Override
                    public void close() {
                        super.finish();
                    }
                };
                return fileSyncWriter;
            }
        };
        return multiBatchStagingWriter;
    }

    @Override
    protected void queue(String nodeId, String queue, RemoteNodeStatuses statuses) {
        if (this.parameterService.is("file.sync.enable")) {
            NodeCommunication.CommunicationType TYPE = NodeCommunication.CommunicationType.FILE_XTRCT;
            int availableThreads = this.nodeCommunicationService.getAvailableThreads(TYPE);
            NodeCommunication lock = this.nodeCommunicationService.find(nodeId, queue, TYPE);
            if (availableThreads > 0) {
                this.nodeCommunicationService.execute(lock, statuses, this);
            }
        }
    }

    @Override
    protected ProcessType getProcessType() {
        return ProcessType.FILE_SYNC_INITIAL_LOAD_EXTRACT_JOB;
    }
}

