/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DdlBuilderFactory;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.LongMapper;
import org.jumpmind.exception.InterruptedException;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.ConfigurationVersionHelper;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.extract.ExtractDataReaderFactory;
import org.jumpmind.symmetric.extract.IExtractDataReaderFactory;
import org.jumpmind.symmetric.extract.MultiBatchStagingWriter;
import org.jumpmind.symmetric.extract.SelectFromSymDataSource;
import org.jumpmind.symmetric.extract.SelectFromTableEvent;
import org.jumpmind.symmetric.extract.SelectFromTableSource;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.DataProcessor;
import org.jumpmind.symmetric.io.data.IDataProcessorListener;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.io.data.reader.ExtractDataReader;
import org.jumpmind.symmetric.io.data.reader.IExtractDataReaderSource;
import org.jumpmind.symmetric.io.data.reader.ProtocolDataReader;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.symmetric.io.data.writer.IProtocolDataWriterListener;
import org.jumpmind.symmetric.io.data.writer.ProtocolDataWriter;
import org.jumpmind.symmetric.io.data.writer.StagingDataWriter;
import org.jumpmind.symmetric.io.data.writer.StructureDataWriter;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.io.stage.StagingFileLock;
import org.jumpmind.symmetric.io.stage.StagingLowFreeSpace;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatchWithPayload;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoDataWriter;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.TableReloadStatus;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IInitialLoadService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ISequenceService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.ClusterLockRefreshListener;
import org.jumpmind.symmetric.service.impl.DataExtractorServiceSqlMap;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.BatchBufferedWriter;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.CustomizableThreadFactory;
import org.jumpmind.util.ExceptionUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.FutureImpl;
import org.jumpmind.util.Statistics;
import org.slf4j.MDC;

public class DataExtractorService
extends AbstractService
implements IDataExtractorService,
INodeCommunicationService.INodeCommunicationExecutor {
    static final long MS_PASSED_BEFORE_BATCH_REQUERIED = 5000L;
    protected ISymmetricEngine engine;
    IOutgoingBatchService outgoingBatchService;
    private IRouterService routerService;
    private IInitialLoadService initialLoadService;
    private IConfigurationService configurationService;
    private ITriggerRouterService triggerRouterService;
    private ITransformService transformService;
    private ISequenceService sequenceService;
    private IDataService dataService;
    private INodeService nodeService;
    IStatisticManager statisticManager;
    private IStagingManager stagingManager;
    private INodeCommunicationService nodeCommunicationService;
    private IClusterService clusterService;
    private Map<String, BatchLock> locks = new ConcurrentHashMap<String, BatchLock>();
    private CustomizableThreadFactory threadPoolFactory;

    public DataExtractorService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.outgoingBatchService = engine.getOutgoingBatchService();
        this.routerService = engine.getRouterService();
        this.dataService = engine.getDataService();
        this.configurationService = engine.getConfigurationService();
        this.triggerRouterService = engine.getTriggerRouterService();
        this.nodeService = engine.getNodeService();
        this.transformService = engine.getTransformService();
        this.statisticManager = engine.getStatisticManager();
        this.stagingManager = engine.getStagingManager();
        this.nodeCommunicationService = engine.getNodeCommunicationService();
        this.clusterService = engine.getClusterService();
        this.sequenceService = engine.getSequenceService();
        this.initialLoadService = engine.getInitialLoadService();
        this.setSqlMap(new DataExtractorServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public void extractConfigurationStandalone(Node targetNode, Writer writer, String ... tablesToExclude) {
        Node sourceNode = this.nodeService.findIdentity();
        if (targetNode != null && sourceNode != null) {
            TriggerHistory triggerHistory;
            TriggerRouter triggerRouter;
            int i;
            Batch batch = new Batch(Batch.BatchType.EXTRACT, -9999L, "config", this.symmetricDialect.getBinaryEncoding(), sourceNode.getNodeId(), targetNode.getNodeId(), false);
            NodeGroupLink nodeGroupLink = new NodeGroupLink(this.parameterService.getNodeGroupId(), targetNode.getNodeGroupId());
            List<TriggerRouter> configTriggerRouters = this.triggerRouterService.buildTriggerRoutersForSymmetricTables(StringUtils.isBlank((CharSequence)targetNode.getSymmetricVersion()) ? Version.version() : targetNode.getSymmetricVersion(), nodeGroupLink, tablesToExclude);
            ArrayList<SelectFromTableEvent> initialLoadEvents = new ArrayList<SelectFromTableEvent>(configTriggerRouters.size() * 2);
            ConfigurationVersionHelper helper = new ConfigurationVersionHelper(this.symmetricDialect.getTablePrefix(), targetNode);
            ArrayList<TriggerRouter> triggerRouters = new ArrayList<TriggerRouter>();
            ArrayList<TriggerHistory> triggerHistories = new ArrayList<TriggerHistory>();
            for (i = 0; i < configTriggerRouters.size(); ++i) {
                triggerRouter = configTriggerRouters.get(i);
                Trigger trigger = triggerRouter.getTrigger();
                String channelId = trigger.getChannelId();
                String tableName = trigger.getSourceTableName();
                if (!"config".equals(channelId) && !"heartbeat".equals(channelId) || !helper.shouldSendTable(tableName)) continue;
                TriggerHistory triggerHistory2 = this.triggerRouterService.getNewestTriggerHistoryForTrigger(trigger.getTriggerId(), null, null, tableName);
                if (triggerHistory2 == null) {
                    Table table = this.platform.getTableFromCache(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), tableName, false);
                    if (table == null) {
                        throw new IllegalStateException("Could not find a required table: " + tableName);
                    }
                    triggerHistory2 = new TriggerHistory(table, trigger, this.symmetricDialect.getTriggerTemplate());
                    triggerHistory2.setTriggerHistoryId(Integer.MAX_VALUE - i);
                }
                triggerRouters.add(triggerRouter);
                triggerHistories.add(triggerHistory2);
            }
            for (i = triggerRouters.size() - 1; i >= 0; --i) {
                triggerRouter = (TriggerRouter)triggerRouters.get(i);
                triggerHistory = (TriggerHistory)triggerHistories.get(i);
                StringBuilder sql = new StringBuilder(this.symmetricDialect.createPurgeSqlFor(targetNode, triggerRouter, triggerHistory));
                this.addPurgeCriteriaToConfigurationTables(triggerRouter.getTrigger().getSourceTableName(), sql);
                Data data = new Data(1L, null, sql.toString(), DataEventType.SQL, triggerHistory.getSourceTableName(), null, triggerHistory, triggerRouter.getTrigger().getChannelId(), null, null);
                initialLoadEvents.add(new SelectFromTableEvent(data, triggerRouter));
            }
            for (i = 0; i < triggerRouters.size(); ++i) {
                triggerRouter = (TriggerRouter)triggerRouters.get(i);
                triggerHistory = (TriggerHistory)triggerHistories.get(i);
                Table table = this.symmetricDialect.getPlatform().getTableFromCache(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName(), false);
                String initialLoadSql = "1=1 order by ";
                String quote = this.platform.getDdlBuilder().getDatabaseInfo().getDelimiterToken();
                Column[] pkColumns = table.getPrimaryKeyColumns();
                for (int j = 0; j < pkColumns.length; ++j) {
                    if (j > 0) {
                        initialLoadSql = initialLoadSql + ", ";
                    }
                    initialLoadSql = initialLoadSql + quote + pkColumns[j].getName() + quote;
                }
                if (!triggerRouter.getTrigger().getSourceTableName().endsWith("node_identity")) {
                    initialLoadEvents.add(new SelectFromTableEvent(targetNode, triggerRouter, triggerHistory, initialLoadSql));
                    continue;
                }
                Data data = new Data(1L, null, targetNode.getNodeId(), DataEventType.INSERT, triggerHistory.getSourceTableName(), null, triggerHistory, triggerRouter.getTrigger().getChannelId(), null, null);
                initialLoadEvents.add(new SelectFromTableEvent(data, triggerRouter));
            }
            SelectFromTableSource source = new SelectFromTableSource(this.engine, batch, initialLoadEvents);
            source.setConfiguration(true);
            ExtractDataReader dataReader = new ExtractDataReader(this.symmetricDialect.getPlatform(), (IExtractDataReaderSource)source);
            ProtocolDataWriter dataWriter = new ProtocolDataWriter(this.nodeService.findIdentityNodeId(), writer, targetNode.requires13Compatiblity(), false, false);
            List<TransformService.TransformTableNodeGroupLink> transformsList = this.transformService.getConfigExtractTransforms(nodeGroupLink);
            TransformTable[] transforms = transformsList.toArray(new TransformTable[transformsList.size()]);
            TransformWriter transformWriter = new TransformWriter(this.symmetricDialect.getTargetPlatform(), TransformPoint.EXTRACT, (IDataWriter)dataWriter, this.transformService.getColumnTransforms(), transforms);
            DataContext ctx = new DataContext();
            DataProcessor processor = new DataProcessor((IDataReader)dataReader, (IDataWriter)transformWriter, "configuration extract");
            ctx.put("targetNode", (Object)targetNode);
            ctx.put("sourceNode", (Object)sourceNode);
            ctx.put("engine", (Object)this.engine);
            processor.process(ctx);
            if (triggerRouters.size() == 0) {
                this.log.error("{} attempted registration, but was sent an empty configuration", (Object)targetNode);
            }
        }
    }

    private void addPurgeCriteriaToConfigurationTables(String sourceTableName, StringBuilder sql) {
        Node me;
        if ((TableConstants.getTableName(this.parameterService.getTablePrefix(), "node").equalsIgnoreCase(sourceTableName) || TableConstants.getTableName(this.parameterService.getTablePrefix(), "node_security").equalsIgnoreCase(sourceTableName)) && (me = this.nodeService.findIdentity()) != null) {
            sql.append(String.format(" where created_at_node_id='%s'", me.getNodeId()));
        }
    }

    private List<OutgoingBatch> filterBatchesForExtraction(OutgoingBatches batches, ChannelMap suspendIgnoreChannelsList) {
        if (this.parameterService.is("file.sync.enable")) {
            List<Channel> fileSyncChannels = this.configurationService.getFileSyncChannels();
            for (Channel channel : fileSyncChannels) {
                batches.filterBatchesForChannel(channel);
            }
        }
        List<OutgoingBatch> ignoredBatches = batches.filterBatchesForChannels(suspendIgnoreChannelsList.getIgnoreChannels());
        for (OutgoingBatch batch : ignoredBatches) {
            batch.setStatus(AbstractBatch.Status.OK);
            batch.incrementIgnoreCount();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Batch {} is being ignored", (Object)batch.getBatchId());
        }
        this.outgoingBatchService.updateOutgoingBatches(ignoredBatches);
        batches.filterBatchesForChannels(suspendIgnoreChannelsList.getSuspendChannels());
        if (this.parameterService.is("initial.load.block.channels", true) && batches.containsLoadBatches() && (!this.parameterService.is("initial.load.unblock.channels.on.error", true) || !batches.containsBatchesInError())) {
            batches.removeNonLoadBatches();
        }
        return batches.getBatches();
    }

    @Override
    public List<OutgoingBatchWithPayload> extractToPayload(ProcessInfo processInfo, Node targetNode, StructureDataWriter.PayloadType payloadType, boolean useJdbcTimestampFormat, boolean useUpsertStatements, boolean useDelimiterIdentifiers) {
        ChannelMap channelMap;
        List<OutgoingBatch> activeBatches;
        OutgoingBatches batches = this.outgoingBatchService.getOutgoingBatches(targetNode.getNodeId(), false);
        if (batches.containsBatches() && (activeBatches = this.filterBatchesForExtraction(batches, channelMap = this.configurationService.getSuspendIgnoreChannelLists(targetNode.getNodeId()))).size() > 0) {
            IDdlBuilder builder = DdlBuilderFactory.getInstance().create(targetNode.getDatabaseType());
            if (builder == null) {
                throw new IllegalStateException("Could not find a ddl builder registered for the database type of " + targetNode.getDatabaseType() + ".  Please check the database type setting for node '" + targetNode.getNodeId() + "'");
            }
            StructureDataWriter writer = new StructureDataWriter(this.symmetricDialect.getPlatform(), targetNode.getDatabaseType(), payloadType, useDelimiterIdentifiers, this.symmetricDialect.getBinaryEncoding(), useJdbcTimestampFormat, useUpsertStatements);
            List<OutgoingBatch> extractedBatches = this.extract(processInfo, targetNode, activeBatches, (IDataWriter)writer, null, ExtractMode.FOR_PAYLOAD_CLIENT);
            ArrayList<OutgoingBatchWithPayload> batchesWithPayload = new ArrayList<OutgoingBatchWithPayload>();
            for (OutgoingBatch batch : extractedBatches) {
                OutgoingBatchWithPayload batchWithPayload = new OutgoingBatchWithPayload(batch, payloadType);
                batchWithPayload.setPayload((List)writer.getPayloadMap().get(batch.getBatchId()));
                batchWithPayload.setPayloadType(payloadType);
                batchesWithPayload.add(batchWithPayload);
            }
            return batchesWithPayload;
        }
        return Collections.emptyList();
    }

    @Override
    public List<OutgoingBatch> extract(ProcessInfo extractInfo, Node targetNode, IOutgoingTransport transport) {
        return this.extract(extractInfo, targetNode, null, transport);
    }

    @Override
    public List<OutgoingBatch> extract(ProcessInfo extractInfo, Node targetNode, String queue, IOutgoingTransport transport) {
        ChannelMap channelMap;
        List<OutgoingBatch> activeBatches;
        OutgoingBatches batches;
        String startRouteJob = this.parameterService.getString("start.route.job");
        boolean startRoutingJob = false;
        startRoutingJob = StringUtils.isBlank((CharSequence)startRouteJob) ? this.parameterService.is("start.routing.job") : this.parameterService.is("start.route.job");
        if (!startRoutingJob && this.parameterService.is("route.on.extract")) {
            this.initialLoadService.queueLoads(true);
            this.routerService.routeData(true);
        }
        if ((batches = this.loadPendingBatches(extractInfo, targetNode, queue, transport)) != null && batches.containsBatches() && (activeBatches = this.filterBatchesForExtraction(batches, channelMap = transport.getSuspendIgnoreChannelLists(this.configurationService, queue, targetNode))).size() > 0) {
            BufferedWriter writer = transport.openWriter();
            ProtocolDataWriter dataWriter = new ProtocolDataWriter(this.nodeService.findIdentityNodeId(), (Writer)writer, targetNode.requires13Compatiblity(), targetNode.allowCaptureTimeInProtocol(), this.parameterService.is("extract.row.capture.time", true));
            return this.extract(extractInfo, targetNode, activeBatches, (IDataWriter)dataWriter, writer, ExtractMode.FOR_SYM_CLIENT);
        }
        return Collections.emptyList();
    }

    protected OutgoingBatches loadPendingBatches(ProcessInfo extractInfo, Node targetNode, String queue, IOutgoingTransport transport) {
        BufferedWriter writer = transport.getWriter();
        extractInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
        Callable<OutgoingBatches> getOutgoingBatches = () -> {
            MDC.put((String)"engineName", (String)this.engine.getParameterService().getEngineName());
            OutgoingBatches batches = null;
            if (queue != null) {
                NodeGroupLink link = this.configurationService.getNodeGroupLinkFor(this.nodeService.findIdentity().getNodeGroupId(), targetNode.getNodeGroupId(), false);
                if (link != null) {
                    NodeGroupLinkAction defaultAction = this.configurationService.getNodeGroupLinkFor(this.nodeService.findIdentity().getNodeGroupId(), targetNode.getNodeGroupId(), false).getDataEventAction();
                    ProcessType processType = extractInfo.getKey().getProcessType();
                    NodeGroupLinkAction action = null;
                    if (processType.equals((Object)ProcessType.PUSH_JOB_EXTRACT)) {
                        action = NodeGroupLinkAction.P;
                    } else if (processType.equals((Object)ProcessType.PULL_HANDLER_EXTRACT)) {
                        action = NodeGroupLinkAction.W;
                    }
                    batches = this.outgoingBatchService.getOutgoingBatches(targetNode.getNodeId(), queue, action, defaultAction, false);
                } else {
                    this.log.error("Group link not found for " + this.nodeService.findIdentity().getNodeGroupId() + " to " + targetNode.getNodeGroupId() + ".  Check that configuration matches on both nodes.");
                }
            } else {
                batches = this.outgoingBatchService.getOutgoingBatches(targetNode.getNodeId(), false);
            }
            return batches;
        };
        if (writer != null) {
            boolean streamToFileEnabled = this.parameterService.is("stream.to.file.enabled");
            long keepAliveMillis = this.parameterService.getLong("send.ack.keepalive.ms");
            Node sourceNode = this.nodeService.findIdentity();
            FutureTask<OutgoingBatches> getOutgoingBatchesTask = new FutureTask<OutgoingBatches>(getOutgoingBatches);
            ExecutorService executor = Executors.newFixedThreadPool(1);
            executor.execute(getOutgoingBatchesTask);
            while (true) {
                try {
                    OutgoingBatches outgoingBatches = getOutgoingBatchesTask.get(keepAliveMillis, TimeUnit.MILLISECONDS);
                    return outgoingBatches;
                }
                catch (TimeoutException ex) {
                    this.writeKeepAliveAck(writer, sourceNode, streamToFileEnabled);
                    continue;
                }
                catch (Exception ex) {
                    throw new SymmetricException("Failed to execute getOutgoingBatchesTask ", ex);
                }
                break;
            }
            finally {
                executor.shutdown();
            }
        }
        try {
            return getOutgoingBatches.call();
        }
        catch (Exception ex) {
            throw new SymmetricException("Failed to execute getOutgoingBatchesTask ", ex);
        }
    }

    @Override
    public boolean extractOnlyOutgoingBatch(String nodeId, long batchId, Writer writer) {
        OutgoingBatch batch;
        boolean extracted = false;
        Node targetNode = null;
        targetNode = "-1".equals(nodeId) ? new Node(nodeId, this.parameterService.getNodeGroupId()) : this.nodeService.findNode(nodeId, true);
        if (targetNode != null && (batch = this.outgoingBatchService.findOutgoingBatch(batchId, nodeId)) != null) {
            ProtocolDataWriter dataWriter = new ProtocolDataWriter(this.nodeService.findIdentityNodeId(), writer, targetNode.requires13Compatiblity(), targetNode.allowCaptureTimeInProtocol(), this.parameterService.is("extract.row.capture.time", true));
            List<OutgoingBatch> batches = new ArrayList<OutgoingBatch>(1);
            batches.add(batch);
            batches = this.extract(new ProcessInfo(), targetNode, batches, (IDataWriter)dataWriter, null, ExtractMode.EXTRACT_ONLY);
            extracted = batches.size() > 0;
        }
        return extracted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OutgoingBatch> extract(ProcessInfo extractInfo, Node targetNode, List<OutgoingBatch> activeBatches, IDataWriter dataWriter, BufferedWriter writer, ExtractMode mode) {
        if (activeBatches.size() > 0) {
            ArrayList<OutgoingBatch> processedBatches = new ArrayList<OutgoingBatch>(activeBatches.size());
            HashSet<String> channelsProcessed = new HashSet<String>();
            long batchesSelectedAtMs = System.currentTimeMillis();
            AbstractBatch currentBatch = null;
            ExecutorService executor = null;
            try {
                boolean streamToFileEnabled = this.parameterService.is("stream.to.file.enabled");
                long keepAliveMillis = this.parameterService.getLong("send.ack.keepalive.ms");
                Node sourceNode = this.nodeService.findIdentity();
                FutureExtractStatus status = new FutureExtractStatus();
                if (this.threadPoolFactory == null) {
                    this.threadPoolFactory = new CustomizableThreadFactory(String.format("%s-dataextractor", this.parameterService.getEngineName().toLowerCase()));
                }
                executor = streamToFileEnabled ? Executors.newFixedThreadPool(1, (ThreadFactory)this.threadPoolFactory) : null;
                ArrayList<Future<FutureOutgoingBatch>> futures = new ArrayList<Future<FutureOutgoingBatch>>();
                extractInfo.setTotalBatchCount(activeBatches.size());
                for (int i = 0; i < activeBatches.size(); ++i) {
                    currentBatch = activeBatches.get(i);
                    channelsProcessed.add(currentBatch.getChannelId());
                    AbstractBatch extractBatch = currentBatch;
                    Callable<FutureOutgoingBatch> callable = () -> this.lambda$extract$1(batchesSelectedAtMs, (OutgoingBatch)extractBatch, status, extractInfo, targetNode, dataWriter, mode, activeBatches);
                    if (status.shouldExtractSkip) break;
                    if (executor != null) {
                        futures.add(executor.submit(callable));
                        continue;
                    }
                    try {
                        FutureOutgoingBatch batch = callable.call();
                        futures.add((Future<FutureOutgoingBatch>)new FutureImpl((Object)batch));
                        continue;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.parameterService.is("jobs.synchronized.enable") && executor != null) {
                    executor.shutdown();
                    boolean isProcessed = false;
                    while (!isProcessed) {
                        try {
                            isProcessed = executor.awaitTermination(keepAliveMillis, TimeUnit.MILLISECONDS);
                        }
                        catch (java.lang.InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        if (isProcessed) continue;
                        this.writeKeepAliveAck(writer, sourceNode, streamToFileEnabled);
                    }
                }
                long initialLoadMaxBytesToSync = this.parameterService.getLong("initial.load.transport.max.bytes.to.sync");
                long totalBytesSend = 0L;
                boolean logMaxBytesReached = false;
                Iterator<OutgoingBatch> activeBatchIter = activeBatches.iterator();
                block17: for (int i = 0; i < futures.size(); ++i) {
                    Future future = (Future)futures.get(i);
                    currentBatch = activeBatchIter.next();
                    boolean isProcessed = false;
                    ProcessInfo transferInfo = null;
                    while (!isProcessed) {
                        try {
                            FutureOutgoingBatch extractBatch = (FutureOutgoingBatch)future.get(keepAliveMillis, TimeUnit.MILLISECONDS);
                            transferInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(this.nodeService.findIdentityNodeId(), extractInfo.getQueue(), targetNode.getNodeId(), extractInfo.getProcessType() == ProcessType.PUSH_JOB_EXTRACT ? ProcessType.PUSH_JOB_TRANSFER : ProcessType.PULL_HANDLER_TRANSFER));
                            transferInfo.setCurrentBatchId(currentBatch.getBatchId());
                            transferInfo.incrementBatchCount();
                            transferInfo.setTotalDataCount(currentBatch.getExtractRowCount());
                            currentBatch = extractBatch.getOutgoingBatch();
                            if (i == futures.size() - 1) {
                                extractInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                            }
                            if (extractBatch.isExtractSkipped) {
                                transferInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                                continue block17;
                            }
                            if (streamToFileEnabled || mode == ExtractMode.FOR_PAYLOAD_CLIENT || ((OutgoingBatch)currentBatch).isExtractJobFlag() && this.parameterService.is("initial.load.use.extract.job.enabled")) {
                                if (totalBytesSend > initialLoadMaxBytesToSync) {
                                    if (!logMaxBytesReached) {
                                        logMaxBytesReached = true;
                                        this.log.info("Reached the total byte threshold for initial load after {} of {} batches were sent for node '{}' (sent {} bytes, the max is {}).  The remaining batches will be send on a subsequent sync.", new Object[]{i, futures.size(), targetNode.getNodeId(), totalBytesSend, initialLoadMaxBytesToSync});
                                    }
                                    transferInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                                    continue block17;
                                }
                                transferInfo.setStatus(ProcessInfo.ProcessStatus.TRANSFERRING);
                                transferInfo.setCurrentLoadId(currentBatch.getLoadId());
                                boolean isRetry = extractBatch.isRetry() && extractBatch.getOutgoingBatch().getStatus() != AbstractBatch.Status.IG;
                                currentBatch = this.sendOutgoingBatch(transferInfo, targetNode, (OutgoingBatch)currentBatch, isRetry, dataWriter, writer, mode);
                                totalBytesSend += currentBatch.getByteCount();
                            }
                            processedBatches.add((OutgoingBatch)currentBatch);
                            if (currentBatch.getStatus() != AbstractBatch.Status.OK) {
                                currentBatch.setLoadCount(currentBatch.getLoadCount() + 1L);
                                this.changeBatchStatus(AbstractBatch.Status.LD, (OutgoingBatch)currentBatch, mode);
                            }
                            if (currentBatch.getLoadId() > 0L) {
                                long transferMillis = transferInfo.getEndTime() == null ? new Date().getTime() - transferInfo.getStartTime().getTime() : transferInfo.getEndTime().getTime() - transferInfo.getStartTime().getTime();
                                this.updateExtractRequestTransferred((OutgoingBatch)currentBatch, transferMillis);
                            }
                            transferInfo.setCurrentTableName(currentBatch.getSummary());
                            transferInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                            isProcessed = true;
                        }
                        catch (TimeoutException e) {
                            this.writeKeepAliveAck(writer, sourceNode, streamToFileEnabled);
                        }
                        catch (Exception e) {
                            if (transferInfo != null && transferInfo.getStatus() != ProcessInfo.ProcessStatus.OK) {
                                transferInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                            }
                            if (e instanceof ExecutionException) {
                                if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().contains("string truncation")) {
                                    throw new RuntimeException("There is a good chance that the truncation error you are receiving is because contains_big_lobs on the '" + currentBatch.getChannelId() + "' channel needs to be turned on.", e.getCause() != null ? e.getCause() : e);
                                }
                                if (e.getCause() instanceof RuntimeException) {
                                    throw (RuntimeException)e.getCause();
                                }
                                throw new RuntimeException(e.getCause() != null ? e.getCause() : e);
                            }
                            if (!(e instanceof RuntimeException)) {
                                throw new RuntimeException(e);
                            }
                            if (!(e instanceof RuntimeException)) continue;
                            throw (RuntimeException)e;
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                if (currentBatch != null) {
                    boolean isNewErrorStaging = false;
                    if (!this.isStreamClosedByClient(e)) {
                        if (e.getCause() instanceof java.lang.InterruptedException || e.getCause() instanceof CancellationException) {
                            this.log.info("Extract of batch {} was interrupted", (Object)currentBatch);
                        } else if (e instanceof StagingLowFreeSpace) {
                            this.log.error("Extract is disabled because disk is almost full: {}", (Object)e.getMessage());
                        } else if (e.getCause() instanceof ZipException || e instanceof ProtocolException || e instanceof IllegalStateException) {
                            if (currentBatch.getSqlCode() != -808) {
                                isNewErrorStaging = true;
                            }
                            this.log.warn("The batch {} appears corrupt in staging, so removing it. ({})", (Object)currentBatch.getNodeBatchId(), (Object)e.getMessage());
                            IStagedResource resource = this.getStagedResource((OutgoingBatch)currentBatch);
                            if (resource != null) {
                                resource.delete();
                            }
                        } else {
                            this.log.error("Failed to extract batch " + currentBatch, (Throwable)e);
                        }
                    }
                    try {
                        currentBatch = this.outgoingBatchService.findOutgoingBatch(currentBatch.getBatchId(), currentBatch.getNodeId());
                        SQLException se = ExceptionUtils.unwrapSqlException((Throwable)e);
                        if (se != null) {
                            currentBatch.setSqlState(se.getSQLState());
                            currentBatch.setSqlCode(se.getErrorCode());
                            currentBatch.setSqlMessage(se.getMessage());
                        } else if (isNewErrorStaging) {
                            currentBatch.setSqlState("STAGE");
                            currentBatch.setSqlCode(-808);
                            currentBatch.setSqlMessage(ExceptionUtils.getRootMessage((Throwable)e));
                        } else {
                            currentBatch.setSqlMessage(ExceptionUtils.getRootMessage((Throwable)e));
                        }
                        currentBatch.revertStatsOnError();
                        if (currentBatch.getStatus() != AbstractBatch.Status.IG && currentBatch.getStatus() != AbstractBatch.Status.OK) {
                            currentBatch.setStatus(AbstractBatch.Status.ER);
                            currentBatch.setErrorFlag(!isNewErrorStaging);
                            this.statisticManager.incrementDataExtractedErrors(currentBatch.getChannelId(), 1L);
                            extractInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                        }
                        this.outgoingBatchService.updateOutgoingBatch((OutgoingBatch)currentBatch);
                    }
                    catch (Exception ex) {
                        this.log.error("Failed to update the outgoing batch status for failed batch {}", (Object)currentBatch, (Object)ex);
                        extractInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                    }
                } else {
                    this.log.error("Could not log the outgoing batch status because the batch was null", (Throwable)e);
                }
            }
            finally {
                if (executor != null) {
                    executor.shutdown();
                }
            }
            Calendar now = Calendar.getInstance();
            for (String channelProcessed : channelsProcessed) {
                NodeChannel nodeChannel = this.configurationService.getNodeChannel(channelProcessed, targetNode.getNodeId(), false);
                if (nodeChannel == null || nodeChannel.getExtractPeriodMillis() <= 0L) continue;
                nodeChannel.setLastExtractTime(now.getTime());
                this.configurationService.updateLastExtractTime(nodeChannel);
            }
            return processedBatches;
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FutureOutgoingBatch extractBatch(OutgoingBatch extractBatch, FutureExtractStatus status, ProcessInfo extractInfo, Node targetNode, IDataWriter dataWriter, ExtractMode mode, List<OutgoingBatch> activeBatches) throws Exception {
        extractInfo.setThread(Thread.currentThread());
        extractInfo.setCurrentLoadId(extractBatch.getLoadId());
        extractInfo.setTotalDataCount(extractBatch.getDataRowCount());
        FutureOutgoingBatch outgoingBatch = new FutureOutgoingBatch(extractBatch, false);
        long maxBytesToSync = this.parameterService.getLong("transport.max.bytes.to.sync");
        boolean streamToFileEnabled = this.parameterService.is("stream.to.file.enabled");
        if (!status.shouldExtractSkip) {
            if (extractBatch.isExtractJobFlag() && extractBatch.getStatus() != AbstractBatch.Status.IG) {
                if (this.parameterService.is("initial.load.use.extract.job.enabled")) {
                    if (extractBatch.getStatus() != AbstractBatch.Status.RQ && extractBatch.getStatus() != AbstractBatch.Status.IG && !this.isPreviouslyExtracted(extractBatch, false)) {
                        this.log.info("Batch {} is marked as ready but it is missing in staging.  Rescheduling it for extraction.", (Object)extractBatch.getNodeBatchId());
                        if (mode != ExtractMode.EXTRACT_ONLY) {
                            this.resetExtractRequest(extractBatch);
                        }
                        outgoingBatch.isExtractSkipped = true;
                        status.shouldExtractSkip = true;
                        return outgoingBatch;
                    } else {
                        if (extractBatch.getStatus() != AbstractBatch.Status.RQ) return outgoingBatch;
                        this.log.info("Batch {} is not ready for delivery.  It is currently scheduled for extraction.", (Object)extractBatch.getNodeBatchId());
                        outgoingBatch.isExtractSkipped = true;
                        status.shouldExtractSkip = true;
                    }
                    return outgoingBatch;
                } else {
                    extractBatch.setStatus(AbstractBatch.Status.NE);
                    extractBatch.setExtractJobFlag(false);
                }
                return outgoingBatch;
            } else {
                try {
                    boolean isRetry = this.isRetry(extractBatch, targetNode);
                    outgoingBatch = new FutureOutgoingBatch(this.extractOutgoingBatch(extractInfo, targetNode, dataWriter, extractBatch, streamToFileEnabled, true, mode, null), isRetry);
                    ++status.batchExtractCount;
                    status.byteExtractCount = (int)((long)status.byteExtractCount + extractBatch.getByteCount());
                    if ((long)status.byteExtractCount < maxBytesToSync || status.batchExtractCount >= activeBatches.size()) return outgoingBatch;
                    this.log.info("Reached the total byte threshold after {} of {} batches were extracted for node '{}' (extracted {} bytes, the max is {}).  The remaining batches will be extracted on a subsequent sync.", new Object[]{status.batchExtractCount, activeBatches.size(), targetNode.getNodeId(), status.byteExtractCount, maxBytesToSync});
                    status.shouldExtractSkip = true;
                    return outgoingBatch;
                }
                catch (Exception e) {
                    outgoingBatch.isExtractSkipped = true;
                    status.shouldExtractSkip = true;
                    throw e;
                }
            }
        } else {
            outgoingBatch.isExtractSkipped = true;
        }
        return outgoingBatch;
    }

    protected void writeKeepAliveAck(BufferedWriter writer, Node sourceNode, boolean streamToFileEnabled) {
        try {
            if (writer != null && streamToFileEnabled) {
                writer.write("nodeid," + sourceNode.getNodeId());
                writer.newLine();
                writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final boolean changeBatchStatus(AbstractBatch.Status status, OutgoingBatch currentBatch, ExtractMode mode) {
        if (currentBatch.getStatus() != AbstractBatch.Status.IG) {
            currentBatch.setStatus(status);
        }
        if (mode != ExtractMode.EXTRACT_ONLY) {
            long batchStatusUpdateMillis = this.parameterService.getLong("outgoing.batches.update.status.millis");
            int batchStatusUpdateDataCount = this.parameterService.getInt("outgoing.batches.update.status.data.count");
            Channel channel = this.configurationService.getChannel(currentBatch.getChannelId());
            if (currentBatch.getStatus() == AbstractBatch.Status.RQ || currentBatch.getStatus() == AbstractBatch.Status.LD || currentBatch.getLastUpdatedTime() == null || System.currentTimeMillis() - batchStatusUpdateMillis >= currentBatch.getLastUpdatedTime().getTime() || channel.isReloadFlag() || currentBatch.getDataRowCount() > (long)batchStatusUpdateDataCount) {
                this.outgoingBatchService.updateOutgoingBatch(currentBatch);
                return true;
            }
            return false;
        }
        return false;
    }

    protected final OutgoingBatch requeryIfEnoughTimeHasPassed(long ts, OutgoingBatch currentBatch) {
        OutgoingBatch batch;
        if (System.currentTimeMillis() - ts > 5000L && (batch = this.outgoingBatchService.findOutgoingBatch(currentBatch.getBatchId(), currentBatch.getNodeId())) != null && !batch.getStatus().equals((Object)currentBatch.getStatus())) {
            currentBatch.setStatus(batch.getStatus());
        }
        return currentBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected OutgoingBatch extractOutgoingBatch(ProcessInfo extractInfo, Node targetNode, IDataWriter dataWriter, OutgoingBatch currentBatch, boolean useStagingDataWriter, boolean updateBatchStatistics, ExtractMode mode, IDataProcessorListener listener) {
        block26: {
            block28: {
                block25: {
                    block27: {
                        if (currentBatch.getStatus() == AbstractBatch.Status.OK && ExtractMode.EXTRACT_ONLY != mode && ExtractMode.FOR_SYM_CLIENT != mode) break block26;
                        sourceNode = this.nodeService.findIdentity();
                        writer = this.wrapWithTransformWriter(sourceNode, targetNode, extractInfo, dataWriter, useStagingDataWriter);
                        ts = System.currentTimeMillis();
                        extractTimeInMs = 0L;
                        byteCount = 0L;
                        transformTimeInMs = 0L;
                        if (currentBatch.getStatus() != AbstractBatch.Status.IG) break block27;
                        this.cleanupIgnoredBatch(sourceNode, targetNode, currentBatch, writer);
                        break block28;
                    }
                    if (currentBatch.getStatus() != AbstractBatch.Status.RQ && this.isPreviouslyExtracted(currentBatch, false)) break block28;
                    lock = null;
                    this.log.debug("{} attempting to acquire lock for batch {}", (Object)targetNode.getNodeId(), (Object)currentBatch.getBatchId());
                    lock = this.acquireLock(currentBatch, useStagingDataWriter);
                    this.log.debug("{} acquired lock for batch {}", (Object)targetNode.getNodeId(), (Object)currentBatch.getBatchId());
                    if (currentBatch.getStatus() != AbstractBatch.Status.RQ && this.isPreviouslyExtracted(currentBatch, true)) break block25;
                    this.log.debug("{} extracting batch {}", (Object)targetNode.getNodeId(), (Object)currentBatch.getBatchId());
                    currentBatch.setExtractCount(currentBatch.getExtractCount() + 1L);
                    if (currentBatch.getExtractStartTime() == null) {
                        currentBatch.setExtractStartTime(new Date());
                    }
                    if (updateBatchStatistics) {
                        this.changeBatchStatus(AbstractBatch.Status.QY, currentBatch, mode);
                    }
                    ctx = new DataContext();
                    ctx.put("targetNodeId", (Object)targetNode.getNodeId());
                    ctx.put("targetNodeExternalId", (Object)targetNode.getExternalId());
                    ctx.put("targetNodeGroupId", (Object)targetNode.getNodeGroupId());
                    ctx.put("targetNode", (Object)targetNode);
                    ctx.put("sourceNode", (Object)sourceNode);
                    ctx.put("sourceNodeId", (Object)sourceNode.getNodeId());
                    ctx.put("sourceNodeExternalId", (Object)sourceNode.getExternalId());
                    ctx.put("sourceNodeGroupId", (Object)sourceNode.getNodeGroupId());
                    ctx.put("engine", (Object)this.engine);
                    extractInfo.setTotalDataCount(currentBatch.getDataRowCount());
                    currentBatch.resetStats();
                    dataReader = this.buildExtractDataReader(sourceNode, targetNode, currentBatch, extractInfo);
                    try {
                        new DataProcessor((IDataReader)dataReader, writer, listener, "extract").process(ctx);
                    }
                    catch (Exception e) {
                        if ((e instanceof ProtocolException || this.sqlTemplate.isDataTruncationViolation((Throwable)e)) && !this.configurationService.getNodeChannel(currentBatch.getChannelId(), false).getChannel().isContainsBigLob()) {
                            this.log.warn(e.getMessage());
                            this.log.info("Re-attempting extraction for batch {} with contains_big_lobs temporarily enabled for channel {}", (Object)currentBatch.getBatchId(), (Object)currentBatch.getChannelId());
                            extractInfo.setTotalDataCount(currentBatch.getDataRowCount());
                            currentBatch.resetStats();
                            resource = this.getStagedResource(currentBatch);
                            if (resource != null) {
                                resource.delete();
                            }
                            dataReader = this.buildExtractDataReader(sourceNode, targetNode, currentBatch, extractInfo, true);
                            writer = this.wrapWithTransformWriter(sourceNode, targetNode, extractInfo, dataWriter, useStagingDataWriter);
                            new DataProcessor((IDataReader)dataReader, writer, listener, "extract").process(ctx);
                        }
                        throw e;
                    }
                    extractTimeInMs = System.currentTimeMillis() - ts;
                    stats = this.getExtractStats(writer, currentBatch);
                    if (stats == null) break block25;
                    transformTimeInMs = stats.get("TRANSFORMMILLIS");
                    currentBatch.setDataRowCount(stats.get("STATEMENTCOUNT"));
                    currentBatch.setDataInsertRowCount(stats.get("INSERTCOUNT"));
                    currentBatch.setDataUpdateRowCount(stats.get("UPDATECOUNT"));
                    currentBatch.setDataDeleteRowCount(stats.get("DELETECOUNT"));
                    currentBatch.setTableExtractedCount(stats.getTableStats());
                    currentBatch.setTransformExtractMillis(transformTimeInMs);
                    extractTimeInMs -= transformTimeInMs;
                    byteCount = stats.get("BYTECOUNT");
                    this.statisticManager.incrementDataBytesExtracted(currentBatch.getChannelId(), byteCount);
                    this.statisticManager.incrementDataExtracted(currentBatch.getChannelId(), stats.get("STATEMENTCOUNT"));
                    this.statisticManager.incrementTableRows(currentBatch.getTableExtractedCount(), false);
                    currentBatch.setByteCount(byteCount);
                    if (!useStagingDataWriter) {
                        this.statisticManager.incrementDataBytesSent(currentBatch.getChannelId(), byteCount);
                        this.statisticManager.incrementDataSent(currentBatch.getChannelId(), stats.get("STATEMENTCOUNT"));
                    }
                    if (!currentBatch.isCommonFlag()) break block25;
                    this.outgoingBatchService.updateCommonBatchExtractStatistics(currentBatch);
                }
                try {
                    resource = this.getStagedResource(currentBatch);
                    if (resource == null) ** GOTO lbl109
                    resource.setState(IStagedResource.State.DONE);
                }
                finally {
                    this.releaseLock(lock, currentBatch, useStagingDataWriter);
                    this.log.debug("{} released lock for batch {}", (Object)targetNode.getNodeId(), (Object)currentBatch.getBatchId());
                }
                catch (RuntimeException ex) {
                    try {
                        resource = this.getStagedResource(currentBatch);
                        if (resource != null) {
                            resource.close();
                            resource.delete();
                        }
                        throw ex;
                    }
                    catch (Throwable var25_24) {
                        try {
                            resource = this.getStagedResource(currentBatch);
                            if (resource != null) {
                                resource.setState(IStagedResource.State.DONE);
                            }
                            this.releaseLock(lock, currentBatch, useStagingDataWriter);
                        }
                        catch (Throwable var27_26) {
                            this.releaseLock(lock, currentBatch, useStagingDataWriter);
                            this.log.debug("{} released lock for batch {}", (Object)targetNode.getNodeId(), (Object)currentBatch.getBatchId());
                            throw var27_26;
                        }
                        this.log.debug("{} released lock for batch {}", (Object)targetNode.getNodeId(), (Object)currentBatch.getBatchId());
                        throw var25_24;
                    }
                }
            }
            if (updateBatchStatistics) {
                currentBatch = this.requeryIfEnoughTimeHasPassed(ts, currentBatch);
                if (extractTimeInMs > 0L) {
                    currentBatch.setExtractMillis(extractTimeInMs);
                }
                if (byteCount > 0L) {
                    currentBatch.setByteCount(byteCount);
                }
                if (transformTimeInMs > 0L) {
                    currentBatch.setTransformExtractMillis(transformTimeInMs);
                }
                if (!(currentBatch.getLoadId() <= 0L || currentBatch.getSummary() != null && currentBatch.getSummary().startsWith(this.symmetricDialect.getTablePrefix()))) {
                    if (currentBatch.getExtractRowCount() != currentBatch.getDataRowCount()) {
                        currentBatch.setDataRowCount(currentBatch.getExtractRowCount());
                        currentBatch.setDataInsertRowCount(currentBatch.getExtractInsertRowCount());
                    }
                    if ((extractRequest = this.getExtractRequestForBatch(currentBatch)) != null) {
                        this.sqlTemplate.update(this.getSql(new String[]{"updateExtractRequestStatus"}), new Object[]{ExtractRequest.ExtractStatus.OK.name(), new Date(), currentBatch.getExtractRowCount(), currentBatch.getExtractMillis(), extractRequest.getRequestId()});
                        this.checkSendDeferredConstraints(extractRequest, null, targetNode);
                    }
                }
            }
        }
        return currentBatch;
    }

    protected String getSemaphoreKey(OutgoingBatch batch, boolean useStagingDataWriter) {
        return useStagingDataWriter ? Long.toString(batch.getBatchId()) : batch.getNodeBatchId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchLock acquireLock(OutgoingBatch batch, boolean useStagingDataWriter) {
        BatchLock lock;
        block9: {
            String semaphoreKey = this.getSemaphoreKey(batch, useStagingDataWriter);
            lock = null;
            DataExtractorService dataExtractorService = this;
            synchronized (dataExtractorService) {
                lock = this.locks.get(semaphoreKey);
                if (lock == null) {
                    lock = new BatchLock(semaphoreKey);
                    this.locks.put(semaphoreKey, lock);
                }
                ++lock.referenceCount;
            }
            try {
                lock.acquire();
                if (!this.isStagingFileLockRequired(batch)) break block9;
                StagingFileLock fileLock = this.acquireStagingFileLock(batch);
                if (fileLock.isAcquired()) {
                    lock.fileLock = fileLock;
                    break block9;
                }
                this.releaseLock(lock, batch, useStagingDataWriter);
                lock = null;
                throw new SymmetricException("Failed to get extract lock on batch " + batch.getNodeBatchId(), new Object[0]);
            }
            catch (java.lang.InterruptedException e) {
                this.releaseLock(lock, batch, useStagingDataWriter);
                throw new InterruptedException(e);
            }
            catch (Throwable e) {
                this.releaseLock(lock, batch, useStagingDataWriter);
                if (e instanceof SymmetricException) {
                    throw (SymmetricException)e;
                }
                throw new SymmetricException(e);
            }
        }
        return lock;
    }

    @Override
    public StagingFileLock acquireStagingFileLock(OutgoingBatch batch) {
        boolean stagingFileAcquired = false;
        StagingFileLock fileLock = null;
        int iterations = 0;
        while (!stagingFileAcquired) {
            fileLock = this.stagingManager.acquireFileLock(this.getLockingServerInfo(), new Object[]{"outgoing", batch.getStagedLocation(), batch.getBatchId()});
            stagingFileAcquired = fileLock.isAcquired();
            if (!stagingFileAcquired) {
                if (fileLock.getLockFile() == null) {
                    this.log.warn("Staging lock file not acquired " + fileLock.getLockFailureMessage());
                    return fileLock;
                }
                long lockAge = fileLock.getLockAge();
                if (lockAge >= this.parameterService.getLong("lock.timeout.ms")) {
                    this.log.warn("Lock {} in place for {} > about to BREAK the lock.", (Object)fileLock.getLockFile(), (Object)DurationFormatUtils.formatDurationWords((long)lockAge, (boolean)true, (boolean)true));
                    fileLock.breakLock();
                } else {
                    if (iterations % 10 == 0) {
                        this.log.info("Lock {} in place for {}, waiting...", (Object)fileLock.getLockFile(), (Object)DurationFormatUtils.formatDurationWords((long)lockAge, (boolean)true, (boolean)true));
                    } else {
                        this.log.debug("Lock {} in place for {}, waiting...", (Object)fileLock.getLockFile(), (Object)DurationFormatUtils.formatDurationWords((long)lockAge, (boolean)true, (boolean)true));
                    }
                    try {
                        Thread.sleep(this.parameterService.getLong("lock.wait.retry.ms"));
                    }
                    catch (java.lang.InterruptedException ex) {
                        this.log.debug("Interrupted.", (Throwable)ex);
                    }
                }
            }
            ++iterations;
        }
        return fileLock;
    }

    private String getLockingServerInfo() {
        return String.format("Server: '%s' Host: '%s' IP: '%s'", this.clusterService.getServerId(), AppUtils.getHostName(), AppUtils.getIpAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock(BatchLock lock, OutgoingBatch batch, boolean useStagingDataWriter) {
        if (lock != null) {
            DataExtractorService dataExtractorService = this;
            synchronized (dataExtractorService) {
                --lock.referenceCount;
                if (lock.referenceCount == 0) {
                    this.locks.remove(lock.semaphoreKey);
                }
                lock.release();
            }
            if (lock.fileLock != null) {
                lock.fileLock.releaseLock();
            }
        }
    }

    protected boolean isStagingFileLockRequired(OutgoingBatch batch) {
        return batch.isCommonFlag() && this.parameterService.is("cluster.staging.enabled");
    }

    protected void triggerReExtraction(OutgoingBatch currentBatch) {
        IStagedResource resource = this.getStagedResource(currentBatch);
        if (resource != null) {
            resource.delete();
        }
    }

    protected ExtractDataReader buildExtractDataReader(Node sourceNode, Node targetNode, OutgoingBatch currentBatch, ProcessInfo processInfo) {
        boolean containsBigLob = this.engine.getConfigurationService().getNodeChannel(currentBatch.getChannelId(), false).getChannel().isContainsBigLob();
        return this.buildExtractDataReader(sourceNode, targetNode, currentBatch, processInfo, containsBigLob);
    }

    protected ExtractDataReader buildExtractDataReader(Node sourceNode, Node targetNode, OutgoingBatch currentBatch, ProcessInfo processInfo, boolean containsBigLob) {
        IExtractDataReaderSource source = (IExtractDataReaderSource)AppUtils.newInstance(IExtractDataReaderSource.class, SelectFromSymDataSource.class, (Object[])new Object[]{this.engine, currentBatch, sourceNode, targetNode, processInfo, containsBigLob}, (Class[])new Class[]{ISymmetricEngine.class, OutgoingBatch.class, Node.class, Node.class, ProcessInfo.class, Boolean.TYPE});
        IExtractDataReaderFactory factory = (IExtractDataReaderFactory)AppUtils.newInstance(IExtractDataReaderFactory.class, ExtractDataReaderFactory.class, (Object[])new Object[]{this.engine}, (Class[])new Class[]{ISymmetricEngine.class});
        return factory.getReader(this.platform, source, sourceNode, targetNode);
    }

    protected Statistics getExtractStats(IDataWriter writer, OutgoingBatch currentBatch) {
        Map statisticsMap = null;
        statisticsMap = writer instanceof TransformWriter ? ((TransformWriter)writer).getNestedWriter().getStatistics() : writer.getStatistics();
        if (statisticsMap.size() > 0) {
            for (Map.Entry entry : statisticsMap.entrySet()) {
                if (((Batch)entry.getKey()).getBatchId() != currentBatch.getBatchId()) continue;
                return (Statistics)entry.getValue();
            }
        }
        return null;
    }

    protected IDataWriter wrapWithTransformWriter(Node sourceNode, Node targetNode, ProcessInfo processInfo, IDataWriter dataWriter, boolean useStagingDataWriter) {
        TransformWriter transformExtractWriter = null;
        if (useStagingDataWriter) {
            long memoryThresholdInBytes = this.parameterService.getLong("stream.to.file.threshold.bytes");
            transformExtractWriter = this.createTransformDataWriter(sourceNode, targetNode, (IDataWriter)new ProcessInfoDataWriter((IDataWriter)new StagingDataWriter(memoryThresholdInBytes, true, this.nodeService.findIdentityNodeId(), "outgoing", this.stagingManager, targetNode.allowCaptureTimeInProtocol(), this.parameterService.is("extract.row.capture.time", true), new IProtocolDataWriterListener[0]), processInfo));
        } else {
            transformExtractWriter = this.createTransformDataWriter(sourceNode, targetNode, (IDataWriter)new ProcessInfoDataWriter(dataWriter, processInfo));
        }
        return transformExtractWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupIgnoredBatch(Node sourceNode, Node targetNode, OutgoingBatch currentBatch, IDataWriter writer) {
        Batch batch = new Batch(Batch.BatchType.EXTRACT, currentBatch.getBatchId(), currentBatch.getChannelId(), this.symmetricDialect.getBinaryEncoding(), sourceNode.getNodeId(), currentBatch.getNodeId(), currentBatch.isCommonFlag());
        batch.setIgnored(true);
        try {
            IStagedResource resource = this.getStagedResource(currentBatch);
            if (resource != null) {
                resource.delete();
            }
            DataContext ctx = new DataContext(batch);
            ctx.put("targetNode", (Object)targetNode);
            ctx.put("sourceNode", (Object)sourceNode);
            writer.open(ctx);
            writer.start(batch);
            writer.end(batch, false);
        }
        finally {
            writer.close();
        }
    }

    protected IStagedResource getStagedResource(OutgoingBatch currentBatch) {
        return this.stagingManager.find(new Object[]{"outgoing", currentBatch.getStagedLocation(), currentBatch.getBatchId()});
    }

    protected boolean isPreviouslyExtracted(OutgoingBatch currentBatch, boolean acquireReference) {
        IStagedResource previouslyExtracted = this.getStagedResource(currentBatch);
        if (previouslyExtracted != null && previouslyExtracted.getState() == IStagedResource.State.DONE) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("We have already extracted batch {}.  Using the existing extraction: {}", (Object)currentBatch.getBatchId(), (Object)previouslyExtracted);
            }
            if (acquireReference) {
                previouslyExtracted.reference();
            }
            return true;
        }
        return false;
    }

    protected boolean isRetry(OutgoingBatch currentBatch, Node remoteNode) {
        if (currentBatch.getSentCount() > 0L && currentBatch.getStatus() != AbstractBatch.Status.RS) {
            boolean offline = this.parameterService.is("node.offline", false);
            boolean cclient = StringUtils.equals((CharSequence)remoteNode.getDeploymentType(), (CharSequence)"cclient");
            if (remoteNode.isVersionGreaterThanOrEqualTo(3, 8, 0) && !offline && !cclient) {
                IStagedResource previouslyExtracted = this.getStagedResource(currentBatch);
                return previouslyExtracted != null && previouslyExtracted.getState() == IStagedResource.State.DONE;
            }
        }
        return false;
    }

    protected OutgoingBatch sendOutgoingBatch(ProcessInfo processInfo, Node targetNode, OutgoingBatch currentBatch, boolean isRetry, IDataWriter dataWriter, BufferedWriter writer, ExtractMode mode) {
        if (currentBatch.getStatus() != AbstractBatch.Status.OK || ExtractMode.EXTRACT_ONLY == mode) {
            currentBatch.setSentCount(currentBatch.getSentCount() + 1L);
            if (currentBatch.getStatus() != AbstractBatch.Status.RS) {
                currentBatch.setTransferStartTime(new Date());
            }
            long ts = System.currentTimeMillis();
            IStagedResource extractedBatch = this.getStagedResource(currentBatch);
            if (extractedBatch != null) {
                processInfo.setTotalDataCount(currentBatch.getDataRowCount());
                if (currentBatch.getLoadId() > 0L) {
                    processInfo.setCurrentTableName(currentBatch.getSummary());
                }
                if (mode == ExtractMode.FOR_SYM_CLIENT && writer != null) {
                    ISymmetricEngine targetEngine;
                    if (!isRetry && this.parameterService.is("outgoing.batches.copy.to.incoming.staging") && !this.parameterService.is("node.offline", false) && (targetEngine = AbstractSymmetricEngine.findEngineByUrl(targetNode.getSyncUrl())) != null) {
                        IParameterService targetParam = targetEngine.getParameterService();
                        if (extractedBatch.isFileResource() && targetParam.is("stream.to.file.enabled") && (!targetParam.is("cluster.lock.enabled") || targetParam.is("cluster.staging.enabled"))) {
                            Node sourceNode = this.nodeService.findIdentity();
                            Node targetNodeByEngine = targetEngine.getNodeService().findIdentity();
                            if (sourceNode != null && sourceNode.equals(targetNodeByEngine) || targetNodeByEngine != null && !targetNodeByEngine.equals(targetNode)) {
                                this.log.warn("Target engine (NodeId {}) is the same engine as the current one and differs from the correct target (NodeId {}). This looks like a mis-configuration of the sync urls '{}'", new Object[]{targetNodeByEngine.getNodeId(), targetNode.getNodeId(), targetNode.getSyncUrl()});
                            } else {
                                IStagedResource targetResource = targetEngine.getStagingManager().create(new Object[]{"incoming", Batch.getStagedLocation((boolean)false, (String)sourceNode.getNodeId(), (long)currentBatch.getBatchId()), currentBatch.getBatchId()});
                                try {
                                    Files.copy(extractedBatch.getFile().toPath(), targetResource.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    processInfo.setCurrentDataCount(currentBatch.getDataRowCount());
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Copied file to incoming staging of remote engine {}", (Object)targetResource.getFile().getAbsolutePath());
                                    }
                                    targetResource.setState(IStagedResource.State.DONE);
                                    isRetry = true;
                                    if (currentBatch.getSentCount() == 1L) {
                                        this.statisticManager.incrementDataSent(currentBatch.getChannelId(), currentBatch.getDataRowCount());
                                        this.statisticManager.incrementDataBytesSent(currentBatch.getChannelId(), extractedBatch.getFile().length());
                                    }
                                }
                                catch (Exception e) {
                                    FileUtils.deleteQuietly((File)targetResource.getFile());
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    }
                    Channel channel = this.configurationService.getChannel(currentBatch.getChannelId());
                    DataContext ctx = new DataContext();
                    this.transferFromStaging(mode, Batch.BatchType.EXTRACT, currentBatch, isRetry, extractedBatch, writer, ctx, channel.getMaxKBytesPerSecond(), processInfo);
                } else {
                    ProtocolDataReader dataReader = new ProtocolDataReader(Batch.BatchType.EXTRACT, currentBatch.getNodeId(), extractedBatch);
                    DataContext ctx = new DataContext();
                    ctx.put("targetNode", (Object)targetNode);
                    ctx.put("sourceNode", (Object)this.nodeService.findIdentity());
                    new DataProcessor((IDataReader)dataReader, (IDataWriter)new ProcessInfoDataWriter(dataWriter, processInfo), "send from stage").process(ctx);
                    if (dataReader.getStatistics().size() > 0) {
                        if (!isRetry) {
                            Statistics stats = (Statistics)dataReader.getStatistics().values().iterator().next();
                            this.statisticManager.incrementDataSent(currentBatch.getChannelId(), stats.get("READ_RECORD_COUNT"));
                            long byteCount = stats.get("READ_BYTE_COUNT");
                            this.statisticManager.incrementDataBytesSent(currentBatch.getChannelId(), byteCount);
                        }
                    } else {
                        this.log.warn("Could not find recorded statistics for batch {}", (Object)currentBatch.getNodeBatchId());
                    }
                }
            } else {
                throw new IllegalStateException(String.format("Could not find the staged resource for batch %s", currentBatch.getNodeBatchId()));
            }
            currentBatch = this.requeryIfEnoughTimeHasPassed(ts, currentBatch);
        }
        return currentBatch;
    }

    protected void transferFromStaging(ExtractMode mode, Batch.BatchType batchType, OutgoingBatch batch, boolean isRetry, IStagedResource stagedResource, BufferedWriter writer, DataContext context, BigDecimal maxKBytesPerSec, ProcessInfo processInfo) {
        int MAX_WRITE_LENGTH = 32768;
        BufferedReader reader = stagedResource.getReader();
        try {
            if (isRetry) {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("batch")) {
                        if (this.nodeService.findNode(batch.getNodeId(), true).isVersionGreaterThanOrEqualTo(3, 9, 0)) {
                            writer.write(this.getBatchStatsColumns());
                            writer.newLine();
                            writer.write(this.getBatchStats(batch));
                            writer.newLine();
                        }
                        writer.write("retry," + batch.getBatchId());
                        writer.newLine();
                        writer.write("commit," + batch.getBatchId());
                        writer.newLine();
                        break;
                    }
                    writer.write(line);
                    writer.newLine();
                }
                writer.flush();
                processInfo.setCurrentDataCount(batch.getDataRowCount());
            } else {
                long startTime;
                long totalBytes = stagedResource.getSize();
                long totalCharsRead = 0L;
                long totalBytesRead = 0L;
                int numCharsRead = 0;
                int numBytesRead = 0;
                long ts = startTime = System.currentTimeMillis();
                long bts = startTime;
                boolean isThrottled = maxKBytesPerSec != null && maxKBytesPerSec.compareTo(BigDecimal.ZERO) > 0;
                long totalThrottleTime = 0L;
                int bufferSize = 32768;
                if (isThrottled) {
                    bufferSize = maxKBytesPerSec.multiply(new BigDecimal(1024)).intValue();
                }
                char[] buffer = new char[bufferSize];
                boolean batchStatsWritten = false;
                String prevBuffer = "";
                while ((numCharsRead = reader.read(buffer)) != -1) {
                    if (!batchStatsWritten && this.nodeService.findNode(batch.getNodeId(), true).isVersionGreaterThanOrEqualTo(3, 9, 0)) {
                        batchStatsWritten = this.writeBatchStats(writer, buffer, numCharsRead, prevBuffer, batch);
                        prevBuffer = new String(buffer);
                    } else {
                        writer.write(buffer, 0, numCharsRead);
                    }
                    totalCharsRead += (long)numCharsRead;
                    if (Thread.currentThread().isInterrupted()) {
                        throw new IoException("This thread was interrupted", new Object[0]);
                    }
                    long batchStatusUpdateMillis = this.parameterService.getLong("outgoing.batches.update.status.millis");
                    if (System.currentTimeMillis() - ts > batchStatusUpdateMillis && batch.getStatus() != AbstractBatch.Status.SE && batch.getStatus() != AbstractBatch.Status.RS) {
                        this.changeBatchStatus(AbstractBatch.Status.SE, batch, mode);
                    }
                    if (System.currentTimeMillis() - ts > 60000L) {
                        this.log.info("Batch '{}', for node '{}', for process 'send from stage' has been processing for {} seconds.  The following stats have been gathered: {}", new Object[]{batch.getBatchId(), batch.getNodeId(), (System.currentTimeMillis() - startTime) / 1000L, "CHARS=" + totalCharsRead});
                        ts = System.currentTimeMillis();
                    }
                    if (isThrottled) {
                        totalBytesRead += (long)(numBytesRead += new String(buffer, 0, numCharsRead).getBytes().length);
                        if (numBytesRead >= bufferSize) {
                            long expectedMillis = (long)((float)numBytesRead / 1024.0f / maxKBytesPerSec.floatValue() * 1000.0f);
                            long actualMillis = System.currentTimeMillis() - bts;
                            if (actualMillis < expectedMillis) {
                                totalThrottleTime += expectedMillis - actualMillis;
                                Thread.sleep(expectedMillis - actualMillis);
                            }
                            numBytesRead = 0;
                            bts = System.currentTimeMillis();
                        }
                    } else {
                        totalBytesRead += (long)new String(buffer, 0, numCharsRead).getBytes().length;
                    }
                    processInfo.setCurrentDataCount((long)((double)totalBytesRead / (double)totalBytes * (double)batch.getDataRowCount()));
                }
                if (batch.getSentCount() == 1L) {
                    this.statisticManager.incrementDataSent(batch.getChannelId(), batch.getDataRowCount());
                    this.statisticManager.incrementDataBytesSent(batch.getChannelId(), totalBytesRead);
                }
                if (this.log.isDebugEnabled() && totalThrottleTime > 0L) {
                    this.log.debug("Batch '{}' for node '{}' took {}ms for {} bytes and was throttled for {}ms because limit is set to {} KB/s", new Object[]{batch.getBatchId(), batch.getNodeId(), System.currentTimeMillis() - startTime, totalBytesRead, totalThrottleTime, maxKBytesPerSec});
                }
            }
            if (writer instanceof BatchBufferedWriter) {
                ((BatchBufferedWriter)writer).getBatchIds().add(batch.getBatchId());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            stagedResource.close();
            stagedResource.dereference();
        }
    }

    protected int findStatsIndex(String bufferString, String prevBuffer) {
        int index = -1;
        String fullBuffer = prevBuffer + bufferString;
        String pattern = "\nbatch\\s*,\\s*\\d*\r*\n";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(fullBuffer);
        if (m.find()) {
            String group = m.group(0);
            int start = fullBuffer.indexOf(group);
            index = start + group.length() > prevBuffer.length() ? start + group.length() - prevBuffer.length() : start + group.length();
        }
        return index;
    }

    @Override
    public List<ExtractRequest> getPendingTablesForExtractByLoadId(long loadId) {
        return this.sqlTemplate.query(this.getSql("selectIncompleteTablesForExtractByLoadId"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{loadId, this.engine.getNodeId()});
    }

    @Override
    public List<ExtractRequest> getCompletedTablesForExtractByLoadId(long loadId) {
        return this.sqlTemplate.query(this.getSql("selectCompletedTablesForExtractByLoadId"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{loadId, this.engine.getNodeId()});
    }

    @Override
    public List<ExtractRequest> getPendingTablesForExtractByLoadIdAndNodeId(long loadId, String nodeId) {
        return this.sqlTemplate.query(this.getSql("selectIncompleteTablesForExtractByLoadIdAndNodeId"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{loadId, nodeId});
    }

    @Override
    public List<ExtractRequest> getPendingTablesForExtractByLoadIdNodeIdSourceId(long loadId, String nodeId, String sourceId) {
        return this.sqlTemplate.query(this.getSql("selectIncompleteTablesForExtractByLoadIdNodeIdSourceId"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{loadId, nodeId, sourceId});
    }

    @Override
    public List<ExtractRequest> getCompletedTablesForExtractByLoadIdAndNodeId(long loadId, String nodeId) {
        return this.sqlTemplate.query(this.getSql("selectCompletedTablesForExtractByLoadIdAndNodeId"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{loadId, nodeId});
    }

    @Override
    public List<ExtractRequest> getCompletedTablesForExtractByLoadIdNodeIdSourceId(long loadId, String nodeId, String sourceId) {
        return this.sqlTemplate.query(this.getSql("selectCompletedTablesForExtractByLoadIdNodeIdSourceId"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{loadId, nodeId, sourceId});
    }

    @Override
    public void updateExtractRequestLoadTime(ISqlTransaction transaction, Date loadTime, OutgoingBatch outgoingBatch) {
        if (this.platform.supportsParametersInSelect()) {
            transaction.prepareAndExecute(this.getSql("updateExtractRequestLoadTime"), new Object[]{outgoingBatch.getBatchId(), new Date(), outgoingBatch.getReloadRowCount() > 0L ? outgoingBatch.getDataRowCount() : 0L, outgoingBatch.getLoadMillis(), outgoingBatch.getBatchId(), new Date(), outgoingBatch.getBatchId(), outgoingBatch.getBatchId(), outgoingBatch.getNodeId(), outgoingBatch.getLoadId(), this.engine.getNodeId()});
        } else {
            String sql = this.getSql("updateExtractRequestLoadTimeNoParamsInSelect");
            sql = FormatUtils.replace((String)"batchId", (String)String.valueOf(outgoingBatch.getBatchId()), (String)sql);
            sql = FormatUtils.replace((String)"rowCount", (String)String.valueOf(outgoingBatch.getReloadRowCount() > 0L ? outgoingBatch.getDataRowCount() : 0L), (String)sql);
            sql = FormatUtils.replace((String)"loadMillis", (String)String.valueOf(outgoingBatch.getLoadMillis()), (String)sql);
            transaction.prepareAndExecute(sql, new Object[]{outgoingBatch.getBatchId(), new Date(), outgoingBatch.getBatchId(), outgoingBatch.getBatchId(), outgoingBatch.getNodeId(), outgoingBatch.getLoadId(), this.engine.getNodeId()});
        }
        TableReloadStatus status = this.dataService.updateTableReloadStatusDataLoaded(transaction, outgoingBatch.getLoadId(), this.engine.getNodeId(), outgoingBatch.getBatchId(), 1, outgoingBatch.isBulkLoaderFlag());
        if (status != null && status.isFullLoad() && (status.isCancelled() || status.isCompleted())) {
            this.log.info("Initial load ended for node {}", (Object)outgoingBatch.getNodeId());
            this.nodeService.setInitialLoadEnded(transaction, outgoingBatch.getNodeId());
        }
    }

    @Override
    public void updateExtractRequestTransferred(OutgoingBatch batch, long transferMillis) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            if (this.platform.supportsParametersInSelect()) {
                transaction.prepareAndExecute(this.getSql("updateExtractRequestTransferred"), new Object[]{batch.getBatchId(), batch.getDataRowCount(), transferMillis, batch.getBatchId(), batch.getBatchId(), batch.getNodeId(), batch.getLoadId(), batch.getBatchId(), this.engine.getNodeId()});
            } else {
                String sql = this.getSql("updateExtractRequestTransferredNoParamsInSelect");
                sql = FormatUtils.replace((String)"rowCount", (String)String.valueOf(batch.getDataRowCount()), (String)sql);
                transaction.prepareAndExecute(sql, new Object[]{batch.getBatchId(), transferMillis, batch.getBatchId(), batch.getBatchId(), batch.getNodeId(), batch.getLoadId(), batch.getBatchId(), this.engine.getNodeId()});
            }
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public int cancelExtractRequests(long loadId) {
        return this.sqlTemplate.update(this.getSql("cancelExtractRequests"), new Object[]{ExtractRequest.ExtractStatus.OK.name(), new Date(), loadId, this.engine.getNodeId(), ExtractRequest.ExtractStatus.OK.name()});
    }

    protected boolean writeBatchStats(BufferedWriter writer, char[] buffer, int bufferSize, String prevBuffer, OutgoingBatch batch) throws IOException {
        String bufferString = new String(buffer);
        int index = this.findStatsIndex(bufferString, prevBuffer);
        if (index > 0) {
            char[] prefix = Arrays.copyOf(buffer, index);
            writer.write(prefix, 0, index);
        }
        if (index > -1) {
            String stats = this.getBatchStatsColumns() + System.lineSeparator() + this.getBatchStats(batch) + System.lineSeparator();
            char[] statsBuffer = stats.toCharArray();
            writer.write(statsBuffer, 0, statsBuffer.length);
            char[] suffix = Arrays.copyOfRange(buffer, index, buffer.length);
            writer.write(suffix, 0, bufferSize - index);
        } else {
            writer.write(buffer, 0, bufferSize);
        }
        return index > -1;
    }

    protected String getBatchStatsColumns() {
        return StringUtils.join((Object[])new String[]{"stats_columns", "LOAD_FLAG", "EXTRACT_COUNT", "SENT_COUNT", "LOAD_COUNT", "LOAD_ID", "COMMON_FLAG", "ROUTER_MILLIS", "EXTRACT_MILLIS", "TRANSFORM_EXTRACT_MILLIS", "TRANSFORM_LOAD_MILLIS", "RELOAD_ROW_COUNT", "OTHER_ROW_COUNT", "DATA_ROW_COUNT", "DATA_INSERT_ROW_COUNT", "DATA_UPDATE_ROW_COUNT", "DATA_DELETE_ROW_COUNT", "EXTRACT_ROW_COUNT", "EXTRACT_INSERT_ROW_COUNT", "EXTRACT_UPDATE_ROW_COUNT", "EXTRACT_DELETE_ROW_COUNT", "FAILED_DATA_ID"}, (char)',');
    }

    protected String getBatchStats(OutgoingBatch batch) {
        return StringUtils.join((Object[])new String[]{"stats", String.valueOf(batch.isLoadFlag() ? 1 : 0), String.valueOf(batch.getExtractCount()), String.valueOf(batch.getSentCount()), String.valueOf(batch.getLoadCount()), String.valueOf(batch.getLoadId()), String.valueOf(batch.isCommonFlag() ? 1 : 0), String.valueOf(batch.getRouterMillis()), String.valueOf(batch.getExtractMillis()), String.valueOf(batch.getTransformExtractMillis()), String.valueOf(batch.getTransformLoadMillis()), String.valueOf(batch.getReloadRowCount()), String.valueOf(batch.getOtherRowCount()), String.valueOf(batch.getDataRowCount()), String.valueOf(batch.getDataInsertRowCount()), String.valueOf(batch.getDataUpdateRowCount()), String.valueOf(batch.getDataDeleteRowCount()), String.valueOf(batch.getExtractRowCount()), String.valueOf(batch.getExtractInsertRowCount()), String.valueOf(batch.getExtractUpdateRowCount()), String.valueOf(batch.getExtractDeleteRowCount()), String.valueOf(batch.getFailedDataId())}, (char)',');
    }

    @Override
    public boolean extractBatchRange(Writer writer, String nodeId, long startBatchId, long endBatchId) {
        boolean foundBatch = false;
        Node sourceNode = this.nodeService.findIdentity();
        for (long batchId = startBatchId; batchId <= endBatchId; ++batchId) {
            OutgoingBatch batch = this.outgoingBatchService.findOutgoingBatch(batchId, nodeId);
            if (batch == null) continue;
            Node targetNode = this.nodeService.findNode(nodeId, true);
            if (targetNode == null && "-1".equals(nodeId)) {
                targetNode = new Node();
                targetNode.setNodeId("-1");
            }
            if (targetNode == null) continue;
            ExtractDataReader dataReader = this.buildExtractDataReader(sourceNode, targetNode, batch, new ProcessInfo());
            DataContext ctx = new DataContext();
            ctx.put("targetNode", (Object)targetNode);
            ctx.put("sourceNode", (Object)this.nodeService.findIdentity());
            new DataProcessor((IDataReader)dataReader, (IDataWriter)this.createTransformDataWriter(this.nodeService.findIdentity(), targetNode, (IDataWriter)new ProtocolDataWriter(this.nodeService.findIdentityNodeId(), writer, targetNode.requires13Compatiblity(), false, false)), "extract range").process(ctx);
            foundBatch = true;
        }
        return foundBatch;
    }

    @Override
    public boolean extractBatchRange(Writer writer, String nodeId, Date startBatchTime, Date endBatchTime, String ... channelIds) {
        boolean foundBatch = false;
        Node sourceNode = this.nodeService.findIdentity();
        OutgoingBatches batches = this.outgoingBatchService.getOutgoingBatchRange(nodeId, startBatchTime, endBatchTime, channelIds);
        List<OutgoingBatch> list = batches.getBatches();
        for (OutgoingBatch outgoingBatch : list) {
            Node targetNode = this.nodeService.findNode(nodeId, true);
            if (targetNode == null && "-1".equals(nodeId)) {
                targetNode = new Node();
                targetNode.setNodeId("-1");
            }
            if (targetNode == null) continue;
            ExtractDataReader dataReader = this.buildExtractDataReader(sourceNode, targetNode, outgoingBatch, new ProcessInfo());
            DataContext ctx = new DataContext();
            ctx.put("targetNode", (Object)targetNode);
            ctx.put("sourceNode", (Object)this.nodeService.findIdentity());
            new DataProcessor((IDataReader)dataReader, (IDataWriter)this.createTransformDataWriter(this.nodeService.findIdentity(), targetNode, (IDataWriter)new ProtocolDataWriter(this.nodeService.findIdentityNodeId(), writer, targetNode.requires13Compatiblity(), false, false)), "extract range").process(ctx);
            foundBatch = true;
        }
        return foundBatch;
    }

    protected TransformWriter createTransformDataWriter(Node identity, Node targetNode, IDataWriter extractWriter) {
        List<TransformService.TransformTableNodeGroupLink> transformsList = null;
        if (targetNode != null) {
            transformsList = this.transformService.findTransformsFor(new NodeGroupLink(identity.getNodeGroupId(), targetNode.getNodeGroupId()), TransformPoint.EXTRACT);
        }
        TransformTable[] transforms = transformsList != null ? transformsList.toArray(new TransformTable[transformsList.size()]) : null;
        TransformWriter transformExtractWriter = new TransformWriter(this.symmetricDialect.getTargetPlatform(), TransformPoint.EXTRACT, extractWriter, this.transformService.getColumnTransforms(), transforms);
        return transformExtractWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteNodeStatuses queueWork(boolean force) {
        RemoteNodeStatuses statuses = new RemoteNodeStatuses(this.configurationService.getChannels(false));
        Node identity = this.nodeService.findIdentity();
        if (identity != null) {
            if (force || this.clusterService.lock("Initial Load Extract")) {
                try {
                    List<NodeQueuePair> nodes = this.getExtractRequestNodes();
                    for (NodeQueuePair pair : nodes) {
                        this.clusterService.refreshLock("Initial Load Extract");
                        this.queue(pair.getNodeId(), pair.getQueue(), statuses);
                    }
                }
                finally {
                    if (!force) {
                        this.clusterService.unlock("Initial Load Extract");
                    }
                }
            }
        } else {
            this.log.debug("Not running initial load extract service because this node does not have an identity");
        }
        return statuses;
    }

    protected void queue(String nodeId, String queue, RemoteNodeStatuses statuses) {
        NodeCommunication.CommunicationType TYPE = NodeCommunication.CommunicationType.EXTRACT;
        int availableThreads = this.nodeCommunicationService.getAvailableThreads(TYPE);
        NodeCommunication lock = this.nodeCommunicationService.find(nodeId, queue, TYPE);
        if (availableThreads > 0) {
            this.nodeCommunicationService.execute(lock, statuses, this);
        }
    }

    public List<NodeQueuePair> getExtractRequestNodes() {
        return this.sqlTemplate.query(this.getSql("selectNodeIdsForExtractSql"), (ISqlRowMapper)new NodeQueuePairMapper(), new Object[]{ExtractRequest.ExtractStatus.NE.name(), this.engine.getNodeId()});
    }

    protected List<ExtractRequest> getExtractRequestsForNode(NodeCommunication nodeCommunication) {
        return this.sqlTemplate.query(this.getSql("selectExtractRequestForNodeSql"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{nodeCommunication.getNodeId(), nodeCommunication.getQueue(), ExtractRequest.ExtractStatus.NE.name(), this.engine.getNodeId()});
    }

    protected ExtractRequest getExtractRequestForBatch(OutgoingBatch batch) {
        return (ExtractRequest)this.sqlTemplate.queryForObject(this.getSql("selectExtractRequestForBatchSql"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{batch.getBatchId(), batch.getBatchId(), batch.getNodeId(), batch.getLoadId(), this.engine.getNodeId()});
    }

    protected Map<Long, List<ExtractRequest>> getExtractChildRequestsForNode(NodeCommunication nodeCommunication, List<ExtractRequest> parentRequests) {
        HashMap<Long, List<ExtractRequest>> requests = new HashMap<Long, List<ExtractRequest>>();
        List childRequests = this.sqlTemplate.query(this.getSql("selectExtractChildRequestForNodeSql"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{nodeCommunication.getNodeId(), nodeCommunication.getQueue(), ExtractRequest.ExtractStatus.NE.name(), this.engine.getNodeId()});
        for (ExtractRequest childRequest : childRequests) {
            ArrayList<ExtractRequest> childList = (ArrayList<ExtractRequest>)requests.get(childRequest.getParentRequestId());
            if (childList == null) {
                childList = new ArrayList<ExtractRequest>();
                requests.put(childRequest.getParentRequestId(), childList);
            }
            childList.add(childRequest);
        }
        return requests;
    }

    protected List<ExtractRequest> getExtractChildRequestsForNode(ExtractRequest parentRequest) {
        return this.sqlTemplate.query(this.getSql("selectExtractChildRequestsByParentSql"), (ISqlRowMapper)new ExtractRequestMapper(), new Object[]{parentRequest.getRequestId(), this.engine.getNodeId()});
    }

    @Override
    public void resetExtractRequest(OutgoingBatch batch) {
        ExtractRequest request = this.getExtractRequestForBatch(batch);
        if (request != null) {
            List<ProcessInfo> infos = this.statisticManager.getProcessInfos();
            for (ProcessInfo info : infos) {
                if (!info.getProcessType().equals((Object)ProcessType.INITIAL_LOAD_EXTRACT_JOB) || !request.getNodeId().equals(info.getTargetNodeId()) || info.getCurrentBatchId() < request.getStartBatchId() || info.getCurrentBatchId() > request.getEndBatchId()) continue;
                this.log.info("Sending interrupt to " + info.getKey());
                info.getThread().interrupt();
            }
            List<OutgoingBatch> batches = this.outgoingBatchService.getOutgoingBatchRange(request.getStartBatchId(), request.getEndBatchId()).getBatches();
            List<ExtractRequest> childRequests = null;
            if (request.getParentRequestId() == 0L) {
                childRequests = this.getExtractChildRequestsForNode(request);
            }
            this.restartExtractRequest(batches, request, childRequests);
        } else {
            this.log.warn("Unable to find extract request for node {} batch {} load {}", new Object[]{batch.getNodeId(), batch.getBatchId(), batch.getLoadId()});
        }
    }

    @Override
    public ExtractRequest requestExtractRequest(ISqlTransaction transaction, String nodeId, String queue, TriggerRouter triggerRouter, long startBatchId, long endBatchId, long loadId, String table, long rows, long parentRequestId) {
        long requestId = 0L;
        requestId = this.platform.supportsMultiThreadedTransactions() ? this.sequenceService.nextVal("extract_request") : this.sequenceService.nextVal(transaction, "extract_request");
        transaction.prepareAndExecute(this.getSql("insertExtractRequestSql"), new Object[]{requestId, this.engine.getNodeId(), nodeId, queue, ExtractRequest.ExtractStatus.LS.name(), startBatchId, endBatchId, triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId(), loadId, table, rows, parentRequestId, new Date(), new Date()}, new int[]{-5, 12, 12, 12, 12, -5, -5, 12, 12, -5, 12, -5, -5, 93, 93});
        ExtractRequest request = new ExtractRequest();
        request.setRequestId(requestId);
        request.setNodeId(nodeId);
        request.setQueue(queue);
        request.setStatus(ExtractRequest.ExtractStatus.LS);
        request.setStartBatchId(startBatchId);
        request.setEndBatchId(endBatchId);
        request.setRouterId(triggerRouter.getRouterId());
        request.setLoadId(loadId);
        request.setTableName(table);
        request.setRows(rows);
        request.setParentRequestId(parentRequestId);
        return request;
    }

    protected void updateExtractRequestStatus(ISqlTransaction transaction, long extractId, ExtractRequest.ExtractStatus status, long extractedRows, long extractedMillis) {
        transaction.prepareAndExecute(this.getSql("updateExtractRequestStatus"), new Object[]{status.name(), new Date(), extractedRows, extractedMillis, extractId});
    }

    protected boolean canProcessExtractRequest(ExtractRequest request, NodeCommunication.CommunicationType communicationType) {
        return !request.getTableName().equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, "file_snapshot"));
    }

    @Override
    public void execute(NodeCommunication nodeCommunication, RemoteNodeStatus status) {
        if (!this.isApplicable(nodeCommunication)) {
            this.log.debug("{} failed isApplicable check and will not run.", (Object)this);
            return;
        }
        List<ExtractRequest> requests = this.getExtractRequestsForNode(nodeCommunication);
        Map<Long, List<ExtractRequest>> allChildRequests = null;
        long ts = System.currentTimeMillis();
        if (requests.size() > 0) {
            allChildRequests = this.getExtractChildRequestsForNode(nodeCommunication, requests);
        }
        for (int i = 0; i < requests.size() && System.currentTimeMillis() - ts <= 30000L; ++i) {
            ExtractRequest request = requests.get(i);
            if (!this.canProcessExtractRequest(request, nodeCommunication.getCommunicationType())) continue;
            Node identity = this.nodeService.findIdentity();
            Node targetNode = this.nodeService.findNode(nodeCommunication.getNodeId(), true);
            this.log.info("Starting request {} to extract table {} into batches {} through {} for node {}.", new Object[]{request.getRequestId(), request.getTableName(), request.getStartBatchId(), request.getEndBatchId(), request.getNodeId()});
            List<OutgoingBatch> batches = this.outgoingBatchService.getOutgoingBatchRange(request.getStartBatchId(), request.getEndBatchId()).getBatches();
            ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(identity.getNodeId(), nodeCommunication.getQueue(), nodeCommunication.getNodeId(), this.getProcessType()));
            processInfo.setTotalBatchCount(batches.size());
            List<ExtractRequest> childRequests = allChildRequests.get(request.getRequestId());
            try {
                boolean isCanceled = true;
                boolean isRestarted = false;
                for (OutgoingBatch outgoingBatch : batches) {
                    if (outgoingBatch.getStatus() != AbstractBatch.Status.OK && outgoingBatch.getStatus() != AbstractBatch.Status.IG) {
                        isCanceled = false;
                    }
                    if (outgoingBatch.getStatus() == AbstractBatch.Status.RQ) continue;
                    isRestarted = true;
                }
                if (!isCanceled) {
                    Channel channel = this.configurationService.getChannel(batches.get(0).getChannelId());
                    OutgoingBatch firstBatch = batches.get(0);
                    processInfo.setCurrentLoadId(firstBatch.getLoadId());
                    processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
                    if (isRestarted) {
                        this.restartExtractRequest(batches, request, childRequests);
                    }
                    MultiBatchStagingWriter multiBatchStagingWriter = this.buildMultiBatchStagingWriter(request, childRequests, identity, targetNode, batches, processInfo, channel, isRestarted);
                    this.extractOutgoingBatch(processInfo, targetNode, multiBatchStagingWriter, firstBatch, false, false, ExtractMode.FOR_SYM_CLIENT, new ClusterLockRefreshListener(this.clusterService));
                    this.checkSendDeferredConstraints(request, childRequests, targetNode);
                } else {
                    this.log.info("Batches already had an OK status for request {} to extract table {} for batches {} through {} for node {}.  Not extracting.", new Object[]{request.getRequestId(), request.getTableName(), request.getStartBatchId(), request.getEndBatchId(), request.getNodeId()});
                }
                ISqlTransaction transaction = null;
                try {
                    transaction = this.sqlTemplate.startSqlTransaction();
                    long extractMillis = new Date().getTime() - processInfo.getStartTime().getTime();
                    this.updateExtractRequestStatus(transaction, request.getRequestId(), ExtractRequest.ExtractStatus.OK, processInfo.getCurrentDataCount(), extractMillis);
                    if (childRequests != null) {
                        for (ExtractRequest childRequest : childRequests) {
                            this.updateExtractRequestStatus(transaction, childRequest.getRequestId(), ExtractRequest.ExtractStatus.OK, processInfo.getCurrentDataCount(), extractMillis);
                        }
                    }
                    transaction.commit();
                    this.log.info("Done with request {} to extract table {} into batches {} through {} for node {}", new Object[]{request.getRequestId(), request.getTableName(), request.getStartBatchId(), request.getEndBatchId(), request.getNodeId()});
                }
                catch (Error ex) {
                    if (transaction != null) {
                        transaction.rollback();
                    }
                    throw ex;
                }
                catch (RuntimeException ex) {
                    if (transaction != null) {
                        transaction.rollback();
                    }
                    throw ex;
                }
                finally {
                    this.close(transaction);
                }
                this.releaseMissedExtractRequests();
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                continue;
            }
            catch (CancellationException ex) {
                this.log.info("Interrupted on request {} to extract table {} for batches {} through {} for node {}", new Object[]{request.getRequestId(), request.getTableName(), request.getStartBatchId(), request.getEndBatchId(), request.getNodeId()});
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                continue;
            }
            catch (RuntimeException ex) {
                this.log.warn("Failed on request {} to extract table {} into batches {} through {} for node {}", new Object[]{request.getRequestId(), request.getTableName(), request.getStartBatchId(), request.getEndBatchId(), request.getNodeId()});
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                if (ex instanceof StagingLowFreeSpace) {
                    this.log.error("Extract load is disabled because disk is almost full: {}", (Object)ex.getMessage());
                    break;
                }
                throw ex;
            }
        }
    }

    protected void restartExtractRequest(List<OutgoingBatch> batches, ExtractRequest request, List<ExtractRequest> childRequests) {
        this.log.info("Resetting status of request {} to extract table {} into batches {} through {} for node {}", new Object[]{request.getRequestId(), request.getTableName(), request.getStartBatchId(), request.getEndBatchId(), request.getNodeId()});
        long batchLoadedCount = 0L;
        if (request.getLastLoadedBatchId() > 0L) {
            batchLoadedCount = request.getLastLoadedBatchId() - request.getStartBatchId() + 1L;
        }
        long rowLoadedCount = request.getLoadedRows();
        ArrayList<ExtractRequest> allRequests = new ArrayList<ExtractRequest>();
        allRequests.add(request);
        if (childRequests != null) {
            allRequests.addAll(childRequests);
        }
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            for (ExtractRequest extractRequest : allRequests) {
                transaction.prepareAndExecute(this.getSql("restartExtractRequest"), new Object[]{ExtractRequest.ExtractStatus.NE.name(), extractRequest.getRequestId(), extractRequest.getNodeId()});
                if (batchLoadedCount > 0L || rowLoadedCount > 0L) {
                    this.dataService.updateTableReloadStatusDataLoaded(transaction, extractRequest.getLoadId(), this.engine.getNodeId(), extractRequest.getStartBatchId(), (int)batchLoadedCount * -1, false);
                }
                this.outgoingBatchService.updateOutgoingBatchStatus(transaction, AbstractBatch.Status.RQ, extractRequest.getNodeId(), extractRequest.getStartBatchId(), extractRequest.getEndBatchId());
            }
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
        for (OutgoingBatch outgoingBatch : batches) {
            IStagedResource resource = this.getStagedResource(outgoingBatch);
            if (resource != null) {
                resource.delete();
            }
            if (childRequests == null) continue;
            long batchIndex = outgoingBatch.getBatchId() - request.getStartBatchId();
            for (ExtractRequest extractRequest : childRequests) {
                OutgoingBatch childBatch = new OutgoingBatch(extractRequest.getNodeId(), outgoingBatch.getChannelId(), outgoingBatch.getStatus());
                childBatch.setBatchId(outgoingBatch.getBatchId() + batchIndex);
                resource = this.getStagedResource(childBatch);
                if (resource == null) continue;
                resource.delete();
            }
        }
        String symIncomingBatch = TableConstants.getTableName(this.parameterService.getTablePrefix(), "incoming_batch");
        String nodeIdentityId = this.nodeService.findIdentityNodeId();
        for (ExtractRequest extractRequest : allRequests) {
            String sql = "delete from " + symIncomingBatch + " where node_id = '" + nodeIdentityId + "' and batch_id between " + extractRequest.getStartBatchId() + " and " + extractRequest.getEndBatchId();
            this.dataService.sendSQL(extractRequest.getNodeId(), sql);
        }
        for (ExtractRequest extractRequest : allRequests) {
            TableReloadStatus reloadStatus = this.dataService.getTableReloadStatusByLoadIdAndSourceNodeId(extractRequest.getLoadId(), nodeIdentityId);
            OutgoingBatches setupBatches = this.outgoingBatchService.getOutgoingBatchByLoadRangeAndTable(extractRequest.getLoadId(), 1L, reloadStatus.getStartDataBatchId() - 1L, extractRequest.getTableName().toLowerCase());
            for (OutgoingBatch batch : setupBatches.getBatches()) {
                String sql = "delete from " + symIncomingBatch + " where node_id = '" + nodeIdentityId + "' and batch_id = " + batch.getBatchId();
                this.dataService.sendSQL(batch.getNodeId(), sql);
                batch.setStatus(AbstractBatch.Status.NE);
                this.outgoingBatchService.updateOutgoingBatch(batch);
            }
        }
    }

    @Override
    public void releaseMissedExtractRequests() {
        List requestIds = this.sqlTemplateDirty.query(this.getSql("selectExtractChildRequestIdsMissed"), (ISqlRowMapper)new LongMapper(), new Object[]{AbstractBatch.Status.NE.name(), AbstractBatch.Status.OK.name(), this.engine.getNodeId(), this.engine.getNodeId()});
        if (requestIds != null && requestIds.size() > 0) {
            this.log.info("Releasing {} child extract requests that missed processing by parent node", (Object)requestIds.size());
            for (Long requestId : requestIds) {
                this.sqlTemplate.update(this.getSql("releaseExtractChildRequestFromParent"), new Object[]{requestId});
            }
        }
    }

    protected void checkSendDeferredConstraints(ExtractRequest request, List<ExtractRequest> childRequests, Node targetNode) {
        TableReloadRequest reloadRequest;
        if (this.parameterService.is("initial.load.defer.create.constraints", false) && ((reloadRequest = this.dataService.getTableReloadRequest(request.getLoadId(), request.getTriggerId(), request.getRouterId())) != null && reloadRequest.isCreateTable() || reloadRequest == null && this.parameterService.is("initial.load.create.first"))) {
            List<TriggerHistory> histories;
            boolean success = false;
            Trigger trigger = this.triggerRouterService.getTriggerById(request.getTriggerId());
            if (trigger != null && (histories = this.triggerRouterService.getActiveTriggerHistories(this.triggerRouterService.getTriggerById(request.getTriggerId()))) != null && histories.size() > 0) {
                for (TriggerHistory history : histories) {
                    Channel channel = this.configurationService.getChannel(trigger.getReloadChannelId());
                    if (channel.isFileSyncFlag() || !history.getSourceTableName().equalsIgnoreCase(request.getTableName())) continue;
                    Data data = new Data(history.getSourceTableName(), DataEventType.CREATE, null, String.valueOf(request.getLoadId()), history, trigger.getChannelId(), null, null);
                    data.setNodeList(targetNode.getNodeId());
                    this.dataService.insertData(data);
                    if (childRequests == null) continue;
                    for (ExtractRequest childRequest : childRequests) {
                        data = new Data(history.getSourceTableName(), DataEventType.CREATE, null, String.valueOf(childRequest.getLoadId()), history, trigger.getChannelId(), null, null);
                        data.setNodeList(childRequest.getNodeId());
                        this.dataService.insertData(data);
                    }
                }
                success = true;
            }
            if (!success) {
                this.log.warn("Unable to send deferred constraints for trigger '{}' router '{}' in load {}", new Object[]{reloadRequest.getTriggerId(), reloadRequest.getRouterId(), reloadRequest.getLoadId()});
            }
        }
    }

    protected boolean isApplicable(NodeCommunication nodeCommunication) {
        return nodeCommunication.getCommunicationType() != NodeCommunication.CommunicationType.FILE_XTRCT;
    }

    protected MultiBatchStagingWriter buildMultiBatchStagingWriter(ExtractRequest request, List<ExtractRequest> childRequests, Node sourceNode, Node targetNode, List<OutgoingBatch> batches, ProcessInfo processInfo, Channel channel, boolean isRestarted) {
        MultiBatchStagingWriter multiBatchStatingWriter = new MultiBatchStagingWriter(this.engine, request, childRequests, sourceNode.getNodeId(), batches, channel.getMaxBatchSize(), processInfo, isRestarted);
        return multiBatchStatingWriter;
    }

    protected ProcessType getProcessType() {
        return ProcessType.INITIAL_LOAD_EXTRACT_JOB;
    }

    @Override
    public void removeBatchFromStaging(OutgoingBatch batch) {
        IStagedResource resource = this.getStagedResource(batch);
        if (resource != null) {
            resource.delete();
        } else {
            this.log.info("Could not remove batch {} from staging because it did not exist", (Object)batch.getNodeBatchId());
        }
    }

    @Override
    public void updateExtractRequestStatuses(ISqlTransaction transaction, long loadId, String sourceNodeId, String fromStatus, String toStatus) {
        transaction.prepareAndExecute(this.getSql("updateExtractRequestStatuses"), new Object[]{toStatus, new Date(), loadId, sourceNodeId, fromStatus});
    }

    private /* synthetic */ FutureOutgoingBatch lambda$extract$1(long batchesSelectedAtMs, OutgoingBatch extractBatch, FutureExtractStatus status, ProcessInfo extractInfo, Node targetNode, IDataWriter dataWriter, ExtractMode mode, List activeBatches) throws Exception {
        MDC.put((String)"engineName", (String)this.engine.getParameterService().getEngineName());
        OutgoingBatch refreshedBatch = this.requeryIfEnoughTimeHasPassed(batchesSelectedAtMs, extractBatch);
        return this.extractBatch(refreshedBatch, status, extractInfo, targetNode, dataWriter, mode, activeBatches);
    }

    static class BatchLock {
        String semaphoreKey;
        private Semaphore inMemoryLock = new Semaphore(1);
        StagingFileLock fileLock;
        int referenceCount = 0;

        public BatchLock(String semaphoreKey) {
            this.semaphoreKey = semaphoreKey;
        }

        public void acquire() throws java.lang.InterruptedException {
            this.inMemoryLock.acquire();
        }

        public void release() {
            this.inMemoryLock.release();
        }
    }

    static class FutureOutgoingBatch {
        OutgoingBatch outgoingBatch;
        boolean isRetry;
        boolean isExtractSkipped;

        public FutureOutgoingBatch(OutgoingBatch outgoingBatch, boolean isRetry) {
            this.outgoingBatch = outgoingBatch;
            this.isRetry = isRetry;
        }

        public OutgoingBatch getOutgoingBatch() {
            return this.outgoingBatch;
        }

        public boolean isRetry() {
            return this.isRetry;
        }
    }

    static class FutureExtractStatus {
        boolean shouldExtractSkip;
        int batchExtractCount;
        int byteExtractCount;

        FutureExtractStatus() {
        }
    }

    class ExtractRequestMapper
    implements ISqlRowMapper<ExtractRequest> {
        ExtractRequestMapper() {
        }

        public ExtractRequest mapRow(Row row) {
            ExtractRequest request = new ExtractRequest();
            request.setNodeId(row.getString("node_id"));
            request.setRequestId(row.getLong("request_id"));
            request.setStartBatchId(row.getLong("start_batch_id"));
            request.setEndBatchId(row.getLong("end_batch_id"));
            request.setStatus(ExtractRequest.ExtractStatus.valueOf(row.getString("status").toUpperCase()));
            request.setCreateTime(row.getDateTime("create_time"));
            request.setLastUpdateTime(row.getDateTime("last_update_time"));
            request.setTriggerId(row.getString("trigger_id"));
            request.setRouterId(row.getString("router_id"));
            request.setTriggerRouter(DataExtractorService.this.triggerRouterService.findTriggerRouterById(row.getString("trigger_id"), row.getString("router_id"), false));
            request.setQueue(row.getString("queue"));
            request.setLoadId(row.getLong("load_id"));
            request.setTableName(row.getString("table_name"));
            request.setRows(row.getLong("total_rows"));
            request.setTransferredRows(row.getLong("transferred_rows"));
            request.setLastTransferredBatchId(row.getLong("last_transferred_batch_id"));
            request.setLoadedRows(row.getLong("loaded_rows"));
            request.setLastLoadedBatchId(row.getLong("last_loaded_batch_id"));
            request.setTransferredMillis(row.getLong("transferred_millis"));
            request.setLoadedMillis(row.getLong("loaded_millis"));
            request.setParentRequestId(row.getLong("parent_request_id"));
            request.setExtractedRows(row.getLong("extracted_rows"));
            request.setExtractedMillis(row.getLong("extracted_millis"));
            return request;
        }
    }

    static class NodeQueuePairMapper
    implements ISqlRowMapper<NodeQueuePair> {
        NodeQueuePairMapper() {
        }

        public NodeQueuePair mapRow(Row row) {
            NodeQueuePair pair = new NodeQueuePair();
            pair.setNodeId(row.getString("node_id"));
            pair.setQueue(row.getString("queue"));
            return pair;
        }
    }

    private static class NodeQueuePair {
        private String nodeId;
        private String queue;

        private NodeQueuePair() {
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getQueue() {
            return this.queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }
    }

    protected static enum ExtractMode {
        FOR_SYM_CLIENT,
        FOR_PAYLOAD_CLIENT,
        EXTRACT_ONLY;

    }
}

