/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IExtensionService extensionService;
    protected TypedProperties parameters;
    private long cacheTimeoutInMs = 0L;
    private long lastTimeParameterWereCached;
    protected Properties systemProperties = (Properties)System.getProperties().clone();
    protected boolean databaseHasBeenInitialized = false;
    protected boolean databaseHasBeenSetup = false;
    protected String externalId = null;
    protected String engineName = null;
    protected String nodeGroupId = null;
    protected String syncUrl = null;
    protected String registrationUrl = null;

    public BigDecimal getDecimal(String key, BigDecimal defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException ex) {
                TypedProperties.logPropertiesException((Logger)this.log, (String)key, (String)val);
            }
        }
        return defaultVal;
    }

    public BigDecimal getDecimal(String key) {
        return this.getDecimal(key, BigDecimal.ZERO);
    }

    public boolean is(String key) {
        return this.is(key, false);
    }

    public boolean is(String key, boolean defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            if ((val = val.trim()).equals("1")) {
                return true;
            }
            return Boolean.parseBoolean(val);
        }
        return defaultVal;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            try {
                return Integer.parseInt(val.trim());
            }
            catch (NumberFormatException ex) {
                TypedProperties.logPropertiesException((Logger)this.log, (String)key, (String)val);
            }
        }
        return defaultVal;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException ex) {
                TypedProperties.logPropertiesException((Logger)this.log, (String)key, (String)val);
            }
        }
        return defaultVal;
    }

    public String getString(String key, String defaultVal) {
        String value = this.getParameters().get(key, defaultVal);
        return StringUtils.isBlank((CharSequence)value) ? defaultVal : value;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getTempDirectory() {
        String engineName = this.getEngineName();
        String tmpDirBase = this.getString("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
        if (StringUtils.trimToNull((String)engineName) == null) {
            return tmpDirBase;
        }
        return tmpDirBase + File.separator + engineName;
    }

    protected abstract TypedProperties rereadApplicationParameters();

    public synchronized void rereadParameters() {
        this.lastTimeParameterWereCached = 0L;
        this.getParameters();
    }

    protected synchronized TypedProperties getParameters() {
        long timeoutTime = System.currentTimeMillis() - this.cacheTimeoutInMs;
        if (this.parameters == null || this.cacheTimeoutInMs > 0L && this.lastTimeParameterWereCached < timeoutTime) {
            try {
                this.parameters = this.rereadApplicationParameters();
                SymmetricUtils.replaceSystemAndEnvironmentVariables((Properties)this.parameters);
                this.lastTimeParameterWereCached = System.currentTimeMillis();
                this.cacheTimeoutInMs = this.getInt("parameter.reload.timeout.ms");
            }
            catch (SqlException ex) {
                if (this.parameters == null) {
                    this.log.error("Could not read database parameters and they have not yet been initialized");
                    throw ex;
                }
                this.log.warn("Could not read database parameters.  We will try again later", (Throwable)ex);
                throw ex;
            }
        }
        return this.parameters;
    }

    public TypedProperties getAllParameters() {
        return this.getParameters();
    }

    public Date getLastTimeParameterWereCached() {
        return new Date(this.lastTimeParameterWereCached);
    }

    public String getExternalId() {
        if (this.externalId == null) {
            String value = this.getString("external.id");
            this.externalId = value = this.substituteScripts(value);
            if (this.log.isDebugEnabled()) {
                this.log.debug("External Id eval results in: {}", (Object)this.externalId);
            }
        }
        return this.externalId;
    }

    public String getSyncUrl() {
        if (this.syncUrl == null) {
            String value = this.getString("sync.url");
            if ((value = this.substituteScripts(value)) != null) {
                value = value.trim();
            }
            this.syncUrl = value;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sync URL eval results in: {}", (Object)this.syncUrl);
            }
        }
        return this.syncUrl;
    }

    public String getNodeGroupId() {
        if (this.nodeGroupId == null) {
            String value = this.getString("group.id");
            this.nodeGroupId = value = this.substituteScripts(value);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node Group Id eval results in: {}", (Object)this.nodeGroupId);
            }
        }
        return this.nodeGroupId;
    }

    public String getRegistrationUrl() {
        if (this.registrationUrl == null) {
            String value = this.getString("registration.url");
            if ((value = this.substituteScripts(value)) != null) {
                value = value.trim();
            }
            this.registrationUrl = value;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registration URL eval results in: {}", (Object)this.registrationUrl);
            }
        }
        return this.registrationUrl;
    }

    public String getEngineName() {
        if (this.engineName == null) {
            String value = this.getString("engine.name", "SymmetricDS");
            this.engineName = value = this.substituteScripts(value);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Engine Name eval results in: {}", (Object)this.engineName);
            }
        }
        return this.engineName;
    }

    public Map<String, String> getReplacementValues() {
        HashMap<String, String> replacementValues = new HashMap<String, String>(2);
        replacementValues.put("nodeGroupId", this.getNodeGroupId());
        replacementValues.put("externalId", this.getExternalId());
        replacementValues.put("engineName", this.getEngineName());
        replacementValues.put("syncUrl", this.getSyncUrl());
        replacementValues.put("registrationUrl", this.getRegistrationUrl());
        return replacementValues;
    }

    public synchronized void setDatabaseHasBeenInitialized(boolean databaseHasBeenInitialized) {
        if (this.databaseHasBeenInitialized != databaseHasBeenInitialized) {
            this.databaseHasBeenInitialized = databaseHasBeenInitialized;
            this.parameters = null;
        }
    }

    public synchronized void setDatabaseHasBeenSetup(boolean databaseHasBeenSetup) {
        this.databaseHasBeenSetup = databaseHasBeenSetup;
    }

    public synchronized boolean hasDatabaseBeenSetup() {
        return this.databaseHasBeenSetup;
    }

    public abstract TypedProperties getDatabaseParameters(String var1, String var2);

    protected synchronized TypedProperties rereadDatabaseParameters(Properties p) {
        if (this.databaseHasBeenInitialized) {
            TypedProperties properties = this.getDatabaseParameters("ALL", "ALL");
            properties.putAll((Properties)this.getDatabaseParameters("ALL", p.getProperty("group.id")));
            properties.putAll((Properties)this.getDatabaseParameters(p.getProperty("external.id"), p.getProperty("group.id")));
            return properties;
        }
        return new TypedProperties();
    }

    public void setExtensionService(IExtensionService extensionService) {
        this.extensionService = extensionService;
    }

    protected String substituteScripts(String value) {
        int endTick;
        int startTick;
        if (this.log.isDebugEnabled()) {
            this.log.debug("substituteScripts starting value is: {}", (Object)value);
        }
        if ((startTick = StringUtils.indexOf((CharSequence)value, (int)96)) != -1 && (endTick = StringUtils.lastIndexOf((CharSequence)value, (int)96)) != -1 && startTick != endTick) {
            String script = StringUtils.substring((String)value, (int)(startTick + 1), (int)endTick);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Script found.  Script is is: {}", (Object)script);
            }
            Interpreter interpreter = new Interpreter();
            try {
                interpreter.set("hostName", (Object)AppUtils.getHostName());
                interpreter.set("log", (Object)this.log);
                interpreter.set("nodeGroupId", (Object)this.nodeGroupId);
                interpreter.set("syncUrl", (Object)this.syncUrl);
                interpreter.set("registrationUrl", (Object)this.registrationUrl);
                interpreter.set("externalId", (Object)this.externalId);
                interpreter.set("engineName", (Object)this.engineName);
                Object scriptResult = interpreter.eval(script);
                if (scriptResult == null) {
                    scriptResult = "";
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Script output is: {}", scriptResult);
                }
                value = StringUtils.substring((String)value, (int)0, (int)startTick) + scriptResult.toString() + StringUtils.substring((String)value, (int)(endTick + 1));
            }
            catch (EvalError e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("substituteScripts return value is {}", (Object)value);
            }
        }
        return value;
    }
}

