/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.InvalidSqlException;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.util.FormatUtils;

public class SubSelectDataRouter
extends AbstractDataRouter
implements IBuiltInExtensionPoint {
    private static final String SQL = "select c.node_id from $(prefixName)_node c where c.node_group_id=:NODE_GROUP_ID and c.sync_enabled=1 and ";
    private ISymmetricDialect symmetricDialect;

    public SubSelectDataRouter(ISymmetricDialect symmetricDialect) {
        this.symmetricDialect = symmetricDialect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<String> routeToNodes(SimpleRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        String sql = FormatUtils.replaceToken((String)SQL, (String)"prefixName", (String)this.symmetricDialect.getTablePrefix(), (boolean)true);
        String subSelect = dataMetaData.getRouter().getRouterExpression();
        Set<String> nodeIds = null;
        if (!StringUtils.isBlank((CharSequence)subSelect) && !initialLoadSelectUsed) {
            try {
                Map<String, Object> sqlParams = this.getDataObjectMap(dataMetaData, this.symmetricDialect, true);
                sqlParams.put("NODE_GROUP_ID", dataMetaData.getRouter().getNodeGroupLink().getTargetNodeGroupId());
                sqlParams.put("EXTERNAL_DATA", dataMetaData.getData().getExternalData());
                sqlParams.put("DATA_EVENT_TYPE", dataMetaData.getData().getDataEventType().name());
                sqlParams.put("TABLE_NAME", dataMetaData.getData().getTableName());
                ISqlTemplate template = this.symmetricDialect.getPlatform().getSqlTemplate();
                long queryStartTime = System.currentTimeMillis();
                List ids = template.query(String.format("%s(%s)", sql, subSelect), (ISqlRowMapper)new StringMapper(), sqlParams);
                long queryEndTime = System.currentTimeMillis();
                String routerId = dataMetaData.getRouter().getRouterId();
                SimpleRouterContext.RouterTimer rt = routingContext.addQueryTime(routerId, queryEndTime - queryStartTime);
                if (rt.getQueryTime() > 60000L) {
                    rt.resetQueryTime();
                    this.log.info("Subselect data router with id: {} has total query time of {} seconds.", (Object)routerId, (Object)(rt.getTotalQueryTime() / 1000L));
                }
                if (ids == null) return nodeIds;
                return new HashSet<String>(ids);
            }
            catch (InvalidSqlException ex) {
                this.log.error("The subselect expression was invalid for the {} subselect router for the '{}' event for table '{}'", new Object[]{dataMetaData.getRouter().getRouterId(), dataMetaData.getData().getDataEventType().name(), dataMetaData.getData().getTableName()});
                throw ex;
            }
        }
        if (!initialLoadSelectUsed) throw new InvalidSqlException("The subselect expression is missing for the %s router", new Object[]{dataMetaData.getRouter().getRouterId()});
        return this.toNodeIds(nodes, null);
    }
}

