/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.IRouterService;

public class FileSyncDataRouter
extends AbstractDataRouter
implements IBuiltInExtensionPoint {
    public static final String ROUTER_TYPE = "filesync";
    private ISymmetricEngine engine;

    public FileSyncDataRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        HashSet<String> nodeIds = new HashSet<String>();
        IFileSyncService fileSyncService = this.engine.getFileSyncService();
        IRouterService routerService = this.engine.getRouterService();
        Map<String, String> newData = this.getNewDataAsString(null, dataMetaData, this.engine.getSymmetricDialect());
        String triggerId = newData.get("TRIGGER_ID");
        String routerId = newData.get("ROUTER_ID");
        String sourceNodeId = newData.get("LAST_UPDATE_BY");
        String lastEventType = newData.get("LAST_EVENT_TYPE");
        if (triggerId == null) {
            Map<String, String> oldData = this.getOldDataAsString(null, dataMetaData, this.engine.getSymmetricDialect());
            triggerId = oldData.get("TRIGGER_ID");
            routerId = oldData.get("ROUTER_ID");
            sourceNodeId = oldData.get("LAST_UPDATE_BY");
            lastEventType = oldData.get("LAST_EVENT_TYPE");
        }
        FileSnapshot.LastEventType eventType = FileSnapshot.LastEventType.fromCode(lastEventType);
        FileTriggerRouter fileTriggerRouter = fileSyncService.getFileTriggerRouter(triggerId, routerId, false);
        if (fileTriggerRouter != null && fileTriggerRouter.isEnabled()) {
            if (fileTriggerRouter.getRouter().getNodeGroupLink().equals(triggerRouter.getRouter().getNodeGroupLink()) && (eventType == null || eventType == FileSnapshot.LastEventType.DELETE && fileTriggerRouter.getFileTrigger().isSyncOnDelete() || eventType == FileSnapshot.LastEventType.MODIFY && fileTriggerRouter.getFileTrigger().isSyncOnModified() || eventType == FileSnapshot.LastEventType.CREATE && fileTriggerRouter.getFileTrigger().isSyncOnCreate())) {
                Router router = fileTriggerRouter.getRouter();
                Map<String, IDataRouter> routers = routerService.getRouters();
                IDataRouter dataRouter = null;
                if (StringUtils.isNotBlank((CharSequence)router.getRouterType())) {
                    dataRouter = routers.get(router.getRouterType());
                }
                if (dataRouter == null) {
                    dataRouter = routers.get("default");
                }
                if (context instanceof ChannelRouterContext) {
                    ((ChannelRouterContext)context).addUsedDataRouter(dataRouter);
                }
                dataMetaData.setRouter(router);
                Set<String> dataRouterNodeIds = dataRouter.routeToNodes(context, dataMetaData, nodes, false, false, triggerRouter);
                if (dataRouterNodeIds != null) {
                    nodeIds.addAll(dataRouterNodeIds);
                }
                nodeIds.remove(sourceNodeId);
            }
        } else if (context != null && context.getChannel() != null && !context.getChannel().isFileSyncFlag()) {
            this.log.error("One or more file triggers use the '{}' channel, which is not configured for file sync.", (Object)context.getChannel().getChannelId());
        } else {
            this.log.error("Could not find a trigger router with a trigger_id of {} and a router_id of {}.  The file snapshot will not be routed", (Object)triggerId, (Object)routerId);
        }
        return nodeIds;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }
}

