/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SyntaxParsingException;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;

public class ColumnMatchDataRouter
extends AbstractDataRouter
implements IDataRouter,
IBuiltInExtensionPoint {
    private static final String NULL_VALUE = "NULL";
    private ISymmetricEngine engine;
    static final String EXPRESSION_KEY = String.format("%s.Expression.", ColumnMatchDataRouter.class.getName());

    public ColumnMatchDataRouter() {
    }

    public ColumnMatchDataRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        Set<String> nodeIds = null;
        if (initialLoadSelectUsed && initialLoad) {
            nodeIds = this.toNodeIds(nodes, null);
        } else {
            List<Expression> expressions = this.getExpressions(dataMetaData.getRouter(), routingContext);
            Map<String, String> columnValues = this.getDataMap(dataMetaData, this.engine.getSymmetricDialect());
            if (columnValues != null) {
                Node identity = this.engine.getNodeService().findIdentity();
                for (Expression e : expressions) {
                    String column = e.tokens[0].trim();
                    String value = e.tokens[1];
                    String columnValue = columnValues.get(column);
                    if (value.equalsIgnoreCase(":NODE_ID")) {
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, node.getNodeId(), nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":SOURCE_NODE_ID")) {
                        String sourceNodeId = identity.getNodeId();
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, sourceNodeId, nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":EXTERNAL_ID")) {
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, node.getExternalId(), nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":SOURCE_EXTERNAL_ID")) {
                        String sourceExternalId = identity.getExternalId();
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, sourceExternalId, nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":NODE_GROUP_ID")) {
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, node.getNodeGroupId(), nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":SOURCE_NODE_GROUP_ID")) {
                        String sourceNodeGroupId = identity.getNodeGroupId();
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, sourceNodeGroupId, nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (e.hasEquals && value.equalsIgnoreCase(":REDIRECT_NODE")) {
                        Map<String, String> redirectMap = this.getRedirectMap(routingContext);
                        String string = redirectMap.get(columnValue);
                        if (string == null) continue;
                        nodeIds = this.addNodeId(string, nodeIds, nodes);
                        continue;
                    }
                    String compareValue = value;
                    if (value.equalsIgnoreCase(":EXTERNAL_DATA")) {
                        compareValue = dataMetaData.getData().getExternalData();
                    } else if (value.startsWith(":")) {
                        compareValue = columnValues.get(value.substring(1));
                    } else if (value.equals(NULL_VALUE)) {
                        compareValue = null;
                    }
                    nodeIds = this.runExpression(e, columnValue, compareValue, nodes, nodeIds, null);
                }
            } else {
                this.log.warn("There were no columns to match for the data_id of {}", (Object)dataMetaData.getData().getDataId());
            }
        }
        if (nodeIds != null) {
            nodeIds.remove(null);
        } else {
            nodeIds = Collections.emptySet();
        }
        return nodeIds;
    }

    protected Set<String> runExpression(Expression e, String columnValue, String compareValue, Set<Node> nodes, Set<String> nodeIds, Node node) {
        boolean result = false;
        if (e.hasEquals && (columnValue == null && compareValue == null || columnValue != null && columnValue.equals(compareValue))) {
            result = true;
        } else if (e.hasNotEquals && (columnValue == null && compareValue != null || columnValue != null && !columnValue.equals(compareValue))) {
            result = true;
        } else if (e.hasContains && columnValue != null && compareValue != null && ArrayUtils.contains((Object[])columnValue.split(","), (Object)compareValue)) {
            result = true;
        } else if (e.hasNotContains && columnValue != null && compareValue != null && !ArrayUtils.contains((Object[])columnValue.split(","), (Object)compareValue)) {
            result = true;
        }
        if (result) {
            nodeIds = node != null ? this.addNodeId(node.getNodeId(), nodeIds, nodes) : this.toNodeIds(nodes, nodeIds);
        }
        return nodeIds;
    }

    protected List<Expression> getExpressions(Router router, SimpleRouterContext context) {
        String KEY = EXPRESSION_KEY + router.getRouterId();
        List<Expression> expressions = (List<Expression>)context.getContextCache().get(KEY);
        if (expressions == null) {
            expressions = this.parse(router.getRouterExpression());
            context.getContextCache().put(KEY, expressions);
        }
        return expressions;
    }

    public List<Expression> parse(String routerExpression) throws SyntaxParsingException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (!StringUtils.isBlank((CharSequence)routerExpression)) {
            String[] operators = new String[]{"!=", "=", "not contains", "contains"};
            String[] expTokens = routerExpression.split("\\s*(\\s+or|\\s+OR)?(\r\n|\r|\n)(or\\s+|OR\\s+)?\\s*|\\s+or\\s+|\\s+OR\\s+");
            if (expTokens != null) {
                for (String t : expTokens) {
                    if (StringUtils.isBlank((CharSequence)t)) continue;
                    boolean isFound = false;
                    for (String operator : operators) {
                        String[] tokens;
                        if (!t.contains(operator) || (tokens = t.split(operator)).length != 2) continue;
                        tokens[0] = this.parseColumn(tokens[0]);
                        tokens[1] = this.parseValue(tokens[1]);
                        expressions.add(new Expression(operator, tokens));
                        isFound = true;
                        break;
                    }
                    if (isFound) continue;
                    this.log.warn("The provided column match expression was invalid: {}.  The full expression is {}.", (Object)t, (Object)routerExpression);
                    throw new SyntaxParsingException("The provided column match expression was invalid: " + t + ".  The full expression is " + routerExpression + ".", new Object[0]);
                }
            }
        } else {
            this.log.warn("The provided column match expression is empty");
        }
        return expressions;
    }

    private String parseColumn(String value) {
        return value.trim();
    }

    private String parseValue(String value) {
        if ((value = value.trim()).charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
            value = value.substring(1, value.length() - 1);
            value = value.replaceAll("''", "'");
        }
        return value;
    }

    protected Map<String, String> getRedirectMap(SimpleRouterContext ctx) {
        String CTX_CACHE_KEY = ColumnMatchDataRouter.class.getSimpleName() + "RouterMap";
        Map<String, String> redirectMap = (Map<String, String>)ctx.getContextCache().get(CTX_CACHE_KEY);
        if (redirectMap == null) {
            redirectMap = this.engine.getConfigurationService().getRegistrationRedirectMap();
            ctx.getContextCache().put(CTX_CACHE_KEY, redirectMap);
        }
        return redirectMap;
    }

    public static class Expression {
        public static final String EQUALS = "=";
        public static final String NOT_EQUALS = "!=";
        public static final String CONTAINS = "contains";
        public static final String NOT_CONTAINS = "not contains";
        boolean hasEquals;
        boolean hasNotEquals;
        boolean hasContains;
        boolean hasNotContains;
        String[] tokens;
        String operator;

        public Expression(String operator, String[] tokens) {
            this.tokens = tokens;
            this.operator = operator;
            if (operator.equals(EQUALS)) {
                this.hasEquals = true;
            } else if (operator.equals(NOT_EQUALS)) {
                this.hasNotEquals = true;
            } else if (operator.equals(CONTAINS)) {
                this.hasContains = true;
            } else if (operator.equals(NOT_CONTAINS)) {
                this.hasNotContains = true;
            }
        }

        public String[] getTokens() {
            return this.tokens;
        }

        public String getOperator() {
            return this.operator;
        }

        public boolean hasEquals() {
            return this.hasEquals;
        }

        public boolean hasNotEquals() {
            return this.hasEquals;
        }

        public boolean hasContains() {
            return this.hasEquals;
        }

        public boolean hasNotContains() {
            return this.hasEquals;
        }
    }
}

