/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.monitor.IMonitorType;

public class MonitorTypeFileHandles
implements IMonitorType,
IBuiltInExtensionPoint {
    @Override
    public String getName() {
        return "fileHandles";
    }

    @Override
    public MonitorEvent check(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        try {
            ObjectName oName = new ObjectName("java.lang:type=OperatingSystem");
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            int openFiles = Integer.parseInt(mbeanServer.getAttribute(oName, "OpenFileDescriptorCount").toString());
            int maxCount = Integer.parseInt(mbeanServer.getAttribute(oName, "MaxFileDescriptorCount").toString());
            int percent = (int)((float)openFiles * 100.0f / (float)maxCount);
            event.setValue(percent);
            return event;
        }
        catch (Exception e) {
            event.setValue(0L);
            return event;
        }
    }

    @Override
    public boolean requiresClusterLock() {
        return false;
    }
}

