/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.monitor.AbstractMonitorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTypeCpu
extends AbstractMonitorType
implements IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    protected RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
    protected List<StackTraceElement> ignoreElements = new ArrayList<StackTraceElement>();
    public static final String NAME = "cpu";
    protected boolean useNative = true;

    public MonitorTypeCpu() {
        this.ignoreElements.add(new StackTraceElement("java.lang.Object", "wait", null, 0));
        this.ignoreElements.add(new StackTraceElement("sun.misc.Unsafe", "park", null, 0));
        this.ignoreElements.add(new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "epollWait", null, 0));
        this.ignoreElements.add(new StackTraceElement("java.lang.Thread", "sleep", null, 0));
        this.ignoreElements.add(new StackTraceElement("sun.management.ThreadImpl", "getThreadInfo1", null, 0));
        this.ignoreElements.add(new StackTraceElement("sun.nio.ch.ServerSocketChannelImpl", "accept", null, 0));
        this.ignoreElements.add(new StackTraceElement("sun.nio.ch.ServerSocketChannelImpl", "accept0", null, 0));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public MonitorEvent check(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        int cpuUsage = this.getCpuUsage();
        this.log.debug("CPU usage is {}", (Object)cpuUsage);
        event.setValue(cpuUsage);
        event.setDetails(this.getNotificationMessage(cpuUsage, 0L, 0L));
        return event;
    }

    public int getCpuUsage() {
        int availableProcessors = this.osBean.getAvailableProcessors();
        this.log.debug("Found {} available processors", (Object)availableProcessors);
        if (this.useNative) {
            String line = null;
            try {
                int pid = this.getProcessId();
                this.log.debug("Checking usage of PID {}", (Object)pid);
                if (pid >= 0 && (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_LINUX)) {
                    String[] fields;
                    if (SystemUtils.IS_OS_WINDOWS) {
                        line = this.runCommand(3, "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe", "-Command", "Get-WmiObject -Query \\\"Select * from Win32_PerfFormattedData_PerfProc_Process where IDProcess = " + pid + "\\\" | Select-Object -Property PercentProcessorTime");
                        if (line != null) {
                            return Math.min(Integer.parseInt(line.replace(" ", "")), 100);
                        }
                    } else if (SystemUtils.IS_OS_MAC) {
                        line = this.runCommand(25, "top", "-l2", "-pid", String.valueOf(pid));
                        if (line != null && (fields = line.trim().split("\\s+")).length > 2) {
                            return Math.min(Math.round(Float.parseFloat(fields[2]) / (float)availableProcessors), 100);
                        }
                    } else {
                        line = this.runCommand(7, "top", "-bn1", "-p", String.valueOf(pid));
                        if (line != null && (fields = line.trim().split("\\s+")).length > 9) {
                            return Math.min(Math.round(Float.parseFloat(fields[8]) / (float)availableProcessors), 100);
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                this.log.info("Cannot parse native command line output because \"{}: {}\".  Output was: \"{}\"", new Object[]{e.getClass().getName(), e.getMessage(), line});
                this.useNative = false;
            }
            if (!this.useNative) {
                this.log.info("Switching to CPU time based on JMX");
            }
        }
        long prevUpTime = this.runtimeBean.getUptime();
        long prevProcessCpuTime = this.getProcessCpuTime();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long upTime = this.runtimeBean.getUptime();
        long processCpuTime = this.getProcessCpuTime();
        long elapsedCpu = processCpuTime - prevProcessCpuTime;
        long elapsedTime = upTime - prevUpTime;
        return Math.min((int)((float)elapsedCpu / ((float)elapsedTime * 1000.0f * (float)availableProcessors)), 100);
    }

    protected int getProcessId() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Field jvm = runtime.getClass().getDeclaredField("jvm");
            jvm.setAccessible(true);
            Method pid_method = jvm.get(runtime).getClass().getDeclaredMethod("getProcessId", new Class[0]);
            pid_method.setAccessible(true);
            return (Integer)pid_method.invoke(jvm.get(runtime), new Object[0]);
        }
        catch (Exception e) {
            this.log.debug("Caught exception", (Throwable)e);
            return -1;
        }
    }

    protected long getProcessCpuTime() {
        long cpuTime = 0L;
        try {
            Method method = this.osBean.getClass().getMethod("getProcessCpuTime", new Class[0]);
            method.setAccessible(true);
            cpuTime = (Long)method.invoke((Object)this.osBean, new Object[0]);
        }
        catch (Exception ignore) {
            this.log.debug("Caught exception", (Throwable)ignore);
        }
        return cpuTime;
    }

    protected String runCommand(int lineNumber, String ... args) {
        String ret = null;
        ArrayList<String> cmd = new ArrayList<String>();
        for (String arg : args) {
            cmd.add(arg);
        }
        this.log.debug("Running command: {}", cmd);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            process = pb.start();
            process.waitFor();
        }
        catch (Exception e) {
            this.log.warn("Cannot run command " + cmd + " because", (Throwable)e);
        }
        if (process != null) {
            ArrayList<String> cmdOutput = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    cmdOutput.add(line);
                }
            }
            catch (Exception e) {
                this.log.warn("Cannot read command " + cmd + " because", (Throwable)e);
            }
            if (cmdOutput != null && cmdOutput.size() > lineNumber) {
                ret = (String)cmdOutput.get(lineNumber);
            }
        }
        return ret;
    }

    protected String getNotificationMessage(long value, long threshold, long period) {
        ThreadInfo[] infos = new ThreadInfo[3];
        long[] cpuUsages = new long[3];
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        for (long threadId : threadBean.getAllThreadIds()) {
            ThreadInfo info = threadBean.getThreadInfo(threadId, 1);
            if (info == null || info.getThreadState() == Thread.State.TERMINATED) continue;
            StackTraceElement[] trace = info.getStackTrace();
            boolean ignore = false;
            if (trace != null && trace.length > 0) {
                for (StackTraceElement element : this.ignoreElements) {
                    if (!trace[0].getClassName().equals(element.getClassName()) || !trace[0].getMethodName().equals(element.getMethodName())) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            this.rankTopUsage(infos, cpuUsages, info, threadBean.getThreadCpuTime(threadId));
        }
        StringBuilder text = new StringBuilder("CPU usage is at ");
        text.append(value).append("%").append(System.lineSeparator()).append(System.lineSeparator());
        for (int i = 0; i < infos.length; ++i) {
            ThreadInfo info;
            if (infos[i] == null || (info = threadBean.getThreadInfo(infos[i].getThreadId(), 30)) == null) continue;
            text.append("Top #").append(i + 1).append(" CPU thread ").append(infos[i].getThreadName()).append(" (ID ").append(infos[i].getThreadId()).append(") is using ").append((float)cpuUsages[i] / 1.0E9f).append("s").append(System.lineSeparator());
            text.append(this.logStackTrace(info)).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return text.toString();
    }

    @Override
    public boolean requiresClusterLock() {
        return false;
    }
}

