/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.monitor;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.monitor.AbstractMonitorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTypeBlock
extends AbstractMonitorType
implements IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public MonitorEvent check(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        List transactions = null;
        IDatabasePlatform platform = this.engine.getDatabasePlatform();
        if (platform != null) {
            transactions = platform.getTransactions();
        }
        if (transactions != null && !transactions.isEmpty()) {
            HashMap<String, Transaction> transactionMap = new HashMap<String, Transaction>();
            for (Transaction transaction : transactions) {
                String id = transaction.getId();
                if (transactionMap.containsKey(id) && transactionMap.get(transaction.getBlockingId()) != null) continue;
                transactionMap.put(id, transaction);
            }
            ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
            String dbUser = this.engine.getParameterService().getString("db.user");
            for (Transaction transaction : transactions) {
                MonitorTypeBlock.filterTransactions(transaction, transactionMap, filteredTransactions, dbUser, false, false);
            }
            long secondsBlocked = 0L;
            for (Transaction transaction : filteredTransactions) {
                if (!transaction.getUsername().equals(dbUser) || transactionMap.get(transaction.getBlockingId()) == null) continue;
                secondsBlocked = Math.max(secondsBlocked, transaction.getDuration() / 1000L);
            }
            event.setValue(secondsBlocked);
            if (secondsBlocked > 0L) {
                event.setDetails(this.serializeDetails(filteredTransactions));
            }
        } else {
            event.setValue(0L);
        }
        return event;
    }

    public static boolean filterTransactions(Transaction transaction, Map<String, Transaction> transactionMap, List<Transaction> filteredTransactions, String dbUser, boolean isBlockingUser, boolean isBlocking) {
        Transaction blockingTransaction = transactionMap.get(transaction.getBlockingId());
        if (!isBlocking && blockingTransaction == null) {
            return false;
        }
        if (filteredTransactions.contains(transaction)) {
            return true;
        }
        if (isBlockingUser || dbUser != null && dbUser.equalsIgnoreCase(transaction.getUsername())) {
            filteredTransactions.add(transaction);
            if (blockingTransaction != null) {
                MonitorTypeBlock.filterTransactions(blockingTransaction, transactionMap, filteredTransactions, dbUser, true, true);
            }
            return true;
        }
        if (blockingTransaction != null && MonitorTypeBlock.filterTransactions(blockingTransaction, transactionMap, filteredTransactions, dbUser, false, true)) {
            filteredTransactions.add(transaction);
            return true;
        }
        return false;
    }

    protected String serializeDetails(List<Transaction> transactions) {
        String result = null;
        try {
            result = new Gson().toJson(transactions);
        }
        catch (Exception e) {
            this.log.warn("Unable to convert list of transactions to JSON", (Throwable)e);
        }
        return result;
    }

    @Override
    public String getName() {
        return "block";
    }

    @Override
    public boolean requiresClusterLock() {
        return false;
    }
}

