/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;

public class TriggerRouter
implements IModelObject,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean enabled = true;
    private int initialLoadOrder = 50;
    private String initialLoadSelect;
    private String initialLoadDeleteStmt;
    private Trigger trigger;
    private Router router;
    private Date createTime;
    private Date lastUpdateTime;
    private String lastUpdateBy;
    private boolean pingBackEnabled = false;

    public TriggerRouter() {
        this(new Trigger(), new Router());
    }

    public TriggerRouter(Trigger trigger, Router router) {
        this.trigger = trigger;
        this.router = router;
        this.createTime = new Date();
        this.lastUpdateTime = new Date();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    @Override
    public void setCreateTime(Date createdOn) {
        this.createTime = createdOn;
    }

    @Override
    public void setLastUpdateTime(Date lastModifiedOn) {
        this.lastUpdateTime = lastModifiedOn;
    }

    @Override
    public void setLastUpdateBy(String updatedBy) {
        this.lastUpdateBy = updatedBy;
    }

    public int getInitialLoadOrder() {
        return this.initialLoadOrder;
    }

    public void setInitialLoadOrder(int order) {
        this.initialLoadOrder = order;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setInitialLoadSelect(String initialLoadSelect) {
        this.initialLoadSelect = initialLoadSelect;
    }

    public String getInitialLoadSelect() {
        return this.initialLoadSelect;
    }

    public String getInitialLoadDeleteStmt() {
        return this.initialLoadDeleteStmt;
    }

    public void setInitialLoadDeleteStmt(String initialLoadDeleteStmt) {
        this.initialLoadDeleteStmt = initialLoadDeleteStmt;
    }

    public boolean isRouted(DataEventType event) {
        switch (event) {
            case INSERT: {
                return this.router.isSyncOnInsert();
            }
            case DELETE: {
                return this.router.isSyncOnDelete();
            }
            case UPDATE: {
                return this.router.isSyncOnUpdate();
            }
        }
        return true;
    }

    public String getTargetSchema(String defaultSchema, TriggerHistory triggerHistory) {
        if (this.router != null && !StringUtils.isBlank((CharSequence)this.router.getTargetSchemaName())) {
            return this.router.getTargetSchemaName();
        }
        if (this.router != null && this.router.isUseSourceCatalogSchema() && triggerHistory != null) {
            return triggerHistory.getSourceSchemaName();
        }
        return defaultSchema;
    }

    public String getTargetCatalog(String defaultCatalog, TriggerHistory triggerHistory) {
        if (this.router != null && !StringUtils.isBlank((CharSequence)this.router.getTargetCatalogName())) {
            return this.router.getTargetCatalogName();
        }
        if (this.router != null && this.router.isUseSourceCatalogSchema() && triggerHistory != null) {
            return triggerHistory.getSourceCatalogName();
        }
        return defaultCatalog;
    }

    public String getTargetTable(TriggerHistory triggerHistory) {
        if (this.router != null && !StringUtils.isBlank((CharSequence)this.router.getTargetTableName())) {
            return this.router.getTargetTableName();
        }
        if (triggerHistory != null) {
            return triggerHistory.getSourceTableName();
        }
        if (this.trigger != null && !StringUtils.isBlank((CharSequence)this.trigger.getSourceTableName())) {
            return this.trigger.getSourceTableName();
        }
        return null;
    }

    public String qualifiedTargetTableName(TriggerHistory triggerHistory) {
        String catalog = this.getTargetCatalog(null, triggerHistory);
        String schema = this.getTargetSchema(null, triggerHistory);
        String tableName = this.getTargetTable(triggerHistory);
        if (!StringUtils.isBlank((CharSequence)schema)) {
            tableName = schema + "." + tableName;
        }
        if (!StringUtils.isBlank((CharSequence)catalog)) {
            tableName = catalog + "." + tableName;
        }
        return tableName;
    }

    public void setPingBackEnabled(boolean pingBackEnabled) {
        this.pingBackEnabled = pingBackEnabled;
    }

    public boolean isPingBackEnabled() {
        return this.pingBackEnabled;
    }

    public boolean isSame(TriggerRouter triggerRouter) {
        return this.trigger == null && triggerRouter.trigger == null || this.trigger != null && triggerRouter.trigger != null && this.trigger.matches(triggerRouter.trigger) && this.router == null && triggerRouter.router == null || this.router != null && triggerRouter.router != null && this.router.equals(triggerRouter.router);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.router == null ? 0 : this.router.hashCode());
        result = 31 * result + (this.trigger == null ? 0 : this.trigger.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriggerRouter other = (TriggerRouter)obj;
        if (this.router == null ? other.router != null : !this.router.equals(other.router)) {
            return false;
        }
        return !(this.trigger == null ? other.trigger != null : !this.trigger.equals(other.trigger));
    }

    public String toString() {
        return (this.trigger != null ? this.trigger.toString() : "") + ":" + (this.router != null ? this.router.toString() : "");
    }

    public String getIdentifier() {
        return this.getTrigger().getTriggerId() + this.getRouter().getRouterId();
    }

    public String getTriggerId() {
        return this.trigger != null ? this.trigger.getTriggerId() : null;
    }

    public String getRouterId() {
        return this.router != null ? this.router.getRouterId() : null;
    }

    public void setTriggerId(String triggerId) {
        if (this.trigger == null) {
            this.trigger = new Trigger();
        }
        this.trigger.setTriggerId(triggerId);
    }

    public void setRouterId(String routerId) {
        if (this.router == null) {
            this.router = new Router();
        }
        this.router.setRouterId(routerId);
    }

    public TriggerRouter copy() {
        TriggerRouter triggerRouter = null;
        try {
            triggerRouter = (TriggerRouter)super.clone();
            triggerRouter.setTrigger(this.trigger.copy());
            triggerRouter.setRouter(this.router.copy());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return triggerRouter;
    }
}

