/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import org.jumpmind.extension.IProcessInfoListener;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.util.AppUtils;

public class ProcessInfo
implements Serializable,
Comparable<ProcessInfo>,
Cloneable {
    private static final long serialVersionUID = 1L;
    private ProcessInfoKey key;
    private ProcessStatus status = ProcessStatus.NEW;
    private long currentDataCount;
    private long totalDataCount = 0L;
    private long totalBatchCount;
    private long currentBatchId;
    private long currentBatchCount;
    private String currentChannelId;
    private String currentTableName;
    private transient Thread thread;
    private Date currentBatchStartTime;
    private long currentLoadId;
    private Date startTime = new Date();
    private Date lastStatusChangeTime = new Date();
    private Date endTime;
    private IProcessInfoListener listener;
    private boolean bulkLoadFlag = false;

    public ProcessInfo() {
        this(new ProcessInfoKey("", "", null));
    }

    public ProcessInfo(ProcessInfoKey key) {
        this.key = key;
        this.thread = Thread.currentThread();
    }

    public String getSourceNodeId() {
        return this.key.getSourceNodeId();
    }

    public String getTargetNodeId() {
        return this.key.getTargetNodeId();
    }

    public ProcessType getProcessType() {
        return this.key.getProcessType();
    }

    public ProcessInfoKey getKey() {
        return this.key;
    }

    public void setKey(ProcessInfoKey key) {
        this.key = key;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessStatus status) {
        this.status = status;
        this.lastStatusChangeTime = new Date();
        if (status == ProcessStatus.OK || status == ProcessStatus.ERROR) {
            this.endTime = new Date();
        }
    }

    public long getCurrentDataCount() {
        return this.currentDataCount;
    }

    public void setCurrentDataCount(long dataCount) {
        this.currentDataCount = dataCount;
        if (this.listener != null) {
            this.listener.changeDataCount(this.currentDataCount);
        }
    }

    public long getTotalBatchCount() {
        return this.totalBatchCount;
    }

    public void setTotalBatchCount(long batchCount) {
        this.totalBatchCount = batchCount;
    }

    public void incrementCurrentDataCount() {
        ++this.currentDataCount;
        if (this.totalDataCount < this.currentDataCount) {
            this.totalDataCount = this.currentDataCount;
        }
        if (this.listener != null) {
            this.listener.changeDataCount(this.currentDataCount);
        }
    }

    public void incrementBatchCount() {
        ++this.totalBatchCount;
    }

    public void incrementCurrentBatchCount() {
        ++this.currentBatchCount;
    }

    public long getCurrentBatchCount() {
        return this.currentBatchCount;
    }

    public void setCurrentBatchCount(long currentBatchCount) {
        this.currentBatchCount = currentBatchCount;
    }

    public long getCurrentBatchId() {
        return this.currentBatchId;
    }

    public void setCurrentBatchId(long currentBatchId) {
        this.currentBatchId = currentBatchId;
        this.currentBatchStartTime = new Date();
    }

    public void setCurrentLoadId(long loadId) {
        this.currentLoadId = loadId;
    }

    public long getCurrentLoadId() {
        return this.currentLoadId;
    }

    public String getQueue() {
        String queue = this.key.getQueue();
        if (queue == null) {
            queue = "";
        }
        return queue;
    }

    public String getCurrentChannelId() {
        return this.currentChannelId;
    }

    public void setCurrentChannelId(String currentChannelId) {
        this.currentChannelId = currentChannelId;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setCurrentTableName(String currentTableName) {
        this.currentTableName = currentTableName;
    }

    public String getCurrentTableName() {
        return this.currentTableName;
    }

    public Date getLastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public Date getCurrentBatchStartTime() {
        if (this.currentBatchStartTime == null) {
            return this.startTime;
        }
        return this.currentBatchStartTime;
    }

    public void setCurrentBatchStartTime(Date currentBatchStartTime) {
        this.currentBatchStartTime = currentBatchStartTime;
    }

    public String toString() {
        return String.format("%s,status=%s,startTime=%s", this.key.toString(), this.status.toString(), this.startTime.toString());
    }

    public String showInError(String identityNodeId) {
        if (this.status == ProcessStatus.ERROR) {
            switch (this.key.getProcessType()) {
                case PUSH_JOB_EXTRACT: 
                case PUSH_JOB_TRANSFER: 
                case PULL_HANDLER_EXTRACT: 
                case PULL_HANDLER_TRANSFER: {
                    return this.key.getTargetNodeId();
                }
                case PULL_JOB_LOAD: 
                case PULL_JOB_TRANSFER: 
                case PUSH_HANDLER_LOAD: 
                case PUSH_HANDLER_TRANSFER: 
                case ROUTER_JOB: 
                case ROUTER_READER: 
                case GAP_DETECT: {
                    return this.key.getSourceNodeId();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public int compareTo(ProcessInfo o) {
        if (this.status == ProcessStatus.ERROR && o.status != ProcessStatus.ERROR) {
            return -1;
        }
        if (o.status == ProcessStatus.ERROR && this.status != ProcessStatus.ERROR) {
            return 1;
        }
        if (this.status != ProcessStatus.OK && o.status == ProcessStatus.OK) {
            return -1;
        }
        if (o.status != ProcessStatus.OK && this.status == ProcessStatus.OK) {
            return 1;
        }
        return o.startTime.compareTo(this.startTime);
    }

    public ThreadData getThreadData() {
        if (this.thread != null && this.thread.isAlive()) {
            return ProcessInfo.getThreadData(this.thread.getId());
        }
        return null;
    }

    public static ThreadData getThreadData(long threadId) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ThreadInfo info = threadBean.getThreadInfo(threadId, 100);
        if (info != null) {
            String threadName = info.getThreadName();
            return new ThreadData(threadName, AppUtils.formatStackTrace((StackTraceElement[])info.getStackTrace()));
        }
        return null;
    }

    public long getTotalDataCount() {
        return this.totalDataCount;
    }

    public void setTotalDataCount(long totalDataCount) {
        this.totalDataCount = totalDataCount;
    }

    public void setListener(IProcessInfoListener listener) {
        this.listener = listener;
    }

    public boolean isBulkLoadFlag() {
        return this.bulkLoadFlag;
    }

    public void setBulkLoadFlag(boolean bulkLoadFlag) {
        this.bulkLoadFlag = bulkLoadFlag;
    }

    public ProcessInfo copy() {
        try {
            return (ProcessInfo)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInfo other = (ProcessInfo)obj;
        return this.key.equals(other.getKey());
    }

    public static class ThreadData {
        private String threadName;
        private String stackTrace;

        public ThreadData(String threadName, String stackTrace) {
            this.threadName = threadName;
            this.stackTrace = stackTrace;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public String getThreadName() {
            return this.threadName;
        }
    }

    public static enum ProcessStatus {
        NEW("New"),
        QUERYING("Querying"),
        EXTRACTING("Extracting"),
        LOADING("Loading"),
        TRANSFERRING("Transferring"),
        ACKING("Acking"),
        PROCESSING("Processing"),
        OK("Ok"),
        ERROR("Error"),
        CREATING("Creating");

        private String description;

        private ProcessStatus(String description) {
            this.description = description;
        }

        public ProcessStatus fromDesciption(String description) {
            for (ProcessStatus status : ProcessStatus.values()) {
                if (!status.description.equals(description)) continue;
                return status;
            }
            return null;
        }

        public String toString() {
            return this.description;
        }
    }
}

