/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.Version;
import org.jumpmind.util.AppUtils;

public class NodeHost
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Date LAST_RESTART_TIME = new Date();
    protected static final int MAX_IP_ADDRESS_SIZE = 50;
    private String nodeId;
    private String hostName;
    private String instanceId;
    private String ipAddress;
    private String osUser;
    private String osName;
    private String osArch;
    private String osVersion;
    private int availableProcessors;
    private long freeMemoryBytes;
    private long totalMemoryBytes;
    private long maxMemoryBytes;
    private String javaVersion;
    private String javaVendor;
    private String jdbcVersion;
    private String symmetricVersion;
    private String timezoneOffset;
    private Date heartbeatTime;
    private Date lastRestartTime = LAST_RESTART_TIME;
    private Date createTime = new Date();

    public NodeHost() {
    }

    public NodeHost(String nodeId, String instanceId) {
        this();
        this.nodeId = nodeId;
        this.instanceId = instanceId;
    }

    public void refresh(IDatabasePlatform platform, String instanceId) {
        this.instanceId = instanceId;
        this.hostName = StringUtils.left((String)AppUtils.getHostName(), (int)60);
        this.setIpAddress(AppUtils.getIpAddress());
        this.osUser = System.getProperty("user.name");
        this.osName = System.getProperty("os.name");
        this.osArch = System.getProperty("os.arch");
        this.osVersion = System.getProperty("os.version");
        this.availableProcessors = Runtime.getRuntime().availableProcessors();
        this.freeMemoryBytes = Runtime.getRuntime().freeMemory();
        this.totalMemoryBytes = Runtime.getRuntime().totalMemory();
        this.maxMemoryBytes = Runtime.getRuntime().maxMemory();
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
        this.jdbcVersion = platform.getSqlTemplate().getDriverVersion();
        this.symmetricVersion = Version.version();
        this.timezoneOffset = AppUtils.getTimezoneOffset();
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        this.heartbeatTime = cal.getTime();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = StringUtils.left((String)hostName, (int)60);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = StringUtils.left((String)ipAddress, (int)50);
    }

    public String getOsUser() {
        return this.osUser;
    }

    public void setOsUser(String osUser) {
        this.osUser = osUser;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public void setAvailableProcessors(int availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    public long getFreeMemoryBytes() {
        return this.freeMemoryBytes;
    }

    public void setFreeMemoryBytes(long freeMemoryBytes) {
        this.freeMemoryBytes = freeMemoryBytes;
    }

    public long getTotalMemoryBytes() {
        return this.totalMemoryBytes;
    }

    public void setTotalMemoryBytes(long totalMemoryBytes) {
        this.totalMemoryBytes = totalMemoryBytes;
    }

    public long getMaxMemoryBytes() {
        return this.maxMemoryBytes;
    }

    public void setMaxMemoryBytes(long maxMemoryBytes) {
        this.maxMemoryBytes = maxMemoryBytes;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public void setJavaVendor(String javaVendor) {
        this.javaVendor = javaVendor;
    }

    public void setJdbcVersion(String jdbcVersion) {
        this.jdbcVersion = jdbcVersion;
    }

    public String getJdbcVersion() {
        return this.jdbcVersion;
    }

    public String getSymmetricVersion() {
        return this.symmetricVersion;
    }

    public void setSymmetricVersion(String symmetricVersion) {
        this.symmetricVersion = symmetricVersion;
    }

    public String getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public void setTimezoneOffset(String timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    public Date getHeartbeatTime() {
        return this.heartbeatTime;
    }

    public void setHeartbeatTime(Date heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public Date getLastRestartTime() {
        return this.lastRestartTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setLastRestartTime(Date lastRestartTime) {
        this.lastRestartTime = lastRestartTime;
    }
}

