/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Date;
import org.jumpmind.symmetric.model.Node;

public class NodeCommunication
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Node node;
    private String nodeId;
    private String queue = "default";
    private CommunicationType communicationType;
    private Date lockTime;
    private Date lastLockTime = new Date();
    private long lastLockMillis;
    private String lockingServerId;
    private long successCount;
    private long failCount;
    private long totalSuccessCount;
    private long totalFailCount;
    private long totalSuccessMillis;
    private long totalFailMillis;
    private long batchToSendCount;
    private int nodePriority;

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public CommunicationType getCommunicationType() {
        return this.communicationType;
    }

    public void setCommunicationType(CommunicationType communicationType) {
        this.communicationType = communicationType;
    }

    public Date getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(Date startTime) {
        this.lockTime = startTime;
    }

    public String getLockingServerId() {
        return this.lockingServerId;
    }

    public void setLockingServerId(String lockingServerId) {
        this.lockingServerId = lockingServerId;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(long successCount) {
        this.successCount = successCount;
    }

    public long getFailCount() {
        return this.failCount;
    }

    public void setFailCount(long failCount) {
        this.failCount = failCount;
    }

    public long getTotalSuccessCount() {
        return this.totalSuccessCount;
    }

    public void setTotalSuccessCount(long totalSuccessCount) {
        this.totalSuccessCount = totalSuccessCount;
    }

    public long getTotalFailCount() {
        return this.totalFailCount;
    }

    public void setTotalFailCount(long totalFailCount) {
        this.totalFailCount = totalFailCount;
    }

    public long getTotalSuccessMillis() {
        return this.totalSuccessMillis;
    }

    public void setTotalSuccessMillis(long totalSuccessMillis) {
        this.totalSuccessMillis = totalSuccessMillis;
    }

    public long getTotalFailMillis() {
        return this.totalFailMillis;
    }

    public void setTotalFailMillis(long totalFailMillis) {
        this.totalFailMillis = totalFailMillis;
    }

    public void setLastLockMillis(long lastLockMillis) {
        this.lastLockMillis = lastLockMillis;
    }

    public long getLastLockMillis() {
        return this.lastLockMillis;
    }

    public void setLastLockTime(Date lastLockTime) {
        this.lastLockTime = lastLockTime;
    }

    public Date getLastLockTime() {
        return this.lastLockTime;
    }

    public long getBatchToSendCount() {
        return this.batchToSendCount;
    }

    public void setBatchToSendCount(long batchToSendCount) {
        this.batchToSendCount = batchToSendCount;
    }

    public int getNodePriority() {
        return this.nodePriority;
    }

    public void setNodePriority(int nodePriority) {
        this.nodePriority = nodePriority;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isLocked() {
        return this.lockTime != null;
    }

    public long getAverageSuccessPeriod() {
        if (this.totalSuccessCount > 0L && this.totalSuccessMillis > 0L) {
            return this.totalSuccessMillis / this.totalSuccessCount;
        }
        return 0L;
    }

    public long getAverageFailurePeriod() {
        if (this.totalFailCount > 0L && this.totalFailMillis > 0L) {
            return this.totalFailMillis / this.totalFailCount;
        }
        return 0L;
    }

    public String getIdentifier() {
        return this.getNodeId() + "-" + this.getQueue();
    }

    public String toString() {
        return "NodeCommunication [nodeId=" + this.nodeId + ", queue=" + this.queue + ", communicationType=" + (Object)((Object)this.communicationType) + "]";
    }

    public static enum CommunicationType {
        PULL,
        PUSH,
        FILE_PUSH,
        FILE_PULL,
        OFFLN_PULL,
        OFFLN_PUSH,
        EXTRACT,
        FILE_XTRCT,
        OFF_FSPULL,
        OFF_FSPUSH,
        ROUTE;


        public static boolean isPullType(CommunicationType communicationType) {
            return communicationType == PULL || communicationType == FILE_PULL || communicationType == OFFLN_PULL || communicationType == OFF_FSPULL;
        }
    }
}

