/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.IModelObject;

public class FileTrigger
implements IModelObject {
    private static final long serialVersionUID = 1L;
    private String triggerId;
    private String channelId = "filesync";
    private String reloadChannelId = "filesync_reload";
    private String baseDir;
    private boolean recurse;
    private String includesFiles;
    private String excludesFiles;
    private boolean syncOnCreate = true;
    private boolean syncOnModified = true;
    private boolean syncOnDelete = true;
    private boolean syncOnCtlFile = false;
    private boolean deleteAfterSync = false;
    private String beforeCopyScript;
    private String afterCopyScript;
    private Date createTime = new Date();
    private String lastUpdateBy;
    private Date lastUpdateTime;
    public static final String FILE_CTL_EXTENSION = ".ctl";

    public FileTrigger() {
    }

    public FileTrigger(String baseDir, boolean recurse, String includes, String excludes) {
        this.baseDir = baseDir;
        this.recurse = recurse;
        this.includesFiles = includes;
        this.excludesFiles = excludes;
        this.triggerId = "?";
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getReloadChannelId() {
        return this.reloadChannelId;
    }

    public void setReloadChannelId(String reloadChannelId) {
        this.reloadChannelId = reloadChannelId;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean recursive) {
        this.recurse = recursive;
    }

    public String getIncludesFiles() {
        return this.includesFiles;
    }

    public void setIncludesFiles(String includesFiles) {
        this.includesFiles = includesFiles;
    }

    public String getExcludesFiles() {
        return this.excludesFiles;
    }

    public void setExcludesFiles(String excludesFiles) {
        this.excludesFiles = excludesFiles;
    }

    public boolean isSyncOnCreate() {
        return this.syncOnCreate;
    }

    public void setSyncOnCreate(boolean syncOnCreate) {
        this.syncOnCreate = syncOnCreate;
    }

    public boolean isSyncOnModified() {
        return this.syncOnModified;
    }

    public void setSyncOnModified(boolean syncOnModified) {
        this.syncOnModified = syncOnModified;
    }

    public boolean isSyncOnDelete() {
        return this.syncOnDelete;
    }

    public void setSyncOnDelete(boolean syncOnDelete) {
        this.syncOnDelete = syncOnDelete;
    }

    public boolean isSyncOnCtlFile() {
        return this.syncOnCtlFile;
    }

    public void setSyncOnCtlFile(boolean syncOnCtlFile) {
        this.syncOnCtlFile = syncOnCtlFile;
    }

    public boolean isDeleteAfterSync() {
        return this.deleteAfterSync;
    }

    public void setDeleteAfterSync(boolean deleteAfterSync) {
        this.deleteAfterSync = deleteAfterSync;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    @Override
    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public IOFileFilter createIOFileFilter() {
        ArrayList<Object> fileFilters;
        String[] stringArray;
        if (StringUtils.isNotBlank((CharSequence)this.includesFiles)) {
            stringArray = this.includesFiles.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        }
        String[] includes = stringArray;
        String[] excludes = StringUtils.isNotBlank((CharSequence)this.excludesFiles) ? this.excludesFiles.split(",") : null;
        WildcardFileFilter filter = new WildcardFileFilter(includes);
        if (excludes != null && excludes.length > 0) {
            fileFilters = new ArrayList<Object>();
            fileFilters.add(filter);
            fileFilters.add(new NotFileFilter((IOFileFilter)new WildcardFileFilter(excludes)));
            filter = new AndFileFilter(fileFilters);
        }
        if (!this.recurse) {
            fileFilters = new ArrayList();
            fileFilters.add(filter);
            fileFilters.add(new NotFileFilter(FileFilterUtils.directoryFileFilter()));
            filter = new AndFileFilter(fileFilters);
        } else {
            fileFilters = new ArrayList();
            fileFilters.add(filter);
            fileFilters.add(FileFilterUtils.directoryFileFilter());
            filter = new OrFileFilter(fileFilters);
        }
        return filter;
    }

    public void setAfterCopyScript(String afterCopyScript) {
        this.afterCopyScript = afterCopyScript;
    }

    public String getAfterCopyScript() {
        return this.afterCopyScript;
    }

    public void setBeforeCopyScript(String beforeCopyScript) {
        this.beforeCopyScript = beforeCopyScript;
    }

    public String getBeforeCopyScript() {
        return this.beforeCopyScript;
    }

    public File createSourceFile(FileSnapshot snapshot) {
        File sourceBaseDir = new File(this.baseDir);
        if (!snapshot.getRelativeDir().equals(".")) {
            String sourcePath = snapshot.getRelativeDir() + "/";
            sourceBaseDir = new File(sourceBaseDir, sourcePath);
        }
        return new File(sourceBaseDir, snapshot.getFileName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileTrigger && this.triggerId != null) {
            return this.triggerId.equals(((FileTrigger)obj).triggerId);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.triggerId != null ? this.triggerId.hashCode() : super.hashCode();
    }

    public String toString() {
        if (this.triggerId != null) {
            return this.triggerId;
        }
        return super.toString();
    }
}

