/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.cassandra.CassandraPlatform;
import org.jumpmind.db.platform.kafka.KafkaPlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.CassandraDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DefaultTransformWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.DynamicDefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.KafkaWriter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;
    protected Set<String> conflictLosingParentRows = new HashSet<String>();
    protected Map<String, Table> targetTableMap = new ConcurrentHashMap<String, Table>();

    public DefaultDataLoaderFactory() {
    }

    public DefaultDataLoaderFactory(ISymmetricEngine engine) {
        this.engine = engine;
        this.parameterService = engine.getParameterService();
    }

    @Override
    public String getTypeName() {
        return "default";
    }

    @Override
    public IDataWriter getDataWriter(final String sourceNodeId, final ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        IDatabasePlatform targetPlatform = symmetricDialect.getTargetPlatform();
        try {
            if (targetPlatform instanceof CassandraPlatform) {
                return new CassandraDatabaseWriter(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData));
            }
            if (targetPlatform instanceof KafkaPlatform) {
                String producer = this.parameterService.getString("kafka.producer", "SymmetricDS");
                String outputFormat = this.parameterService.getString("kafka.format", "JSON");
                String topicBy = this.parameterService.getString("kafka.topic.by", "CHANNEL");
                String messageBy = this.parameterService.getString("kafka.message.by", "BATCH");
                String confluentUrl = this.parameterService.getString("kafka.confluent.registry.url");
                String schemaPackage = this.parameterService.getString("kafka.avro.java.package");
                String externalNodeID = this.parameterService.getExternalId();
                String loadOnlyPrefix = "target.";
                TypedProperties props = this.parameterService.getAllParameters();
                String url = this.parameterService.getString("target.db.url");
                String runtimeConfigTablePrefix = this.parameterService.getString("sync.table.prefix");
                String channelReload = "reload";
                return new KafkaWriter(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)new DefaultTransformWriterConflictResolver(transformWriter), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), producer, outputFormat, topicBy, messageBy, confluentUrl, schemaPackage, externalNodeID, url, loadOnlyPrefix, props, runtimeConfigTablePrefix, channelReload);
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to create writer for platform " + targetPlatform.getClass().getSimpleName(), (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        DefaultTransformWriterConflictResolver resolver = new DefaultTransformWriterConflictResolver(transformWriter){

            protected void beforeResolutionAttempt(CsvData csvData, Conflict conflict) {
                DynamicDefaultDatabaseWriter writer;
                ISqlTransaction transaction;
                if (conflict.getPingBack() != Conflict.PingBack.OFF && (transaction = (writer = (DynamicDefaultDatabaseWriter)this.transformWriter.getNestedWriterOfType(DynamicDefaultDatabaseWriter.class)).getTransaction()) != null) {
                    symmetricDialect.enableSyncTriggers(transaction);
                }
            }

            protected void afterResolutionAttempt(CsvData csvData, Conflict conflict) {
                Boolean isWinner;
                ISqlTransaction transaction;
                DynamicDefaultDatabaseWriter writer = (DynamicDefaultDatabaseWriter)this.transformWriter.getNestedWriterOfType(DynamicDefaultDatabaseWriter.class);
                if (Boolean.TRUE.equals(writer.getContext().get("DatabaseWriter.TransactionAborted"))) {
                    return;
                }
                if (conflict.getPingBack() == Conflict.PingBack.SINGLE_ROW && (transaction = writer.getTransaction()) != null) {
                    symmetricDialect.disableSyncTriggers(transaction, sourceNodeId);
                }
                if (conflict.getResolveType() == Conflict.ResolveConflict.NEWER_WINS && conflict.getDetectType() != Conflict.DetectConflict.USE_TIMESTAMP && conflict.getDetectType() != Conflict.DetectConflict.USE_VERSION && (isWinner = (Boolean)writer.getContext().get("isConflictWinner")) != null && isWinner.booleanValue()) {
                    writer.getContext().remove("isConflictWinner");
                    ISqlTransaction transaction2 = writer.getTransaction();
                    if (transaction2 != null) {
                        this.handleWinnerForNewerCaptureWins(transaction2, csvData);
                    }
                }
            }

            protected void handleWinnerForNewerCaptureWins(ISqlTransaction transaction, CsvData csvData) {
                String tableName = (String)csvData.getAttribute("tableName");
                Timestamp loadingTs = (Timestamp)csvData.getAttribute("createTime");
                List<TriggerHistory> hists = DefaultDataLoaderFactory.this.engine.getTriggerRouterService().getActiveTriggerHistories(tableName);
                if (hists != null && hists.size() > 0 && loadingTs != null) {
                    TriggerHistory hist = hists.get(0);
                    Data data = new Data(hist.getSourceTableName(), csvData.getDataEventType(), csvData.getCsvData("rowData"), csvData.getCsvData("pkData"), hist, (String)csvData.getAttribute("channelId"), null, (String)csvData.getAttribute("sourceNodeId"));
                    data.setOldData(csvData.getCsvData("oldData"));
                    data.setPreRouted(true);
                    data.setCreateTime((Date)csvData.getAttribute("createTime"));
                    DefaultDataLoaderFactory.this.engine.getDataService().insertData(transaction, data);
                    String channelId = (String)csvData.getAttribute("channelId");
                    if (channelId != null && !channelId.equals("reload")) {
                        String pkCsvData = CsvUtils.escapeCsvData((String)this.getPkCsvData(csvData, hist));
                        String nodeTableName = TableConstants.getTableName(DefaultDataLoaderFactory.this.parameterService.getTablePrefix(), "node");
                        List<TriggerHistory> nodeHists = DefaultDataLoaderFactory.this.engine.getTriggerRouterService().getActiveTriggerHistories(nodeTableName);
                        if (nodeHists != null && nodeHists.size() > 0 && pkCsvData != null) {
                            String sourceNodeId2 = (String)csvData.getAttribute("sourceNodeId");
                            long createTime = data.getCreateTime() != null ? data.getCreateTime().getTime() : 0L;
                            String script = "if (context != void && context != null && org.jumpmind.symmetric.Version.isOlderVersion(\"3.12.4\")) { engine.getDataService().sendNewerDataToNode(context.findTransaction(), SOURCE_NODE_ID, \"" + tableName + "\", " + pkCsvData + ", new Date(" + createTime + "L), \"" + sourceNodeId2 + "\"); }";
                            Data scriptData = new Data(nodeTableName, DataEventType.BSH, CsvUtils.escapeCsvData((String)script), null, nodeHists.get(0), "reload", null, null);
                            scriptData.setSourceNodeId(sourceNodeId2);
                            DefaultDataLoaderFactory.this.engine.getDataService().insertData(transaction, scriptData);
                        }
                    }
                }
            }

            protected String getPkCsvData(CsvData csvData, TriggerHistory hist) {
                String pkCsvData = csvData.getCsvData("pkData");
                if (pkCsvData == null) {
                    if (hist.getParsedPkColumnNames() != null && hist.getParsedPkColumnNames().length > 0) {
                        String[] pkData = new String[hist.getParsedPkColumnNames().length];
                        Map values = csvData.toColumnNameValuePairs(hist.getParsedPkColumnNames(), "rowData");
                        int i = 0;
                        for (String name : hist.getParsedPkColumnNames()) {
                            pkData[i++] = (String)values.get(name);
                        }
                        pkCsvData = CsvUtils.escapeCsvData((String[])pkData);
                    } else {
                        pkCsvData = csvData.getCsvData("rowData");
                    }
                }
                if (pkCsvData != null) {
                    pkCsvData = pkCsvData.replace("\n", "\\n").replace("\r", "\\r");
                }
                return pkCsvData;
            }
        };
        DynamicDefaultDatabaseWriter writer = null;
        writer = this.engine.getCacheManager().isUsingTargetExternalId(false) ? new DynamicDefaultDatabaseWriter(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)resolver, this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData)){

            protected String getTableKey(Table table) {
                if (!table.getName().contains(this.batch.getSourceNodeId())) {
                    return super.getTableKey(table);
                }
                try {
                    table = (Table)table.clone();
                    table.setName(table.getName().replace(this.batch.getSourceNodeId(), ""));
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                return table.getTableKey();
            }

            protected Table lookupTableFromCache(Table sourceTable, String tableKey) {
                if (!sourceTable.getName().contains(this.batch.getSourceNodeId())) {
                    return super.lookupTableFromCache(sourceTable, tableKey);
                }
                Table table = DefaultDataLoaderFactory.this.targetTableMap.get(tableKey);
                if (table != null) {
                    try {
                        table = (Table)table.clone();
                        table.setName(sourceTable.getName());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
                return table;
            }

            protected void putTableInCache(String tableKey, Table table) {
                DefaultDataLoaderFactory.this.targetTableMap.put(tableKey, table);
            }
        } : new DynamicDefaultDatabaseWriter(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), (IDatabaseWriterConflictResolver)resolver, this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData));
        return writer;
    }

    @Override
    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return true;
    }

    protected DatabaseWriterSettings buildDatabaseWriterSettings(List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedDatas) {
        DatabaseWriterSettings settings = this.buildParameterDatabaseWriterSettings(conflictSettings);
        settings.setLoadOnlyNode(this.engine.getParameterService().is("load.only"));
        settings.setDatabaseWriterFilters(filters);
        settings.setDatabaseWriterErrorHandlers(errorHandlers);
        settings.setResolvedData(resolvedDatas);
        settings.setConflictLosingParentRows(this.conflictLosingParentRows);
        List<IAlterDatabaseInterceptor> alterDatabaseInterceptors = this.engine.getExtensionService().getExtensionPointList(IAlterDatabaseInterceptor.class);
        IAlterDatabaseInterceptor[] interceptors = alterDatabaseInterceptors.toArray(new IAlterDatabaseInterceptor[alterDatabaseInterceptors.size()]);
        settings.setAlterDatabaseInterceptors(interceptors);
        return settings;
    }

    @Override
    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.parameterService = engine.getParameterService();
    }
}

