/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.ConfigurationChangedHelper;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterFilterAdapter;
import org.jumpmind.symmetric.load.IClientReloadListener;
import org.jumpmind.symmetric.load.ILoadSyncLifecycleListener;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.TableReloadStatus;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChangedDatabaseWriterFilter
extends DatabaseWriterFilterAdapter
implements IBuiltInExtensionPoint,
ILoadSyncLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationChangedDatabaseWriterFilter.class);
    private static final String SUFFIX = ConfigurationChangedDatabaseWriterFilter.class.getSimpleName();
    private static final String CTX_KEY_RESYNC_TABLE_NEEDED = "Resync.Table" + SUFFIX;
    private static final String CTX_KEY_CHANGED_NODE_SECURITY = "ChangedNodeSecurity." + SUFFIX;
    private static final String CTX_KEY_INITIAL_LOAD_COMPLETED = "InitialLoadCompleted." + SUFFIX;
    private static final String CTX_KEY_INITIAL_LOAD_LISTENER = "InitialLoadListener." + SUFFIX;
    private static final String CTX_KEY_MY_NODE_ID = "MyNodeId." + SUFFIX;
    private static final String CTX_KEY_MY_NODE_SECURITY = "MyNodeSecurity." + SUFFIX;
    private static final String CTX_KEY_CANCEL_LOAD = "CancelLoad." + SUFFIX;
    private static final String CTX_KEY_INITAL_LOAD_ID = "InitialLoadId." + SUFFIX;
    private ISymmetricEngine engine;
    private ConfigurationChangedHelper helper;
    private String tablePrefixLower;
    private boolean matchesTablePrefix;

    public ConfigurationChangedDatabaseWriterFilter(ISymmetricEngine engine) {
        this.engine = engine;
        this.helper = new ConfigurationChangedHelper(engine);
        this.tablePrefixLower = engine.getParameterService().getTablePrefix().toLowerCase();
    }

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        Map newData;
        String monitorID;
        this.matchesTablePrefix = table.getNameLowerCase().startsWith(this.tablePrefixLower);
        if (!this.matchesTablePrefix) {
            return true;
        }
        if (context.getBatch().getBatchId() == -9999L) {
            this.helper.setSyncTriggersAllowed((Context)context, true);
        }
        if (this.matchesTable(table, "node_security") && (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE)) {
            Map newData2 = data.toColumnNameValuePairs(table.getColumnNames(), "rowData");
            String initialLoadTime = (String)newData2.get("INITIAL_LOAD_TIME");
            String initialLoadEndTime = (String)newData2.get("INITIAL_LOAD_END_TIME");
            String nodeId = (String)newData2.get("NODE_ID");
            String identityId = (String)context.get(CTX_KEY_MY_NODE_ID);
            NodeSecurity nodeSecurity = (NodeSecurity)context.get(CTX_KEY_MY_NODE_SECURITY);
            if ((nodeId.equals(identityId) || identityId == null) && nodeSecurity != null && (nodeSecurity.getInitialLoadTime() == null || nodeSecurity.getInitialLoadEndTime() != null) && StringUtils.isNotBlank((CharSequence)initialLoadTime) && StringUtils.isBlank((CharSequence)initialLoadEndTime)) {
                log.info("Initial load started for me");
                if (this.hasClientReloadListener(context)) {
                    List<IClientReloadListener> listeners = this.engine.getExtensionService().getExtensionPointList(IClientReloadListener.class);
                    for (IClientReloadListener listener : listeners) {
                        listener.reloadStarted();
                    }
                }
            }
        } else if (this.matchesTable(table, "monitor") && data.getDataEventType() == DataEventType.INSERT && (monitorID = (String)(newData = data.toColumnNameValuePairs(table.getColumnNames(), "rowData")).get("MONITOR_ID")) != null && (monitorID.equals("SystemBatchErrorMonitor") || monitorID.equals("SystemLogMonitor") || monitorID.equals("SystemOfflineNodeMonitor"))) {
            return false;
        }
        return true;
    }

    public void afterWrite(DataContext context, Table table, CsvData data) {
        if (!this.matchesTablePrefix) {
            return;
        }
        this.helper.handleChange((Context)context, table, data);
        if (data.getDataEventType() == DataEventType.CREATE) {
            HashSet<Table> tables = (HashSet<Table>)context.get(CTX_KEY_RESYNC_TABLE_NEEDED);
            if (tables == null) {
                tables = new HashSet<Table>();
                context.put(CTX_KEY_RESYNC_TABLE_NEEDED, tables);
            }
            tables.add(table);
        }
        if (this.matchesTable(table, "node_security") && data.getDataEventType() == DataEventType.UPDATE) {
            boolean isInitialLoadComplete;
            Map newData = data.toColumnNameValuePairs(table.getColumnNames(), "rowData");
            String initialLoadEnabled = (String)newData.get("INITIAL_LOAD_ENABLED");
            String initialLoadTime = (String)newData.get("INITIAL_LOAD_TIME");
            String initialLoadEndTime = (String)newData.get("INITIAL_LOAD_END_TIME");
            String nodeId = (String)newData.get("NODE_ID");
            NodeSecurity nodeSecurity = (NodeSecurity)context.get(CTX_KEY_MY_NODE_SECURITY);
            boolean bl = isInitialLoadComplete = nodeId != null && nodeId.equals(context.getBatch().getTargetNodeId()) && nodeSecurity != null && nodeSecurity.getInitialLoadEndTime() == null && StringUtils.isNotBlank((CharSequence)initialLoadTime) && StringUtils.isNotBlank((CharSequence)initialLoadEndTime) && "0".equals(initialLoadEnabled);
            if (isInitialLoadComplete && !this.engine.getParameterService().is("trigger.create.before.initial.load.enabled")) {
                log.info("Requesting syncTriggers because {} is false and sym_node_security changed to indicate that an initial load has completed", (Object)"trigger.create.before.initial.load.enabled");
                this.helper.setSyncTriggersNeeded((Context)context);
                this.engine.getRegistrationService().setAllowClientRegistration(false);
            }
            if (isInitialLoadComplete) {
                context.put(CTX_KEY_INITIAL_LOAD_COMPLETED, (Object)true);
                context.put(CTX_KEY_INITAL_LOAD_ID, (Object)Long.parseLong((String)newData.get("INITIAL_LOAD_ID")));
            }
        }
        if (this.matchesTable(table, "node_security")) {
            context.put(CTX_KEY_CHANGED_NODE_SECURITY, (Object)true);
        }
        if (this.matchesTable(table, "table_reload_status") && data.getDataEventType() == DataEventType.UPDATE) {
            Map oldData = data.toColumnNameValuePairs(table.getColumnNames(), "oldData");
            Map newData = data.toColumnNameValuePairs(table.getColumnNames(), "rowData");
            boolean isCancelled = "1".equals(newData.get("cancelled")) && (oldData.get("cancelled") == null || "0".equals(oldData.get("cancelled"))) && context.get(CTX_KEY_MY_NODE_ID).equals(newData.get("source_node_id"));
            String loadId = (String)newData.get("load_id");
            if (isCancelled && loadId != null) {
                ArrayList<Long> loadIds = (ArrayList<Long>)context.get(CTX_KEY_CANCEL_LOAD);
                if (loadIds == null) {
                    loadIds = new ArrayList<Long>();
                    context.put(CTX_KEY_CANCEL_LOAD, loadIds);
                }
                loadIds.add(Long.parseLong(loadId));
            }
        }
    }

    private boolean hasClientReloadListener(DataContext context) {
        Boolean hasListener = (Boolean)context.get(CTX_KEY_INITIAL_LOAD_LISTENER);
        if (hasListener == null) {
            hasListener = this.engine.getExtensionService().getExtensionPointList(IClientReloadListener.class).size() > 0;
            context.put(CTX_KEY_INITIAL_LOAD_LISTENER, (Object)hasListener);
        }
        return hasListener != false && this.engine.getDatabasePlatform().supportsMultiThreadedTransactions();
    }

    private boolean matchesTable(Table table, String tableSuffix) {
        if (table != null && table.getName() != null) {
            return table.getName().equalsIgnoreCase(TableConstants.getTableName(this.engine.getParameterService().getTablePrefix(), tableSuffix));
        }
        return false;
    }

    @Override
    public void syncStarted(DataContext context) {
        this.putNodeIdentityIntoContext(context);
        this.putNodeSecurityIntoContext(context);
        this.helper.setSyncTriggersAllowed((Context)context, this.engine.getParameterService().is("auto.sync.triggers") && this.engine.getParameterService().is("auto.sync.triggers.after.config.loaded"));
    }

    @Override
    public void syncEnded(DataContext context, List<IncomingBatch> batchesProcessed, Throwable ex) {
        this.helper.contextComplete((Context)context);
        IParameterService parameterService = this.engine.getParameterService();
        INodeService nodeService = this.engine.getNodeService();
        Set tables = (Set)context.remove(CTX_KEY_RESYNC_TABLE_NEEDED);
        if (tables != null && parameterService.is("auto.sync.triggers") && (parameterService.is("trigger.create.before.initial.load.enabled") || nodeService.findNodeSecurity(nodeService.findIdentityNodeId(), true).hasInitialLoaded()) && this.engine.getSymmetricDialect().getPlatform().equals(this.engine.getTargetDialect().getPlatform())) {
            this.engine.getTriggerRouterService().syncTriggers(new ArrayList<Table>(tables), false);
        }
        if (context.remove(CTX_KEY_INITIAL_LOAD_COMPLETED) != null) {
            TableReloadRequest currLoad;
            long loadId = (Long)context.remove(CTX_KEY_INITAL_LOAD_ID);
            log.info("Initial load ended for me, load ID {}", (Object)loadId);
            if (this.hasClientReloadListener(context)) {
                List<IClientReloadListener> listeners = this.engine.getExtensionService().getExtensionPointList(IClientReloadListener.class);
                for (IClientReloadListener listener : listeners) {
                    listener.reloadCompleted();
                }
            }
            if (parameterService.is("trigger.create.before.initial.load.enabled") && (currLoad = this.engine.getDataService().getTableReloadRequest(loadId)) != null && currLoad.isCreateTable()) {
                this.engine.getTriggerRouterService().syncTriggers();
            }
        }
        List loadIds = (List)context.get(CTX_KEY_CANCEL_LOAD);
        String identityId = (String)context.get(CTX_KEY_MY_NODE_ID);
        if (loadIds != null && identityId != null) {
            for (Long loadId : loadIds) {
                TableReloadStatus status = this.engine.getDataService().getTableReloadStatusByLoadIdAndSourceNodeId(loadId, identityId);
                if (status == null) continue;
                this.engine.getInitialLoadService().cancelLoad(status);
            }
        }
    }

    public void batchCommitted(DataContext context) {
        this.helper.contextCommitted((Context)context);
        if (context.remove(CTX_KEY_CHANGED_NODE_SECURITY) != null) {
            this.putNodeSecurityIntoContext(context);
        }
        if (context.getBatch().getBatchId() == -9999L) {
            NodeSecurity security;
            INodeService nodeService = this.engine.getNodeService();
            String nodeId = nodeService.findIdentityNodeId();
            Node sourceNode = nodeService.findNode(context.getBatch().getSourceNodeId());
            if (nodeId != null && sourceNode != null && Version.isOlderThanVersion(sourceNode.getSymmetricVersion(), "3.12.0") && (security = nodeService.findNodeSecurity(nodeId)) != null && (security.isRegistrationEnabled() || security.getRegistrationTime() == null)) {
                this.engine.getRegistrationService().markNodeAsRegistered(nodeId);
            }
        }
    }

    protected void putNodeIdentityIntoContext(DataContext context) {
        context.put(CTX_KEY_MY_NODE_ID, (Object)this.engine.getNodeService().findIdentityNodeId());
    }

    protected void putNodeSecurityIntoContext(DataContext context) {
        String myNodeId = this.engine.getNodeService().findIdentityNodeId();
        if (myNodeId != null) {
            context.put(CTX_KEY_MY_NODE_SECURITY, (Object)this.engine.getNodeService().findNodeSecurity(myNodeId, true));
        }
    }
}

