/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import bsh.Variable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.load.DynamicDatabaseWriterFilter;
import org.jumpmind.symmetric.model.LoadFilter;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BshDatabaseWriterFilter
extends DynamicDatabaseWriterFilter {
    private static final String OLD_ = "OLD_";
    private static final String CONTEXT = "context";
    private static final String TABLE = "table";
    private static final String DATA = "data";
    private static final String ERROR = "error";
    private static final String ENGINE = "engine";
    private static final String LOG = "log";
    private final String INTERPRETER_KEY = String.format("%d.BshInterpreter", this.hashCode());
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public BshDatabaseWriterFilter(ISymmetricEngine engine, Map<String, List<LoadFilter>> loadFilters) {
        super(engine, loadFilters);
    }

    @Override
    protected boolean processLoadFilters(DataContext context, Table table, CsvData data, Exception error, DynamicDatabaseWriterFilter.WriteMethod writeMethod, List<LoadFilter> loadFiltersForTable) {
        boolean writeRow = true;
        LoadFilter currentFilter = null;
        try {
            Interpreter interpreter = this.getInterpreter((Context)context);
            this.bind(interpreter, context, table, data, error);
            Iterator<LoadFilter> iterator = loadFiltersForTable.iterator();
            while (iterator.hasNext()) {
                LoadFilter filter;
                currentFilter = filter = iterator.next();
                if (!(filter.isFilterOnDelete() && data.getDataEventType().equals((Object)DataEventType.DELETE) || filter.isFilterOnInsert() && data.getDataEventType().equals((Object)DataEventType.INSERT)) && (!filter.isFilterOnUpdate() || !data.getDataEventType().equals((Object)DataEventType.UPDATE))) continue;
                Object result = null;
                if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.BEFORE_WRITE) && filter.getBeforeWriteScript() != null) {
                    result = interpreter.eval(filter.getBeforeWriteScript());
                } else if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.AFTER_WRITE) && filter.getAfterWriteScript() != null) {
                    result = interpreter.eval(filter.getAfterWriteScript());
                } else if (writeMethod.equals((Object)DynamicDatabaseWriterFilter.WriteMethod.HANDLE_ERROR) && filter.getHandleErrorScript() != null) {
                    result = interpreter.eval(filter.getHandleErrorScript());
                }
                if (result == null || !result.equals(Boolean.FALSE)) continue;
                writeRow = false;
            }
        }
        catch (EvalError ex) {
            this.processError(currentFilter, table, ex);
        }
        return writeRow;
    }

    @Override
    protected void executeScripts(DataContext context, String key, Set<String> scripts, boolean isFailOnError) {
        block8: {
            Interpreter interpreter = this.getInterpreter((Context)context);
            String currentScript = null;
            try {
                this.bind(interpreter, context, null, null, null);
                if (scripts != null) {
                    Iterator<String> iterator = scripts.iterator();
                    while (iterator.hasNext()) {
                        String script;
                        currentScript = script = iterator.next();
                        interpreter.eval(script);
                    }
                }
            }
            catch (EvalError e) {
                if (e instanceof ParseException) {
                    String errorMsg = String.format("Evaluation error while parsing the following beanshell script:\n\n%s\n\nThe error was on line %d and the error message was: %s", currentScript, e.getErrorLineNumber(), e.getMessage());
                    this.log.error(errorMsg, (Throwable)e);
                    if (isFailOnError) {
                        throw new SymmetricException(errorMsg, new Object[0]);
                    }
                }
                if (!(e instanceof TargetError)) break block8;
                Throwable target = ((TargetError)e).getTarget();
                String errorMsg = String.format("Evaluation error occured in the following beanshell script:\n\n%s\n\nThe error was on line %d", currentScript, e.getErrorLineNumber());
                this.log.error(errorMsg, target);
                if (isFailOnError) {
                    if (target instanceof RuntimeException) {
                        throw (RuntimeException)target;
                    }
                    throw new SymmetricException(target);
                }
                this.log.error("Failed while evaluating script", target);
            }
        }
    }

    protected Interpreter getInterpreter(Context context) {
        Interpreter interpreter = (Interpreter)context.get(this.INTERPRETER_KEY);
        if (interpreter == null) {
            interpreter = new Interpreter();
            context.put(this.INTERPRETER_KEY, (Object)interpreter);
        }
        return interpreter;
    }

    protected void bind(Interpreter interpreter, DataContext context, Table table, CsvData data, Exception error) throws EvalError {
        this.resetInterpreter(interpreter);
        interpreter.set(LOG, (Object)this.log);
        interpreter.set(ENGINE, (Object)this.engine);
        interpreter.set(CONTEXT, (Object)context);
        interpreter.set(TABLE, (Object)table);
        interpreter.set(DATA, (Object)data);
        interpreter.set(ERROR, (Object)error);
        if (data != null) {
            Map sourceValues = data.toColumnNameValuePairs(table.getColumnNames(), "rowData");
            if (sourceValues.size() > 0) {
                for (String columnName : sourceValues.keySet()) {
                    interpreter.set(columnName, sourceValues.get(columnName));
                    interpreter.set(columnName.toUpperCase(), sourceValues.get(columnName));
                }
            } else {
                Map pkValues = data.toColumnNameValuePairs(table.getPrimaryKeyColumnNames(), "pkData");
                for (String columnName : pkValues.keySet()) {
                    interpreter.set(columnName, pkValues.get(columnName));
                    interpreter.set(columnName.toUpperCase(), pkValues.get(columnName));
                }
            }
            Map oldValues = data.toColumnNameValuePairs(table.getColumnNames(), "oldData");
            for (String columnName : oldValues.keySet()) {
                interpreter.set(OLD_ + columnName, oldValues.get(columnName));
                interpreter.set(OLD_ + columnName.toUpperCase(), oldValues.get(columnName));
            }
        }
    }

    protected void resetInterpreter(Interpreter interpreter) throws EvalError {
        for (Variable variable : interpreter.getNameSpace().getDeclaredVariables()) {
            interpreter.unset(variable.getName());
        }
    }

    protected void processError(LoadFilter currentFilter, Table table, Throwable ex) {
        if (ex instanceof TargetError) {
            ex = ((TargetError)ex).getTarget();
        }
        String formattedMessage = String.format("Error executing beanshell script for load filter %s on table %s. The error was: %s", currentFilter != null ? currentFilter.getLoadFilterId() : "N/A", table.getName(), ex.getMessage());
        this.log.error(formattedMessage);
        if (currentFilter.isFailOnError()) {
            throw new SymmetricException(formattedMessage, ex);
        }
    }
}

