/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushHeartbeatListener
implements IHeartbeatListener,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISymmetricEngine engine;

    public PushHeartbeatListener(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public void heartbeat(Node me) {
        IParameterService parameterService = this.engine.getParameterService();
        if (parameterService.is("heartbeat.sync.on.push.enabled")) {
            ISymmetricDialect symmetricDialect = this.engine.getSymmetricDialect();
            boolean updateWithBatchStatus = parameterService.is("heartbeat.update.node.with.batch.status", false);
            int batchInErrorCount = -1;
            int outgoingUnsentCount = -1;
            int outgoingUnsentRowCount = -1;
            Date lastSuccessfulSyncTime = null;
            String mostRecentActiveTableSynced = null;
            int totalRowsLoaded = -1;
            Date oldestLoadedDate = null;
            long purgeOutgoingLastMs = -1L;
            Date purgeOutgoingLastRun = null;
            long purgeOutgoingAverage = -1L;
            long routingLastMs = -1L;
            long routingAveragetMs = -1L;
            Date routingLastRun = null;
            long symDataSize = -1L;
            if (updateWithBatchStatus) {
                batchInErrorCount = this.engine.getOutgoingBatchService().countOutgoingBatchesInError();
                batchInErrorCount += this.engine.getIncomingBatchService().countIncomingBatchesInError();
                int[] batchesRowsUnsent = this.engine.getOutgoingBatchService().countOutgoingNonSystemBatchesRowsUnsent();
                outgoingUnsentCount = batchesRowsUnsent[0];
                outgoingUnsentRowCount = batchesRowsUnsent[1];
                Date outDate = this.engine.getOutgoingBatchService().getOutgoingBatchesLatestUpdateSql();
                Date inDate = this.engine.getIncomingBatchService().getIncomingBatchesLatestUpdateSql();
                lastSuccessfulSyncTime = outDate == null && inDate == null ? null : (outDate == null ? inDate : (inDate == null ? outDate : (outDate.after(inDate) ? outDate : inDate)));
                IStatisticManager statisticsManager = this.engine.getStatisticManager();
                mostRecentActiveTableSynced = statisticsManager.getMostRecentActiveTableSynced();
                Map<Integer, Date> totalLoadedRowsMap = statisticsManager.getTotalLoadedRows();
                if (totalLoadedRowsMap != null && totalLoadedRowsMap.size() == 1) {
                    totalRowsLoaded = totalLoadedRowsMap.keySet().iterator().next();
                    oldestLoadedDate = totalLoadedRowsMap.values().iterator().next();
                }
                if (this.engine.getJobManager().isStarted()) {
                    IJob purgeOutgoingJob = this.engine.getJobManager().getJob("Purge Outgoing");
                    purgeOutgoingLastMs = purgeOutgoingJob.getLastExecutionTimeInMs();
                    purgeOutgoingLastRun = purgeOutgoingJob.getLastFinishTime();
                    purgeOutgoingAverage = purgeOutgoingJob.getAverageExecutionTimeInMs();
                    IJob routeJob = this.engine.getJobManager().getJob("Routing");
                    routingAveragetMs = routeJob.getAverageExecutionTimeInMs();
                    routingLastRun = routeJob.getLastFinishTime();
                    routingLastMs = routeJob.getLastExecutionTimeInMs();
                }
                symDataSize = this.engine.getDataService().countData();
            }
            if (!parameterService.getExternalId().equals(me.getExternalId()) || !parameterService.getNodeGroupId().equals(me.getNodeGroupId()) || parameterService.getSyncUrl() != null && !parameterService.getSyncUrl().equalsIgnoreCase(me.getSyncUrl()) || !parameterService.getString("schema.version", "").equals(me.getSchemaVersion()) || this.engine.getDeploymentType() != null && !this.engine.getDeploymentType().equals(me.getDeploymentType()) || !Version.version().equals(me.getSymmetricVersion()) || this.engine.getParameterService().isRegistrationServer() && !Version.version().equals(me.getConfigVersion()) || !symmetricDialect.getName().equals(me.getDatabaseType()) || !symmetricDialect.getVersion().equals(me.getDatabaseVersion()) || updateWithBatchStatus && (me.getBatchInErrorCount() != batchInErrorCount || me.getBatchToSendCount() != outgoingUnsentCount || me.getLastSuccessfulSyncDate() != lastSuccessfulSyncTime || me.getMostRecentActiveTableSynced() != mostRecentActiveTableSynced || me.getPurgeOutgoingLastMs() != purgeOutgoingLastMs || me.getPurgeOutgoingLastRun() != purgeOutgoingLastRun || me.getPurgeOutgoingAverageMs() != purgeOutgoingAverage || me.getRoutingAverageMs() != routingAveragetMs || me.getRoutingLastRun() != routingLastRun || me.getRoutingLastMs() != routingLastMs || me.getSymDataSize() != symDataSize)) {
                this.log.info("Some attribute(s) of node changed.  Recording changes");
                me.setDeploymentType(this.engine.getDeploymentType());
                me.setDeploymentSubType(this.engine.getDeploymentSubType());
                me.setSymmetricVersion(Version.version());
                me.setDatabaseType(this.engine.getTargetDialect().getName());
                me.setDatabaseVersion(this.engine.getTargetDialect().getVersion());
                me.setDatabaseName(this.engine.getDatabasePlatform().getName());
                me.setBatchInErrorCount(batchInErrorCount);
                me.setBatchToSendCount(outgoingUnsentCount);
                me.setLastSuccessfulSyncDate(lastSuccessfulSyncTime);
                me.setDataRowsToSendCount(outgoingUnsentRowCount);
                me.setMostRecentActiveTableSynced(mostRecentActiveTableSynced);
                me.setDataRowsLoadedCount(totalRowsLoaded);
                me.setOldestLoadTime(oldestLoadedDate);
                me.setPurgeOutgoingLastMs(purgeOutgoingLastMs);
                me.setPurgeOutgoingLastRun(purgeOutgoingLastRun);
                me.setPurgeOutgoingAverageMs(purgeOutgoingAverage);
                me.setRoutingAverageMs(routingAveragetMs);
                me.setRoutingLastRun(routingLastRun);
                me.setRoutingLastMs(routingLastMs);
                me.setSymDataSize(symDataSize);
                me.setSchemaVersion(parameterService.getString("schema.version"));
                if (this.engine.getParameterService().isRegistrationServer()) {
                    me.setConfigVersion(Version.version());
                }
                if (parameterService.is("auto.update.node.values.from.properties")) {
                    this.log.info("Updating my node configuration info according to the symmetric properties");
                    me.setExternalId(parameterService.getExternalId());
                    me.setNodeGroupId(parameterService.getNodeGroupId());
                    if (!StringUtils.isBlank((CharSequence)parameterService.getSyncUrl())) {
                        me.setSyncUrl(parameterService.getSyncUrl());
                    }
                }
                this.engine.getNodeService().save(me);
            }
            this.log.debug("Updating my node info");
            HashSet<Node> targetNodes = new HashSet<Node>();
            targetNodes.addAll(this.engine.getNodeService().findNodesWhoPullFromMe());
            targetNodes.addAll(this.engine.getNodeService().findNodesToPushTo());
            if (this.engine.getOutgoingBatchService().countOutgoingBatchesUnsentHeartbeat() < targetNodes.size() || targetNodes.size() == 0) {
                this.engine.getNodeService().updateNodeHostForCurrentNode();
            }
            this.log.debug("Done updating my node info");
            if (!this.engine.getNodeService().isRegistrationServer() && !symmetricDialect.getPlatform().getDatabaseInfo().isTriggersSupported()) {
                this.engine.getDataService().insertHeartbeatEvent(me, false);
                Set<Node> children = this.engine.getNodeService().findNodesThatOriginatedFromNodeId(me.getNodeId());
                for (Node node : children) {
                    this.engine.getDataService().insertHeartbeatEvent(node, false);
                }
            }
        }
        this.checkConfig(me);
    }

    protected void checkConfig(Node me) {
        block20: {
            try {
                File file;
                Map<String, Channel> channels = this.engine.getConfigurationService().getChannels(false);
                Channel channel = channels.get("heartbeat");
                long desc = 0L;
                if (StringUtils.isNumeric((CharSequence)channel.getDescription())) {
                    desc = Long.parseLong(channel.getDescription());
                }
                if (desc <= 0L || desc >= System.currentTimeMillis() / 86400000L) break block20;
                IDataExtractorService dataExtractorService = this.engine.getDataExtractorService();
                File dir = new File("conf");
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if ((file = new File(dir, ".config")).exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
                try (FileWriter writer = new FileWriter(file);){
                    dataExtractorService.extractConfigurationStandalone(me, writer, TableConstants.getConfigTablesExcludedFromExport());
                }
                catch (IOException e) {
                    return;
                }
                this.log.info("Removing configuration built by professional edition");
                this.engine.getParameterService().deleteAllParameters();
                this.engine.getTriggerRouterService().deleteAllTriggerRouters();
                this.engine.getTriggerRouterService().deleteAllTriggers();
                this.engine.getFileSyncService().deleteAllFileTriggerRouters();
                this.engine.getFileSyncService().deleteAllFileTriggers();
                this.engine.getTriggerRouterService().deleteAllRouters();
                this.engine.getTransformService().deleteAllTransformColumns();
                this.engine.getTransformService().deleteAllTransformTables();
                this.engine.getExtensionService().deleteAllExtensions();
                this.engine.getLoadFilterService().deleteAllLoadFilters();
                this.engine.getJobManager().removeAllJobs();
                this.engine.getConfigurationService().deleteAllChannels();
                this.engine.getConfigurationService().initDefaultChannels();
                for (File snapshot : this.engine.listSnapshots()) {
                    FileUtils.deleteQuietly((File)snapshot);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public long getTimeBetweenHeartbeatsInSeconds() {
        return this.engine.getParameterService().getLong("heartbeat.sync.on.push.period.sec");
    }
}

