/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.symmetric.service.IExtensionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String CODE_START = "import org.jumpmind.symmetric.io.data.transform.*;\nimport org.jumpmind.symmetric.io.data.*;\nimport org.jumpmind.db.platform.*;\nimport org.jumpmind.db.sql.*;\nimport java.util.*;\npublic class JavaColumnTransformExt extends JavaColumnTransform { \n    public String transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data,\n        Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {\n\n";
    public static final String CODE_END = "\n\n   }\n}\n";
    public static final String NAME = "java";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String TRANSFORM_KEY = String.format("%d.JavaRouter", this.hashCode());
    protected IExtensionService extensionService;

    public JavaColumnTransform() {
    }

    public JavaColumnTransform(IExtensionService extensionService) {
        this.extensionService = extensionService;
    }

    public String getName() {
        return NAME;
    }

    public boolean isExtractColumnTransform() {
        return true;
    }

    public boolean isLoadColumnTransform() {
        return true;
    }

    public String transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        try {
            ISingleValueColumnTransform colTransform = this.getCompiledClass(context, column);
            return (String)colTransform.transform(platform, context, column, data, sourceValues, newValue, oldValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ISingleValueColumnTransform getCompiledClass(DataContext context, TransformColumn column) throws Exception {
        ISingleValueColumnTransform colTransform = (ISingleValueColumnTransform)context.get(this.TRANSFORM_KEY);
        if (colTransform == null) {
            String javaCode = CODE_START + column.getTransformExpression() + CODE_END;
            colTransform = (ISingleValueColumnTransform)this.extensionService.getCompiledClass(javaCode);
            context.put(this.TRANSFORM_KEY, (Object)colTransform);
        }
        return colTransform;
    }
}

