/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.DbCompareRow;
import org.jumpmind.symmetric.io.DbCompareTables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCompareDiffWriter {
    private static final Logger log = LoggerFactory.getLogger(DbCompareDiffWriter.class);
    private boolean continueAfterError = false;
    private boolean error = false;
    private Throwable throwable = null;
    private ISymmetricEngine targetEngine;
    private DbCompareTables tables;
    private OutputStream stream;

    public DbCompareDiffWriter(ISymmetricEngine targetEngine, DbCompareTables tables, OutputStream stream) {
        this.targetEngine = targetEngine;
        this.tables = tables;
        this.stream = stream;
    }

    public void writeDelete(DbCompareRow targetCompareRow) {
        block5: {
            if (this.stream == null) {
                return;
            }
            try {
                Table table = targetCompareRow.getTable();
                DmlStatement statement = this.targetEngine.getDatabasePlatform().createDmlStatement(DmlStatement.DmlType.DELETE, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), null, null, null);
                Row row = new Row(targetCompareRow.getTable().getPrimaryKeyColumnCount());
                for (int i = 0; i < targetCompareRow.getTable().getPrimaryKeyColumnCount(); ++i) {
                    if (table.getColumn(i).getJdbcTypeName().equalsIgnoreCase("univarchar") || table.getColumn(i).getJdbcTypeName().equalsIgnoreCase("unichar") || table.getColumn(i).getJdbcTypeName().equalsIgnoreCase("unitext")) {
                        table.getColumn(i).setMappedType("VARCHAR");
                    }
                    row.put(table.getColumn(i).getName(), (Object)targetCompareRow.getRowValues().get(targetCompareRow.getTable().getColumn(i).getName()));
                }
                String sql = statement.buildDynamicDeleteSql(BinaryEncoding.HEX, row, false, true);
                this.writeLine(sql);
            }
            catch (RuntimeException e) {
                this.error = true;
                this.throwable = e;
                log.error(e.getMessage(), (Throwable)e);
                if (this.isContinueAfterError()) break block5;
                throw e;
            }
        }
    }

    public void writeInsert(DbCompareRow sourceCompareRow) {
        block6: {
            if (this.stream == null) {
                return;
            }
            try {
                Table targetTable = this.tables.getTargetTable();
                ArrayList<Column> targetColumns = new ArrayList<Column>();
                ArrayList<Column> targetPkColumns = new ArrayList<Column>();
                for (Column targetColumn : targetTable.getColumns()) {
                    if (!this.tables.getColumnMapping().containsValue(targetColumn) && targetColumn.isRequired() && targetColumn.getDefaultValue() != null) continue;
                    targetColumns.add(targetColumn);
                    if (!targetColumn.isPrimaryKey()) continue;
                    targetPkColumns.add(targetColumn);
                }
                DmlStatement statement = this.targetEngine.getDatabasePlatform().createDmlStatement(DmlStatement.DmlType.INSERT, targetTable.getCatalog(), targetTable.getSchema(), targetTable.getName(), targetPkColumns.toArray(new Column[targetPkColumns.size()]), targetColumns.toArray(new Column[targetColumns.size()]), null, null);
                Row row = new Row(targetColumns.size());
                for (Column sourceColumn : this.tables.getSourceTable().getColumns()) {
                    Column targetColumn = this.tables.getColumnMapping().get(sourceColumn);
                    if (targetColumn == null) continue;
                    if (targetColumn.getJdbcTypeName().equalsIgnoreCase("univarchar") || targetColumn.getJdbcTypeName().equalsIgnoreCase("unichar") || targetColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                        targetColumn.setMappedType("VARCHAR");
                    }
                    row.put(targetColumn.getName(), (Object)sourceCompareRow.getRowValues().get(sourceColumn.getName()));
                }
                String sql = statement.buildDynamicSql(BinaryEncoding.HEX, row, false, false);
                this.writeLine(sql);
            }
            catch (RuntimeException e) {
                this.error = true;
                this.throwable = e;
                log.error(e.getMessage(), (Throwable)e);
                if (this.isContinueAfterError()) break block6;
                throw e;
            }
        }
    }

    public void writeUpdate(DbCompareRow targetCompareRow, Map<Column, String> deltas) {
        block6: {
            if (this.stream == null) {
                return;
            }
            try {
                Table table = targetCompareRow.getTable();
                Column[] changedColumns = deltas.keySet().toArray(new Column[deltas.keySet().size()]);
                DmlStatement statement = this.targetEngine.getDatabasePlatform().createDmlStatement(DmlStatement.DmlType.UPDATE, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), changedColumns, null, null);
                Row row = new Row(changedColumns.length + table.getPrimaryKeyColumnCount());
                for (Column changedColumn : deltas.keySet()) {
                    if (changedColumn.getJdbcTypeName().equalsIgnoreCase("univarchar") || changedColumn.getJdbcTypeName().equalsIgnoreCase("unichar") || changedColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                        changedColumn.setMappedType("VARCHAR");
                    }
                    String value = deltas.get(changedColumn);
                    row.put(changedColumn.getName(), (Object)value);
                }
                for (String pkColumnName : table.getPrimaryKeyColumnNames()) {
                    String value = targetCompareRow.getRow().getString(pkColumnName);
                    row.put(pkColumnName, (Object)value);
                }
                String sql = statement.buildDynamicSql(BinaryEncoding.HEX, row, false, true);
                this.writeLine(sql);
            }
            catch (RuntimeException e) {
                this.error = true;
                this.throwable = e;
                log.error(e.getMessage(), (Throwable)e);
                if (this.isContinueAfterError()) break block6;
                throw e;
            }
        }
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                log.debug("CAUGHT EXCEPTION while closing stream", (Throwable)e);
            }
            this.stream = null;
        }
    }

    protected void writeLine(String line) {
        try {
            this.stream.write(line.getBytes());
            this.stream.write("\r\n".getBytes());
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to write to stream '" + line + "'", ex);
        }
    }

    public void setContinueAfterError(boolean continueAfterError) {
        this.continueAfterError = continueAfterError;
    }

    public boolean isContinueAfterError() {
        return this.continueAfterError;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

