/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.file.BashFileSyncZipScript;
import org.jumpmind.symmetric.file.BeanShellFileSyncZipScript;
import org.jumpmind.symmetric.file.DirectorySnapshot;
import org.jumpmind.symmetric.file.FileSyncZipScript;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSyncZipDataWriter
implements IDataWriter {
    private static final Logger log = LoggerFactory.getLogger(FileSyncZipDataWriter.class);
    protected long byteCount;
    protected long maxBytesToSync;
    protected IFileSyncService fileSyncService;
    protected IStagedResource stagedResource;
    protected ZipOutputStream zos;
    protected Table snapshotTable;
    protected Batch batch;
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();
    protected List<FileSnapshot> snapshotEvents;
    protected DataContext context;
    protected INodeService nodeService;
    protected IExtensionService extensionService;
    protected IConfigurationService configurationService;
    protected boolean batchInError;

    public FileSyncZipDataWriter(long maxBytesToSync, IFileSyncService fileSyncService, INodeService nodeService, IStagedResource stagedResource, IExtensionService extensionService, IConfigurationService configurationService) {
        this.maxBytesToSync = maxBytesToSync;
        this.fileSyncService = fileSyncService;
        this.stagedResource = stagedResource;
        this.nodeService = nodeService;
        this.extensionService = extensionService;
        this.configurationService = configurationService;
    }

    public void open(DataContext context) {
        this.context = context;
    }

    public void close() {
    }

    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }

    public void start(Batch batch) {
        this.batch = batch;
        this.statistics.put(batch, new Statistics());
        this.snapshotEvents = new ArrayList<FileSnapshot>();
    }

    public boolean start(Table table) {
        this.snapshotTable = table;
        return true;
    }

    public void write(CsvData data) {
        DataEventType eventType = data.getDataEventType();
        if (eventType == DataEventType.INSERT || eventType == DataEventType.UPDATE) {
            if (this.filterInitialLoad(data)) {
                return;
            }
            if (eventType == DataEventType.INSERT) {
                this.statistics.get(this.batch).increment("INSERTCOUNT");
            } else {
                this.statistics.get(this.batch).increment("UPDATECOUNT");
            }
            Map columnData = data.toColumnNameValuePairs(this.snapshotTable.getColumnNames(), "rowData");
            Map oldColumnData = data.toColumnNameValuePairs(this.snapshotTable.getColumnNames(), "oldData");
            FileSnapshot snapshot = new FileSnapshot();
            snapshot.setTriggerId((String)columnData.get("TRIGGER_ID"));
            snapshot.setRouterId((String)columnData.get("ROUTER_ID"));
            try {
                snapshot.setFileModifiedTime(Long.parseLong((String)columnData.get("FILE_MODIFIED_TIME")));
            }
            catch (NumberFormatException nfe) {
                log.info("File modified time was not a number : " + (String)columnData.get("FILE_MODIFIED_TIME") + " for file " + (String)columnData.get("FILE_NAME"));
            }
            try {
                snapshot.setCrc32Checksum(columnData.get("CRC32_CHECKSUM") == null ? 0L : Long.parseLong((String)columnData.get("CRC32_CHECKSUM")));
            }
            catch (NumberFormatException nfe) {
                log.info("Checksum was not a number : " + (String)columnData.get("CRC32_CHECKSUM") + " for file " + (String)columnData.get("FILE_NAME"));
            }
            String oldChecksum = (String)oldColumnData.get("CRC32_CHECKSUM");
            if (StringUtils.isNotBlank((CharSequence)oldChecksum)) {
                snapshot.setOldCrc32Checksum(Long.parseLong(oldChecksum));
            }
            try {
                snapshot.setFileSize(Long.parseLong((String)columnData.get("FILE_SIZE")));
            }
            catch (NumberFormatException nfe) {
                log.info("File size was not a number : " + (String)columnData.get("FILE_SIZE") + " for file " + (String)columnData.get("FILE_NAME"));
            }
            snapshot.setLastUpdateBy((String)columnData.get("LAST_UPDATE_BY"));
            snapshot.setFileName((String)columnData.get("FILE_NAME"));
            snapshot.setRelativeDir((String)columnData.get("RELATIVE_DIR"));
            snapshot.setLastEventType(FileSnapshot.LastEventType.fromCode((String)columnData.get("LAST_EVENT_TYPE")));
            this.snapshotEvents.add(snapshot);
        } else if (eventType == DataEventType.RELOAD) {
            String targetNodeId = this.context.getBatch().getTargetNodeId();
            Node targetNode = this.nodeService.findNode(targetNodeId, true);
            List<FileTriggerRouter> fileTriggerRouters = this.fileSyncService.getFileTriggerRoutersForCurrentNode(false);
            for (FileTriggerRouter fileTriggerRouter : fileTriggerRouters) {
                if (!fileTriggerRouter.isEnabled() || !fileTriggerRouter.isInitialLoadEnabled() || !fileTriggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId().equals(targetNode.getNodeGroupId())) continue;
                DirectorySnapshot directorySnapshot = this.fileSyncService.getDirectorySnapshot(fileTriggerRouter);
                this.snapshotEvents.addAll(directorySnapshot);
            }
        }
    }

    public void end(Table table) {
    }

    public void end(Batch batch, boolean inError) {
        block25: {
            try {
                if (inError) break block25;
                if (this.zos == null) {
                    this.zos = new ZipOutputStream(this.stagedResource.getOutputStream());
                }
                FileSyncZipScript script = this.createFileSyncZipScript(batch.getTargetNodeId());
                script.buildScriptStart(batch);
                HashMap<String, FileSnapshot.LastEventType> entriesByLastEventType = new HashMap<String, FileSnapshot.LastEventType>();
                HashMap<String, String> entriesByLastRouterId = new HashMap<String, String>();
                for (FileSnapshot snapshot : this.snapshotEvents) {
                    FileTriggerRouter triggerRouter = this.fileSyncService.getFileTriggerRouter(snapshot.getTriggerId(), snapshot.getRouterId(), false);
                    if (triggerRouter != null) {
                        boolean addFileToScript;
                        String targetBaseDir;
                        FileSnapshot.LastEventType eventType = snapshot.getLastEventType();
                        FileTrigger fileTrigger = triggerRouter.getFileTrigger();
                        String string = targetBaseDir = triggerRouter.getTargetBaseDir() == null ? null : triggerRouter.getTargetBaseDir().replace('\\', '/');
                        if (StringUtils.isBlank(targetBaseDir)) {
                            targetBaseDir = fileTrigger.getBaseDir() == null ? null : fileTrigger.getBaseDir().replace('\\', '/');
                        }
                        targetBaseDir = StringEscapeUtils.escapeJava((String)targetBaseDir);
                        StringBuilder entryName = new StringBuilder(Long.toString(batch.getBatchId()));
                        entryName.append("/");
                        if (!snapshot.getRelativeDir().equals(".")) {
                            entryName.append(snapshot.getRelativeDir()).append("/");
                        }
                        entryName.append(snapshot.getFileName());
                        File file = fileTrigger.createSourceFile(snapshot);
                        if (file.isDirectory()) {
                            entryName.append("/");
                        }
                        String targetFile = "targetBaseDir + \"/\" + targetRelativeDir + \"/\" + targetFileName";
                        FileSnapshot.LastEventType previousEventForEntry = (FileSnapshot.LastEventType)((Object)entriesByLastEventType.get(entryName.toString()));
                        boolean addFileToZip = true;
                        if (previousEventForEntry != null && (previousEventForEntry == eventType || previousEventForEntry == FileSnapshot.LastEventType.CREATE && eventType == FileSnapshot.LastEventType.MODIFY || previousEventForEntry == FileSnapshot.LastEventType.MODIFY && eventType == FileSnapshot.LastEventType.CREATE)) {
                            addFileToZip = false;
                        }
                        String lastRouterId = (String)entriesByLastRouterId.get(entryName.toString());
                        boolean bl = addFileToScript = !snapshot.getRouterId().equals(lastRouterId);
                        if (addFileToZip && eventType != FileSnapshot.LastEventType.DELETE) {
                            if (file.exists()) {
                                this.byteCount += file.length();
                                ZipEntry entry = new ZipEntry(entryName.toString());
                                BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                                entry.setCreationTime(attr.creationTime());
                                entry.setSize(file.length());
                                entry.setTime(file.lastModified());
                                this.zos.putNextEntry(entry);
                                if (file.isFile()) {
                                    try (FileInputStream fis = new FileInputStream(file);){
                                        IOUtils.copy((InputStream)fis, (OutputStream)this.zos);
                                    }
                                }
                                this.zos.closeEntry();
                                entriesByLastEventType.put(entryName.toString(), eventType);
                                entriesByLastRouterId.put(entryName.toString(), snapshot.getRouterId());
                            } else {
                                log.warn("Could not find the {} file to package for synchronization.  Skipping it.", (Object)file.getAbsolutePath());
                            }
                        }
                        if (!addFileToScript) continue;
                        script.buildScriptFileSnapshot(batch, snapshot, triggerRouter, fileTrigger, file, targetBaseDir, targetFile);
                        continue;
                    }
                    log.error("Could not locate the file trigger ({}) router ({}) to process a snapshot event.  The event will be ignored", (Object)snapshot.getTriggerId(), (Object)snapshot.getRouterId());
                }
                script.buildScriptEnd(batch);
                ZipEntry entry = new ZipEntry(batch.getBatchId() + "/" + script.getScriptFileName(batch));
                this.zos.putNextEntry(entry);
                IOUtils.write((String)script.getScript().toString(), (OutputStream)this.zos, (Charset)Charset.defaultCharset());
                this.zos.closeEntry();
                entry = new ZipEntry(batch.getBatchId() + "/batch-info.txt");
                this.zos.putNextEntry(entry);
                IOUtils.write((String)batch.getChannelId(), (OutputStream)this.zos, (Charset)Charset.defaultCharset());
                this.zos.closeEntry();
            }
            catch (IOException e) {
                this.batchInError = true;
                throw new IoException((Exception)e);
            }
        }
    }

    public void finish() {
        try {
            if (this.zos != null) {
                this.zos.finish();
                try {
                    this.zos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
        finally {
            if (this.stagedResource != null) {
                if (!this.batchInError) {
                    this.stagedResource.setState(IStagedResource.State.DONE);
                    this.stagedResource.close();
                } else {
                    this.stagedResource.delete();
                    this.batchInError = false;
                }
            }
        }
    }

    public boolean readyToSend() {
        return this.byteCount > this.maxBytesToSync;
    }

    protected FileSyncZipScript createFileSyncZipScript(String targetNodeId) {
        if (this.isCClient(targetNodeId)) {
            return new BashFileSyncZipScript();
        }
        return new BeanShellFileSyncZipScript(this.extensionService);
    }

    protected boolean isCClient(String nodeId) {
        boolean cclient = false;
        Node node = this.nodeService.findNode(nodeId, true);
        if (node != null) {
            cclient = StringUtils.equals((CharSequence)node.getDeploymentType(), (CharSequence)"cclient");
        }
        return cclient;
    }

    protected boolean filterInitialLoad(CsvData data) {
        Channel channel = this.configurationService.getChannel(this.batch.getChannelId());
        if (channel.isReloadFlag()) {
            List<FileTriggerRouter> fileTriggerRouters = this.fileSyncService.getFileTriggerRoutersForCurrentNode(false);
            Map columnData = data.toColumnNameValuePairs(this.snapshotTable.getColumnNames(), "rowData");
            String triggerId = (String)columnData.get("TRIGGER_ID");
            String routerId = (String)columnData.get("ROUTER_ID");
            for (FileTriggerRouter fileTriggerRouter : fileTriggerRouters) {
                if (!fileTriggerRouter.getTriggerId().equals(triggerId) || !fileTriggerRouter.getRouterId().equals(routerId)) continue;
                return !fileTriggerRouter.isEnabled() || !fileTriggerRouter.isInitialLoadEnabled();
            }
        }
        return false;
    }
}

