/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.file;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.symmetric.file.FileSyncZipScript;
import org.jumpmind.symmetric.file.IFileConflictResolver;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.model.FileConflictStrategy;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.service.IExtensionService;

public class BeanShellFileSyncZipScript
extends FileSyncZipScript {
    protected IExtensionService extensionService;

    public BeanShellFileSyncZipScript(IExtensionService extensionService) {
        this.extensionService = extensionService;
    }

    @Override
    public String getScriptFileName(Batch batch) {
        return "sync.bsh";
    }

    @Override
    public void buildScriptStart(Batch batch) {
        this.getScript().append("fileList = new HashMap();\n");
    }

    @Override
    public void buildScriptFileSnapshot(Batch batch, FileSnapshot snapshot, FileTriggerRouter triggerRouter, FileTrigger fileTrigger, File file, String targetBaseDir, String targetFile) {
        FileSnapshot.LastEventType eventType = snapshot.getLastEventType();
        StringBuilder command = new StringBuilder();
        command.append("targetBaseDir = \"").append(targetBaseDir).append("\";\n");
        command.append("if (targetBaseDir.startsWith(\"${androidBaseDir}\")) {                      \n");
        command.append("    targetBaseDir = targetBaseDir.replace(\"${androidBaseDir}\", \"\");     \n");
        command.append("    targetBaseDir = androidBaseDir + targetBaseDir;                         \n");
        command.append("} else if (targetBaseDir.startsWith(\"${androidAppFilesDir}\")) {           \n");
        command.append("    targetBaseDir = targetBaseDir.replace(\"${androidAppFilesDir}\", \"\"); \n");
        command.append("    targetBaseDir = androidAppFilesDir + targetBaseDir;                     \n");
        command.append("}                                                                           \n");
        command.append("processFile = true;\n");
        command.append("sourceFileName = \"").append(snapshot.getFileName()).append("\";\n");
        command.append("targetRelativeDir = \"");
        if (!snapshot.getRelativeDir().equals(".")) {
            command.append(StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir()));
            command.append("\";\n");
        } else {
            command.append("\";\n");
        }
        command.append("targetFileName = sourceFileName;\n");
        command.append("sourceFilePath = \"");
        command.append(StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir())).append("\";\n");
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getBeforeCopyScript())) {
            command.append(fileTrigger.getBeforeCopyScript()).append("\n");
        }
        command.append("if (processFile) {\n");
        switch (eventType) {
            case CREATE: 
            case MODIFY: {
                if (!file.exists()) break;
                command.append("  File targetBaseDirFile = new File(targetBaseDir);\n");
                command.append("  if (!targetBaseDirFile.exists()) {\n");
                command.append("    targetBaseDirFile.mkdirs();\n");
                command.append("  }\n");
                command.append("  java.io.File sourceFile = new java.io.File(batchDir + \"/\"");
                if (!snapshot.getRelativeDir().equals(".")) {
                    command.append(" + sourceFilePath + \"/\"");
                }
                command.append(" + sourceFileName");
                command.append(");\n");
                command.append("  java.io.File targetFile = new java.io.File(");
                command.append(targetFile);
                command.append(");\n");
                command.append("  if (targetFile.exists() && targetFile.isDirectory()) {\n");
                command.append("      processFile = false;\n");
                command.append("  }\n");
                FileConflictStrategy conflictStrategy = triggerRouter.getConflictStrategy();
                if (conflictStrategy == FileConflictStrategy.TARGET_WINS || conflictStrategy == FileConflictStrategy.MANUAL) {
                    command.append("  if (targetFile.exists() && !targetFile.isDirectory()) {\n");
                    command.append("    long targetChecksum = org.apache.commons.io.FileUtils.checksumCRC32(targetFile);\n");
                    command.append("    if (targetChecksum != " + snapshot.getOldCrc32Checksum() + "L) {\n");
                    if (conflictStrategy == FileConflictStrategy.MANUAL) {
                        command.append("      throw new org.jumpmind.symmetric.file.FileConflictException(targetFileName + \" was in conflict \");\n");
                    } else {
                        command.append("      processFile = false;\n");
                    }
                    command.append("    }\n");
                    command.append("  }\n");
                } else if (triggerRouter.getConflictStrategyString() != null) {
                    for (IFileConflictResolver resolver : this.extensionService.getExtensionPointList(IFileConflictResolver.class)) {
                        if (!triggerRouter.getConflictStrategyString().equals(resolver.getName())) continue;
                        command.append(resolver.getResolveCommand(snapshot));
                    }
                }
                command.append("  if (processFile) {\n");
                command.append("    if (sourceFile.isDirectory()) {\n");
                command.append("      org.apache.commons.io.FileUtils.copyDirectory(sourceFile, targetFile, true);\n");
                command.append("    } else {\n");
                command.append("      org.apache.commons.io.FileUtils.copyFile(sourceFile, targetFile, true);\n");
                command.append("    }\n");
                command.append("  }\n");
                command.append("  fileList.put(").append(targetFile).append(",\"");
                command.append(eventType.getCode());
                command.append("\");\n");
                break;
            }
            case DELETE: {
                command.append("  org.apache.commons.io.FileUtils.deleteQuietly(new java.io.File(");
                command.append(targetFile);
                command.append("));\n");
                command.append("  fileList.put(").append(targetFile).append(",\"");
                command.append(eventType.getCode());
                command.append("\");\n");
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getAfterCopyScript())) {
            command.append(fileTrigger.getAfterCopyScript()).append("\n");
        }
        command.append("}\n\n");
        this.getScript().append((CharSequence)command);
    }

    @Override
    public void buildScriptEnd(Batch batch) {
        this.getScript().append("return fileList;\n");
    }
}

