/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.IProtocolDataWriterListener;
import org.jumpmind.symmetric.io.data.writer.StagingDataWriter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBatchStagingWriter
implements IDataWriter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;
    protected ExtractRequest request;
    protected long maxBatchSize;
    protected IDataWriter currentDataWriter;
    protected List<OutgoingBatch> batches;
    protected List<OutgoingBatch> finishedBatches;
    protected IStagingManager stagingManager;
    protected String sourceNodeId;
    protected DataContext context;
    protected Table table;
    protected OutgoingBatch outgoingBatch;
    protected Batch batch;
    protected boolean inError = false;
    protected ProcessInfo processInfo;
    protected long startTime;
    protected long ts;
    protected long rowCount;
    protected long byteCount;
    protected List<ExtractRequest> childRequests;
    protected Map<Long, OutgoingBatch> childBatches;
    protected long memoryThresholdInBytes;
    protected boolean isRestarted;

    public MultiBatchStagingWriter(ISymmetricEngine engine, ExtractRequest request, List<ExtractRequest> childRequests, String sourceNodeId, List<OutgoingBatch> batches, long maxBatchSize, ProcessInfo processInfo, boolean isRestarted) {
        this.engine = engine;
        this.stagingManager = engine.getStagingManager();
        this.request = request;
        this.sourceNodeId = sourceNodeId;
        this.maxBatchSize = maxBatchSize;
        this.batches = new ArrayList<OutgoingBatch>(batches);
        this.finishedBatches = new ArrayList<OutgoingBatch>(batches.size());
        this.processInfo = processInfo;
        this.startTime = this.ts = System.currentTimeMillis();
        this.childRequests = childRequests;
        this.memoryThresholdInBytes = engine.getParameterService().getLong("stream.to.file.threshold.bytes");
        this.childBatches = new HashMap<Long, OutgoingBatch>();
        this.isRestarted = isRestarted;
    }

    public void open(DataContext context) {
        this.context = context;
        this.nextBatch();
        this.currentDataWriter = this.buildWriter();
        this.currentDataWriter.open(context);
    }

    protected IDataWriter buildWriter() {
        return new StagingDataWriter(this.memoryThresholdInBytes, false, this.sourceNodeId, "outgoing", this.stagingManager, false, false, (IProtocolDataWriterListener[])null);
    }

    public void close() {
        while (!this.inError && this.batches.size() > 0) {
            this.startNewBatch();
            if (this.table != null) {
                this.end(this.table);
            }
            this.end(this.batch, false);
            this.log.debug("Batch {} is empty", new Object[]{this.batch.getNodeBatchId()});
            Statistics stats = this.closeCurrentDataWriter();
            this.checkSend(stats);
        }
        this.closeCurrentDataWriter();
    }

    private Statistics closeCurrentDataWriter() {
        Statistics stats = null;
        if (this.currentDataWriter != null) {
            stats = (Statistics)this.currentDataWriter.getStatistics().get(this.batch);
            this.outgoingBatch.setByteCount(stats.get("BYTECOUNT"));
            this.outgoingBatch.setExtractMillis(System.currentTimeMillis() - this.batch.getStartTime().getTime());
            this.currentDataWriter.close();
            this.currentDataWriter = null;
            if (this.inError) {
                IStagedResource resource = this.getStagedResource(this.outgoingBatch);
                if (resource != null) {
                    resource.delete();
                }
            } else {
                this.checkSend(stats);
            }
        }
        return stats;
    }

    public Map<Batch, Statistics> getStatistics() {
        if (this.currentDataWriter != null) {
            return this.currentDataWriter.getStatistics();
        }
        return Collections.emptyMap();
    }

    public void start(Batch batch) {
        this.batch = batch;
        if (batch != null) {
            this.processInfo.setCurrentBatchId(batch.getBatchId());
            this.processInfo.setCurrentChannelId(batch.getChannelId());
            this.processInfo.incrementBatchCount();
            this.processInfo.setCurrentDataCount(0L);
        }
        this.currentDataWriter.start(batch);
    }

    public boolean start(Table table) {
        this.table = table;
        if (table != null) {
            this.processInfo.setCurrentTableName(table.getFullyQualifiedTableName());
        }
        this.currentDataWriter.start(table);
        return true;
    }

    public void write(CsvData data) {
        this.outgoingBatch.incrementDataRowCount();
        this.outgoingBatch.incrementDataInsertRowCount();
        this.currentDataWriter.write(data);
        if (this.outgoingBatch.getDataRowCount() >= this.maxBatchSize && this.batches.size() > 0) {
            this.currentDataWriter.end(this.table);
            this.currentDataWriter.end(this.batch, false);
            this.closeCurrentDataWriter();
            this.startNewBatch();
        }
        if (System.currentTimeMillis() - this.ts > 60000L) {
            long currentRowCount = this.rowCount + ((Statistics)this.currentDataWriter.getStatistics().get(this.batch)).get("STATEMENTCOUNT");
            long currentByteCount = this.byteCount + ((Statistics)this.currentDataWriter.getStatistics().get(this.batch)).get("BYTECOUNT");
            this.log.info("Extract request {} for table {} extracting for {} seconds, {} batches, {} rows, and {} bytes.  Current batch is {} in range {}-{}.", new Object[]{this.request.getRequestId(), this.request.getTableName(), (System.currentTimeMillis() - this.startTime) / 1000L, this.finishedBatches.size() + 1, currentRowCount, currentByteCount, this.batch.getBatchId(), this.request.getStartBatchId(), this.request.getEndBatchId()});
            this.ts = System.currentTimeMillis();
        }
    }

    public void checkSend(Statistics stats) {
        OutgoingBatch batchFromDatabase;
        IStagedResource resource = this.getStagedResource(this.outgoingBatch);
        if (resource != null) {
            resource.setState(IStagedResource.State.DONE);
        }
        if ((batchFromDatabase = this.engine.getOutgoingBatchService().findOutgoingBatch(this.outgoingBatch.getBatchId(), this.outgoingBatch.getNodeId())).getStatus().equals((Object)AbstractBatch.Status.OK) || batchFromDatabase.getStatus().equals((Object)AbstractBatch.Status.IG)) {
            this.log.info("User cancelled batches, so cancelling extract request");
            throw new CancellationException();
        }
        this.outgoingBatch.setStatus(AbstractBatch.Status.NE);
        this.outgoingBatch.setExtractRowCount(this.outgoingBatch.getDataRowCount());
        this.outgoingBatch.setExtractInsertRowCount(this.outgoingBatch.getDataInsertRowCount());
        this.checkSendChildRequests(batchFromDatabase, resource, stats);
        this.engine.getOutgoingBatchService().updateOutgoingBatch(this.outgoingBatch);
    }

    protected void checkSendChildRequests(OutgoingBatch parentBatch, IStagedResource parentResource, Statistics stats) {
        if (this.childRequests != null) {
            long batchIndex = this.outgoingBatch.getBatchId() - this.request.getStartBatchId();
            for (ExtractRequest childRequest : this.childRequests) {
                long childBatchId = childRequest.getStartBatchId() + batchIndex;
                Date startExtractTime = new Date();
                if (parentResource != null) {
                    IStagedResource childResource = this.stagingManager.create(new Object[]{"outgoing", Batch.getStagedLocation((boolean)false, (String)childRequest.getNodeId(), (long)childBatchId), childBatchId});
                    this.log.debug("About to copy batch {} to batch {}-{}", new Object[]{this.outgoingBatch.getNodeBatchId(), childRequest.getNodeId(), childBatchId});
                    BufferedReader reader = parentResource.getReader();
                    BufferedWriter writer = childResource.getWriter(this.memoryThresholdInBytes);
                    try {
                        int i;
                        StringBuffer sb = new StringBuffer();
                        while ((i = reader.read()) != -1) {
                            char c = (char)i;
                            sb.append(c);
                            if (c != '\n') continue;
                            String s = MultiBatchStagingWriter.replaceBatchId(sb.toString(), this.outgoingBatch.getBatchId(), childBatchId);
                            writer.write(s);
                            sb.delete(0, sb.length());
                        }
                        if (sb.length() > 0) {
                            String s = MultiBatchStagingWriter.replaceBatchId(sb.toString(), this.outgoingBatch.getBatchId(), childBatchId);
                            writer.write(s);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to copy batch " + this.outgoingBatch.getNodeBatchId() + " to batch " + childRequest.getNodeId() + "-" + childBatchId + ": " + e.getMessage());
                    }
                    finally {
                        childResource.close();
                        parentResource.close();
                    }
                    childResource.setState(IStagedResource.State.DONE);
                }
                OutgoingBatch childBatch = this.engine.getOutgoingBatchService().findOutgoingBatch(childBatchId, childRequest.getNodeId());
                childBatch.setExtractStartTime(startExtractTime);
                childBatch.setExtractMillis(System.currentTimeMillis() - startExtractTime.getTime());
                if (stats != null) {
                    childBatch.setDataRowCount(stats.get("STATEMENTCOUNT"));
                    childBatch.setDataInsertRowCount(stats.get("INSERTCOUNT"));
                    childBatch.setByteCount(stats.get("BYTECOUNT"));
                }
                if (!childBatch.getStatus().equals((Object)AbstractBatch.Status.OK) && !childBatch.getStatus().equals((Object)AbstractBatch.Status.IG)) {
                    childBatch.setStatus(AbstractBatch.Status.NE);
                    this.engine.getOutgoingBatchService().updateOutgoingBatch(childBatch);
                }
                this.childBatches.put(childBatch.getBatchId(), childBatch);
            }
        }
    }

    private static String replaceBatchId(String s, long originalBatchId, long newBatchId) {
        if (s.startsWith("batch") || s.startsWith("commit")) {
            s = s.replace(Long.toString(originalBatchId), Long.toString(newBatchId));
        }
        return s;
    }

    public void end(Table table) {
        if (this.currentDataWriter != null) {
            this.currentDataWriter.end(table);
            Statistics stats = (Statistics)this.currentDataWriter.getStatistics().get(this.batch);
            this.outgoingBatch.setByteCount(stats.get("BYTECOUNT"));
            this.outgoingBatch.setExtractMillis(System.currentTimeMillis() - this.batch.getStartTime().getTime());
        }
    }

    public void end(Batch batch, boolean inError) {
        this.inError = inError;
        if (this.currentDataWriter != null) {
            this.currentDataWriter.end(this.batch, inError);
            this.closeCurrentDataWriter();
        }
    }

    protected void nextBatch() {
        if (this.outgoingBatch != null) {
            this.finishedBatches.add(this.outgoingBatch);
            this.rowCount += this.outgoingBatch.getDataRowCount();
            this.byteCount += this.outgoingBatch.getByteCount();
            this.engine.getStatisticManager().incrementDataBytesExtracted(this.outgoingBatch.getChannelId(), this.outgoingBatch.getByteCount());
            this.engine.getStatisticManager().incrementDataExtracted(this.outgoingBatch.getChannelId(), this.outgoingBatch.getDataRowCount());
            this.engine.getStatisticManager().incrementTableRows(this.outgoingBatch.getTableLoadedCount(), false);
        }
        this.outgoingBatch = this.batches.remove(0);
        this.outgoingBatch.setDataRowCount(0L);
        this.outgoingBatch.setDataInsertRowCount(0L);
        this.outgoingBatch.setExtractStartTime(new Date());
        if (this.finishedBatches.size() > 0) {
            this.outgoingBatch.setExtractCount(this.outgoingBatch.getExtractCount() + 1L);
        }
        for (OutgoingBatch batch : this.finishedBatches) {
            IStagedResource resource = this.getStagedResource(batch);
            if (resource == null) continue;
            resource.refreshLastUpdateTime();
        }
    }

    protected void startNewBatch() {
        this.nextBatch();
        this.currentDataWriter = this.buildWriter();
        this.batch = new Batch(Batch.BatchType.EXTRACT, this.outgoingBatch.getBatchId(), this.outgoingBatch.getChannelId(), this.engine.getSymmetricDialect().getBinaryEncoding(), this.sourceNodeId, this.outgoingBatch.getNodeId(), false);
        this.currentDataWriter.open(this.context);
        this.currentDataWriter.start(this.batch);
        this.processInfo.incrementBatchCount();
        if (this.table != null) {
            this.currentDataWriter.start(this.table);
        }
    }

    protected IStagedResource getStagedResource(OutgoingBatch currentBatch) {
        return this.stagingManager.find(new Object[]{"outgoing", currentBatch.getStagedLocation(), currentBatch.getBatchId()});
    }
}

