/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.SymmetricUtils;

public class ColumnsAccordingToTriggerHistory {
    private static Map<String, Map<String, Table>> cacheByEngine = new ConcurrentHashMap<String, Map<String, Table>>();
    private Map<CacheKey, Table> cache = new HashMap<CacheKey, Table>();
    private ISymmetricEngine engine;
    private Node sourceNode;
    private Node targetNode;
    private ITriggerRouterService triggerRouterService;
    private ISymmetricDialect symmetricDialect;
    private String tablePrefix;
    private boolean isUsingTargetExternalId;

    public ColumnsAccordingToTriggerHistory(ISymmetricEngine engine, Node sourceNode, Node targetNode) {
        this.engine = engine;
        this.triggerRouterService = engine.getTriggerRouterService();
        this.symmetricDialect = engine.getSymmetricDialect();
        this.tablePrefix = engine.getTablePrefix().toLowerCase();
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.isUsingTargetExternalId = engine.getCacheManager().isUsingTargetExternalId(false);
    }

    public Table lookup(String routerId, TriggerHistory triggerHistory, boolean setTargetTableName, boolean useDatabaseDefinition, boolean addMissingColumns) {
        CacheKey key = new CacheKey(routerId, triggerHistory.getTriggerHistoryId(), setTargetTableName, useDatabaseDefinition, addMissingColumns);
        Table table = this.cache.get(key);
        if (table == null) {
            table = this.lookupAndOrderColumnsAccordingToTriggerHistory(routerId, triggerHistory, setTargetTableName, useDatabaseDefinition, addMissingColumns);
            this.cache.put(key, table);
        }
        return table;
    }

    protected Table lookupAndOrderColumnsAccordingToTriggerHistory(String routerId, TriggerHistory triggerHistory, boolean setTargetTableName, boolean useDatabaseDefinition, boolean addMissingColumns) {
        String catalogName = triggerHistory.getSourceCatalogName();
        String schemaName = triggerHistory.getSourceSchemaName();
        String tableName = triggerHistory.getSourceTableName();
        String tableNameLowerCase = triggerHistory.getSourceTableNameLowerCase();
        Table table = null;
        if (useDatabaseDefinition) {
            table = this.isUsingTargetExternalId && !tableName.startsWith(this.tablePrefix) ? this.lookupTableExpanded(this.getTargetPlatform(tableNameLowerCase), catalogName, schemaName, tableName, triggerHistory, addMissingColumns) : this.lookupTable(this.getTargetPlatform(tableNameLowerCase), catalogName, schemaName, tableName, triggerHistory, addMissingColumns);
        } else {
            table = new Table(tableName);
            table.addColumns(triggerHistory.getParsedColumnNames());
            table.setPrimaryKeys(triggerHistory.getParsedPkColumnNames());
        }
        Router router = this.triggerRouterService.getRouterById(routerId, false);
        if (router != null && setTargetTableName) {
            if (router.isUseSourceCatalogSchema()) {
                table.setCatalog(catalogName);
                table.setSchema(schemaName);
            } else {
                table.setCatalog(null);
                table.setSchema(null);
            }
            if (StringUtils.equals((CharSequence)"$(none)", (CharSequence)router.getTargetCatalogName())) {
                table.setCatalog(null);
            } else if (StringUtils.isNotBlank((CharSequence)router.getTargetCatalogName())) {
                table.setCatalog(SymmetricUtils.replaceNodeVariables(this.sourceNode, this.targetNode, router.getTargetCatalogName()));
                table.setCatalog(SymmetricUtils.replaceCatalogSchemaVariables(catalogName, this.symmetricDialect.getTargetPlatform().getDefaultCatalog(), schemaName, this.symmetricDialect.getTargetPlatform().getDefaultSchema(), router.getTargetCatalogName()));
            }
            if (StringUtils.equals((CharSequence)"$(none)", (CharSequence)router.getTargetSchemaName())) {
                table.setSchema(null);
            } else if (StringUtils.isNotBlank((CharSequence)router.getTargetSchemaName())) {
                table.setSchema(SymmetricUtils.replaceNodeVariables(this.sourceNode, this.targetNode, router.getTargetSchemaName()));
                table.setSchema(SymmetricUtils.replaceCatalogSchemaVariables(catalogName, this.symmetricDialect.getTargetPlatform().getDefaultCatalog(), schemaName, this.symmetricDialect.getTargetPlatform().getDefaultSchema(), router.getTargetSchemaName()));
            }
            if (StringUtils.isNotBlank((CharSequence)router.getTargetTableName())) {
                table.setName(router.getTargetTableName());
            }
        }
        return table;
    }

    protected IDatabasePlatform getTargetPlatform(String tableName) {
        return tableName.startsWith(this.tablePrefix) ? this.symmetricDialect.getPlatform() : this.symmetricDialect.getTargetDialect().getPlatform();
    }

    protected Table lookupTable(IDatabasePlatform platform, String catalogName, String schemaName, String tableName, TriggerHistory triggerHistory, boolean addMissingColumns) {
        Table table = platform.getTableFromCache(catalogName, schemaName, tableName, false);
        if (table != null && table.getColumnCount() < triggerHistory.getParsedColumnNames().length) {
            table = platform.getTableFromCache(catalogName, schemaName, tableName, true);
        }
        if (table == null) {
            throw new SymmetricException("Could not find the following table.  It might have been dropped: %s", Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
        }
        table = table.copyAndFilterColumns(triggerHistory.getParsedColumnNames(), triggerHistory.getParsedPkColumnNames(), true, addMissingColumns);
        return table;
    }

    protected Table lookupTableExpanded(IDatabasePlatform platform, String catalogName, String schemaName, String tableName, TriggerHistory triggerHistory, boolean addMissingColumns) {
        Table table = null;
        if (!tableName.contains(this.targetNode.getExternalId())) {
            table = this.lookupTable(platform, catalogName, schemaName, tableName, triggerHistory, addMissingColumns);
        } else {
            String baseTableName = tableName.replace(this.targetNode.getExternalId(), "") + (addMissingColumns ? "-t" : "-f");
            Map<String, Table> sourceTableMap = this.getSourceTableMap(this.engine.getEngineName());
            table = sourceTableMap.get(baseTableName);
            if (table == null) {
                table = this.lookupTable(platform, catalogName, schemaName, tableName, triggerHistory, addMissingColumns);
                sourceTableMap.put(baseTableName, table);
            } else {
                table = table.copyAndFilterColumns(triggerHistory.getParsedColumnNames(), triggerHistory.getParsedPkColumnNames(), true, addMissingColumns);
            }
            if (table != null) {
                table.setName(tableName);
            }
        }
        return table;
    }

    protected Map<String, Table> getSourceTableMap(String engineName) {
        Map<String, Table> map = cacheByEngine.get(engineName);
        if (map == null) {
            map = new ConcurrentHashMap<String, Table>();
            cacheByEngine.put(engineName, map);
        }
        return map;
    }

    static class CacheKey {
        private String routerId;
        private int triggerHistoryId;
        private boolean setTargetTableName;
        private boolean useDatabaseDefinition;
        private boolean addMissingColumns;

        public CacheKey(String routerId, int triggerHistoryId, boolean setTargetTableName, boolean useDatabaseDefinition, boolean addMissingColumns) {
            this.routerId = routerId;
            this.triggerHistoryId = triggerHistoryId;
            this.setTargetTableName = setTargetTableName;
            this.useDatabaseDefinition = useDatabaseDefinition;
            this.addMissingColumns = addMissingColumns;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.routerId == null ? 0 : this.routerId.hashCode());
            result = 31 * result + (this.setTargetTableName ? 1231 : 1237);
            result = 31 * result + this.triggerHistoryId;
            result = 31 * result + (this.useDatabaseDefinition ? 1231 : 1237);
            result = 31 * result + (this.addMissingColumns ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.routerId == null ? other.routerId != null : !this.routerId.equals(other.routerId)) {
                return false;
            }
            if (this.setTargetTableName != other.setTargetTableName) {
                return false;
            }
            if (this.triggerHistoryId != other.triggerHistoryId) {
                return false;
            }
            if (this.useDatabaseDefinition != other.useDatabaseDefinition) {
                return false;
            }
            return this.addMissingColumns == other.addMissingColumns;
        }
    }
}

