/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ext;

import java.io.Serializable;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.extension.IExtensionPoint;

public class ExtensionPointMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IExtensionPoint extensionPoint;
    private String name;
    private Class<? extends IExtensionPoint> type;
    private boolean installed;
    private String extraInfo;

    public ExtensionPointMetaData(IExtensionPoint extensionPoint, String name, boolean installed) {
        this(extensionPoint, name, null, installed);
    }

    public ExtensionPointMetaData(IExtensionPoint extensionPoint, String name, Class<? extends IExtensionPoint> type, boolean installed) {
        this(extensionPoint, name, type, installed, null);
    }

    public ExtensionPointMetaData(IExtensionPoint extensionPoint, String name, Class<? extends IExtensionPoint> type, boolean installed, String extraInfo) {
        this.extensionPoint = extensionPoint;
        this.name = name;
        this.type = type;
        this.installed = installed;
        this.extraInfo = extraInfo;
        this.assignExtensionPointInterface();
        this.installed |= this.type != null && (this.type.getSimpleName().equals("IServletExtension") || this.type.getSimpleName().equals("IServletFilterExtension"));
    }

    public String getTypeText() {
        StringBuilder typeText = new StringBuilder();
        if (this.type != null) {
            String simpleName = this.type.getSimpleName();
            boolean justAddedSpace = true;
            for (int i = 1; i < simpleName.length(); ++i) {
                if (!justAddedSpace && Character.isUpperCase(simpleName.charAt(i))) {
                    typeText.append(" ");
                    typeText.append(simpleName.charAt(i));
                    continue;
                }
                justAddedSpace = false;
                typeText.append(Character.toUpperCase(simpleName.charAt(i)));
            }
        }
        return typeText.toString();
    }

    protected void assignExtensionPointInterface() {
        if (this.extensionPoint != null) {
            for (Class<?> base = this.extensionPoint.getClass(); base != null && this.type == null; base = base.getSuperclass()) {
                this.type = this.findExtensionPoint(base.getInterfaces());
            }
        }
    }

    protected Class<? extends IExtensionPoint> findExtensionPoint(Class<?>[] types) {
        for (Class<?> ifc : types) {
            if (ifc.equals(IExtensionPoint.class)) {
                return ifc;
            }
            Class<? extends IExtensionPoint> searchValue = this.findExtensionPoint(ifc.getInterfaces());
            if (searchValue == null) continue;
            return ifc;
        }
        return null;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setType(Class<? extends IExtensionPoint> type) {
        this.type = type;
    }

    public Class<? extends IExtensionPoint> getType() {
        return this.type;
    }

    public IExtensionPoint getExtensionPoint() {
        return this.extensionPoint;
    }

    public void setExtensionPoint(IExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isBuiltIn() {
        return this.extensionPoint instanceof IBuiltInExtensionPoint;
    }
}

