/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.TransformService;

public interface ISymmetricDialect {
    public void createTrigger(StringBuilder var1, DataEventType var2, Trigger var3, TriggerHistory var4, Channel var5, String var6, Table var7, ISqlTransaction var8);

    public void createTrigger(StringBuilder var1, DataEventType var2, Trigger var3, TriggerHistory var4, Channel var5, String var6, Table var7);

    public void createDdlTrigger(String var1, StringBuilder var2, String var3, String var4, String var5);

    public String getEngineName();

    public void removeTrigger(StringBuilder var1, String var2, String var3, String var4, String var5, ISqlTransaction var6);

    public void removeTrigger(StringBuilder var1, String var2, String var3, String var4, String var5);

    public void removeDdlTrigger(StringBuilder var1, String var2, String var3, String var4);

    public boolean doesTriggerExist(String var1, String var2, String var3, String var4);

    public boolean doesDdlTriggerExist(String var1, String var2, String var3);

    public void verifyDatabaseIsCompatible();

    public void initTablesAndDatabaseObjects();

    public void dropTablesAndDatabaseObjects();

    public boolean createOrAlterTablesIfNecessary(String ... var1);

    public void dropRequiredDatabaseObjects();

    public void createRequiredDatabaseObjects();

    public IDatabasePlatform getPlatform();

    public IDatabasePlatform getTargetPlatform();

    public IDatabasePlatform getTargetPlatform(String var1);

    public String getName();

    public String getVersion();

    public int getMajorVersion();

    public int getMinorVersion();

    public String getProductVersion();

    public BinaryEncoding getBinaryEncoding();

    public String getTransactionTriggerExpression(String var1, String var2, Trigger var3);

    public String createInitialLoadSqlFor(Node var1, TriggerRouter var2, Table var3, TriggerHistory var4, Channel var5, String var6);

    public boolean[] getColumnPositionUsingTemplate(Table var1, TriggerHistory var2);

    public String createPurgeSqlFor(Node var1, TriggerRouter var2, TriggerHistory var3);

    public String createPurgeSqlFor(Node var1, TriggerRouter var2, TriggerHistory var3, List<TransformService.TransformTableNodeGroupLink> var4);

    public String createPurgeSqlFor(Node var1, TriggerRouter var2, TriggerHistory var3, List<TransformService.TransformTableNodeGroupLink> var4, String var5);

    public List<String> createPurgeSqlForMultipleTables(Node var1, TriggerRouter var2, TriggerHistory var3, List<TransformService.TransformTableNodeGroupLink> var4, String var5);

    public String createCsvDataSql(Trigger var1, TriggerHistory var2, Channel var3, String var4);

    public String createCsvPrimaryKeySql(Trigger var1, TriggerHistory var2, Channel var3, String var4);

    public int getMaxTriggerNameLength();

    public boolean supportsTransactionId();

    public boolean supportsTransactionViews();

    public boolean supportsSubselectsInDelete();

    public boolean supportsSubselectsInUpdate();

    public boolean supportsDdlTriggers();

    public void cleanDatabase();

    @Deprecated
    public void disableSyncTriggers(ISqlTransaction var1);

    public void disableSyncTriggers(ISqlTransaction var1, String var2);

    public void enableSyncTriggers(ISqlTransaction var1);

    public String getSyncTriggersExpression();

    public String getSyncTriggersOnIncomingExpression();

    public String getSourceNodeExpression();

    public String getCreateSymmetricDDL();

    public boolean isBlobSyncSupported();

    public boolean isClobSyncSupported();

    public boolean isTransactionIdOverrideSupported();

    public long insertWithGeneratedKey(String var1, SequenceIdentifier var2);

    public long insertWithGeneratedKey(String var1, SequenceIdentifier var2, Object ... var3);

    @Deprecated
    public Column[] orderColumns(String[] var1, Table var2);

    public boolean supportsOpenCursorsAcrossCommit();

    public Set<String> getSqlKeywords();

    public String getInitialLoadTableAlias();

    public String preProcessTriggerSqlClause(String var1);

    public void truncateTable(String var1);

    public String getDatabaseTimeSQL();

    public long getDatabaseTime();

    public boolean areDatabaseTransactionsPendingSince(long var1);

    public Date getEarliestTransactionStartTime();

    public boolean needsToSelectLobData();

    public String getDataHasChangedCondition(Trigger var1);

    public boolean canGapsOccurInCapturedDataIds();

    public String massageDataExtractionSql(String var1, boolean var2);

    public String massageForLob(String var1, boolean var2);

    public boolean isInitialLoadTwoPassLob(Table var1);

    public String getInitialLoadTwoPassLobSql(String var1, Table var2, boolean var3);

    public boolean escapesTemplatesForDatabaseInserts();

    public String getMasterCollation();

    public boolean supportsBatchUpdates();

    public void cleanupTriggers();

    public String getDriverName();

    public String getDriverVersion();

    public String getSequenceName(SequenceIdentifier var1);

    public String getSequenceKeyName(SequenceIdentifier var1);

    public long getCurrentSequenceValue(SequenceIdentifier var1);

    public String getTablePrefix();

    public Database readSymmetricSchemaFromXml();

    public String getSymmetricDdlChanges();

    public String getTemplateNumberPrecisionSpec();

    public Map<String, String> getSqlReplacementTokens();

    public int getSqlTypeForIds();

    public AbstractTriggerTemplate getTriggerTemplate();

    public IParameterService getParameterService();

    public void setExtensionService(IExtensionService var1);

    public PermissionType[] getSymTablePermissions();

    public ISymmetricDialect getTargetDialect();

    public ISymmetricDialect getTargetDialect(String var1);

    public void setTargetDialect(ISymmetricDialect var1);
}

