/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TableConstants {
    public static final String SYM_PARAMETER = "parameter";
    public static final String SYM_LOCK = "lock";
    public static final String SYM_OUTGOING_BATCH = "outgoing_batch";
    public static final String SYM_EXTRACT_REQUEST = "extract_request";
    public static final String SYM_INCOMING_BATCH = "incoming_batch";
    public static final String SYM_TRIGGER = "trigger";
    public static final String SYM_ROUTER = "router";
    public static final String SYM_TRIGGER_HIST = "trigger_hist";
    public static final String SYM_NODE_GROUP = "node_group";
    public static final String SYM_NODE = "node";
    public static final String SYM_NODE_HOST = "node_host";
    public static final String SYM_DATA = "data";
    public static final String SYM_DATA_GAP = "data_gap";
    public static final String SYM_DATA_EVENT = "data_event";
    public static final String SYM_TRANSFORM_TABLE = "transform_table";
    public static final String SYM_LOAD_FILTER = "load_filter";
    public static final String SYM_TRANSFORM_COLUMN = "transform_column";
    public static final String SYM_TRIGGER_ROUTER = "trigger_router";
    public static final String SYM_CHANNEL = "channel";
    public static final String SYM_NODE_SECURITY = "node_security";
    public static final String SYM_NODE_IDENTITY = "node_identity";
    public static final String SYM_NODE_COMMUNICATION = "node_communication";
    public static final String SYM_NODE_GROUP_LINK = "node_group_link";
    public static final String SYM_NODE_HOST_STATS = "node_host_stats";
    public static final String SYM_NODE_HOST_JOB_STATS = "node_host_job_stats";
    public static final String SYM_REGISTRATION_REQUEST = "registration_request";
    public static final String SYM_REGISTRATION_REDIRECT = "registration_redirect";
    public static final String SYM_NODE_CHANNEL_CTL = "node_channel_ctl";
    public static final String SYM_CONFLICT = "conflict";
    public static final String SYM_NODE_GROUP_CHANNEL_WND = "node_group_channel_wnd";
    public static final String SYM_NODE_HOST_CHANNEL_STATS = "node_host_channel_stats";
    public static final String SYM_INCOMING_ERROR = "incoming_error";
    public static final String SYM_SEQUENCE = "sequence";
    public static final String SYM_TABLE_RELOAD_REQUEST = "table_reload_request";
    public static final String SYM_GROUPLET = "grouplet";
    public static final String SYM_GROUPLET_LINK = "grouplet_link";
    public static final String SYM_TRIGGER_ROUTER_GROUPLET = "trigger_router_grouplet";
    public static final String SYM_FILE_TRIGGER = "file_trigger";
    public static final String SYM_FILE_TRIGGER_ROUTER = "file_trigger_router";
    public static final String SYM_FILE_SNAPSHOT = "file_snapshot";
    public static final String SYM_FILE_INCOMING = "file_incoming";
    public static final String SYM_CONSOLE_USER = "console_user";
    public static final String SYM_CONSOLE_ROLE = "console_role";
    public static final String SYM_CONSOLE_ROLE_PRIVILEGE = "console_role_privilege";
    public static final String SYM_CONSOLE_USER_HIST = "console_user_hist";
    public static final String SYM_CONSOLE_EVENT = "console_event";
    public static final String SYM_CONSOLE_TABLE_STATS = "console_table_stats";
    public static final String SYM_DESIGN_DIAGRAM = "design_diagram";
    public static final String SYM_DIAGRAM_GROUP = "diagram_group";
    public static final String SYM_EXTENSION = "extension";
    public static final String SYM_MONITOR = "monitor";
    public static final String SYM_MONITOR_EVENT = "monitor_event";
    public static final String SYM_NOTIFICATION = "notification";
    public static final String SYM_CONTEXT = "context";
    public static final String SYM_JOB = "job";
    public static final String SYM_TABLE_RELOAD_STATUS = "table_reload_status";
    public static final String SYM_TABLE_GROUP = "table_group";
    public static final String SYM_TABLE_GROUP_HIER = "table_group_hier";
    protected static boolean hasConsoleSchema = TableConstants.class.getResourceAsStream("/console-schema.xml") != null;

    public static final Set<String> getTables(String tablePrefix) {
        HashSet<String> tables = new HashSet<String>();
        TableConstants.addPrefixToTableNames(tables, tablePrefix, SYM_CHANNEL, SYM_CONFLICT, SYM_CONTEXT, SYM_DATA, SYM_DATA_GAP, SYM_DATA_EVENT, SYM_EXTRACT_REQUEST, SYM_EXTENSION, SYM_FILE_INCOMING, SYM_FILE_SNAPSHOT, SYM_FILE_TRIGGER, SYM_FILE_TRIGGER_ROUTER, SYM_GROUPLET, SYM_GROUPLET_LINK, SYM_INCOMING_BATCH, SYM_INCOMING_ERROR, SYM_JOB, SYM_LOAD_FILTER, SYM_LOCK, SYM_MONITOR, SYM_MONITOR_EVENT, SYM_NODE, SYM_NODE_CHANNEL_CTL, SYM_NODE_COMMUNICATION, SYM_NODE_GROUP, SYM_NODE_GROUP_CHANNEL_WND, SYM_NODE_GROUP_LINK, SYM_NODE_HOST, SYM_NODE_HOST_CHANNEL_STATS, SYM_NODE_HOST_JOB_STATS, SYM_NODE_HOST_STATS, SYM_NODE_IDENTITY, SYM_NODE_SECURITY, SYM_NOTIFICATION, SYM_OUTGOING_BATCH, SYM_PARAMETER, SYM_REGISTRATION_REDIRECT, SYM_REGISTRATION_REQUEST, SYM_ROUTER, SYM_SEQUENCE, SYM_TABLE_RELOAD_REQUEST, SYM_TABLE_RELOAD_STATUS, SYM_TRANSFORM_TABLE, SYM_TRANSFORM_COLUMN, SYM_TRIGGER, SYM_TRIGGER_HIST, SYM_TRIGGER_ROUTER, SYM_TRIGGER_ROUTER_GROUPLET);
        if (hasConsoleSchema) {
            tables.addAll(TableConstants.getTablesForConsole(tablePrefix));
        }
        return tables;
    }

    public static final Set<String> getTablesForConsole(String tablePrefix) {
        HashSet<String> tables = new HashSet<String>();
        TableConstants.addPrefixToTableNames(tables, tablePrefix, SYM_CONSOLE_EVENT, SYM_CONSOLE_USER, SYM_CONSOLE_USER_HIST, SYM_CONSOLE_ROLE, SYM_CONSOLE_ROLE_PRIVILEGE, SYM_CONSOLE_TABLE_STATS, SYM_DESIGN_DIAGRAM, SYM_DIAGRAM_GROUP, SYM_TABLE_GROUP, SYM_TABLE_GROUP_HIER);
        return tables;
    }

    public static final Set<String> getTablesWithoutPrefix() {
        return TableConstants.getTables("");
    }

    public static final List<String> getConfigTables(String tablePrefix) {
        ArrayList<String> tables = new ArrayList<String>();
        TableConstants.addPrefixToTableNames(tables, tablePrefix, SYM_NODE_GROUP, SYM_NODE_GROUP_LINK, SYM_NODE, SYM_NODE_HOST, SYM_NODE_IDENTITY, SYM_NODE_SECURITY, SYM_PARAMETER, SYM_CHANNEL, SYM_NODE_GROUP_CHANNEL_WND, SYM_TRIGGER, SYM_ROUTER, SYM_TRIGGER_ROUTER, SYM_TRANSFORM_TABLE, SYM_LOAD_FILTER, SYM_TRANSFORM_COLUMN, SYM_CONFLICT, SYM_GROUPLET, SYM_GROUPLET_LINK, SYM_TRIGGER_ROUTER_GROUPLET, SYM_FILE_TRIGGER, SYM_FILE_TRIGGER_ROUTER, SYM_FILE_SNAPSHOT, SYM_EXTENSION, SYM_MONITOR, SYM_MONITOR_EVENT, SYM_NOTIFICATION, SYM_JOB, SYM_TABLE_RELOAD_REQUEST, SYM_TABLE_RELOAD_STATUS, SYM_EXTRACT_REQUEST);
        if (hasConsoleSchema) {
            TableConstants.addPrefixToTableNames(tables, tablePrefix, SYM_CONSOLE_ROLE, SYM_CONSOLE_USER, SYM_CONSOLE_ROLE_PRIVILEGE, SYM_CONSOLE_USER_HIST, SYM_DESIGN_DIAGRAM, SYM_DIAGRAM_GROUP, SYM_TABLE_GROUP, SYM_TABLE_GROUP_HIER);
        }
        return tables;
    }

    public static final Map<String, String> getConfigTablesByVersion(String tablePrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.3.0", SYM_GROUPLET, SYM_GROUPLET_LINK, SYM_TRIGGER_ROUTER_GROUPLET);
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.5.0", SYM_FILE_TRIGGER, SYM_FILE_TRIGGER_ROUTER, SYM_FILE_SNAPSHOT, SYM_NODE_GROUP_CHANNEL_WND);
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.7.0", SYM_EXTENSION);
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.8.0", SYM_NOTIFICATION, SYM_MONITOR, SYM_MONITOR_EVENT, SYM_CONSOLE_EVENT);
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.8.18", SYM_CONSOLE_USER_HIST);
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.9.0", SYM_JOB);
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.12.0", SYM_CONSOLE_ROLE, SYM_CONSOLE_ROLE_PRIVILEGE, SYM_DESIGN_DIAGRAM, SYM_DIAGRAM_GROUP);
        TableConstants.addPrefixToTableNames(map, tablePrefix, "3.14.0", SYM_TABLE_RELOAD_STATUS, SYM_EXTRACT_REQUEST, SYM_TABLE_GROUP, SYM_TABLE_GROUP_HIER);
        return map;
    }

    public static final String[] getConfigTablesExcludedFromRegistration() {
        return new String[]{SYM_MONITOR_EVENT, SYM_TABLE_RELOAD_REQUEST, SYM_TABLE_RELOAD_STATUS, SYM_EXTRACT_REQUEST};
    }

    public static final Set<String> getConfigTablesWithoutCapture(String tablePrefix) {
        HashSet<String> tables = new HashSet<String>();
        TableConstants.addPrefixToTableNames(tables, tablePrefix, SYM_NODE_IDENTITY);
        return tables;
    }

    public static final String[] getConfigTablesExcludedFromExport() {
        return new String[]{SYM_NODE, SYM_NODE_SECURITY, SYM_NODE_IDENTITY, SYM_NODE_HOST, SYM_FILE_SNAPSHOT, SYM_CONSOLE_USER, SYM_CONSOLE_ROLE, SYM_CONSOLE_ROLE_PRIVILEGE, SYM_CONSOLE_USER_HIST, SYM_MONITOR_EVENT, SYM_TABLE_RELOAD_REQUEST, SYM_TABLE_RELOAD_STATUS, SYM_EXTRACT_REQUEST};
    }

    public static final List<String> getConfigTablesForExport(String tablePrefix) {
        List<String> tables = TableConstants.getConfigTables(tablePrefix);
        for (String table : TableConstants.getConfigTablesExcludedFromExport()) {
            tables.remove(TableConstants.getTableName(tablePrefix, table));
        }
        return tables;
    }

    protected static final void addPrefixToTableNames(Map<String, String> map, String tablePrefix, String version, String ... names) {
        for (String name : names) {
            map.put(TableConstants.getTableName(tablePrefix, name), version);
        }
    }

    protected static final void addPrefixToTableNames(Collection<String> collection, String tablePrefix, String ... names) {
        for (String name : names) {
            collection.add(TableConstants.getTableName(tablePrefix, name));
        }
    }

    public static String getTableName(String tablePrefix, String tableSuffix) {
        return String.format("%s%s%s", tablePrefix, StringUtils.isNotBlank((CharSequence)tablePrefix) ? "_" : "", tableSuffix);
    }
}

