# 自定义布局 - 快速参考

## 🎯 核心概念

你现在可以像这样定义布局：

```
"2x2"      → 2×2 网格（4个图）
"3,2"      → 上3个，下2个（5个图，下排居中）
"[2,3,2]"  → 上2个，中3个，下2个（7个图，全部自动居中）
```

---

## 📝 输入位置

在 **右侧面板** → **"布局模板"** 下拉菜单

选择任何一个模板后，会出现 **"自定义布局"** 输入框
→ 输入你的布局格式 → 实时预览

---

## 💡 常用布局参考

### 对称布局
- `"2x2"` → 4个
- `"3x3"` → 9个
- `"4x4"` → 16个

### 非对称布局（自动居中）
- `"[3,2]"` → 5个 - 上3下2
- `"[2,3,2]"` → 7个 - 金字塔
- `"[1,2,3,2,1]"` → 9个 - 大金字塔
- `"[4,3,2,1]"` → 10个 - 倒金字塔
- `"[5,4,3,2,1]"` → 15个 - 大倒金字塔

### 特殊形状
- `"[1]"` → 1个 - 单个（顶部居中）
- `"[2]"` → 2个 - 并排
- `"[1,1,1,1,1]"` → 5个 - 垂直排列

---

## ✨ 核心特性

| 特性 | 说明 |
|------|------|
| **自动居中** | 不规则布局自动水平对齐 |
| **实时预览** | 输入时立即显示效果 |
| **灵活** | 支持任意行列组合 |
| **简单** | 无需复杂操作 |

---

## 🔍 工作原理示例

### [3,2] 布局的自动居中

```
输入: [3, 2]

第1行：3个图
[图1]  [图2]  [图3]
 ↓      ↓      ↓
位置: 0    0.333  0.667

第2行：2个图（自动居中！）
   [图4]  [图5]
    ↓      ↓
位置: 0    0.5

✨ 结果：图4和图5正好对齐在图2和图3之间的间隙！
```

### 计算公式

```python
行宽度占用 = 1 / 该行列数 × 该行列数 = 1.0
起始偏移 = (1.0 - 1.0) / 2 = 0

→ 所有行都从0开始，占满100%宽度
→ 由于列宽不同，自动形成对齐效果
```

---

## ⚠️ 常见注意

1. **图片数量不匹配**
   - 超出的不显示，缺少的留空
   - 建议：输入的总数 = 你有的图片数

2. **格式必须正确**
   - ✅ `"2x2"`, `"3,2"`, `"[3,2]"`
   - ❌ `"2-2"`, `"2 2"`, `"3/2"`

3. **支持多种写法**
   - `"2x2"` = `"2X2"` = `"2×2"`
   - `"[3,2]"` = `"3,2"` = `"3 , 2"`

---

## 🎨 布局预览

### [3,2] - 5个图
```
┌────┬────┬────┐
│  1 │  2 │  3 │
├──────┬──────┤
│  4   │  5   │
└──────┴──────┘
```

### [2,3,2] - 7个图
```
┌────┬────┐
│  1 │  2 │
├──────┬──────┤
│  3   │  4   │  5  
├──────┬──────┤
│  6   │  7   │
└──────┴──────┘
```

### [1,3,1] - 5个图（居中）
```
    ┌────┐
    │ 1  │
┌───┼────┼───┐
│ 2 │ 3  │ 4 │
┌───┴────┴───┐
│     5      │
└────────────┘
```

---

## 🚀 立即开始

1. 打开程序
2. 选择一个布局模板
3. 在 **"自定义布局"** 输入框输入：`3,2`
4. 看看效果！

---

💬 有问题？参考完整指南：[CUSTOM_LAYOUT_GUIDE.md](CUSTOM_LAYOUT_GUIDE.md)
